/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenAbout;
import sk.inlogic.screen.ScreenInstructions;
import sk.inlogic.screen.ScreenRealyQuit;
import sk.inlogic.screen.ScreenSelectPack;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_ABOUT = 2;
    public static final int COMP_ID_SOUND = 3;
    private static final int COMP_ID_SETTINGS = 4;
    private static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_NONE = 6;
    private static final int TOTAL_COMP_IDS = 7;
    private final int _iNextScreenPack;
    private final int _iNextScreenInst;
    private final int _iNextScreenAbou;
    private final int _iNextScreenQuit;
    private Rectangle[] _rectItems = new Rectangle[7];
    private Rectangle _rectLogo;
    private int _iSelectedCompId;
    private int _iSelectorCompId;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int _iOffsetButton = 5;
    private int _iOffsetY;
    private int _iTmpSlctdCmpId;
    private int interuption = 0;
    private int _iCycle = 10;
    private int _iMusicControler = 0;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode = -1;
    private boolean _bChangeSequence = false;
    private boolean releasedTouch = false;
    private boolean activeButton = true;
    private Image _imgBg;
    private Image _imgGameLogo;
    private Sprite _sprButtonPrs;
    private Sprite _sprButtonRls;
    private Sprite _sprButtonBar;
    private Sprite _sprButtonIcons;
    private Sprite _sprFkIcons;
    private PreparedText _ptItemName;
    private AnimationComponent[] _animationComponents = new AnimationComponent[7];
    boolean check = false;
    private int sel = this._iSelectedCompId;
    private int force = this._iSelectedCompId;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem) {
        this._iNextScreenPack = 0;
        this._iNextScreenInst = 1;
        this._iNextScreenAbou = 2;
        this._iNextScreenQuit = 3;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.mainCanvas = mainCanvas;
        this._iSelectedCompId = selectedItem;
        this._iSelectorCompId = selectedItem;
        this.initDimensions();
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{2, 4});
        Resources.loadSprites(new int[]{3, 4, 5, 1, 0});
        Resources.loadGFont(0);
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.calculatePositions();
        this.preapreTxt();
        this.initAnimationComponents();
        this.startAnimation(true, -1);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{2, 4});
        Resources.freeSprites(new int[]{3, 4, 5, 1, 0});
        Resources.freeGFont(0);
        this.freeResources();
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgGameLogo = Resources.resImgs[4];
    }

    private void initSprites() {
        this._sprButtonPrs = Resources.resSprs[3];
        this._sprButtonRls = Resources.resSprs[4];
        this._sprButtonBar = Resources.resSprs[5];
        this._sprButtonIcons = Resources.resSprs[1];
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initFonts() {
        this._ptItemName = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectLogo, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectItems[0], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[1], this._WIDTH, this._HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectItems[2], this._WIDTH, this._HEIGHT);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this._rectItems[3], this._WIDTH, this._HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectItems[5], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(1);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(1);
    }

    private void preapreTxt() {
        this._ptItemName.prepareText("PLAY", this._rectItems[0].width);
    }

    private void freeResources() {
        this._imgBg = null;
        this._imgGameLogo = null;
        this._sprButtonPrs = null;
        this._sprButtonRls = null;
        this._sprButtonBar = null;
        this._sprButtonIcons = null;
        this._sprFkIcons = null;
        this._ptItemName = null;
    }

    public void beforeInteruption() {
        this.check = this.mainCanvas.getSoundManager().IsSoundOn();
        this.mainCanvas.getSoundManager().Stop();
    }

    public void afterInteruption() {
        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        this._iMusicControler = 0;
    }

    private void calculatePositions() {
        int itemHeight = this._sprButtonBar.getHeight();
        int itemWidth = this._sprButtonBar.getWidth();
        int fkHeight = this._sprButtonPrs.getHeight();
        int posX = 0;
        this._rectLogo = new Rectangle(this._WIDTH >> 1, 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        int _iOffsetY = this._HEIGHT - this._imgGameLogo.getWidth() - this._sprButtonBar.getWidth();
        int posY = this._imgGameLogo.getHeight() + (_iOffsetY >>= 3);
        this._rectItems[0] = new Rectangle(posX, posY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[1] = new Rectangle(posX, posY += itemHeight + _iOffsetY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[2] = new Rectangle(posX, posY += itemHeight + _iOffsetY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[3] = new Rectangle(posX, posY += itemHeight + _iOffsetY, this.mainCanvas.getWidth(), itemHeight);
        this._rectItems[4] = new Rectangle(0, MainCanvas.HEIGHT - fkHeight, itemWidth + (itemWidth >> 1), fkHeight);
        this._rectItems[5] = new Rectangle(MainCanvas.WIDTH - fkHeight, MainCanvas.HEIGHT - fkHeight, itemWidth + (itemWidth >> 1), itemHeight);
        _iOffsetY = (this._sprButtonBar.getHeight() >> 1) - (this._sprButtonRls.getHeight() >> 1);
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = nextMode == -1 ? this._iSequenceShow : this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationComponents.length; ++i) {
            if (this._animationComponents[i] == null || this._animationComponents[i].isComponentAnimated()) continue;
            this._animationComponents[i].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                this.startNextScreen(this._iNextMode);
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startNextScreen(int _iNextScreen) {
        switch (_iNextScreen) {
            case 0: {
                this.mainCanvas.changeLastActiveScreen(new ScreenSelectPack(this.mainCanvas, 0));
                break;
            }
            case 1: {
                this.mainCanvas.changeLastActiveScreen(new ScreenInstructions(this.mainCanvas));
                break;
            }
            case 2: {
                this.mainCanvas.changeLastActiveScreen(new ScreenAbout(this.mainCanvas));
                break;
            }
            case 3: {
                this.mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this.mainCanvas, this._iSelectorCompId));
            }
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintDialog(g);
        this.paintLogo(g);
        this.paintFK(g);
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectLogo.x, this._rectLogo.y, 17);
    }

    private void paintDialog(Graphics g) {
        if (this._iSelectorCompId == 0) {
            this.paintButton(g, 0, true);
        } else {
            this.paintButton(g, 0, false);
        }
        if (this._iSelectorCompId == 1) {
            this.paintButton(g, 1, true);
        } else {
            this.paintButton(g, 1, false);
        }
        if (this._iSelectorCompId == 2) {
            this.paintButton(g, 2, true);
        } else {
            this.paintButton(g, 2, false);
        }
        if (this._iSelectorCompId == 3) {
            this.paintButton(g, 3, true);
        } else {
            this.paintButton(g, 3, false);
        }
        this.paintButtonsTxt(g);
    }

    private void paintButton(Graphics g, int _iDx, boolean _bSelected) {
        if (_bSelected) {
            this._sprButtonRls.setFrame(0);
            this._sprButtonRls.setPosition(this._iOffsetButton + this._rectItems[_iDx].x, this._rectItems[_iDx].y + this._iOffsetY);
            this._sprButtonRls.paint(g);
            this._sprButtonRls.setFrame(1);
            for (int i = this._sprButtonRls.getWidth(); i < MainCanvas.WIDTH - this._iOffsetButton - this._sprButtonRls.getWidth(); i += this._sprButtonRls.getWidth()) {
                if (i > MainCanvas.WIDTH - this._iOffsetButton - this._sprButtonRls.getWidth() - (this._sprButtonRls.getWidth() >> 2)) continue;
                this._sprButtonRls.setPosition(this._iOffsetButton + i + this._rectItems[_iDx].x, this._rectItems[_iDx].y + this._iOffsetY);
                this._sprButtonRls.paint(g);
            }
            this._sprButtonRls.setFrame(2);
            this._sprButtonRls.setPosition(this._rectItems[_iDx].x - this._iOffsetButton + MainCanvas.WIDTH - this._sprButtonRls.getWidth(), this._rectItems[_iDx].y + this._iOffsetY);
            this._sprButtonRls.paint(g);
        } else {
            this._sprButtonPrs.setFrame(0);
            this._sprButtonPrs.setPosition(this._iOffsetButton + this._rectItems[_iDx].x, this._rectItems[_iDx].y + this._iOffsetY);
            this._sprButtonPrs.paint(g);
            this._sprButtonPrs.setFrame(1);
            for (int i = this._sprButtonPrs.getWidth(); i < MainCanvas.WIDTH - this._iOffsetButton - this._sprButtonPrs.getWidth(); i += this._sprButtonPrs.getWidth()) {
                if (i > MainCanvas.WIDTH - this._iOffsetButton - this._sprButtonPrs.getWidth() - (this._sprButtonPrs.getWidth() >> 2)) continue;
                this._sprButtonPrs.setPosition(this._iOffsetButton + i + this._rectItems[_iDx].x, this._rectItems[_iDx].y + this._iOffsetY);
                this._sprButtonPrs.paint(g);
            }
            this._sprButtonPrs.setFrame(2);
            this._sprButtonPrs.setPosition(this._rectItems[_iDx].x - this._iOffsetButton + MainCanvas.WIDTH - this._sprButtonPrs.getWidth(), this._rectItems[_iDx].y + this._iOffsetY);
            this._sprButtonPrs.paint(g);
        }
        this._sprButtonBar.setFrame(0 + (this._iSelectorCompId == _iDx ? 1 : 0));
        this._sprButtonBar.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonRls.getWidth() >> 1), this._rectItems[_iDx].y + (this._sprButtonPrs.getHeight() - this._sprButtonBar.getHeight() >> 1));
        this._sprButtonBar.paint(g);
        if (_iDx == 3) {
            this._sprButtonIcons.setFrame(this.mainCanvas.getSoundManager().IsSoundOn() ? 3 : 4);
        } else {
            this._sprButtonIcons.setFrame(_iDx);
        }
        this._sprButtonIcons.setPosition(this._iOffsetButton + this._rectItems[_iDx].x + (this._sprButtonRls.getWidth() >> 1) + (this._sprButtonBar.getWidth() >> 1) - (this._sprButtonIcons.getWidth() >> 1), this._rectItems[_iDx].y);
        this._sprButtonIcons.paint(g);
    }

    private void paintButtonsTxt(Graphics g) {
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(21), this._rectItems[0].width);
        this._ptItemName.drawText(g, this._rectItems[0], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(22), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[1], this._ptItemName.getTextHeight() >> 2, 3);
        this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(23), this._rectItems[1].width);
        this._ptItemName.drawText(g, this._rectItems[2], this._ptItemName.getTextHeight() >> 2, 3);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(26), this._rectItems[1].width);
        } else {
            this._ptItemName.prepareText(Resources.resTexts[0].getHashedString(27), this._rectItems[1].width);
        }
        this._ptItemName.drawText(g, this._rectItems[3], this._ptItemName.getTextHeight() >> 2, 3);
    }

    private void paintFK(Graphics g) {
        this._sprButtonPrs.setFrame(0);
        this._sprButtonPrs.setPosition(this._rectItems[5].x, this._rectItems[5].y);
        this._sprButtonPrs.paint(g);
        this._sprFkIcons.setFrame(6);
        this._sprFkIcons.setPosition(this._rectItems[5].x + (this._sprButtonRls.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1), this._rectItems[5].y + (this._sprButtonRls.getHeight() >> 1) - (this._sprFkIcons.getHeight() >> 1));
        this._sprFkIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        this._iTmpSlctdCmpId = keyCode;
        if (this.activeButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this._iSelectedCompId) {
                    case 0: {
                        this.startAnimation(true, 0);
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 1);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 2);
                        break;
                    }
                    case 3: {
                        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                            this.mainCanvas.getSoundManager().SetSoundOn(false);
                            Settings.musicOn = false;
                            this.mainCanvas.getSoundManager().Stop();
                            break;
                        }
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        Settings.musicOn = true;
                        this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        break;
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.startAnimation(true, 3);
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this._iSelectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.startAnimation(true, 0);
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.startAnimation(true, 1);
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 3;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.startAnimation(true, 2);
                            break;
                        }
                        case 3: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this._iSelectedCompId = 2;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this._iSelectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            if (this.mainCanvas.getSoundManager().IsSoundOn()) {
                                this.mainCanvas.getSoundManager().SetSoundOn(false);
                                this.mainCanvas.getSoundManager().Stop();
                                break;
                            }
                            this.mainCanvas.getSoundManager().SetSoundOn(true);
                            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
                        }
                    }
                }
                this._iSelectorCompId = this._iSelectedCompId;
                this._iTmpSlctdCmpId = this._iSelectedCompId;
                this.force = this._iSelectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._rectItems.length; ++i) {
            if (i == 6) {
                this._iSelectorCompId = this._iSelectedCompId = 6;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 6 || !this._rectItems[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 4: {
                    break;
                }
                case 5: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    this._iSelectorCompId = i;
                    this._iTmpSlctdCmpId = this._iSelectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._iSelectedCompId != 6) {
            if (!this._rectItems[this._iSelectedCompId].contains(x, y)) {
                switch (this._iSelectedCompId) {
                    case 4: {
                        break;
                    }
                    case 5: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this._iSelectorCompId = this._iSelectedCompId = 6;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iSelectedCompId != 6) {
            switch (this._iSelectedCompId) {
                case 5: {
                    this.mainCanvas.changeLastActiveScreen(new ScreenRealyQuit(this.mainCanvas, this._iSelectorCompId));
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this._iSelectorCompId = this._iSelectedCompId = 6;
        this.mainCanvas.repaint();
    }
}

