/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import sk.inlogic.Cube;
import sk.inlogic.Dot;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static Rectangle rectGameArea;
    private Rectangle _rectTxt;
    private int _iStatus;
    private int _iScore;
    private Cube _cube;
    private Dot _dot;
    private PreparedText _tapToStart = new PreparedText(Resources.resGFonts[0]);
    private boolean _pressed = false;

    public void restartGame(Rectangle _rectArea, int _dotStartX, int _dotStartY) {
        this._iStatus = 0;
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._rectTxt = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this._tapToStart.prepareText(Resources.resTexts[0].getHashedString(80), MainCanvas.WIDTH);
        this._tapToStart.prepareText(Resources.resTexts[0].getHashedString(81), MainCanvas.WIDTH);
        rectGameArea = _rectArea;
        this._cube = new Cube(rectGameArea);
        this._dot = new Dot(_dotStartX, _dotStartY, Game.rectGameArea.y + (Game.rectGameArea.height >> 1));
        this._iScore = 0;
    }

    public void update(long lastRunLenght) {
        if (this._iStatus == 1) {
            this._cube.update();
            this._dot.update();
            this.checkScore();
        }
    }

    public void paint(Graphics g, int status) {
        if (this._iStatus == 0) {
            this._tapToStart.drawText(g, this._rectTxt, this._tapToStart.getTextHeight(), 3);
        }
        if (this._iStatus != 3 && status == 0) {
            this._dot.paint(g);
        }
        this._cube.paint(g);
    }

    private void checkScore() {
        if (this._dot.getActualBotomPosition() > this._cube.getCubeTop() + (this._dot.getSprite().getHeight() << 1)) {
            if (this._dot.getActualColor() == this._cube.getActualColor()) {
                ++this._iScore;
                this._dot.reset();
            } else {
                this._iStatus = 3;
            }
        }
    }

    public void rotate() {
        if (this._iStatus == 0) {
            this._iStatus = 1;
            return;
        }
        this._cube.rotateCube();
    }

    public void DragOrDrop() {
    }

    public void pointerPressed(int x, int y) {
        this._pressed = true;
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this.rotate();
            this._pressed = false;
        }
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        return this._iStatus == 0;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }
}

