/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Cube {
    public int _iActualColor = 0;
    public static final int _COLOR_RED = 0;
    public static final int _COLOR_YELLOW = 1;
    public static final int _COLOR_GREEN = 2;
    public static final int _COLOR_BLUE = 3;
    public static final int _TOTAL_COLOR = 4;
    private int _iActualFrame = 0;
    private int[] _FROM_GREEN_TO_BLUE_ANIMATION = new int[]{4, 5, 5, 6};
    private int[] _FROM_YELLOW_TO_GREEN_ANIMATION = new int[]{2, 3, 3, 4};
    private int[] _FROM_BLUE_TO_RED_ANIMATION = new int[]{6, 7, 7, 0};
    private int[] _FROM_RED_TO_YELLOW_ANIMATION = new int[]{0, 1, 1, 2};
    public static final int _TOTAL_FRAME = 2;
    int _iTmpNumber = 0;
    private boolean _bIsRotate = false;
    private Sprite _cube;
    private Rectangle _cubeRect;

    public Cube(Rectangle _rect) {
        this._cubeRect = _rect;
        this.initSprite();
        this.restart();
    }

    void restart() {
        this._iTmpNumber = Math.abs(RandomNum.getRandomInt(100, 0));
        this._iActualColor = this._iTmpNumber < 20 ? 0 : (this._iTmpNumber < 40 ? 1 : (this._iTmpNumber < 60 ? 2 : (this._iTmpNumber < 80 ? 3 : Math.abs(RandomNum.getRandomInt(3, 0)))));
        this._iActualFrame = 0;
    }

    private void initSprite() {
        this._cube = Resources.resSprs[0];
    }

    public void update() {
        if (this._bIsRotate) {
            this.updateCubeAnimation();
        }
    }

    private void updateCubeAnimation() {
        if (this._iActualFrame < 2) {
            ++this._iActualFrame;
        } else {
            this._iActualFrame = 0;
            this._bIsRotate = false;
        }
    }

    public void paint(Graphics g) {
        this._cube.setPosition(this._cubeRect.x, this._cubeRect.y);
        this._cube.setFrame(this.getActualFrame());
        this._cube.paint(g);
    }

    private int getActualFrame() {
        switch (this._iActualColor) {
            case 3: {
                return this._FROM_BLUE_TO_RED_ANIMATION[this._iActualFrame];
            }
            case 2: {
                return this._FROM_GREEN_TO_BLUE_ANIMATION[this._iActualFrame];
            }
            case 0: {
                return this._FROM_RED_TO_YELLOW_ANIMATION[this._iActualFrame];
            }
            case 1: {
                return this._FROM_YELLOW_TO_GREEN_ANIMATION[this._iActualFrame];
            }
        }
        return 0;
    }

    public void rotateCube() {
        if (this._bIsRotate) {
            return;
        }
        this.incActualColor(1);
        this._bIsRotate = true;
    }

    public int getCubeTop() {
        return this._cubeRect.y;
    }

    public int getActualColor() {
        return this._iActualColor;
    }

    public void incActualColor(int _i) {
        this._iActualColor = this._iActualColor == 3 ? 0 : (this._iActualColor += _i);
    }

    public int getNextColor() {
        if (this._iActualColor == 3) {
            return 0;
        }
        return this._iActualColor + 1;
    }

    public String getColorName() {
        switch (this._iActualColor) {
            case 3: {
                return "BLUE";
            }
            case 2: {
                return "GREEN";
            }
            case 0: {
                return "RED";
            }
            case 1: {
                return "YELLOW";
            }
        }
        return "NaN";
    }
}

