/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int[][] _animationSequence = new int[7][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] rectItems_TXT = new Rectangle[9];
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectBB_BACK;
    private Rectangle rectBB_MENU;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle rectTopBig;
    private Rectangle rectTopLittle;
    private Rectangle rectTopLittleTXT;
    private Rectangle rectTitle;
    private int selectedCompId;
    private static PreparedText menuItem;
    private static PreparedText instruction;
    private static PreparedText actualScore;
    private static PreparedText navigationKeysBB;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _gameLogo;
    private Image _score;
    private Image _scoreBest;
    private Sprite _cube;
    private Sprite _dot;
    private Sprite _border;
    private Sprite _icons;
    private static int _WIDTH;
    private static int _HEIGHT;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, boolean tutorial) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.status = 0;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{1, 2, 3});
        Resources.loadSprites(new int[]{0, 1, 4, 2});
        Resources.loadGFonts(new int[]{0, 1, 2});
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this.rectGameArea, _WIDTH >> 1, -this._dot.getHeight());
    }

    public void afterHide() {
        this.freeGraphics();
        Resources.freeImages(new int[]{1, 2, 3});
        Resources.freeSprites(new int[]{0, 1, 4, 2});
        Resources.freeGFonts(new int[]{0, 1, 2});
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._gameLogo = Resources.resImgs[1];
        this._score = Resources.resImgs[2];
        this._scoreBest = Resources.resImgs[3];
    }

    private void initSprites() {
        this._cube = Resources.resSprs[0];
        this._dot = Resources.resSprs[1];
        this._border = Resources.resSprs[4];
        this._icons = Resources.resSprs[2];
    }

    public void initTxt() {
        Resources.loadText(0);
        menuItem = new PreparedText(Resources.resGFonts[0]);
        instruction = new PreparedText(Resources.resGFonts[1]);
        menuItem = new PreparedText(Resources.resGFonts[0]);
        actualScore = new PreparedText(Resources.resGFonts[2]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 12;
        this._animationSequence[0][1] = 13;
        this._animationSequence[0][2] = 14;
        this._animationSequence[0][3] = 17;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 5;
        this._animationSequence[1][6] = 6;
        this._animationSequence[1][7] = 7;
        this._animationSequence[1][8] = 15;
        this._animationSequence[1][9] = 17;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 11;
        this._animationSequence[3][2] = 17;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = 16;
        this._animationSequence[6][3] = 17;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[6][6] = -1;
        this._animationSequence[6][7] = -1;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = 16;
        this._animationSequence[5][3] = 17;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = 9;
        this._animationSequence[2][2] = 16;
        this._animationSequence[2][3] = 17;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[0], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[3], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems_TXT[2], _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(3);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this.rectTopLittle, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectTopLittleTXT, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this.rectBestScore, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(0);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this.rectGameArea, _WIDTH, _HEIGHT);
        this._animationComponents[14].startShowAnimation(3);
        this._animationComponents[15] = new AnimationComponent(this.mainCanvas, this.rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[15].startShowAnimation(2);
        this._animationComponents[16] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT);
        this._animationComponents[16].startShowAnimation(0);
        this._animationComponents[17] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT);
        this._animationComponents[17].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(3);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(0);
        this._animationComponents[14].startShowAnimation(3);
        this._animationComponents[15].startShowAnimation(2);
        this._animationComponents[16].startShowAnimation(0);
        this._animationComponents[17].startShowAnimation(1);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(0);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(3);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(2);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(0);
        this._animationComponents[14].startHideAnimation(3);
        this._animationComponents[15].startHideAnimation(2);
        this._animationComponents[16].startHideAnimation(0);
        this._animationComponents[17].startHideAnimation(1);
    }

    private void freeGraphics() {
        this._cube = null;
        this._dot = null;
        this._border = null;
        this._icons = null;
        this._gameLogo = null;
        this._score = null;
        this._scoreBest = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(16);
        instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        instruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores;
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        if ((scores = RMSObjects.bestScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
            if (!RMSObjects.rmsConnects[1].isExist()) {
                RMSObjects.rmsConnects[1].create();
            }
            RMSObjects.rmsConnects[1].save();
        }
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void calculatePositions() {
        int _xGameOffset = _WIDTH - this._cube.getWidth() >> 1;
        int _yGameOffset = _HEIGHT - this._cube.getWidth();
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        int rectPanelY = (this._border.getHeight() << 1) + itemHeight;
        int rectTextOffsetX = this._icons.getWidth();
        int rectTextOffsetY = this._icons.getHeight();
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        this.rectGameArea = new Rectangle(_xGameOffset, _yGameOffset, this._cube.getWidth(), this._cube.getHeight());
        this.rectScore = new Rectangle(this._icons.getHeight() >> 1, 0, this.mainCanvas.getWidth() - this._icons.getHeight(), this._score.getHeight() << 1);
        this.rectBestScore = new Rectangle(this._icons.getHeight() >> 1, 0, this.mainCanvas.getWidth() - this._icons.getHeight(), this._score.getHeight() << 1);
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectTitle = new Rectangle(posX, itemHeight / 2, itemWidth, itemHeight);
        posX = _WIDTH - itemWidth >> 1;
        posY = this.rectPanel.getTop() + itemHeight;
        posX = 0;
        posY = this._gameLogo.getHeight() + (_HEIGHT - this._gameLogo.getHeight() - 4 * (itemHeight + itemHeight / 10 + this._border.getHeight()) >> 1);
        this.rectItems[3] = new Rectangle(posX, posY, itemWidth, itemHeight);
        this.rectItems[4] = new Rectangle(posX, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectItems[6] = new Rectangle(posX, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectItems[5] = new Rectangle(posX, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - this._icons.getHeight(), this._icons.getWidth(), this._icons.getHeight());
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - this._icons.getWidth(), MainCanvas.HEIGHT - this._icons.getHeight(), this._icons.getWidth(), this._icons.getHeight());
        posX = 0;
        posY = this._gameLogo.getHeight() + (_HEIGHT - this._gameLogo.getHeight() - 4 * (itemHeight + itemHeight / 10 + this._border.getHeight()) >> 1);
        this.rectItems_TXT[0] = new Rectangle(0, posY, itemWidth, itemHeight);
        this.rectItems_TXT[1] = new Rectangle(0, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectItems_TXT[3] = new Rectangle(0, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectItems_TXT[2] = new Rectangle(0, posY += itemHeight + itemHeight / 10 + this._border.getHeight(), itemWidth, itemHeight);
        this.rectLeftFk = new Rectangle(0, _HEIGHT - this._icons.getHeight(), this._icons.getWidth(), this._icons.getHeight());
        this.rectBB_BACK = new Rectangle(0, MainCanvas.HEIGHT - itemHeight, _WIDTH - this._icons.getWidth(), itemHeight);
        this.rectRightFk = new Rectangle(this.mainCanvas.getWidth() - this._icons.getWidth(), _HEIGHT - this._icons.getHeight(), this._icons.getWidth(), this._icons.getHeight());
        this.rectBB_MENU = new Rectangle(this._icons.getWidth(), MainCanvas.HEIGHT - itemHeight, _WIDTH, itemHeight);
        this.rectPlay = new Rectangle(0, _HEIGHT >> 1, _WIDTH, itemHeight);
        this.rectTopBig = new Rectangle(_WIDTH >> 1, 0, this._gameLogo.getWidth(), this._gameLogo.getHeight());
        this.rectTopLittle = new Rectangle((_WIDTH >> 1) - (this._border.getWidth() >> 1), 0, this._border.getWidth(), rectPanelY);
        this.rectTopLittleTXT = new Rectangle((_WIDTH >> 1) - (this._border.getWidth() >> 1), 0, this._border.getWidth(), rectPanelY);
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
        if (this.status == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
            }
            this.mainCanvas.repaint();
        }
        if (this.status == 2) {
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        this.paintPanelTop(g);
        RMSObjects.game.paint(g, this.status);
        switch (this.status) {
            case 1: {
                this.paintBackground(g);
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintBackground(g);
                this.paintMessage(g);
                break;
            }
            case 3: {
                this.paintBackground(g);
                this.paintInstructions(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintBackground(g);
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintBackground(g);
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._gameLogo, this.rectTopBig.x, this.rectTopBig.y, 17);
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            menuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            menuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            String text = Resources.resTexts[0].getHashedString(13) + "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(52);
            menuItem.prepareText(text, this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            menuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            menuItem.drawText(g, this.rectText, menuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintArrows(Graphics g) {
        this._border.setPosition(this.rectTopLittle.x, this.rectTopLittle.y + this._border.getHeight());
        this._border.setTransform(1);
        this._border.paint(g);
        this._border.setTransform(0);
        this._border.setPosition(this.rectTopLittle.x, this.rectTopLittle.y + this.rectTopLittle.height - this._border.getHeight());
        this._border.paint(g);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectTitle.width);
        menuItem.drawText(g, this.rectTopLittleTXT, 0, 3);
        System.out.println("som tu tu tu " + this.scrollDOWN + " " + this.scrollUP);
        if (this.scrollDOWN && this.scrollUP) {
            this._icons.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._icons.getWidth() >> 2), this.rectPanel.y);
            this._icons.setFrame(1);
            this._icons.paint(g);
            this._icons.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._icons.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height - (this._icons.getWidth() << 1));
            this._icons.setFrame(2);
            this._icons.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._icons.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._icons.getWidth() >> 2), this.rectPanel.y);
            this._icons.setFrame(1);
            this._icons.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._icons.setPosition((this.rectPanel.x + this.rectPanel.width >> 1) - (this._icons.getWidth() >> 2), this.rectPanel.y + this.rectPanel.height - (this._icons.getWidth() << 1));
            this._icons.setFrame(2);
            this._icons.paint(g);
        }
    }

    private void paintInstructions(Graphics g) {
        instruction.drawText(g, this.rectText, this.textOffsetY, 20);
        if (this.scrollDOWN && this.scrollUP) {
            this._icons.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._icons.getWidth() >> 2), this.rectText.y - this._icons.getWidth());
            this._icons.setFrame(1);
            this._icons.paint(g);
            this._icons.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._icons.getWidth() >> 2), this.rectText.y + this.rectText.height);
            this._icons.setFrame(2);
            this._icons.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._icons.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._icons.getWidth() >> 2), this.rectText.y - this._icons.getWidth());
            this._icons.setFrame(1);
            this._icons.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._icons.setPosition((this.rectText.x + this.rectText.width >> 1) - (this._icons.getWidth() >> 2), this.rectText.y + this.rectText.height);
            this._icons.setFrame(2);
            this._icons.paint(g);
        }
    }

    private void paintPanelTop(Graphics g) {
        String score = RMSObjects.game.getScore() + "";
        String addscore = "000000";
        addscore = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(addscore + RMSObjects.game.getScore(), this.rectScore.width);
        actualScore.drawText(g, this.rectScore, 0, 10);
        g.drawImage(this._score, this.rectScore.x + this.rectScore.width, this.rectScore.height, 24);
        score = this.bestScoreSave + "";
        String s = "000000";
        s = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(s + this.bestScoreSave, this.rectScore.width);
        actualScore.drawText(g, this.rectBestScore, 0, 6);
        g.drawImage(this._scoreBest, this.rectBestScore.x, this.rectBestScore.height, 20);
    }

    public void paintTop(Graphics g) {
        if (this.status == 3) {
            this._border.setPosition(this.rectTopLittle.x, this.rectTopLittle.y + this._border.getHeight());
            this._border.setTransform(1);
            this._border.paint(g);
            this._border.setTransform(0);
            this._border.setPosition(this.rectTopLittle.x, this.rectTopLittle.y + this.rectTopLittle.height - this._border.getHeight());
            this._border.paint(g);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectText.width);
            menuItem.drawText(g, this.rectTopLittleTXT, 0, 3);
        } else if (this.status == 4) {
            // empty if block
        }
    }

    private void paintFK(Graphics g) {
        if (this.status == 0) {
            this._icons.setFrame(3);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
        } else if (this.status == 4) {
            this._icons.setFrame(6);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
        } else if (this.status == 1) {
            this._icons.setFrame(6);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
        } else if (this.status == 3) {
            this._icons.setFrame(6);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
        } else if (this.status == 5) {
            this._icons.setFrame(5);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
            this._icons.setFrame(4);
            this._icons.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
            this._icons.paint(g);
        } else if (this.status == 6) {
            this._icons.setFrame(5);
            this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._icons.paint(g);
            this._icons.setFrame(4);
            this._icons.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
            this._icons.paint(g);
        } else if (this.status == 2) {
            if (RMSObjects.game.isGameOver()) {
                this._icons.setFrame(5);
                this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._icons.paint(g);
                this._icons.setFrame(4);
                this._icons.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._icons.paint(g);
            } else {
                this._icons.setFrame(5);
                this._icons.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._icons.paint(g);
                this._icons.setFrame(4);
                this._icons.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._icons.paint(g);
            }
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 3) {
            this.paintButton(g, 3, 0, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this.rectItems_TXT[0].width);
            menuItem.drawText(g, this.rectItems_TXT[0], 0, 3);
        } else {
            this.paintButton(g, 3, 0, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this.rectItems_TXT[0].width);
            menuItem.drawText(g, this.rectItems_TXT[0], 0, 3);
        }
        if (this.selectedCompId == 6) {
            this.paintButton(g, 6, 1, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems_TXT[3].width);
            menuItem.drawText(g, this.rectItems_TXT[3], 0, 3);
        } else {
            this.paintButton(g, 6, 1, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems_TXT[3].width);
            menuItem.drawText(g, this.rectItems_TXT[3], 0, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButton(g, 4, 1, true);
            menuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectItems_TXT[1].width);
            menuItem.drawText(g, this.rectItems_TXT[1], 0, 3);
        } else {
            this.paintButton(g, 4, 1, false);
            menuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectItems_TXT[1].width);
            menuItem.drawText(g, this.rectItems_TXT[1], 0, 3);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, 2, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this.rectItems_TXT[2].width);
            menuItem.drawText(g, this.rectItems_TXT[2], 0, 3);
        } else {
            this.paintButton(g, 5, 2, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this.rectItems_TXT[2].width);
            menuItem.drawText(g, this.rectItems_TXT[2], 0, 3);
        }
    }

    private void paintButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            this._border.setPosition(this.rectItems[_type].x + (_WIDTH >> 1) - (this._border.getWidth() >> 1), this.rectItems[_type].y + this.rectItems[_type].height);
            this._border.paint(g);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode) || keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isActionGeneratedByKey(5, keyCode)) break;
                RMSObjects.game.rotate();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.startAnimation(true, 7);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this.rectGameArea, _WIDTH >> 1, -this._dot.getHeight());
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                RMSObjects.game.restartGame(this.rectGameArea, _WIDTH >> 1, -this._dot.getHeight());
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
                this.selectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = instruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

