/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int _IMG_INLOGIC_LOGO = 0;
    public static final int _IMG_MENU_LOGO = 1;
    public static final int _IMG_SCORE = 2;
    public static final int _IMG_HIGH_SCORE = 3;
    public static final int _IMG_RES_ROTATION = 4;
    public static final int TOTAL_IMGS = 5;
    public static Image[] resImgs = new Image[5];
    public static final int _SPR_GAME_CUBE = 0;
    public static final int _SPR_GAME_DOTS = 1;
    public static final int _SPR_ICONS = 2;
    public static final int _SPR_LANGUAGE = 3;
    public static final int _SPR_BORDER = 4;
    public static final int _SPR_SELECTOR = 5;
    public static final int TOTAL_SPRS = 6;
    public static Sprite[] resSprs = new Sprite[6];
    public static final int _GFONT_MAIN = 0;
    public static final int _GFONT_INSTRUCTIONS = 1;
    public static final int _GFONT_SCORE = 2;
    public static final int TOTAL_GFONTS = 3;
    public static GFont[] resGFonts = new GFont[3];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 79;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[79];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static final int TEXT_CONTR_TITLE = 79;
    public static final int TEXT_START_KEYS = 80;
    public static final int TEXT_START_TOCH = 81;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 1: {
                imgPath = graphicsBaseDir + "logo.png";
                break;
            }
            case 0: {
                imgPath = graphicsBaseDir + "I.png";
                break;
            }
            case 3: {
                if (MainCanvas.languageFR) {
                    imgPath = graphicsBaseDir + "high_score_text_fr.png";
                    break;
                }
                imgPath = graphicsBaseDir + "high_scote_text.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "score_text.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "rot.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "cube.png";
                slicesX = 4;
                slicesY = 2;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "dots.png";
                slicesX = 4;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "icons.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 4;
                slicesY = 3;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "border.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "selector.png";
                slicesX = 1;
                slicesY = 1;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\'', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 10: {
                fontCharsWidth = new short[]{4, 4, 4, 4, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 4, 4, 5, 2, 2, 5, 3, 5, 3, 3, 5, 3, 1, 1, 1, 1, 2, 3, 1, 4, 1, 3, 3, 3, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 14: {
                fontCharsWidth = new short[]{9, 10, 9, 9, 10, 10, 9, 9, 3, 8, 10, 8, 13, 10, 9, 10, 9, 9, 10, 10, 9, 9, 14, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 10, 9, 10, 9, 9, 4, 4, 6, 3, 8, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 10, 9, 9, 10, 9, 10, 9, 10, 10, 10, 13, 6, 7, 9, 4, 4, 9, 3, 5, 7, 8, 8, 6, 2, 3, 3, 3, 4, 6, 3, 10, 3, 10, 8, 8, 9, 5, 10, 10, 10, 10, 9, 9, 10, 9, 9};
                break;
            }
            case 16: {
                fontCharsWidth = new short[]{9, 11, 7, 8, 8, 10, 6, 6, 9, 8, 3, 5, 8, 6, 10, 9, 10, 10, 7, 9, 7, 6, 7, 7, 8, 13, 7, 8, 8, 8, 8, 9, 8, 9, 9, 8, 7, 9, 6, 6, 6, 6, 6, 3, 3, 5, 4, 3, 6, 8, 9, 9, 10, 9, 10, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 7, 8, 8, 9, 6, 8, 7, 6, 6, 8, 7, 9, 6, 10, 4, 4, 8, 9, 5, 8, 3, 3, 3, 3, 3, 3, 2, 11, 5, 8, 7, 7, 7, 7, 7, 8, 3, 3, 3, 2, 3, 4, 5, 3, 5, 3, 5, 2, 5, 7, 4, 4, 7, 6, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{11, 13, 12, 12, 12, 13, 12, 11, 4, 9, 13, 10, 17, 13, 12, 13, 13, 12, 12, 12, 12, 13, 17, 12, 13, 13, 13, 12, 12, 12, 13, 12, 13, 13, 12, 12, 12, 12, 13, 13, 5, 4, 7, 4, 9, 13, 13, 12, 12, 12, 13, 13, 13, 13, 13, 12, 12, 13, 13, 13, 12, 13, 11, 13, 13, 12, 11, 13, 17, 7, 7, 12, 6, 5, 12, 4, 7, 8, 9, 9, 8, 4, 3, 3, 3, 6, 4, 4, 12, 3, 12, 10, 10, 13, 5, 12, 12, 13, 13, 13, 12, 12, 12};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{16, 16, 17, 15, 17, 17, 16, 16, 6, 13, 16, 13, 23, 17, 17, 16, 16, 17, 16, 16, 16, 16, 23, 17, 16, 16, 17, 17, 17, 17, 16, 16, 16, 16, 17, 16, 16, 16, 17, 17, 6, 6, 10, 5, 13, 17, 16, 16, 16, 17, 17, 17, 16, 16, 16, 17, 17, 16, 16, 16, 16, 17, 16, 16, 16, 16, 16, 17, 22, 9, 11, 15, 7, 7, 15, 5, 10, 10, 13, 13, 10, 4, 4, 4, 4, 6, 9, 5, 16, 4, 16, 14, 12, 17, 7, 16, 16, 17, 16, 17, 16, 17, 17};
                break;
            }
            case 29: {
                fontCharsWidth = new short[]{18, 19, 18, 18, 20, 18, 19, 19, 5, 15, 19, 14, 25, 19, 19, 19, 18, 19, 18, 19, 18, 19, 25, 19, 18, 19, 19, 19, 19, 18, 19, 18, 18, 19, 19, 18, 19, 18, 19, 18, 7, 7, 12, 6, 15, 19, 19, 19, 19, 19, 18, 18, 19, 18, 19, 19, 18, 19, 18, 19, 18, 19, 19, 18, 19, 18, 18, 19, 25, 11, 11, 17, 8, 7, 17, 6, 12, 11, 14, 14, 11, 4, 5, 4, 5, 7, 10, 4, 18, 5, 18, 15, 15, 19, 7, 19, 19, 18, 18, 18, 18, 18, 18};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
            case 39: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\'', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\'', '/', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontCharsWidth = new short[]{24, 24, 24, 24, 25, 24, 25, 25, 7, 20, 24, 20, 34, 24, 24, 24, 24, 25, 24, 24, 25, 23, 35, 25, 24, 25, 24, 24, 24, 25, 25, 24, 24, 24, 25, 24, 25, 24, 24, 24, 9, 9, 15, 8, 20, 25, 25, 24, 25, 24, 25, 25, 24, 25, 24, 24, 25, 24, 24, 25, 25, 24, 24, 24, 24, 25, 24, 24, 34, 15, 14, 23, 10, 10, 22, 7, 15, 14, 20, 19, 15, 5, 6, 5, 5, 9, 12, 6, 23, 6, 24, 19, 20, 24, 10, 24, 24, 24, 24, 25, 24, 24, 24};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontInstruction(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\'', '\'', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 10: {
                fontCharsWidth = new short[]{4, 5, 4, 4, 4, 5, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 5, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 5, 5, 5, 5, 5, 3, 5, 4, 4, 5, 5, 5, 5, 2, 2, 3, 3, 2, 2, 1, 5, 3, 3, 3, 5, 3, 5, 5, 3, 2, 1, 1, 1, 1, 4, 4, 2, 3, 1, 4, 1, 4, 2, 3, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 16: {
                fontCharsWidth = new short[]{9, 11, 7, 8, 8, 10, 6, 6, 9, 8, 3, 5, 8, 6, 10, 9, 10, 10, 7, 9, 7, 6, 7, 7, 8, 13, 7, 8, 8, 8, 8, 9, 8, 9, 9, 8, 7, 9, 6, 6, 6, 6, 6, 3, 3, 5, 4, 3, 6, 8, 9, 9, 10, 9, 10, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 7, 8, 8, 9, 6, 8, 7, 6, 6, 8, 7, 9, 6, 10, 4, 4, 8, 9, 5, 8, 3, 3, 3, 3, 3, 3, 2, 11, 5, 8, 7, 7, 7, 7, 7, 8, 3, 3, 3, 2, 3, 4, 5, 3, 5, 3, 5, 2, 5, 7, 4, 4, 7, 6, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    private static GFont createGFontGameScore(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 10: {
                fontCharsWidth = new short[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
                break;
            }
            case 12: {
                fontCharsWidth = new short[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
                break;
            }
            case 15: {
                fontCharsWidth = new short[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
                break;
            }
            case 20: {
                fontCharsWidth = new short[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
                break;
            }
            case 22: {
                fontCharsWidth = new short[]{15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
                break;
            }
            case 14: {
                fontCharsWidth = new short[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
                break;
            }
            case 17: {
                fontCharsWidth = new short[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
                break;
            }
            case 18: {
                fontCharsWidth = new short[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
                break;
            }
            case 23: {
                fontCharsWidth = new short[]{23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23};
                break;
            }
            case 30: {
                fontCharsWidth = new short[]{30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30};
                break;
            }
            case 31: {
                fontCharsWidth = new short[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
                break;
            }
            case 34: {
                fontCharsWidth = new short[]{21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
                break;
            }
            case 35: {
                fontCharsWidth = new short[]{35, 35, 35, 35, 35, 35, 35, 35, 21, 35, 35, 35};
                break;
            }
            case 37: {
                fontCharsWidth = new short[]{25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25};
                break;
            }
            case 42: {
                fontCharsWidth = new short[]{28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28};
                break;
            }
            case 46: {
                fontCharsWidth = new short[]{46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46};
                break;
            }
            case 50: {
                fontCharsWidth = new short[]{33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33};
                break;
            }
            case 75: {
                fontCharsWidth = new short[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50};
                break;
            }
            default: {
                fontCharsWidth = new short[]{7, 8, 8, 12, 18, 14, 19, 19, 20, 19, 18, 19, 18, 18};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontInstruction.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontMain.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMain(gFontImg);
                break;
            }
            case 2: {
                gFontImg = Resources.createImage(graphicsBaseDir + "score.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGameScore(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        if (langCode.equals("fr")) {
            MainCanvas.languageFR = true;
        }
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

