/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.ui;

import java.util.Random;
import zed.rollNRun.ui.MainCanvas;

public class Patterns {
    public static byte coinDist = (byte)20;
    public static byte MULTIPLYER = (byte)5;
    public static Random mRandom;

    public static int[][] generatePattern(int x, int y, byte numCoins, byte pattern) {
        int[][] coinPos;
        switch (pattern) {
            case 0: {
                coinPos = Patterns.horLine(x, y, numCoins);
                break;
            }
            case 1: {
                coinPos = Patterns.vertLine(x, y, numCoins);
                break;
            }
            case 2: {
                coinPos = Patterns.diamond(x, y, numCoins);
                break;
            }
            case 3: {
                coinPos = Patterns.vertLineLeftToRight(x, y, numCoins);
                break;
            }
            case 4: {
                coinPos = Patterns.vertLineRightToLeft(x, y, numCoins);
                break;
            }
            case 5: {
                coinPos = Patterns.arrowUp(x, y, numCoins);
                break;
            }
            case 6: {
                coinPos = Patterns.arrowLeftRight(x, y, numCoins);
                break;
            }
            case 7: {
                coinPos = Patterns.arrowRightLeft(x, y, numCoins);
                break;
            }
            case 8: {
                coinPos = Patterns.SShape(x, y, numCoins);
                break;
            }
            case 9: {
                coinPos = Patterns.circleArc(x, y, 20, 15, numCoins);
                break;
            }
            case 10: {
                coinPos = Patterns.circleArc(x, y, 20, 45, numCoins);
                break;
            }
            case 11: {
                coinPos = Patterns.circleArc(x, y, 20, 220, numCoins);
                break;
            }
            case 12: {
                coinPos = Patterns.circleArc(x, y, 20, 270, numCoins);
                break;
            }
            case 13: {
                coinPos = Patterns.circleArc(x, y, 20, 330, numCoins);
                break;
            }
            default: {
                coinPos = Patterns.randomPos(x, y, numCoins);
            }
        }
        MainCanvas.log("pattern : " + pattern);
        return coinPos;
    }

    static int[][] randomPos(int x, int y, byte numCoins) {
        if (mRandom == null) {
            mRandom = new Random();
        }
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins) {
            int[] nArray = xy[i];
            MainCanvas.getInstance();
            MainCanvas.getInstance();
            nArray[0] = MainCanvas.ADDITIONAL_WIDTH + 25 + Math.abs(mRandom.nextInt(MainCanvas.SCREEN_WIDTH - 50));
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        return xy;
    }

    static int[][] vertLine(int x, int y, byte numCoins) {
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins) {
            xy[i][0] = x;
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        return xy;
    }

    static int[][] horLine(int x, int y, byte numCoins) {
        x -= numCoins / 2 * (coinDist / 2) - coinDist / 2;
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins / 2) {
            xy[i][0] = x;
            x += coinDist * 2;
            xy[i][1] = y;
            ++i;
        }
        y += coinDist * MULTIPLYER;
        x = xy[0][0];
        i = numCoins / 2;
        while (i < numCoins) {
            xy[i][0] = x;
            x += coinDist * 2;
            xy[i][1] = y;
            ++i;
        }
        return xy;
    }

    static int[][] vertLineLeftToRight(int x, int y, byte numCoins) {
        x += numCoins / 2 * (coinDist / 2) - coinDist / 2;
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins / 2) {
            xy[i][0] = x;
            x += -coinDist;
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        x = xy[0][0];
        i = numCoins / 2;
        while (i < numCoins) {
            xy[i][0] = x;
            x += -coinDist;
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        return xy;
    }

    static int[][] vertLineRightToLeft(int x, int y, byte numCoins) {
        x -= numCoins / 2 * (coinDist / 2) - coinDist / 2;
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins / 2) {
            xy[i][0] = x;
            x += coinDist;
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        x = xy[0][0];
        i = numCoins / 2;
        while (i < numCoins) {
            xy[i][0] = x;
            x += coinDist;
            xy[i][1] = y;
            y += coinDist * MULTIPLYER;
            ++i;
        }
        return xy;
    }

    static int[][] diamond(int x, int y, byte numCoins) {
        int[][] xy = new int[numCoins][2];
        int divX = 0;
        int divY = ((numCoins / 2 + 1) / 2 + 1) * (coinDist * MULTIPLYER);
        int i = 0;
        while (i < numCoins) {
            xy[i][0] = x + divX;
            xy[i][1] = y + divY;
            if (i != 0 && i != numCoins - 1) {
                xy[++i][0] = x - divX;
                xy[i][1] = y + divY;
            }
            divX = i < numCoins / 2 ? (divX += coinDist) : (divX -= coinDist);
            ++i;
            divY += coinDist * MULTIPLYER;
        }
        return xy;
    }

    static int[][] arrowUp(int x, int y, byte numCoins) {
        int[][] xy = new int[numCoins][2];
        int divX = 0;
        int divY = ((numCoins / 2 + 1) / 2 + 1) * (coinDist * MULTIPLYER);
        int i = 0;
        while (i < numCoins / 2 + 1) {
            xy[i][0] = x + divX;
            xy[i][1] = divY + y;
            if (i != 0) {
                xy[++i][0] = x - divX;
                xy[i][1] = divY + y;
            }
            divX += coinDist;
            ++i;
            divY += coinDist * MULTIPLYER;
        }
        y += coinDist * MULTIPLYER;
        i = numCoins / 2 + 1;
        while (i < numCoins) {
            xy[i][0] = x;
            xy[i][1] = divY + y;
            ++i;
            divY += coinDist * MULTIPLYER;
        }
        return xy;
    }

    static int[][] arrowLeftRight(int x, int y, byte numCoins) {
        int[][] xy = new int[numCoins][2];
        int i = 0;
        int j = -2;
        while (i < numCoins - 4) {
            if (i < (numCoins - 4) / 3 + 1) {
                xy[i][0] = x + (numCoins - 4) / 3 / 2 - coinDist;
            } else if (i < (numCoins - 4) / 3 * 2) {
                xy[i][0] = x + ((numCoins - 4) / 3 / 2 + j) * coinDist;
                ++j;
            } else {
                xy[i][0] = x + -((numCoins - 4) / 3) / 2 + coinDist;
            }
            xy[i][1] = y + i * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
            ++i;
        }
        xy[numCoins - 4][0] = x + (numCoins - 4) / 3 / 2;
        xy[numCoins - 4][1] = y + 1 * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 3][0] = x + (numCoins - 4) / 3 / 2 - coinDist * 2;
        xy[numCoins - 3][1] = y + 1 * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 2][0] = x + -((numCoins - 4) / 3) / 2;
        xy[numCoins - 2][1] = y + (numCoins - 6) * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 1][0] = x + -((numCoins - 4) / 3) / 2 + coinDist * 2;
        xy[numCoins - 1][1] = y + (numCoins - 6) * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        return xy;
    }

    static int[][] arrowRightLeft(int x, int y, byte numCoins) {
        int[][] xy = new int[numCoins][2];
        int i = 0;
        int j = -2;
        while (i < numCoins - 4) {
            if (i < (numCoins - 4) / 3 + 1) {
                xy[i][0] = x + -((numCoins - 4) / 3) / 2 + coinDist;
            } else if (i < (numCoins - 4) / 3 * 2) {
                xy[i][0] = x + -((numCoins - 4) / 3 / 2 + j) * coinDist;
                ++j;
            } else {
                xy[i][0] = x + (numCoins - 4) / 3 / 2 - coinDist;
            }
            xy[i][1] = y + i * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
            ++i;
        }
        xy[numCoins - 4][0] = x + -((numCoins - 4) / 3) / 2 + coinDist * 2;
        xy[numCoins - 4][1] = y + 1 * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 3][0] = x + -((numCoins - 4) / 3) / 2;
        xy[numCoins - 3][1] = y + 1 * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 2][0] = x + (numCoins - 4) / 3 / 2 - coinDist * 2;
        xy[numCoins - 2][1] = y + (numCoins - 6) * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        xy[numCoins - 1][0] = x + (numCoins - 4) / 3 / 2;
        xy[numCoins - 1][1] = y + (numCoins - 6) * (coinDist * MULTIPLYER) + (numCoins - 4) / 2 * (coinDist * MULTIPLYER);
        return xy;
    }

    static int[][] SShape(int x, int y, byte numCoins) {
        y -= numCoins * coinDist;
        int[][] xy = new int[numCoins][2];
        int divX = 0;
        int divY = (numCoins / 2 + 1) * (coinDist * MULTIPLYER);
        int limit = numCoins / 3;
        int i = 0;
        while (i < limit) {
            xy[i][0] = x + -divX;
            xy[i][1] = y + divY;
            divX += coinDist;
            if (++i < numCoins / 3) {
                xy[i][0] = x + divX;
                xy[i][1] = y + divY;
            }
            ++i;
            divY += coinDist * MULTIPLYER;
        }
        divX -= coinDist;
        i = limit;
        while (i < limit * 2) {
            xy[i][0] = x + -divX;
            xy[i][1] = y + divY;
            ++i;
            divY += coinDist * MULTIPLYER;
            divX -= coinDist;
        }
        divX += coinDist;
        i = limit * 2;
        while (i < numCoins) {
            xy[i][0] = x + -divX;
            xy[i][1] = y + divY;
            divX += coinDist;
            if (++i < numCoins) {
                xy[i][0] = x + divX;
                xy[i][1] = y + divY;
            } else {
                xy[i - 2][0] = x + -divX;
                xy[i - 2][1] = y + divY;
            }
            ++i;
            divY += coinDist * MULTIPLYER;
        }
        return xy;
    }

    static int[][] circleArc(int PosX, int posY, int radius, int startAngle, byte numCoins) {
        PosX = startAngle > 90 && startAngle < 270 ? (PosX += numCoins / 2 * (coinDist / 2) - coinDist / 2) : (PosX -= numCoins / 2 * (coinDist / 2) - coinDist / 2);
        int[][] xy = new int[numCoins][2];
        int i = 0;
        while (i < numCoins) {
            xy[i][0] = PosX;
            PosX = (int)((double)PosX + (double)radius * Math.cos((double)startAngle * Math.PI / 180.0));
            xy[i][1] = posY;
            posY = (int)((double)posY + (double)(radius + coinDist * MULTIPLYER) * Math.sin((double)startAngle * Math.PI / 180.0));
            ++i;
            startAngle += 10;
        }
        return xy;
    }
}

