/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import zed.rollNRun.helper.util.ZedAnimation;
import zed.rollNRun.ui.MainCanvas;

public class PWPiFont {
    ZedAnimation theZIF;
    public int charSpacing;
    public int fontHeight;
    public int lineSpacing;
    public int spaceSize;
    private int currentPalette = 0;
    private short[] charFrames;
    public char[] chars;
    public int iScrollY = 0;
    public long iScrollStartTime = 0L;

    public PWPiFont(byte[] data, int currentPalette) {
        this.theZIF = new ZedAnimation(data, currentPalette, true);
        this.load(data);
    }

    private void load(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            dis.skipBytes(4);
            this.loadFontInfo(dis);
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFontInfo(DataInputStream dis) throws IOException {
        this.setFontHeight(dis.readByte());
        this.setLineSpacing(dis.readByte());
        this.charSpacing = dis.readByte();
        this.spaceSize = dis.readByte();
        int charQuantity = dis.readShort();
        this.chars = new char[charQuantity];
        this.charFrames = new short[charQuantity];
        int j = 0;
        while (j < charQuantity) {
            this.chars[j] = dis.readChar();
            this.charFrames[j] = dis.readShort();
            ++j;
        }
    }

    private void initialize() {
        this.sortChars(0, this.chars.length - 1);
    }

    private void sortChars(int low, int high) {
        int left = low;
        int right = high;
        char half = this.chars[(low + high) / 2];
        while (true) {
            if (this.chars[left] < half && left < high) {
                ++left;
                continue;
            }
            while (half < this.chars[right] && right > low) {
                --right;
            }
            if (left <= right) {
                char x = this.chars[left];
                short x2 = this.charFrames[left];
                this.chars[left] = this.chars[right];
                this.charFrames[left] = this.charFrames[right];
                this.chars[right] = x;
                this.charFrames[right] = x2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (low < right) {
            this.sortChars(low, right);
        }
        if (left < high) {
            this.sortChars(left, high);
        }
    }

    public void selectColor(int number) {
        this.theZIF.setPalette(number);
    }

    public short[][] drawString(Graphics graphics, String text, int x, int y, int width, int height, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, width, height, anchor);
    }

    public short[][] drawString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(graphics, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public int drawString(Graphics graphics, String text, int x, int y, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, anchor);
    }

    public int drawString(Graphics graphics, char[] data, int x, int y, int anchor) {
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            int i = 0;
            while (i < data.length) {
                textWidth = textWidth + this.drawChar(graphics, data[i], x + textWidth, y) + this.charSpacing;
                ++i;
            }
        } else {
            int i = 0;
            while (i < data.length) {
                x = x + this.drawChar(graphics, data[i], x, y) + this.charSpacing;
                ++i;
            }
        }
        return textWidth;
    }

    public int drawAniString(Graphics graphics, char[] data, int x, int y, int charSpacing) {
        y += this.getFontHeight();
        int textWidth = 0;
        textWidth = this.getLineWidth(data);
        x -= textWidth / 2;
        int len = data.length;
        int offsetX = 0;
        int i = 0;
        while (i < len / 2) {
            offsetX += this.getCharacterWidth(data[i]) + this.charSpacing;
            ++i;
        }
        int temp_x = x + offsetX;
        int i2 = len / 2;
        while (i2 < len) {
            temp_x = temp_x + this.drawChar(graphics, data[i2], temp_x, y) + charSpacing;
            ++i2;
        }
        offsetX = 0;
        i2 = 0;
        while (i2 < len / 2 - 1) {
            offsetX += this.getCharacterWidth(data[i2]) + this.charSpacing;
            ++i2;
        }
        x += offsetX;
        i2 = len / 2 - 1;
        while (i2 >= 0) {
            this.drawChar(graphics, data[i2], x, y);
            if (i2 > 0) {
                x = x - this.getCharacterWidth(data[i2 - 1]) - charSpacing;
            }
            --i2;
        }
        return textWidth;
    }

    public void drawFastString(Graphics graphics, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.getFontHeight();
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        int i = firstLine;
        while (i < maxLines) {
            if (i >= 0 && mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
            ++i;
        }
    }

    public void resetScroll() {
        this.iScrollStartTime = System.currentTimeMillis();
        this.iScrollY = 0;
    }

    public void drawAutoScrollString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor) {
        int numVisibleLines = height / (this.fontHeight + this.lineSpacing);
        short[][] lines = this.getLineData(data, width - (width >> 4));
        if (numVisibleLines < lines.length && System.currentTimeMillis() - this.iScrollStartTime > 2000L && this.iScrollY++ > lines.length * (this.fontHeight + this.lineSpacing)) {
            this.iScrollY = -lines.length * (this.fontHeight + this.lineSpacing);
        }
        graphics.setClip(x, y, width, height);
        this.drawFastString(graphics, data, lines, x, y - this.iScrollY % (this.fontHeight + this.lineSpacing), width, anchor, this.iScrollY / (this.fontHeight + this.lineSpacing), numVisibleLines + 2);
        MainCanvas.getInstance();
        MainCanvas.getInstance();
        graphics.setClip(0, 0, MainCanvas.SCREEN_WIDTH, MainCanvas.SCREEN_HEIGHT);
    }

    public short[][] drawFastString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor, short[][] mLineData) {
        int textHeight;
        int maxLines = height / this.getFontHeight();
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        int i = 0;
        while (i < maxLines) {
            if (mLineData[i][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
            ++i;
        }
        return mLineData;
    }

    public void drawFastString(Graphics graphics, char[] text, int x, int y, int anchor, short[] lineData) {
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        int i = lineData[0];
        while (i < lineData[1] + 1) {
            x = x + this.drawChar(graphics, text[i], x, y) + this.charSpacing;
            ++i;
        }
    }

    public int drawChar(Graphics g, char character, int x, int y) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        this.theZIF.setPalette(this.getCurrentPalette());
        this.theZIF.drawFrame(g, this.charFrames[charIndex], x, y, 0);
        return this.theZIF.getFrameWidth(this.charFrames[charIndex]);
    }

    public short[][] getLineData(char[] text, int width) {
        Vector<short[]> result = new Vector<short[]>();
        int index = 0;
        short[] currentLine = new short[]{0, 0, 0};
        while (index < text.length) {
            int wordLength = 0;
            while (index < text.length && text[index] != '\n' && text[index] != ' ') {
                wordLength += this.getCharacterWidth(text[index]) + this.charSpacing;
                index = (char)(index + 1);
            }
            if (currentLine[2] == 0) {
                currentLine[1] = (short)(index - 1);
                currentLine[2] = (short)(currentLine[2] + wordLength);
            } else if (currentLine[2] + this.spaceSize + this.charSpacing + wordLength < width) {
                currentLine[1] = (short)(index - 1);
                currentLine[2] = (short)(currentLine[2] + (this.spaceSize + this.charSpacing + wordLength));
            } else {
                result.addElement(currentLine);
                currentLine = new short[]{(short)(((short[])result.elementAt(result.size() - 1))[1] + 2), (short)(index - 1), (short)wordLength};
            }
            if (index < text.length && text[index] == '\n') {
                result.addElement(currentLine);
                currentLine = new short[]{(short)(index + 1), (short)(index + 1), 0};
            }
            index = (char)(index + 1);
        }
        if (currentLine[0] > text.length - 1) {
            currentLine[0] = (short)(text.length - 1);
        }
        if (currentLine[1] > text.length - 1) {
            currentLine[1] = (short)(text.length - 1);
        }
        if (currentLine[0] < 0) {
            currentLine[0] = 0;
        }
        if (currentLine[1] < 0) {
            currentLine[1] = 0;
        }
        result.addElement(currentLine);
        short[][] ret = new short[result.size()][];
        int i = 0;
        while (i < result.size()) {
            short[] data = (short[])result.elementAt(i);
            ret[i] = new short[3];
            ret[i][0] = data[0];
            ret[i][1] = data[1];
            ret[i][2] = data[2] >= this.charSpacing ? (short)(data[2] - this.charSpacing) : (short)0;
            ++i;
        }
        return ret;
    }

    public int getLineWidth(char[] text) {
        if (text.length < 1) {
            return 0;
        }
        int totalWidth = 0;
        totalWidth += this.getCharacterWidth(text[0]);
        int i = 1;
        while (i < text.length) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.charSpacing;
            ++i;
        }
        return totalWidth;
    }

    public int getCharacterWidth(char character) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex < 0) {
            return 0;
        }
        return this.theZIF.getFrameWidth(this.charFrames[charIndex]);
    }

    public int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.chars[mid] == character) {
            return mid;
        }
        if (character < this.chars[mid]) {
            return this.binarySearchOnChars(character, left, mid - 1);
        }
        return this.binarySearchOnChars(character, mid + 1, right);
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getCurrentPalette() {
        return this.currentPalette;
    }

    public void setCurrentPalette(int currentPalette) {
        this.currentPalette = currentPalette;
    }

    public void drawFastStringWithImage(Graphics graphics, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw, int type) {
        boolean paintItem = false;
        int item = 0;
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.fontHeight;
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        int i = firstLine;
        while (i < maxLines) {
            if (mLineData[i][2] != 0) {
                int pos = mLineData[i][0];
                while (pos < mLineData[i][1] + 1) {
                    if (data[pos] == '~') {
                        item = Integer.valueOf("" + data[pos + 1]);
                        paintItem = true;
                    }
                    ++pos;
                }
                if (paintItem) {
                    paintItem = false;
                } else {
                    this.drawFastString(graphics, data, x, y, anchor, mLineData[i]);
                }
            }
            y = y + this.lineSpacing + this.fontHeight;
            ++i;
        }
    }
}

