/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.ui;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import zed.rollNRun.helper.ZEDConstants;
import zed.rollNRun.helper.util.PWRecordStore;
import zed.rollNRun.helper.util.PWSoundBox;
import zed.rollNRun.helper.util.ResHandler;
import zed.rollNRun.ui.Coin;
import zed.rollNRun.ui.MainCanvas;
import zed.rollNRun.ui.Obstacle;
import zed.rollNRun.ui.Patterns;
import zed.rollNRun.ui.PowerUps;
import zed.rollNRun.ui.QuickSort;
import zed.rollNRun.ui.ZedAnimAJO;

public class GamePlay {
    private final int NumBushes;
    private final int CHAR_X;
    public int CHAR_Y;
    private int[] obstY;
    private Coin[] coins;
    private int[][] nextCoinPattern;
    public int mCoins;
    private static Random mRandom;
    private Object[] objects;
    private Obstacle mObst;
    private Obstacle mEnemies;
    private PowerUps mPowerUps;
    private int mKeyCode;
    public int speedOffset;
    private boolean isCharRunnig;
    public boolean isShoot;
    private byte mCounter;
    private byte mCoinCounter;
    public int mDistance;
    private boolean hasJump;
    private boolean gameThread;
    public boolean displayWeapon;
    private byte nextCoinIndex;
    private byte[] randomLeft;
    private byte[] randomRight;
    int panBGX;
    boolean[] allowMovement;
    boolean placeFront;
    boolean hit;
    byte reduceOffset;
    byte numOfObjects;
    byte powerUp;
    byte powerUpCounter;
    byte movSpeed;
    byte dieCounter;
    byte arrowsCounter;
    byte supermanFrameIndx;
    public boolean displayArrows;
    int AJOLimit;
    int setDistance;
    boolean sound;
    byte bushesCollCounter;
    byte speedIncr;
    int distanceCount;

    GamePlay() {
        this.NumBushes = 3;
        MainCanvas.getInstance();
        this.CHAR_X = MainCanvas.SCREEN_CENTER_X;
        MainCanvas.getInstance();
        this.CHAR_Y = MainCanvas.SCREEN_HEIGHT - 30;
        this.mCoins = 0;
        this.mKeyCode = -1;
        this.speedOffset = 0;
        this.isCharRunnig = false;
        this.isShoot = false;
        this.mCounter = 0;
        this.mCoinCounter = 0;
        this.mDistance = 0;
        this.hasJump = false;
        this.gameThread = false;
        this.displayWeapon = false;
        this.nextCoinIndex = 0;
        this.panBGX = 0;
        this.placeFront = false;
        this.hit = false;
        this.reduceOffset = 0;
        this.numOfObjects = (byte)10;
        this.powerUp = (byte)-1;
        this.powerUpCounter = 0;
        this.movSpeed = 0;
        this.dieCounter = 0;
        this.arrowsCounter = 0;
        this.supermanFrameIndx = 0;
        this.displayArrows = false;
        this.AJOLimit = 512;
        MainCanvas.getInstance();
        this.setDistance = MainCanvas.SCREEN_CENTER_Y;
        this.sound = false;
        this.bushesCollCounter = 0;
        this.speedIncr = 0;
        this.distanceCount = 0;
        try {
            mRandom = new Random();
            this.obstY = new int[3];
            this.randomLeft = new byte[3];
            this.randomRight = new byte[3];
            MainCanvas.getInstance();
            this.obstY[0] = MainCanvas.SCREEN_HEIGHT - 520;
            int i = 0;
            while (i < 3) {
                if (i != 2) {
                    this.obstY[i + 1] = this.obstY[0] - 520 * (i + 1);
                }
                this.randomLeft[i] = (byte)GamePlay.getRandomVal(4);
                this.randomRight[i] = (byte)GamePlay.getRandomVal(4);
                ++i;
            }
            this.objects = new Object[this.numOfObjects];
            this.allowMovement = new boolean[this.numOfObjects];
            this.resetGP();
            if (ResHandler.getInstance().mBG != null && ResHandler.getInstance().mBG.getFrameIndxHeight((byte)4) > this.AJOLimit) {
                i = 0;
                while (i < 3) {
                    this.obstY[i] = this.obstY[i] + (ResHandler.getInstance().mBG.getFrameIndxHeight((byte)4) - this.AJOLimit);
                    i = (byte)(i + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception while creating Images : " + e);
        }
    }

    public static int getRandomVal(int limit) {
        return Math.abs(mRandom.nextInt(limit));
    }

    public void resetGameObjects() {
        byte iInd;
        if (this.coins == null) {
            this.coins = new Coin[this.numOfObjects];
            iInd = 0;
            while (iInd < this.numOfObjects) {
                this.coins[iInd] = null;
                MainCanvas.getInstance();
                MainCanvas.getInstance();
                this.coins[iInd] = new Coin(MainCanvas.ADDITIONAL_WIDTH + 25 + GamePlay.getRandomVal(MainCanvas.SCREEN_WIDTH - 50), -((iInd + 1) * 160), true);
                iInd = (byte)(iInd + 1);
            }
        } else {
            iInd = 0;
            while (iInd < this.numOfObjects) {
                Coin coin = this.coins[iInd];
                MainCanvas.getInstance();
                MainCanvas.getInstance();
                coin.setXCoin(MainCanvas.ADDITIONAL_WIDTH + 25 + GamePlay.getRandomVal(MainCanvas.SCREEN_WIDTH - 50));
                this.coins[iInd].setYCoin(-((iInd + 1) * 160));
                this.coins[iInd].setVisibilityCoin(true);
                iInd = (byte)(iInd + 1);
            }
        }
        if (this.objects != null) {
            int index = 0;
            while (index < this.objects.length) {
                this.objects[index] = this.coins[index];
                index = (byte)(index + 1);
            }
        }
        this.nextCoinPattern = null;
        if (this.mObst == null) {
            byte by = (byte)(4 + GamePlay.getRandomVal(9));
            MainCanvas.getInstance();
            MainCanvas.getInstance();
            this.mObst = new Obstacle(1, by, MainCanvas.ADDITIONAL_WIDTH + GamePlay.getRandomVal(MainCanvas.SCREEN_WIDTH), -12 * (Patterns.coinDist * Patterns.MULTIPLYER) - 50);
        }
        this.mObst.visibility = false;
        if (this.mEnemies == null) {
            MainCanvas.getInstance();
            MainCanvas.getInstance();
            this.mEnemies = new Obstacle(0, 1, MainCanvas.ADDITIONAL_WIDTH + GamePlay.getRandomVal(MainCanvas.SCREEN_WIDTH), -12 * (Patterns.coinDist * Patterns.MULTIPLYER) - 50 - 100);
        }
        this.mEnemies.visibility = false;
        if (this.mPowerUps == null) {
            byte by = (byte)GamePlay.getRandomVal(4);
            MainCanvas.getInstance();
            MainCanvas.getInstance();
            this.mPowerUps = new PowerUps(by, MainCanvas.ADDITIONAL_WIDTH + GamePlay.getRandomVal(MainCanvas.SCREEN_WIDTH), -12 * (Patterns.coinDist * Patterns.MULTIPLYER) - 50 - 200);
        }
        this.mPowerUps.setVisibility(false);
        this.placeFront = false;
    }

    private void generateNewPattern() {
        MainCanvas.getInstance();
        this.nextCoinPattern = Patterns.generatePattern(MainCanvas.SCREEN_CENTER_X, -(12 * (Patterns.coinDist * Patterns.MULTIPLYER)) - this.setDistance, (byte)12, (byte)15);
    }

    protected void paintGame(Graphics g) {
        switch (MainCanvas.selWorld) {
            case 1: {
                g.setColor(81, 66, 24);
                break;
            }
            case 2: {
                g.setColor(160, 188, 59);
                break;
            }
            case 3: {
                g.setColor(109, 168, 188);
            }
        }
        MainCanvas.getInstance();
        MainCanvas.getInstance();
        g.fillRect(0, 0, MainCanvas.ACTUAL_SCREEN_WIDTH, MainCanvas.SCREEN_HEIGHT);
        this.panBG(g);
        this.drawBG(g);
        if (!this.placeFront || this.hasJump || this.powerUp == 0) {
            this.drawObjects(g);
            this.drawCharacter(g);
        } else {
            this.drawCharacter(g);
            this.drawObjects(g);
        }
        this.drawSideBush(g);
        this.shootPlayer(g);
        this.drawHeader(g);
    }

    private void panBG(Graphics g) {
        g.translate(this.panBGX, 0);
    }

    public void drawBG(Graphics g) {
        if (ResHandler.getInstance().mBG != null) {
            int i = 0;
            while (i < 3) {
                if (ResHandler.getInstance().mBG.getFrameIndxHeight((byte)4) > this.AJOLimit) {
                    int x = ResHandler.getInstance().mBG.getFrameIndxWidth((byte)4) - this.AJOLimit;
                    int y = ResHandler.getInstance().mBG.getFrameIndxHeight((byte)4) - this.AJOLimit;
                    ZedAnimAJO zedAnimAJO = ResHandler.getInstance().mBG;
                    MainCanvas.getInstance();
                    zedAnimAJO.draw(g, (byte)4, MainCanvas.SCREEN_CENTER_X - ResHandler.getInstance().mBG.getFrameIndxWidth((byte)4) / 2 + x, this.obstY[i], false, false);
                } else {
                    ZedAnimAJO zedAnimAJO = ResHandler.getInstance().mBG;
                    MainCanvas.getInstance();
                    zedAnimAJO.draw(g, (byte)4, MainCanvas.SCREEN_CENTER_X - ResHandler.getInstance().mBG.getFrameIndxWidth((byte)4) / 2, this.obstY[i], false, false);
                }
                ++i;
            }
        }
    }

    public void drawSideBush(Graphics g) {
        if (ResHandler.getInstance().mBG != null) {
            int i = 0;
            while (i < 3) {
                ZedAnimAJO zedAnimAJO = ResHandler.getInstance().mBG;
                byte by = this.randomLeft[i];
                MainCanvas.getInstance();
                zedAnimAJO.draw(g, by, MainCanvas.ADDITIONAL_WIDTH + -(ResHandler.getInstance().mBG.getWidth() / 2 + ResHandler.getInstance().mBG.getWidth() / 8), this.obstY[i] + 300, false, false, (byte)0);
                ZedAnimAJO zedAnimAJO2 = ResHandler.getInstance().mBG;
                byte by2 = this.randomRight[i];
                MainCanvas.getInstance();
                MainCanvas.getInstance();
                zedAnimAJO2.draw(g, by2, MainCanvas.ADDITIONAL_WIDTH + MainCanvas.SCREEN_WIDTH + ResHandler.getInstance().mBG.getWidth() / 2 + ResHandler.getInstance().mBG.getWidth() / 8, this.obstY[i] + 300, false, false, (byte)2);
                ++i;
            }
        }
    }

    private void drawCharacter(Graphics g) {
        if (this.hit && ResHandler.getInstance().mHitAnnim != null) {
            ResHandler.getInstance().mHitAnnim.draw(g, (byte)0, 0, 0, false, true);
        }
        if (ResHandler.getInstance().mCharacter != null) {
            if (this.dieCounter > 0 || MainCanvas.getState() == 21) {
                ResHandler.getInstance().mCharacter.draw(g, (byte)2, 0, 0, false, true);
            } else if (this.hasJump) {
                ResHandler.getInstance().mCharacter.draw(g, (byte)1, 0, 0, false, true);
            } else if (this.powerUp == 0) {
                ResHandler.getInstance().mCharacter.draw(g, this.supermanFrameIndx, ResHandler.getInstance().mCharacter.getPosX(), ResHandler.getInstance().mCharacter.getPosY(), false, false);
                if (this.supermanFrameIndx == 3) {
                    ResHandler.getInstance().jetpack.draw(g, (byte)0, ResHandler.getInstance().mCharacter.getPosX(), ResHandler.getInstance().mCharacter.getPosY() + 10, true, true, (byte)0);
                }
            } else if (this.displayWeapon) {
                ResHandler.getInstance().mCharacter.draw(g, (byte)6, ResHandler.getInstance().mCharacter.getPosX(), ResHandler.getInstance().mCharacter.getPosY(), false, false);
            } else {
                ResHandler.getInstance().mCharacter.draw(g, (byte)0, 0, 0, true, true);
            }
        }
    }

    private void drawHeader(Graphics g) {
        int x = -g.getTranslateX();
        int y = -g.getTranslateY();
        this.drawPowerUps(g, x, y);
        if (ResHandler.getInstance().hud != null) {
            if (ResHandler.getInstance().hud[0] != null) {
                g.drawImage(ResHandler.getInstance().hud[0], x, y, 20);
                if (MainCanvas.smallfont != null) {
                    MainCanvas.smallfont.drawString(g, String.valueOf(this.mDistance) + "M", x + ResHandler.getInstance().hud[0].getWidth() / 3, y + ResHandler.getInstance().hud[0].getHeight() / 2 - MainCanvas.smallfont.fontHeight / 2, 20);
                }
            }
            if (ResHandler.getInstance().hud[3] != null && MainCanvas.smallfont != null) {
                Image image = ResHandler.getInstance().hud[3];
                MainCanvas.getInstance();
                g.drawImage(image, x + MainCanvas.SCREEN_WIDTH, y, 24);
                String string = "" + this.mCoins;
                MainCanvas.getInstance();
                MainCanvas.smallfont.drawString(g, string, x + MainCanvas.SCREEN_WIDTH - ResHandler.getInstance().hud[3].getWidth() + ResHandler.getInstance().hud[3].getWidth() / 2, y + ResHandler.getInstance().hud[3].getHeight() / 2 - MainCanvas.smallfont.fontHeight / 2, 20);
            }
        }
    }

    private void drawPowerUps(Graphics g, int transX, int transY) {
        if (this.mPowerUps != null && this.powerUp != -1) {
            if (this.powerUpCounter % 2 == 0) {
                Image image = ResHandler.getInstance().hud[2];
                MainCanvas.getInstance();
                g.drawImage(image, transX, transY + MainCanvas.SCREEN_HEIGHT, 36);
            } else {
                Image image = ResHandler.getInstance().hud[1];
                MainCanvas.getInstance();
                g.drawImage(image, transX, transY + MainCanvas.SCREEN_HEIGHT, 36);
            }
            int n = transX + ResHandler.getInstance().hud[1].getWidth() / 2 - this.mPowerUps.getWidth() / 2;
            MainCanvas.getInstance();
            this.mPowerUps.paint(g, n, MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().hud[1].getHeight() / 2 - this.mPowerUps.getHeight() / 2, this.powerUp);
        }
    }

    private void shootPlayer(Graphics g) {
        int x = -g.getTranslateX();
        int y = -g.getTranslateY();
        if (MainCanvas.getState() != 3) {
            return;
        }
        if (this.displayWeapon) {
            if (ResHandler.getInstance().obstacle != null) {
                if (this.isShoot) {
                    ZedAnimAJO zedAnimAJO = ResHandler.getInstance().obstacle;
                    MainCanvas.getInstance();
                    MainCanvas.getInstance();
                    zedAnimAJO.draw(g, (byte)0, MainCanvas.SCREEN_CENTER_X, MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0), false, true, (byte)0);
                } else {
                    ZedAnimAJO zedAnimAJO = ResHandler.getInstance().obstacle;
                    MainCanvas.getInstance();
                    MainCanvas.getInstance();
                    zedAnimAJO.draw(g, (byte)0, MainCanvas.SCREEN_CENTER_X, MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0), false, false, (byte)0);
                }
            }
        } else if (this.displayArrows && this.arrowsCounter % 2 == 0 && ResHandler.getInstance().gamePlayArrows != null) {
            g.drawImage(ResHandler.getInstance().gamePlayArrows[0], MainCanvas.SCREEN_CENTER_X + x, this.CHAR_Y + ResHandler.getInstance().mCharacter.getFrameIndxHeight((byte)0), 17);
            Image image = ResHandler.getInstance().gamePlayArrows[1];
            int n = ResHandler.getInstance().gamePlayArrows[1].getWidth() / 2 + x;
            MainCanvas.getInstance();
            g.drawImage(image, n, MainCanvas.SCREEN_CENTER_Y - ResHandler.getInstance().gamePlayArrows[1].getHeight() / 2, 6);
            Image image2 = ResHandler.getInstance().gamePlayArrows[2];
            int n2 = MainCanvas.ACTUAL_SCREEN_WIDTH - ResHandler.getInstance().gamePlayArrows[2].getWidth() / 2 + x;
            MainCanvas.getInstance();
            g.drawImage(image2, n2, MainCanvas.SCREEN_CENTER_Y - ResHandler.getInstance().gamePlayArrows[2].getHeight() / 2, 10);
        }
    }

    private void drawObjects(Graphics g) {
        if (this.objects != null) {
            byte iInd = 0;
            byte len = (byte)this.objects.length;
            while (iInd < len) {
                if (this.objects[iInd] != null) {
                    if (this.objects[iInd] instanceof Coin) {
                        ((Coin)this.objects[iInd]).paint(g);
                    } else if (this.objects[iInd] instanceof Obstacle) {
                        ((Obstacle)this.objects[iInd]).paint(g);
                    } else if (this.objects[iInd] instanceof PowerUps) {
                        ((PowerUps)this.objects[iInd]).paint(g);
                    }
                }
                iInd = (byte)(iInd + 1);
            }
        }
    }

    public void updateGPProcess() {
        if (ResHandler.getInstance().mCharacter == null || ResHandler.getInstance().mBG == null) {
            return;
        }
        try {
            if (this.dieCounter <= 0) {
                MainCanvas.getInstance().timer();
                this.processKeys();
                this.updateBackground();
                this.playGamePlaySound();
            }
            this.processCounter();
        }
        catch (Exception e) {
            System.out.println("Exception in gameplay update : " + e);
        }
    }

    private synchronized void playGamePlaySound() {
        if (!(this.isShoot || this.speedOffset <= 0 || PWSoundBox.getInstance().checkPlayerStatus() || this.sound)) {
            this.sound = true;
            MainCanvas.playSound((byte)7);
        }
    }

    public void setSountEnable() {
        this.sound = false;
    }

    private void charJump() {
        if (this.hasJump && ResHandler.getInstance().mCharacter.getAnimStatus()) {
            this.hasJump = false;
            if (this.powerUp == 2) {
                this.powerUp = (byte)-1;
                this.powerUpCounter = 0;
            }
        }
    }

    private void updateBackground() {
        if (ResHandler.getInstance().mCharacter == null || ResHandler.getInstance().mBG == null) {
            return;
        }
        if (this.isCharRunnig) {
            this.moveBG();
            this.moveObjects();
            this.controlSpeedOffset();
            this.collidesWithBushes();
            this.checkPlayerCollision();
            this.charJump();
        }
        this.checkForShootComplete();
    }

    private void fireChar() {
        if (ResHandler.getInstance().mCharacter == null) {
            return;
        }
        if (this.isShoot && !this.isCharRunnig && !this.hasJump && this.speedOffset <= 0) {
            MainCanvas.getInstance();
            int dy = MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0);
            MainCanvas.getInstance();
            this.speedOffset = MainCanvas.STARTER_SPEED * 2;
            ResHandler.getInstance().mCharacter.setPosY(dy);
            ResHandler.getInstance().mCharacter.resetAnim();
            MainCanvas.playSound((byte)8);
        } else if (!this.isShoot && !this.hasJump) {
            ResHandler.getInstance().mCharacter.resetAnim();
            this.hasJump = true;
        }
    }

    private void checkForShootComplete() {
        int dy;
        if (ResHandler.getInstance().mCharacter == null) {
            return;
        }
        if (!this.isCharRunnig && this.isShoot && !this.hasJump && ResHandler.getInstance().obstacle != null && ResHandler.getInstance().obstacle.getAnimStatus()) {
            MainCanvas.getInstance();
            dy = MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0);
            ResHandler.getInstance().mCharacter.setPosY(dy + 5);
            ResHandler.getInstance().mCharacter.resetAnim();
            this.hasJump = true;
            this.isCharRunnig = true;
            this.displayWeapon = false;
            this.displayArrows = true;
            this.arrowsCounter = 0;
        }
        if (this.isShoot && ResHandler.getInstance().mCharacter.getAnimStatus()) {
            MainCanvas.getInstance();
            dy = MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0) + 5;
            ResHandler.getInstance().mCharacter.setPosY(dy);
            MainCanvas.getInstance();
            this.speedOffset = MainCanvas.BG_SPEED + 2;
            this.hasJump = false;
            this.isShoot = false;
        }
    }

    private void moveObjects() {
        if (ResHandler.getInstance().mCharacter == null) {
            return;
        }
        if (this.objects != null) {
            byte ind = 0;
            byte len = (byte)this.objects.length;
            while (ind < len) {
                if (this.objects[ind] != null) {
                    this.setNextObject(ind);
                    if (this.objects[ind] instanceof Coin) {
                        this.allowMovement[ind] = this.moveCoins((Coin)this.objects[ind]);
                    } else if (this.objects[ind] instanceof Obstacle) {
                        this.allowMovement[ind] = ((Obstacle)this.objects[ind]).move(this.movSpeed);
                        if (ResHandler.getInstance().mCharacter.getPosY() < ((Obstacle)this.objects[ind]).posY) {
                            this.placeFront = true;
                        }
                        int n = ((Obstacle)this.objects[ind]).posY;
                        MainCanvas.getInstance();
                        if (n > MainCanvas.SCREEN_HEIGHT) {
                            this.placeFront = false;
                        }
                    } else if (this.objects[ind] instanceof PowerUps) {
                        this.allowMovement[ind] = ((PowerUps)this.objects[ind]).move(this.movSpeed);
                    }
                }
                ind = (byte)(ind + 1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean moveCoins(Coin lCoin) {
        boolean onScreen;
        block4: {
            block3: {
                onScreen = true;
                if (lCoin == null) return onScreen;
                if (this.powerUp != 1 || lCoin.getYCoin() <= 0) break block3;
                int n = lCoin.getYCoin();
                MainCanvas.getInstance();
                if (n >= MainCanvas.SCREEN_HEIGHT) break block3;
                MainCanvas.getInstance();
                lCoin.move(0, MainCanvas.MAGNETO_SPEED);
                if (lCoin.getXCoin() < ResHandler.getInstance().mCharacter.getPosX()) {
                    lCoin.move(6, 0);
                    break block4;
                } else if (lCoin.getXCoin() > ResHandler.getInstance().mCharacter.getPosX()) {
                    lCoin.move(-6, 0);
                }
                break block4;
            }
            lCoin.move(0, this.movSpeed);
        }
        if (lCoin.getYCoin() >= 0) return onScreen;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void collidesWithBushes() {
        block2: {
            block3: {
                if (this.powerUp == 0) break block2;
                int n = ResHandler.getInstance().mCharacter.getPosX();
                MainCanvas.getInstance();
                if (n < MainCanvas.ADDITIONAL_WIDTH + 20) break block3;
                int n2 = ResHandler.getInstance().mCharacter.getPosX();
                MainCanvas.getInstance();
                MainCanvas.getInstance();
                if (n2 <= MainCanvas.ADDITIONAL_WIDTH + MainCanvas.SCREEN_WIDTH - 20) break block2;
            }
            this.bushesCollCounter = (byte)(this.bushesCollCounter + 1);
            if (this.bushesCollCounter <= 5) return;
            --this.speedOffset;
            this.bushesCollCounter = 0;
            ResHandler.getInstance().mHitAnnim.setPosX(ResHandler.getInstance().mCharacter.getPosX());
            ResHandler.getInstance().mHitAnnim.setPosY(ResHandler.getInstance().mCharacter.getPosY());
            this.hit = true;
            return;
        }
        if (this.bushesCollCounter <= 0) return;
        this.bushesCollCounter = 0;
    }

    private Coin getFreeCoin() {
        Coin lCoin = null;
        byte i = 0;
        int ob = 0;
        while (i < this.numOfObjects) {
            ob = 0;
            ob = 0;
            while (ob < this.objects.length) {
                if (this.coins[i] != null && this.objects[ob] == this.coins[i]) break;
                ob = (byte)(ob + 1);
            }
            if (ob >= this.objects.length) {
                lCoin = this.coins[i];
                break;
            }
            i = (byte)(i + 1);
        }
        return lCoin;
    }

    private boolean isResAvailable(Object obj) {
        int ob = 0;
        while (ob < this.objects.length) {
            if (obj != null && this.objects[ob] == obj) {
                return false;
            }
            ob = (byte)(ob + 1);
        }
        return true;
    }

    private Object selectObject(byte index, byte objIndex) {
        int ran = GamePlay.getRandomVal(ZEDConstants.GP_Constants.objectsGenerationProbability[index][3]);
        if (ran < ZEDConstants.GP_Constants.objectsGenerationProbability[index][0] || this.objects[this.prevIndex(objIndex, this.numOfObjects)] instanceof Obstacle || this.objects[this.prevIndex(objIndex, this.numOfObjects)] instanceof PowerUps || this.objects[this.prevIndex(objIndex, this.numOfObjects)] == null) {
            return this.getFreeCoin();
        }
        if (ran < ZEDConstants.GP_Constants.objectsGenerationProbability[index][1] && this.isResAvailable(this.mPowerUps)) {
            this.mPowerUps.setPowerUpType((byte)GamePlay.getRandomVal(4));
            return this.mPowerUps;
        }
        if (ran < ZEDConstants.GP_Constants.objectsGenerationProbability[index][2] && this.isResAvailable(this.mObst)) {
            this.mObst.obstType = (byte)(4 + GamePlay.getRandomVal(9));
            return this.mObst;
        }
        if (ran < ZEDConstants.GP_Constants.objectsGenerationProbability[index][3] && this.isResAvailable(this.mEnemies)) {
            this.mEnemies.obstIndex = (byte)GamePlay.getRandomVal(6);
            this.mEnemies.mObstacle = ResHandler.getInstance().enemy[this.mEnemies.obstIndex];
            this.mEnemies.mObstacle.resetAnim();
            return this.mEnemies;
        }
        return this.getFreeCoin();
    }

    private byte getLastObjectIndex(byte currentIdx) {
        int ind = 0;
        int y = MainCanvas.SCREEN_HEIGHT + 100;
        int i = 0;
        while (i < this.objects.length) {
            if (!(this.objects[i] instanceof Coin) && !(this.objects[i] instanceof Obstacle)) {
                boolean cfr_ignored_0 = this.objects[i] instanceof PowerUps;
            }
            if (currentIdx != i && this.getObjectPosY(i) < y) {
                y = this.getObjectPosY(i);
                ind = i;
            }
            i = (byte)(i + 1);
        }
        return (byte)ind;
    }

    private void initNextObject(byte index) {
        if (this.objects[index] == null) {
            switch (this.mDistance / 10) {
                case 0: {
                    this.objects[index] = this.getFreeCoin();
                    break;
                }
                case 1: {
                    this.objects[index] = this.selectObject((byte)0, index);
                    break;
                }
                case 2: {
                    this.objects[index] = this.selectObject((byte)1, index);
                    break;
                }
                case 3: {
                    this.objects[index] = this.selectObject((byte)2, index);
                    break;
                }
                case 4: {
                    this.objects[index] = this.selectObject((byte)3, index);
                    break;
                }
                default: {
                    this.objects[index] = this.selectObject((byte)4, index);
                }
            }
            byte lastObjIdx = this.getLastObjectIndex(index);
            if (this.objects[index] instanceof Coin) {
                ((Coin)this.objects[index]).setXCoin(this.nextCoinPattern[this.nextCoinIndex][0]);
                if (this.getObjectPosY(lastObjIdx) < 160) {
                    ((Coin)this.objects[index]).setYCoin(this.getObjectPosY(lastObjIdx) - 160);
                } else {
                    ((Coin)this.objects[index]).setYCoin(-160);
                }
                this.nextCoinPattern[this.nextCoinIndex][0] = -1;
                this.nextCoinPattern[this.nextCoinIndex][1] = -1;
                this.nextCoinIndex = (byte)(this.nextCoinIndex + 1);
                ((Coin)this.objects[index]).setVisibilityCoin(true);
            } else if (this.objects[index] instanceof Obstacle) {
                ((Obstacle)this.objects[index]).posX = this.nextCoinPattern[this.nextCoinIndex][0];
                ((Obstacle)this.objects[index]).posY = this.getObjectPosY(lastObjIdx) < 160 ? this.getObjectPosY(lastObjIdx) - 160 : -160;
                this.nextCoinPattern[this.nextCoinIndex][0] = -1;
                this.nextCoinPattern[this.nextCoinIndex][1] = -1;
                this.nextCoinIndex = (byte)(this.nextCoinIndex + 1);
                ((Obstacle)this.objects[index]).visibility = true;
            } else if (this.objects[index] instanceof PowerUps) {
                ((PowerUps)this.objects[index]).setX(this.nextCoinPattern[this.nextCoinIndex][0]);
                if (this.getObjectPosY(lastObjIdx) < 160) {
                    ((PowerUps)this.objects[index]).setY(this.getObjectPosY(lastObjIdx) - 160);
                } else {
                    ((PowerUps)this.objects[index]).setY(-160);
                }
                this.nextCoinPattern[this.nextCoinIndex][0] = -1;
                this.nextCoinPattern[this.nextCoinIndex][1] = -1;
                this.nextCoinIndex = (byte)(this.nextCoinIndex + 1);
                ((PowerUps)this.objects[index]).setVisibility(true);
            }
        }
    }

    private int getObjectPosY(int index) {
        int y = 0;
        if (this.objects[index] != null) {
            if (this.objects[index] instanceof Coin) {
                y = ((Coin)this.objects[index]).getYCoin();
            } else if (this.objects[index] instanceof Obstacle) {
                y = ((Obstacle)this.objects[index]).posY;
            } else if (this.objects[index] instanceof PowerUps) {
                y = ((PowerUps)this.objects[index]).getY();
            }
        }
        return y;
    }

    private void setNextObject(byte index) {
        block16: {
            block14: {
                block15: {
                    block13: {
                        if (this.nextCoinPattern == null) {
                            this.nextCoinIndex = 0;
                            this.generateNewPattern();
                        }
                        if (this.objects[index] == null) {
                            this.initNextObject(index);
                        }
                        if (!(this.objects[index] instanceof Coin)) break block13;
                        int n = ((Coin)this.objects[index]).getYCoin();
                        MainCanvas.getInstance();
                        if (n > MainCanvas.SCREEN_HEIGHT + 50) break block14;
                    }
                    if (!(this.objects[index] instanceof Obstacle)) break block15;
                    int n = ((Obstacle)this.objects[index]).posY;
                    MainCanvas.getInstance();
                    if (n > MainCanvas.SCREEN_HEIGHT + 50) break block14;
                }
                if (!(this.objects[index] instanceof PowerUps)) break block16;
                int n = ((PowerUps)this.objects[index]).getY();
                MainCanvas.getInstance();
                if (n <= MainCanvas.SCREEN_HEIGHT + 50) break block16;
            }
            if (this.objects[index] instanceof Coin) {
                if (((Coin)this.objects[index]).visibilityCoin) {
                    this.mCoinCounter = 0;
                    this.speedIncr = 0;
                }
                ((Coin)this.objects[index]).visibilityCoin = false;
            }
            if (this.objects[index] instanceof Obstacle) {
                ((Obstacle)this.objects[index]).visibility = false;
            }
            if (this.objects[index] instanceof PowerUps) {
                ((PowerUps)this.objects[index]).setVisibility(false);
            }
            this.objects[index] = null;
            this.initNextObject(index);
        }
        if (this.coins != null) {
            int i = 0;
            while (i < this.coins.length) {
                if (this.coins[i].getYCoin() < 0) {
                    this.coins[i].visibilityCoin = true;
                }
                i = (byte)(i + 1);
            }
        }
        if (this.nextCoinIndex >= this.nextCoinPattern.length - 1) {
            this.nextCoinIndex = 0;
            this.nextCoinPattern = null;
            this.generateNewPattern();
        }
    }

    public void checkHighScore() {
        if (MainCanvas.distance < this.mDistance) {
            MainCanvas.distance = this.mDistance;
        }
        MainCanvas.coins += this.mCoins;
        PWRecordStore.saveUserDataRS();
    }

    private void checkPlayerCollision() {
        if (this.powerUp != 0) {
            this.collisionWithObjects();
        }
        if (ResHandler.getInstance().mHitAnnim != null && ResHandler.getInstance().mHitAnnim.getAnimStatus()) {
            this.hit = false;
            ResHandler.getInstance().mHitAnnim.resetAnim();
        }
        this.powerUpOff();
    }

    private void powerUpOff() {
        if (this.powerUp != -1 && this.powerUpCounter > 10) {
            this.powerUpCounter = 0;
            if (this.powerUp == 0) {
                this.speedOffset += 2;
            }
            this.powerUp = (byte)-1;
        }
    }

    private void collisionWithCoins(Coin lCoin) {
        if (ResHandler.getInstance().mCharacter == null) {
            return;
        }
        if (lCoin != null) {
            int coinWidth = ResHandler.getInstance().mCoin.getFrameWidth();
            int coinHeight = ResHandler.getInstance().mCoin.getFrameHeight();
            if (!this.hasJump && lCoin.isVisibilityCoin() && ResHandler.getInstance().mCharacter.checkCollision(lCoin.getXCoin(), lCoin.getYCoin() + coinHeight / 2, coinWidth, coinHeight, (byte)10)) {
                lCoin.setVisibilityCoin(false);
                this.mCoinCounter = (byte)(this.mCoinCounter + 1);
                ++this.mCoins;
                MainCanvas.getInstance();
                this.speedOffset = MainCanvas.BG_SPEED + this.speedIncr;
                if (this.powerUp == 3) {
                    this.mCoinCounter = (byte)(this.mCoinCounter + 1);
                    ++this.mCoins;
                }
            }
        }
    }

    private void collisionWithObjects() {
        try {
            if (ResHandler.getInstance().mCharacter == null) {
                return;
            }
            if (this.objects != null) {
                byte ind = 0;
                byte len = (byte)this.objects.length;
                while (ind < len) {
                    if (this.objects[ind] != null) {
                        if (this.objects[ind] instanceof Coin) {
                            this.collisionWithCoins((Coin)this.objects[ind]);
                        } else if (this.objects[ind] instanceof Obstacle) {
                            if (((Obstacle)this.objects[ind]).visibility && ((Obstacle)this.objects[ind]).posY > 0 && ResHandler.getInstance().mCharacter.isCollided(((Obstacle)this.objects[ind]).mObstacle, (byte)20) && !this.hasJump && !this.placeFront) {
                                this.speedOffset -= 4;
                                ResHandler.getInstance().mHitAnnim.setPosX(ResHandler.getInstance().mCharacter.getPosX());
                                ResHandler.getInstance().mHitAnnim.setPosY(ResHandler.getInstance().mCharacter.getPosY());
                                this.hit = true;
                            }
                        } else if (this.objects[ind] instanceof PowerUps && !this.hasJump) {
                            this.collisionWithPowerUps(ind);
                        }
                    }
                    ind = (byte)(ind + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void collisionWithPowerUps(byte ind) {
        if (ResHandler.getInstance().mCharacter == null || this.objects[ind] == null) {
            return;
        }
        if (((PowerUps)this.objects[ind]).isVisible() && ResHandler.getInstance().mCharacter.checkCollision(((PowerUps)this.objects[ind]).getX(), ((PowerUps)this.objects[ind]).getY(), ((PowerUps)this.objects[ind]).getWidth(), ((PowerUps)this.objects[ind]).getHeight(), (byte)10)) {
            this.powerUp = ((PowerUps)this.objects[ind]).getPowerUpType();
            ((PowerUps)this.objects[ind]).setVisibility(false);
            switch (this.powerUp) {
                case 0: {
                    this.supermanFrameIndx = 0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.fireChar();
                    break;
                }
                case 3: {
                    break;
                }
            }
            this.powerUpCounter = 0;
        }
    }

    private void processCounter() {
        if (this.mCounter % 2 == 0) {
            if (this.objects != null) {
                byte i = 0;
                byte len = (byte)this.objects.length;
                while (i < len) {
                    if (this.objects[i] != null && this.objects[i] instanceof Coin) {
                        ((Coin)this.objects[i]).animateCoin();
                    }
                    i = (byte)(i + 1);
                }
            }
            if (this.powerUp == 0 && this.supermanFrameIndx < 3 && this.supermanFrameIndx < ResHandler.getInstance().mCharacter.getTotalNumFrame((byte)1)) {
                this.supermanFrameIndx = (byte)(this.supermanFrameIndx + 1);
            }
        }
        if (this.mCounter % 5 == 0 && this.powerUp == 0 && this.powerUpCounter >= 10 && this.supermanFrameIndx < ResHandler.getInstance().mCharacter.getTotalNumFrame((byte)1)) {
            this.supermanFrameIndx = (byte)(this.supermanFrameIndx + 1);
        }
        if (this.mCounter % 10 == 0) {
            if (this.speedOffset > 0 && this.powerUp != 0) {
                --this.speedOffset;
            }
            if (this.dieCounter > 0) {
                this.dieCounter = (byte)(this.dieCounter - 1);
                if (this.dieCounter <= 0) {
                    MainCanvas.mMenuSelInd = 0;
                    this.checkHighScore();
                    MainCanvas.setState((byte)21);
                }
            }
        }
        if (this.mCounter == 120) {
            this.mCounter = 0;
        }
        this.mCounter = (byte)(this.mCounter + 1);
    }

    private void controlSpeedOffset() {
        if (this.mCoinCounter != 0 && this.mCoinCounter % 10 == 0) {
            ++this.speedOffset;
            this.speedIncr = (byte)(this.speedIncr + 2);
            this.mCoinCounter = 0;
        }
        if (this.speedOffset <= 0) {
            MainCanvas.playSound((byte)5);
            this.dieCounter = (byte)3;
        }
    }

    public void resetGP() {
        this.dieCounter = 0;
        this.isCharRunnig = false;
        this.hit = false;
        this.isShoot = false;
        this.mCoinCounter = 0;
        this.speedOffset = 0;
        this.mCoins = 0;
        this.mDistance = 0;
        this.resetGameObjects();
        this.movSpeed = 0;
        this.reduceOffset = 0;
        this.powerUp = (byte)-1;
        this.powerUpCounter = 0;
        this.dieCounter = 0;
        this.mKeyCode = -1;
        this.displayWeapon = true;
        if (ResHandler.getInstance().obstacle != null) {
            MainCanvas.getInstance();
            this.CHAR_Y = MainCanvas.SCREEN_HEIGHT - ResHandler.getInstance().obstacle.getFrameIndxHeight((byte)0) - ResHandler.getInstance().mCharacter.getFrameIndxHeight((byte)0) / 2;
            ResHandler.getInstance().obstacle.resetAnim();
        }
        if (ResHandler.getInstance().mCharacter != null) {
            ResHandler.getInstance().mCharacter.setPosX(this.CHAR_X);
            ResHandler.getInstance().mCharacter.setPosY(this.CHAR_Y);
        }
    }

    public void deAllRes() {
        if (this.coins != null) {
            int i = 0;
            while (i < this.coins.length) {
                this.coins[i] = null;
                i = (byte)(i + 1);
            }
            this.coins = null;
        }
        this.obstY = null;
        this.nextCoinPattern = null;
        this.mCoins = 0;
        mRandom = null;
        this.objects = null;
        this.mObst = null;
        this.mEnemies = null;
        this.mPowerUps = null;
        this.randomLeft = null;
        this.randomRight = null;
        this.allowMovement = null;
        this.isCharRunnig = false;
        this.isShoot = false;
        this.hasJump = false;
        this.gameThread = false;
        this.displayWeapon = false;
        this.placeFront = false;
        this.hit = false;
        this.mKeyCode = -1;
        this.powerUp = (byte)-1;
        this.speedOffset = 0;
        this.mCounter = 0;
        this.mCoinCounter = 0;
        this.mDistance = 0;
        this.nextCoinIndex = 0;
        this.panBGX = 0;
        this.reduceOffset = 0;
        this.powerUpCounter = 0;
        this.movSpeed = 0;
        this.dieCounter = 0;
        this.supermanFrameIndx = 0;
    }

    private void moveBG() {
        this.movSpeed = (byte)this.speedOffset;
        switch (this.powerUp) {
            case 2: {
                MainCanvas.getInstance();
                this.movSpeed = MainCanvas.JUMP_SPEED;
                break;
            }
            case 0: {
                MainCanvas.getInstance();
                this.movSpeed = MainCanvas.JET_SPEED;
                break;
            }
        }
        byte ind = 0;
        byte len = (byte)this.obstY.length;
        while (ind < len) {
            int n = this.obstY[ind];
            MainCanvas.getInstance();
            if (n >= MainCanvas.SCREEN_HEIGHT) {
                this.randomLeft[ind] = (byte)GamePlay.getRandomVal(4);
                this.randomRight[ind] = (byte)GamePlay.getRandomVal(4);
                this.obstY[ind] = this.obstY[this.prevIndex(ind, len)] - 520;
                System.out.println("obstY[ind]============================================" + this.obstY[ind]);
            }
            byte by = ind;
            this.obstY[by] = this.obstY[by] + this.movSpeed;
            if (ind == 0) {
                this.distanceCount += this.movSpeed;
            }
            if (this.distanceCount >= 200) {
                this.distanceCount = 0;
                ++this.mDistance;
            }
            ind = (byte)(ind + 1);
        }
    }

    private byte prevIndex(byte ind, byte len) {
        if (ind > 0) {
            return (byte)(ind - 1);
        }
        return (byte)(len - 1);
    }

    private byte nextIndex(byte ind, byte len) {
        if (ind < len - 1) {
            return (byte)(ind + 1);
        }
        return 0;
    }

    private void sortCoins() {
        if (this.objects != null) {
            int[][] xy = new int[this.objects.length][2];
            byte ind = 0;
            byte len = (byte)this.objects.length;
            while (ind < len) {
                if (this.objects[ind] != null) {
                    if (this.objects[ind] instanceof Coin) {
                        xy[ind][0] = ((Coin)this.objects[ind]).getXCoin();
                        xy[ind][1] = ((Coin)this.objects[ind]).getYCoin();
                    } else if (this.objects[ind] instanceof Obstacle) {
                        xy[ind][0] = ((Obstacle)this.objects[ind]).posX;
                        xy[ind][1] = ((Obstacle)this.objects[ind]).posY;
                    } else if (this.objects[ind] instanceof PowerUps) {
                        xy[ind][0] = ((PowerUps)this.objects[ind]).getX();
                        xy[ind][1] = ((PowerUps)this.objects[ind]).getY();
                    }
                } else {
                    xy[ind][0] = -1;
                    int[] nArray = xy[ind];
                    MainCanvas.getInstance();
                    nArray[1] = -MainCanvas.SCREEN_HEIGHT;
                }
                ind = (byte)(ind + 1);
            }
            this.objects = QuickSort.getInstance().quickSort(this.objects, xy, 0, xy.length - 1);
        }
    }

    private void processKeys() {
        switch (this.mKeyCode) {
            case 3: 
            case 52: {
                int n = ResHandler.getInstance().mCharacter.getPosX();
                MainCanvas.getInstance();
                if (n <= MainCanvas.ADDITIONAL_WIDTH || this.speedOffset <= 0) break;
                ZedAnimAJO zedAnimAJO = ResHandler.getInstance().mCharacter;
                MainCanvas.getInstance();
                zedAnimAJO.move(-MainCanvas.DIR_SPEED, 0);
                break;
            }
            case 4: 
            case 54: {
                int n = ResHandler.getInstance().mCharacter.getPosX();
                MainCanvas.getInstance();
                MainCanvas.getInstance();
                if (n >= MainCanvas.ADDITIONAL_WIDTH + MainCanvas.SCREEN_WIDTH || this.speedOffset <= 0) break;
                ZedAnimAJO zedAnimAJO = ResHandler.getInstance().mCharacter;
                MainCanvas.getInstance();
                zedAnimAJO.move(MainCanvas.DIR_SPEED, 0);
                break;
            }
            case 2: 
            case 53: {
                if (this.speedOffset <= 0) {
                    this.isShoot = true;
                }
                if (this.powerUp == 0 || this.powerUp == 2) break;
                this.fireChar();
                break;
            }
        }
        MainCanvas.getInstance();
        if (Math.abs(MainCanvas.SCREEN_CENTER_X - ResHandler.getInstance().mCharacter.getPosX()) < ResHandler.getInstance().mBG.getWidth()) {
            MainCanvas.getInstance();
            this.panBGX = MainCanvas.SCREEN_CENTER_X - ResHandler.getInstance().mCharacter.getPosX();
        }
    }

    protected void keyPressed(int keyCode) {
        this.mKeyCode = keyCode;
    }

    protected void keyReleased(int keyCode) {
        this.mKeyCode = -1;
    }
}

