/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import zed.rollNRun.ui.MainCanvas;

public class ZedAnimation {
    public static final byte ALL_PALETTE = -1;
    public static final byte TRANSFORM_NONE = 0;
    public static final byte TRANSFORM_MIRROR = 2;
    public static final byte TRANSFORM_MIRROR_ROT180 = 1;
    public static final byte TRANSFORM_MIRROR_ROT270 = 4;
    public static final byte TRANSFORM_MIRROR_ROT90 = 7;
    public static final byte TRANSFORM_ROT180 = 3;
    public static final byte TRANSFORM_ROT270 = 6;
    public static final byte TRANSFORM_ROT90 = 5;
    public byte currentPaletteIdx = 0;
    public int numBitsPalette;
    public int paletteNumColors;
    public int numRepetitions;
    public byte numPalettes;
    int[] palettes;
    byte[] imageData;
    int[] imageDataStartIndex;
    int indexMask;
    byte numBitsIndex;
    private static int[] crc_table;
    public int cacheSize;
    int[] cache = null;
    int[] buff2Draw;
    short[] spritesDimension = null;
    public int numSprites;
    public Image[][] sprites;
    int[] spritePosInCache;
    int[] spriteFlipPosInCache;
    byte[] spriteTransInCache;
    public short[] frameBegins;
    public short[] frameWH;
    int framePainted;
    public byte[] frames;
    public short[][] colBoxes;
    public short[][] attBoxes;
    private static final int MULTI_PROJECT = 5;
    private ZedAnimation[] projects;
    private String[] projectsNames;
    private byte projectsQuantity;
    private byte[] pFramesQuantityInsideMFrames;
    private byte[] pFrames_ProjectIDs;
    private short[] pFrames_FramesIDs;
    private byte mFramesQuantity;
    private byte[] mFramesQuantityInAnimations;
    private short[] mFramesInsideAnimations;
    private byte[] mFramesOffsets;
    private byte[] pFramesOffsetByMFrames;
    public byte[] animations;
    public int[] animationsTimeLengths;
    public short numAnimations;
    public short[] animationOffsets;
    boolean animFinished;
    private byte editorVersion;
    private byte reserved;
    private int binaryFormatVersion;
    private int imageFormatVersion;
    int lastPositionBuffer;
    private boolean clipActivated;
    public long elapsedFrameTime;
    public long cacheUnfoldTime;
    public long intermediateBufferTime;
    public long imagePaintTime;
    public boolean propietaryArrayCopy = false;
    public long tArrayCopy;
    private static final int AXIS_X;
    private static final int AXIS_Y;
    private static final int CLIP_X = 10;
    private static final int CLIP_Y = 10;
    private static final int CLIP_W = 20;
    private static final int CLIP_H = 20;
    public static int totalImgMemory;
    private int imgMemory;
    public int alphaColor;
    private int destW;
    private int destH;
    public static final byte FLAG_INCLUDE_COL_BOX = 1;
    public static final byte FLAG_INCLUDE_ATT_BOX = 2;

    static {
        MainCanvas.getInstance();
        AXIS_X = MainCanvas.SCREEN_WIDTH >> 1;
        MainCanvas.getInstance();
        AXIS_Y = MainCanvas.SCREEN_HEIGHT >> 1;
    }

    public ZedAnimation(byte[] data, int alphaModeColor) {
        this(data, 0, -1, false, false, true, alphaModeColor);
    }

    public ZedAnimation(byte[] data, int currentPalette, boolean staticCache) {
        this(data, currentPalette, -1, true, staticCache, false, 0);
    }

    public ZedAnimation(byte[] data, int currentPalette, int bufferSize, boolean nativeArrayCopy) {
        this(data, currentPalette, bufferSize, nativeArrayCopy, false, false, 0);
    }

    public ZedAnimation(byte[] data, int currentPalette, int bufferSize, boolean nativeArrayCopy, boolean staticCache, boolean alphaMode, int alphaModeColor) {
        this.propietaryArrayCopy = nativeArrayCopy;
        try {
            this.currentPaletteIdx = (byte)currentPalette;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            this.editorVersion = dis.readByte();
            this.imageFormatVersion = dis.readByte();
            this.reserved = dis.readByte();
            if (this.imageFormatVersion == 5) {
                this.loadMultiProject(dis);
            } else {
                this.loadPlainProject(bufferSize, dis);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPlainProject(int bufferSize, DataInputStream dis) throws IOException {
        int i;
        boolean fontsIncluded = dis.readBoolean();
        if (fontsIncluded) {
            this.skipNonAnimationInfo(dis);
        }
        this.numSprites = dis.readShort();
        this.cacheSize = bufferSize;
        this.readSprites(dis, this.numSprites);
        int available = dis.available();
        int numFrames = dis.readShort();
        this.frameBegins = new short[numFrames + 1];
        this.frameBegins[0] = 0;
        int j = 0;
        while (j < numFrames) {
            this.frameBegins[j + 1] = (short)(dis.readShort() * 4);
            ++j;
        }
        this.frames = new byte[this.frameBegins[j]];
        dis.read(this.frames);
        this.frameWH = new short[numFrames * 2];
        int iii = 0;
        while (iii < numFrames) {
            int p0X = Integer.MAX_VALUE;
            int p1X = Integer.MIN_VALUE;
            int i2 = this.frameBegins[iii];
            while (i2 < this.frameBegins[iii + 1]) {
                byte[] currentFrames = this.getCurrentFrame(i2);
                short despX = this.getSpriteXOffset(currentFrames);
                short spriteIdx = this.getSpriteIdx(currentFrames);
                int w = this.getSpriteW(spriteIdx);
                p0X = Math.min(p0X, despX);
                p1X = Math.max(p1X, despX + w);
                i2 += 4;
            }
            this.frameWH[iii * 2] = (short)(p1X - p0X);
            int p0Y = Integer.MAX_VALUE;
            int p1Y = Integer.MIN_VALUE;
            int i3 = this.frameBegins[iii];
            while (i3 < this.frameBegins[iii + 1]) {
                byte[] currentFrames = this.getCurrentFrame(i3);
                short despY = this.getSpriteYOffset(currentFrames);
                short spriteIdx = this.getSpriteIdx(currentFrames);
                int h = this.getSpriteH(spriteIdx);
                p0Y = Math.min(p0Y, despY);
                p1Y = Math.max(p1Y, despY + h);
                i3 += 4;
            }
            this.frameWH[iii * 2 + 1] = (short)(p1Y - p0Y);
            ++iii;
        }
        this.numAnimations = dis.readShort();
        this.animationOffsets = new short[this.numAnimations + 1];
        this.animationOffsets[0] = 0;
        j = 0;
        while (j < this.numAnimations) {
            this.animationOffsets[j + 1] = (short)(dis.readShort() * 2);
            ++j;
        }
        this.animations = new byte[this.animationOffsets[j]];
        dis.read(this.animations);
        this.animationsTimeLengths = new int[this.animationOffsets.length - 1];
        j = 0;
        while (j < this.animationsTimeLengths.length) {
            this.animationsTimeLengths[j] = 0;
            int n = (this.animationOffsets[j + 1] - this.animationOffsets[j]) / 2;
            int k = 0;
            while (k < n) {
                int n2 = j;
                this.animationsTimeLengths[n2] = this.animationsTimeLengths[n2] + (0xFF & this.animations[this.animationOffsets[j] + k * 2 + 1]);
                ++k;
            }
            ++j;
        }
        if (this.includeColBox()) {
            this.colBoxes = new short[numFrames][4];
            i = 0;
            while (i < numFrames) {
                this.colBoxes[i][0] = dis.readShort();
                this.colBoxes[i][1] = dis.readShort();
                this.colBoxes[i][2] = dis.readShort();
                this.colBoxes[i][3] = dis.readShort();
                ++i;
            }
        }
        if (this.includeAttBox()) {
            this.attBoxes = new short[numFrames][4];
            i = 0;
            while (i < numFrames) {
                this.attBoxes[i][0] = dis.readShort();
                this.attBoxes[i][1] = dis.readShort();
                this.attBoxes[i][2] = dis.readShort();
                this.attBoxes[i][3] = dis.readShort();
                ++i;
            }
        }
        System.gc();
    }

    public void drawColBox(Graphics g, int frameId, int x, int y) {
        frameId = this.animations[frameId] & 0xFF;
        if (this.includeColBox()) {
            g.setColor(0xFFFF00);
            g.drawRect(this.colBoxes[frameId][0] + x, this.colBoxes[frameId][1] + y, (int)this.colBoxes[frameId][2], (int)this.colBoxes[frameId][3]);
        }
        if (this.includeAttBox()) {
            g.setColor(0xFF0000);
            g.drawRect(this.attBoxes[frameId][0] + x, this.attBoxes[frameId][1] + y, (int)this.attBoxes[frameId][2], (int)this.attBoxes[frameId][3]);
        }
    }

    public void setPalette(int palette) {
        if (palette >= this.numPalettes) {
            return;
        }
        this.currentPaletteIdx = (byte)palette;
    }

    public final int getSpriteW(int sprite) {
        int desArray = 1;
        return this.getUnsignedIntValueFromShortArray(this.spritesDimension, sprite << desArray);
    }

    public int getFrameWidth(int frame) {
        return this.frameWH[frame * 2];
    }

    public int getFrameHeight(int frame) {
        return this.frameWH[frame * 2 + 1];
    }

    public void skipNonAnimationInfo(DataInputStream dis) throws IOException {
        dis.skipBytes(4);
        short charQuantity = dis.readShort();
        dis.skipBytes(charQuantity * 2 * 2);
    }

    static final short toShort(byte[] data, int i) {
        return (short)((0xFF & data[i]) << 8 | 0xFF & data[i + 1]);
    }

    static final short tenBitsToShort(byte[] data, int i) {
        byte signFlag = (byte)(data[i + 1] & 2);
        int mask = signFlag == 0 ? 0 : -1;
        byte a = (byte)(data[i + 1] ^ mask & 0xFC);
        byte b = (byte)(0xFF & data[i]);
        short r = (short)(a << 8 & 0xFF00 | b & 0xFF);
        return r;
    }

    public void EnablePrecalcImage(int poolID) {
    }

    public static void SetPrecalcImagePoolSize(int poolID) {
    }

    private void readSprites(DataInputStream dis, int numSprites) throws IOException {
        this.imgMemory = 0;
        if (this.imageFormatVersion < 0) {
            this.spritesDimension = new short[numSprites << 2];
            int elementId = 0;
            int j = 0;
            while (j < numSprites) {
                this.readSpriteDimensions(dis, j);
                ++j;
            }
            this.numPalettes = (byte)dis.read();
            int paletteLength = dis.readInt();
            byte[][] palette = new byte[this.numPalettes][paletteLength];
            int i = 0;
            while (i < this.numPalettes) {
                if (this.currentPaletteIdx != -1) {
                    if (i == this.currentPaletteIdx) {
                        dis.read(palette[i]);
                        dis.skip((this.numPalettes - i - 1) * paletteLength);
                        break;
                    }
                    dis.skip(paletteLength);
                } else {
                    dis.read(palette[i]);
                }
                ++i;
            }
            byte[] header = new byte[dis.readInt()];
            dis.read(header);
            byte[] end = new byte[dis.readInt()];
            dis.read(end);
            int tempArrayImageLen = dis.readInt() + header.length + paletteLength + end.length;
            byte[][] tempArrayImage = new byte[numSprites][tempArrayImageLen];
            int posData = header.length + paletteLength;
            this.sprites = new Image[this.numPalettes][numSprites];
            int i2 = 0;
            while (i2 < numSprites) {
                int imageDataLength = dis.readInt();
                dis.read(tempArrayImage[i2], posData, imageDataLength);
                elementId = i2 << 1;
                int j2 = 0;
                while (j2 < this.numPalettes) {
                    if (this.currentPaletteIdx != -1) {
                        if (i2 == this.currentPaletteIdx) {
                            this.buildImage(elementId, paletteLength, palette, header, end, tempArrayImage, posData, i2, imageDataLength, j2);
                        }
                    } else {
                        this.buildImage(elementId, paletteLength, palette, header, end, tempArrayImage, posData, i2, imageDataLength, j2);
                    }
                    ++j2;
                }
                tempArrayImage[i2] = null;
                ++i2;
            }
            this.setPalette(0);
        } else {
            this.spritesDimension = new short[numSprites << 1];
            this.imgMemory += this.spritesDimension.length * 2;
            int minBufferSize = 0;
            int j = 0;
            while (j < numSprites) {
                this.readSpriteDimensions(dis, j);
                int dim = (0xFFFF & this.spritesDimension[j << 1]) * (0xFFFF & this.spritesDimension[(j << 1) + 1]);
                minBufferSize = dim > minBufferSize ? dim : minBufferSize;
                ++j;
            }
            this.numPalettes = dis.readByte();
            this.paletteNumColors = 0xFF & dis.readByte();
            this.numBitsPalette = 0xFF & dis.readByte();
            this.numRepetitions = this.numBitsPalette == 0 ? 1 : 2 << this.numBitsPalette - 1;
            byte[] palettesData = new byte[this.numPalettes * this.paletteNumColors * 2];
            dis.read(palettesData);
            this.imgMemory += palettesData.length;
            this.palettes = new int[this.numPalettes * this.paletteNumColors * this.numRepetitions];
            this.imgMemory += this.palettes.length * 4;
            int pal = 0;
            while (pal < this.numPalettes) {
                int pos = pal * this.paletteNumColors * 2;
                int c = 0;
                while (c < this.paletteNumColors) {
                    int color = ZedAnimation.toIntRGBA(palettesData, pos);
                    int k = 0;
                    while (k < this.numRepetitions) {
                        this.palettes[this.numRepetitions * this.paletteNumColors * pal + (this.numRepetitions * c + k)] = color;
                        ++k;
                    }
                    ++c;
                    pos += 2;
                }
                ++pal;
            }
            int numPixels = dis.readInt();
            this.imageDataStartIndex = new int[numSprites + 1];
            this.imgMemory += this.imageDataStartIndex.length * 4;
            int n = 0;
            while (n < numSprites) {
                this.imageDataStartIndex[n] = dis.readInt();
                ++n;
            }
            this.imageDataStartIndex[numSprites] = numPixels;
            this.imageData = new byte[numPixels];
            this.imgMemory += this.imageData.length;
            int j3 = 0;
            while (j3 < numPixels) {
                this.imageData[j3] = dis.readByte();
                ++j3;
            }
            this.numBitsIndex = (byte)(8 - this.numBitsPalette);
            this.indexMask = 255 >>> this.numBitsPalette;
            this.cacheSize = minBufferSize > this.cacheSize ? minBufferSize : this.cacheSize;
            this.cache = new int[this.cacheSize];
            this.imgMemory += this.cacheSize * 4;
            this.spritePosInCache = new int[numSprites * this.numPalettes << 1];
            this.spriteFlipPosInCache = new int[numSprites * this.numPalettes << 1];
            this.spriteTransInCache = new byte[numSprites * this.numPalettes << 1];
            this.imgMemory += (this.spritePosInCache.length + this.spriteFlipPosInCache.length) * 4 + this.spriteTransInCache.length;
            this.init_SpritePosInCache_Array();
            System.gc();
        }
        totalImgMemory += this.imgMemory;
    }

    private void buildImage(int elementId, int paletteLength, byte[][] palette, byte[] header, byte[] end, byte[][] tempArrayImage, int posData, int i, int imageDataLength, int j) {
        System.arraycopy(header, 0, tempArrayImage[i], 0, header.length);
        System.arraycopy(palette[j], 0, tempArrayImage[i], header.length, paletteLength);
        System.arraycopy(end, 0, tempArrayImage[i], posData + imageDataLength, end.length);
        ZedAnimation.toBytes(this.getUnsignedIntValueFromShortArray(this.spritesDimension, elementId), tempArrayImage[i], 16);
        ZedAnimation.toBytes(this.getUnsignedIntValueFromShortArray(this.spritesDimension, elementId + 1), tempArrayImage[i], 20);
        long crc = ZedAnimation.getCRC32(tempArrayImage[i], 12, 17);
        ZedAnimation.toBytes((int)crc, tempArrayImage[i], 29);
        this.sprites[j][i] = Image.createImage((byte[])tempArrayImage[i], (int)0, (int)(imageDataLength + posData + end.length));
        this.imgMemory += this.sprites[j][i].getWidth() * this.sprites[j][i].getHeight() * 2 + 32;
    }

    private void readSpriteDimensions(DataInputStream dis, int j) throws IOException {
        byte[] packedShorts = new byte[3];
        dis.read(packedShorts, 0, 3);
        byte firstByteWidth = (byte)(packedShorts[0] >> 4 & 0xF);
        byte firstByteHeight = (byte)(packedShorts[0] & 0xF);
        short width = ZedAnimation.toShort(new byte[]{firstByteWidth, packedShorts[1]}, 0);
        short height = ZedAnimation.toShort(new byte[]{firstByteHeight, packedShorts[2]}, 0);
        this.spritesDimension[j << 1] = width;
        this.spritesDimension[(j << 1) + 1] = height;
    }

    private byte[] readByteDat(DataInputStream dis, byte[] tempArrayImage, byte[] header, byte[] palette, byte[] end, int w, int h) throws IOException {
        int posData = header.length + palette.length;
        int length = dis.readInt();
        int bytesRead = dis.read(tempArrayImage, posData, length);
        System.arraycopy(end, 0, tempArrayImage, posData + length, end.length);
        ZedAnimation.toBytes(w, tempArrayImage, 16);
        ZedAnimation.toBytes(h, tempArrayImage, 20);
        long crc = ZedAnimation.getCRC32(tempArrayImage, 12, 17);
        ZedAnimation.toBytes((int)crc, tempArrayImage, 29);
        byte[] temp = new byte[length + posData + end.length];
        System.arraycopy(tempArrayImage, 0, temp, 0, temp.length);
        return temp;
    }

    private Image readImageDat(DataInputStream dis, byte[] tempArrayImage, byte[] header, byte[] palette, byte[] end, int w, int h) throws IOException {
        int posData = header.length + palette.length;
        int length = dis.readInt();
        int bytesRead = dis.read(tempArrayImage, posData, length);
        System.arraycopy(end, 0, tempArrayImage, posData + length, end.length);
        ZedAnimation.toBytes(w, tempArrayImage, 16);
        ZedAnimation.toBytes(h, tempArrayImage, 20);
        long crc = ZedAnimation.getCRC32(tempArrayImage, 12, 17);
        ZedAnimation.toBytes((int)crc, tempArrayImage, 29);
        return Image.createImage((byte[])tempArrayImage, (int)0, (int)(length + posData + end.length));
    }

    static final void toBytes(int num, byte[] data, int start) {
        data[start] = (byte)((num & 0xFF000000) >> 24);
        data[start + 1] = (byte)((num & 0xFF0000) >> 16);
        data[start + 2] = (byte)((num & 0xFF00) >> 8);
        data[start + 3] = (byte)(num & 0xFF);
    }

    public static long getCRC32(byte[] buf, int off, int len) {
        int c;
        if (crc_table == null) {
            crc_table = new int[256];
            int n = 0;
            while (n < 256) {
                c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                ZedAnimation.crc_table[n] = c;
                ++n;
            }
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public void loadMultiProject(DataInputStream dis) {
        try {
            this.projectsQuantity = dis.readByte();
            this.projectsNames = new String[this.projectsQuantity];
            this.projects = new ZedAnimation[this.projectsQuantity];
            int i = 0;
            while (i < this.projectsQuantity) {
                int charQuantity = dis.readByte();
                char[] name = new char[charQuantity];
                int j = 0;
                while (j < charQuantity) {
                    name[j] = dis.readChar();
                    ++j;
                }
                this.projectsNames[i] = new String(name);
                ++i;
            }
            this.mFramesQuantity = dis.readByte();
            this.pFramesQuantityInsideMFrames = new byte[this.mFramesQuantity];
            dis.read(this.pFramesQuantityInsideMFrames);
            int totalQuantityOfPFrames = 0;
            int i2 = 0;
            while (i2 < this.mFramesQuantity) {
                totalQuantityOfPFrames += this.pFramesQuantityInsideMFrames[i2];
                ++i2;
            }
            this.pFrames_ProjectIDs = new byte[totalQuantityOfPFrames];
            this.pFrames_FramesIDs = new short[totalQuantityOfPFrames];
            i2 = 0;
            while (i2 < totalQuantityOfPFrames) {
                this.pFrames_ProjectIDs[i2] = dis.readByte();
                this.pFrames_FramesIDs[i2] = dis.readShort();
                ++i2;
            }
            this.numAnimations = dis.readByte();
            this.mFramesQuantityInAnimations = new byte[this.numAnimations];
            dis.read(this.mFramesQuantityInAnimations);
            int totalQuantityOfMFramesInsideAnimations = 0;
            int i3 = 0;
            while (i3 < this.numAnimations) {
                totalQuantityOfMFramesInsideAnimations += this.mFramesQuantityInAnimations[i3];
                ++i3;
            }
            this.mFramesInsideAnimations = new short[totalQuantityOfMFramesInsideAnimations * 2];
            i3 = 0;
            while (i3 < totalQuantityOfMFramesInsideAnimations) {
                this.mFramesInsideAnimations[i3 * 2] = dis.readShort();
                this.mFramesInsideAnimations[i3 * 2 + 1] = dis.readShort();
                ++i3;
            }
            this.pFramesOffsetByMFrames = new byte[this.mFramesQuantity];
            i3 = 0;
            while (i3 < this.mFramesQuantity) {
                this.pFramesOffsetByMFrames[i3] = (byte)(i3 == 0 ? 0 : this.pFramesOffsetByMFrames[i3 - 1] + this.pFramesQuantityInsideMFrames[i3 - 1]);
                ++i3;
            }
            this.animationsTimeLengths = new int[this.numAnimations];
            this.mFramesOffsets = new byte[this.numAnimations];
            int mFrameIdx = 0;
            int i4 = 0;
            while (i4 < this.numAnimations) {
                int elapsedTime = 0;
                int j = 0;
                while (j < this.mFramesQuantityInAnimations[i4]) {
                    elapsedTime += this.mFramesInsideAnimations[mFrameIdx++ * 2];
                    ++j;
                }
                this.animationsTimeLengths[i4] = elapsedTime;
                this.mFramesOffsets[i4] = i4 == 0 ? (byte)0 : (byte)(this.mFramesQuantityInAnimations[i4 - 1] + this.mFramesOffsets[i4 - 1]);
                ++i4;
            }
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final int getMultiFramePos(int animId, long time, boolean cyclical) {
        this.animFinished = false;
        time /= 10L;
        if (cyclical) {
            time %= (long)this.animationsTimeLengths[animId];
        } else if (time >= (long)this.animationsTimeLengths[animId]) {
            this.animFinished = true;
            time = this.animationsTimeLengths[animId];
        }
        int t = 0;
        int frame = 0;
        while ((long)t < time) {
            if ((long)(t += this.animations[this.animationOffsets[animId] + frame * 2 + 1] & 0xFF) >= time) continue;
            ++frame;
        }
        this.framePainted = frame;
        return this.animationOffsets[animId] + frame * 2;
    }

    public final int drawAnimation(Graphics g, int animation, long time, int x, int y, int transformation, boolean cyclical) {
        this.alphaColor = 0;
        this.destW = 0;
        this.destH = 0;
        int frp = this.getFramePos(animation, time, cyclical);
        if (frp < 0) {
            return -1;
        }
        if (this.imageFormatVersion == 5) {
            this.drawFrame(g, frp, x, y, transformation);
        } else {
            this.drawFrame(g, this.animations[frp] & 0xFF, x, y, transformation);
        }
        return this.animFinished ? -1 : this.framePainted;
    }

    public final int getFrameNum(int animId) {
        return (this.animationOffsets[animId + 1] - this.animationOffsets[animId]) / 2;
    }

    public final int drawResizedAnimation(Graphics g, int animation, long time, int x, int y, int transformation, boolean cyclical, int destW, int destH) {
        this.alphaColor = 0;
        this.destW = destW;
        this.destH = destH;
        int frp = this.getFramePos(animation, time, cyclical);
        if (this.imageFormatVersion == 5) {
            this.drawFrame(g, frp, x, y, transformation);
        } else {
            this.drawFrame(g, this.animations[frp] & 0xFF, x, y, transformation);
        }
        return this.animFinished ? -1 : this.framePainted;
    }

    public final int getFramePos(int animId, long time, boolean cyclical) {
        this.animFinished = false;
        time /= 10L;
        if (this.animationsTimeLengths[animId] == 0) {
            return -1;
        }
        if (cyclical) {
            time %= (long)this.animationsTimeLengths[animId];
        } else if (time >= (long)this.animationsTimeLengths[animId]) {
            this.animFinished = true;
            time = this.animationsTimeLengths[animId];
        }
        int t = 0;
        int frame = 0;
        if (this.imageFormatVersion == 5) {
            frame = this.mFramesOffsets[animId];
        }
        while ((long)t < time) {
            t = this.imageFormatVersion == 5 ? (t += this.mFramesInsideAnimations[frame * 2]) : (t += this.animations[this.animationOffsets[animId] + frame * 2 + 1] & 0xFF);
            if ((long)t >= time) continue;
            ++frame;
        }
        this.framePainted = frame;
        if (this.imageFormatVersion == 5) {
            short mFrame = this.mFramesInsideAnimations[frame * 2 + 1];
            return mFrame;
        }
        return this.animationOffsets[animId] + frame * 2;
    }

    public boolean bFinished() {
        return this.animFinished;
    }

    public int GetGolFramePos(int animId, long time, boolean cyclical) {
        int idx = this.getFramePos(animId, time, cyclical);
        if (idx < 0) {
            return -1;
        }
        return this.animations[idx] & 0xFF;
    }

    public final void drawFrame(Graphics g, int frame, int x, int y, int transformation) {
        if (this.imageFormatVersion == 5) {
            byte pFrameOffset = this.pFramesOffsetByMFrames[frame];
            int i = 0;
            while (i < this.pFramesQuantityInsideMFrames[frame]) {
                short plainFrameId = this.pFrames_FramesIDs[pFrameOffset + i];
                byte projectId = this.pFrames_ProjectIDs[pFrameOffset + i];
                this.projects[projectId].drawFrame(g, plainFrameId, x, y, transformation);
                ++i;
            }
        } else {
            long initFrameTime = System.currentTimeMillis();
            int i = this.frameBegins[frame];
            while (i < this.frameBegins[frame + 1]) {
                byte[] currentFrames = this.getCurrentFrame(i);
                short spriteIdx = this.getSpriteIdx(currentFrames);
                short frameX = this.getSpriteXOffset(currentFrames);
                short frameY = this.getSpriteYOffset(currentFrames);
                int spriteW = this.getSpriteW(spriteIdx);
                int x_offset = this.computeXOffset(transformation, spriteW, frameX);
                int spriteH = this.getSpriteH(spriteIdx);
                int y_offset = this.computeYOffset(transformation, spriteH, frameY, this.getFrameHeight(frame));
                byte transFromSprite = this.getSpriteTransform(i);
                if (transformation == 5 || transformation == 6 || transformation == 7 || transformation == 4) {
                    int aux = x_offset;
                    x_offset = y_offset;
                    y_offset = aux;
                }
                if (transFromSprite == 5 || transFromSprite == 6 || transFromSprite == 7 || transFromSprite == 4) {
                    int centerX = x_offset + spriteW / 2;
                    int centerY = y_offset + spriteH / 2;
                    x_offset = centerX - spriteH / 2;
                    y_offset = centerY - spriteW / 2;
                } else if (transFromSprite == 3) {
                    if (spriteW % 2 != 0) {
                        --x_offset;
                    }
                    if (spriteH % 2 != 0) {
                        --y_offset;
                    }
                }
                this.drawSprite(g, spriteIdx, x + x_offset, y + y_offset, transformation ^ transFromSprite);
                i += 4;
            }
            this.elapsedFrameTime = System.currentTimeMillis() - initFrameTime;
        }
    }

    public long getElapsedFrameTime() {
        return this.elapsedFrameTime;
    }

    public byte[] getCurrentFrame(int i) {
        byte[] currentFrames = new byte[4];
        System.arraycopy(this.frames, i, currentFrames, 0, 4);
        return currentFrames;
    }

    private short getSpriteYOffset(byte[] currentFrame) {
        byte msbY = (byte)(currentFrame[0] >> 3);
        msbY = (byte)(3 & msbY);
        short y_offset = ZedAnimation.tenBitsToShort(new byte[]{currentFrame[3], msbY}, 0);
        return y_offset;
    }

    private short getSpriteXOffset(byte[] currentFrame) {
        byte msbX = (byte)(currentFrame[0] >> 5);
        msbX = (byte)(3 & msbX);
        short x_offset = ZedAnimation.tenBitsToShort(new byte[]{currentFrame[2], msbX}, 0);
        return x_offset;
    }

    private byte getSpriteTransform(int indexInFrameArray) {
        byte byteT = this.frames[indexInFrameArray];
        byteT = (byte)(7 & byteT);
        return byteT;
    }

    private short getSpriteIdx(byte[] currentFrame) {
        byte firstMixedByte = currentFrame[0];
        firstMixedByte = (byte)(currentFrame[0] >>> 7 & 1);
        short spriteIdx = ZedAnimation.toShort(new byte[]{firstMixedByte, currentFrame[1]}, 0);
        return spriteIdx;
    }

    private int computeYOffset(int transformation, int spriteHeight, int yInFrame, int frameHeight) {
        int r = yInFrame;
        if (transformation == 1 || transformation == 3 || transformation == 5 || transformation == 7) {
            r = -yInFrame - spriteHeight;
        }
        return r;
    }

    private int computeXOffset(int transformation, int spriteWidth, int xInFrame) {
        int r = xInFrame;
        if (transformation == 2 || transformation == 3 || transformation == 6 || transformation == 7) {
            r = -xInFrame - spriteWidth;
        }
        return r;
    }

    public void drawSprite(Graphics g, int sprite, int x, int y, int transformation) {
        if (this.imageFormatVersion < 0) {
            this.drawSpritePNG(g, sprite, x, y, transformation);
        } else {
            this.drawSpriteZIF(g, sprite, x, y, transformation);
        }
        if (this.clipActivated) {
            g.setColor(255);
            int clipOffsetX = AXIS_X + 10;
            int clipOffsetY = AXIS_Y + 10;
            if (transformation == 5 || transformation == 2) {
                clipOffsetX = AXIS_X - 20;
            } else if (transformation == 3 || transformation == 7) {
                clipOffsetX = AXIS_X - 20;
                clipOffsetY = AXIS_Y - 20;
            } else if (transformation == 6 || transformation == 1) {
                clipOffsetY = AXIS_Y - 20;
            }
            g.drawRect(clipOffsetX, clipOffsetY, 20, 20);
            g.setClip(clipOffsetX, clipOffsetY, 20, 20);
            if (this.imageFormatVersion < 0) {
                this.drawSpritePNG(g, sprite, x, y, transformation);
            } else {
                this.drawSpriteZIF(g, sprite, x, y, (byte)transformation);
            }
        }
    }

    private void drawSpritePNG(Graphics g, int sprite, int x, int y, int transformation) {
        Image img = this.sprites[this.currentPaletteIdx][sprite];
        try {
            if (transformation != 0) {
                g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), transformation, x, y, 20);
            } else {
                g.drawImage(img, x, y, 20);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void drawSpriteZIF(Graphics g, int sprite, int x, int y, int transformation) {
        byte cacheTrans;
        if (this.imageDataStartIndex[sprite] == this.imageDataStartIndex[sprite + 1]) {
            return;
        }
        long initTime = System.currentTimeMillis();
        boolean bitsCount = false;
        int elementId = sprite << 1;
        short width = this.spritesDimension[elementId];
        short height = this.spritesDimension[elementId + 1];
        int offSet = -1;
        int cacheIdx = this.numSprites * this.currentPaletteIdx + sprite;
        if (transformation == 0) {
            offSet = this.spritePosInCache[cacheIdx];
            cacheTrans = 0;
        } else {
            offSet = this.spriteFlipPosInCache[cacheIdx];
            cacheTrans = this.spriteTransInCache[cacheIdx];
        }
        if (offSet == -1 || cacheTrans != transformation) {
            offSet = this.decode(sprite, width, height, transformation, offSet);
        }
        this.cacheUnfoldTime += System.currentTimeMillis() - initTime;
        initTime = System.currentTimeMillis();
        this.buff2Draw = this.cache;
        this.intermediateBufferTime += System.currentTimeMillis() - initTime;
        initTime = System.currentTimeMillis();
        if (transformation == 7 || transformation == 4 || transformation == 5 || transformation == 6) {
            short tmp = width;
            width = height;
            height = tmp;
        }
        this.drawRGBImage(g, this.buff2Draw, offSet, x, y, width, height);
        this.imagePaintTime += System.currentTimeMillis() - initTime;
    }

    private int decode(int sprite, int width, int height, int transformation, int offset) {
        int bitsCount;
        if (offset != -1) {
            bitsCount = offset;
        } else {
            int scanLength = width;
            if (transformation == 7 || transformation == 4 || transformation == 5 || transformation == 6) {
                scanLength = height;
            }
            int n = bitsCount = this.lastPositionBuffer == 0 ? this.lastPositionBuffer : ((this.lastPositionBuffer - 1) / scanLength + 1) * scanLength;
        }
        if (this.cacheSize - (bitsCount + width * height) < 0) {
            this.init_SpritePosInCache_Array();
            bitsCount = 0;
        }
        int cacheIdx = this.numSprites * this.currentPaletteIdx + sprite;
        if (transformation == 0) {
            this.spritePosInCache[cacheIdx] = bitsCount;
        } else {
            this.spriteFlipPosInCache[cacheIdx] = bitsCount;
            this.spriteTransInCache[cacheIdx] = (byte)transformation;
        }
        int startPos = bitsCount;
        int i = this.imageDataStartIndex[sprite];
        while (i < this.imageDataStartIndex[sprite + 1]) {
            int index = this.indexMask & this.imageData[i];
            int rep = ((0xFF & this.imageData[i]) >>> this.numBitsIndex) + 1;
            int color = this.palettes[this.currentPaletteIdx * this.numRepetitions * this.paletteNumColors + index * this.numRepetitions];
            int j = 0;
            while (j < rep) {
                int targetPos = this.computOffsetByTrans(startPos, bitsCount, width, height, transformation);
                this.cache[targetPos] = color;
                ++bitsCount;
                ++j;
            }
            ++i;
        }
        if (bitsCount > this.lastPositionBuffer) {
            this.lastPositionBuffer = bitsCount;
        }
        return startPos;
    }

    public void drawRGBImage(Graphics g, int[] cache, int offset, int x, int y, int width, int height) {
        if (this.alphaColor != 0) {
            int[] temp = new int[width * height];
            int i = offset;
            while (i < offset + temp.length) {
                temp[i - offset] = this.buff2Draw[i] & this.alphaColor;
                ++i;
            }
            g.drawRGB(temp, 0, width, x, y, width, height, true);
        } else if (this.destW != 0 && this.destH != 0) {
            int[] destPixels = new int[this.destW * this.destH];
            int[] srcPixels = new int[width * height];
            System.arraycopy(this.buff2Draw, offset, srcPixels, 0, srcPixels.length);
            int destY = 0;
            while (destY < this.destH) {
                int destX = 0;
                while (destX < this.destW) {
                    int srcX = destX * width / this.destW;
                    int srcY = destY * height / this.destH;
                    destPixels[destX + destY * this.destW] = srcPixels[srcX + srcY * width];
                    ++destX;
                }
                ++destY;
            }
            g.drawRGB(destPixels, 0, this.destW, x - (this.destW - width >> 1), y - (this.destH - height >> 1), this.destW, this.destH, true);
        } else {
            g.drawRGB(this.buff2Draw, offset, width, x, y, width, height, true);
        }
    }

    private int computOffsetByTrans(int startPos, int currPos, int w, int h, int transformation) {
        if (transformation == 0) {
            return currPos;
        }
        int offset = currPos - startPos;
        int x = offset % w;
        int y = offset / w;
        int destX = 0;
        int destY = 0;
        int scanLength = w;
        switch ((byte)transformation) {
            case 2: {
                destX = w - x - 1;
                destY = y;
                break;
            }
            case 1: {
                destX = x;
                destY = h - y - 1;
                break;
            }
            case 5: {
                destX = h - y - 1;
                destY = x;
                scanLength = h;
                break;
            }
            case 3: {
                destX = w - x - 1;
                destY = h - y - 1;
                break;
            }
            case 6: {
                destX = y;
                destY = w - x - 1;
                scanLength = h;
                break;
            }
            case 7: {
                destX = h - y - 1;
                destY = w - x - 1;
                scanLength = h;
                break;
            }
            case 4: {
                destX = y;
                destY = x;
                scanLength = h;
            }
        }
        currPos = startPos + destY * scanLength + destX;
        return currPos;
    }

    public final int getSpriteH(int sprite) {
        int desArray = 1;
        return this.getUnsignedIntValueFromShortArray(this.spritesDimension, (sprite << desArray) + 1);
    }

    private int getUnsignedIntValueFromShortArray(short[] array, int offset) {
        return 0xFFFF & array[offset];
    }

    static final int toIntRGBA(byte[] data, int start) {
        return (0xF0 & data[start]) * 17 << 20 | (0xF & data[start]) * 17 << 16 | (0xF0 & data[start + 1]) * 17 << 4 | (0xF & data[start + 1]) * 17;
    }

    public void init_SpritePosInCache_Array() {
        int numSprites = this.spritePosInCache.length;
        int i = 0;
        while (i < numSprites) {
            this.spritePosInCache[i] = -1;
            this.spriteFlipPosInCache[i] = -1;
            this.spriteTransInCache[i] = -1;
            ++i;
        }
        this.lastPositionBuffer = 0;
    }

    static short byteArrayToShort(byte[] byteArray) throws IOException {
        ByteArrayInputStream bos = new ByteArrayInputStream(byteArray);
        DataInputStream dos = new DataInputStream(bos);
        return dos.readShort();
    }

    public void setClipped(boolean clipActivated) {
        this.clipActivated = clipActivated;
    }

    public void arraycopy(int color, int[] dst, int dst_position, int length) {
        switch (length) {
            case 1: {
                dst[dst_position] = color;
                break;
            }
            case 2: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                break;
            }
            case 3: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                break;
            }
            case 4: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                break;
            }
            case 5: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                break;
            }
            case 6: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                break;
            }
            case 7: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                break;
            }
            case 8: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                break;
            }
            case 9: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                break;
            }
            case 10: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                break;
            }
            case 11: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                break;
            }
            case 12: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                break;
            }
            case 13: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                break;
            }
            case 14: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                break;
            }
            case 15: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                break;
            }
            case 16: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                dst[dst_position + 15] = color;
                break;
            }
            default: {
                this.arraycopy(color, dst, dst_position, 16);
                this.arraycopy(color, dst, dst_position + 16, length - 16);
            }
        }
    }

    public void resetTimers() {
        this.cacheUnfoldTime = 0L;
        this.intermediateBufferTime = 0L;
        this.imagePaintTime = 0L;
        this.elapsedFrameTime = 0L;
    }

    public boolean includeColBox() {
        return (this.reserved & 1) != 0;
    }

    public boolean includeAttBox() {
        return (this.reserved & 2) != 0;
    }
}

