/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.ui;

import javax.microedition.lcdui.Graphics;
import zed.rollNRun.helper.util.PWAnimPlayer;
import zed.rollNRun.helper.util.PWScreenToolbox;
import zed.rollNRun.helper.util.StringOperate;
import zed.rollNRun.helper.util.ZedAnimation;

public class ZedAnimAJO {
    private ZedAnimation animObj;
    private PWAnimPlayer animPlay;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private byte animationIndx;
    private boolean visibility;
    private boolean collision;

    public ZedAnimAJO(String src, int x, int y, boolean visib) {
        this.animObj = new ZedAnimation(StringOperate.loadRes(src), -1, true);
        this.animPlay = new PWAnimPlayer(this.animObj);
        PWScreenToolbox.get().cleanCache(src);
        this.width = this.animObj.getSpriteW(0);
        this.height = this.animObj.getSpriteH(0);
        this.animationIndx = 0;
        this.visibility = visib;
        this.collision = false;
        this.setPosX(x);
        this.setPosY(y);
    }

    public ZedAnimAJO(String src, int x, int y, boolean visib, byte type) {
        this.animObj = new ZedAnimation(StringOperate.loadRes(src), -1, true);
        this.animPlay = new PWAnimPlayer(this.animObj);
        PWScreenToolbox.get().cleanCache(src);
        this.width = this.animObj.getSpriteW(0);
        this.height = this.animObj.getSpriteH(0);
        this.animationIndx = 0;
        this.visibility = visib;
        this.collision = false;
        this.setSpritePosX(x, type);
        this.setSpritePosY(y, type);
    }

    public void draw(Graphics g, byte animInd, int x, int y, boolean cyclical, boolean drawAnim) {
        if (this.visibility && this.animObj != null) {
            if (drawAnim) {
                this.animationIndx = (byte)Math.abs(this.animPlay.drawAnimation(g, animInd, System.currentTimeMillis(), this.posX, this.posY, 0, cyclical));
            } else {
                this.animationIndx = animInd;
                this.animObj.drawFrame(g, animInd, x, y, 0);
            }
        }
    }

    public void draw(Graphics g, byte animInd, int x, int y, boolean cyclical, boolean drawAnim, byte transform) {
        if (this.visibility && this.animObj != null) {
            if (drawAnim) {
                this.animationIndx = (byte)Math.abs(this.animPlay.drawAnimation(g, animInd, System.currentTimeMillis(), x, y, transform, cyclical));
            } else {
                this.animationIndx = animInd;
                this.animObj.drawFrame(g, animInd, x, y, transform);
            }
        }
    }

    public void drawImg(Graphics g, byte ImgInd, int x, int y) {
        if (this.visibility && this.animObj != null) {
            this.animObj.drawSprite(g, ImgInd, x, y, 0);
        }
    }

    public byte getFrameIndex() {
        return this.animationIndx;
    }

    public byte getTotalNumFrame(byte id) {
        return (byte)this.animObj.getFrameNum(id);
    }

    public boolean getAnimStatus() {
        return this.animPlay.isFinish();
    }

    public void resetAnim() {
        this.animPlay.resetAnim();
    }

    public boolean getVisibility() {
        return this.visibility;
    }

    public void setVisibility(boolean visib) {
        this.visibility = visib;
    }

    public void setPosX(int x) {
        this.posX = x;
    }

    public void setPosY(int y) {
        this.posY = y;
    }

    public void setSpritePosX(int x, byte idx) {
        this.posX = x;
    }

    public void setSpritePosY(int y, byte idx) {
        this.posY = y;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFrameWidth() {
        return this.animObj.getFrameWidth(this.animationIndx);
    }

    public int getFrameIndxWidth(byte frame) {
        return this.animObj.getFrameWidth(frame);
    }

    public int getSpriteIndxWidth(byte frame) {
        return this.animObj.getSpriteW(frame);
    }

    public int getSpriteIndxHeight(byte frame) {
        return this.animObj.getSpriteH(frame);
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameHeight() {
        return this.animObj.getFrameHeight(this.animationIndx);
    }

    public int getFrameIndxHeight(byte frame) {
        return this.animObj.getFrameHeight(frame);
    }

    public boolean isCollided(ZedAnimAJO collider, byte distance) {
        int w = collider.getFrameWidth();
        int h = collider.getFrameHeight();
        this.collision = this.checkCollision(collider.getPosX(), collider.getPosY(), w, h, distance);
        return this.collision;
    }

    public boolean checkCollision(int x, int y, int w, int h, byte distance) {
        return Math.abs(this.getPosX() - x) <= w / 2 + this.getFrameWidth() / 2 - (w / 2 + this.getFrameWidth() / 2) / 4 && Math.abs(this.getPosY() - y) <= h / 2 + this.getFrameHeight() / 2 - (h / 2 + this.getFrameHeight() / 2) / 2;
    }

    public void move(int mx, int my) {
        this.posX = this.getPosX() + mx;
        this.posY = this.getPosY() + my;
    }
}

