/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import zed.rollNRun.helper.util.StringOperate;

public class PWAdvancedKeyboard {
    public static final long TIME_REPEAT_KEY = 1000L;
    public static final char LEFT_SOFT_KEY = '\u0000';
    public static final char RIGHT_SOFT_KEY = '\u0001';
    public static final char FIRE_BUTTON = '\u0002';
    public static final char LEFT_ARROW = '\u0003';
    public static final char RIGHT_ARROW = '\u0004';
    public static final char UP_ARROW = '\u0005';
    public static final char DOWN_ARROW = '\u0006';
    public static final char ACTION_KEY_LIMIT = '\u0006';
    public static final char NO_KEY = '\b';
    public static final char DELETE = '\t';
    public static final char NO_PRINTABLE_LIMIT = '\n';
    public static final byte EVENT_NOEVENT = -100;
    public static final byte EVENT_KEYPRESSED = 0;
    public static final byte EVENT_KEYRELEASED = 1;
    public static final String EMPTY_CHARSET = "^^^^^^^^^^^";
    public static final String FULL_CHARSET_STRING = " 0^.-?!\\@:;/()1^abc\u00c3\u00a12^def\u00c3\u00a93^ghi\u00c3\u00ad4^jkl5^mno\u00c3\u00b1\u00c3\u00b36^pqrs7^tuv8^wxyz9^*^#";
    public static final String FULL_UPPERCASE_CHARSET_STRING = " 0^.-?!\\@:;/()1^ABC\u00c3\u00a12^DEF\u00c3\u00a93^GHI\u00c3\u00ad4^JKL5^MNO?\u00c3\u00b36^PQRS7^TUV8^WXYZ9^*^#";
    public static final String EMAIL_UPPERCASE_CHARSET_STRING = "0^.@-_1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9^*^#";
    public static final String REDUCED_CHARSET_STRING = "^^abc^def^ghi^jkl^mno\u00c3\u00b1^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_STRING = "^^abc^def^ghi^jkl^mno^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9";
    public static final String REDUCED_UPPERCASE_CHARSET_STRING = "^^ABC^DEF^GHI^JKL^MNO\u00c3\u2018^PQRS^TUV^WXYZ^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO\u00c3\u20186^PQRS7^TUV8^WXYZ9^*^#";
    public static final String NUMBERS_CHARSET_STRING = "0^1^2^3^4^5^6^7^8^9^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^abc2^def3^ghi4^jkl5^mno6^pqrs7^tuv8^wxyz9";
    public static final String NUMBERS_CHARSET = "0123456789*#";
    public byte lastEvent;
    public char lastKey;
    private int multitapLastKey = -1;
    public boolean acceptKeyPressed = true;
    public boolean acceptKeyReleased = true;
    public boolean acceptKeyTyped = true;
    public boolean hasMoreKeys = false;
    public StringBuffer text;
    private char[][] charset;
    private String actualCharset;
    private short pointerRead;
    private short pointerWrite;
    private byte[] evtArray_type;
    private char[] evtArray_key;
    private boolean multitap = false;
    private int maxTextSize = 0;
    private int multitapChar = 0;
    private long multitapLastTime;

    public PWAdvancedKeyboard(String charsetString) {
        this.init(charsetString);
    }

    public void init(String charsetString) {
        this.actualCharset = charsetString;
        char[][] charset = new char[10][];
        String[] pwt = StringOperate.splitString(charsetString, '^');
        int i = 0;
        while (i < charset.length) {
            String key = pwt[i];
            charset[i] = new char[key.length()];
            if (key != null) {
                int j = 0;
                while (j < key.length()) {
                    charset[i][j] = key.charAt(j);
                    ++j;
                }
            } else {
                charset[i] = new char[0];
            }
            ++i;
        }
        this.init(charset, 60);
        this.multitap = false;
        this.multitapChar = 0;
        this.text = null;
    }

    public PWAdvancedKeyboard(String[] charsetString) {
        this.init(charsetString);
    }

    public void init(String[] pwt) {
        char[][] charset = new char[10][];
        int i = 0;
        while (i < charset.length) {
            String key = pwt[i];
            if (key != null) {
                charset[i] = new char[key.length()];
                int j = 0;
                while (j < key.length()) {
                    charset[i][j] = key.charAt(j);
                    ++j;
                }
            } else {
                charset[i] = new char[0];
            }
            ++i;
        }
        this.init(charset, 60);
        this.multitap = false;
        this.multitapChar = 0;
        this.text = null;
    }

    public synchronized void removeAlEvents() {
        this.pointerRead = this.pointerWrite;
        this.hasMoreKeys = false;
    }

    private void init(char[][] charset, int bufferSize) {
        this.charset = charset;
        this.pointerWrite = 0;
        this.pointerRead = 0;
        this.evtArray_type = new byte[bufferSize];
        this.evtArray_key = new char[bufferSize];
        this.hasMoreKeys = false;
    }

    public char nextChar() {
        if (!this.hasMoreKeys) {
            return '\b';
        }
        this.lastEvent = this.evtArray_type[this.pointerRead];
        this.lastKey = this.evtArray_key[this.pointerRead];
        this.elementReaded();
        return this.lastKey;
    }

    public synchronized void keyPressed(int keyCode) {
        if (!this.acceptKeyPressed) {
            return;
        }
        if (this.multitap) {
            this.addMultitap((byte)0, keyCode);
        } else {
            int keyNumber = this.getNumericKeyNumberForKeycode(keyCode);
            if (keyNumber != -1) {
                this.add((byte)0, NUMBERS_CHARSET.charAt(keyNumber));
            } else {
                char action = PWAdvancedKeyboard.getActionByKeycode(keyCode);
                if (action != '\b') {
                    this.add((byte)0, action);
                }
            }
        }
    }

    public synchronized void keyReleased(int keyCode) {
        if (!this.acceptKeyReleased | this.multitap) {
            return;
        }
        int keyNumber = this.getNumericKeyNumberForKeycode(keyCode);
        if (keyNumber != -1) {
            this.add((byte)1, NUMBERS_CHARSET.charAt(keyNumber));
        } else {
            char action = PWAdvancedKeyboard.getActionByKeycode(keyCode);
            if (action != '\b') {
                this.add((byte)1, action);
            }
        }
    }

    private synchronized void addMultitap(byte event, int keycode) {
        int keyNumber = this.getNumericKeyNumberForKeycode(keycode);
        if (keyNumber != -1) {
            this.addMultitapKey(keyNumber);
        } else {
            char action = PWAdvancedKeyboard.getActionByKeycode(keycode);
            if (action != '\b') {
                this.add((byte)0, action);
            }
        }
    }

    private void addMultitapKey(int keyPressed) {
        long time = System.currentTimeMillis();
        if (keyPressed >= 0 && keyPressed < this.charset.length && this.charset[keyPressed].length > 0) {
            if (keyPressed == this.multitapLastKey && this.multitapLastTime + 1000L > time && this.charset[keyPressed].length > 1) {
                this.multitapDeleteLastChar();
                this.multitapChar = (this.multitapChar + 1) % this.charset[keyPressed].length;
            } else {
                this.multitapChar = 0;
                if (this.text.length() >= this.maxTextSize) {
                    this.text.deleteCharAt(this.maxTextSize - 1);
                }
            }
            this.text.append(this.charset[keyPressed][this.multitapChar]);
            this.multitapLastTime = time;
            this.multitapLastKey = keyPressed;
        }
    }

    private int getNumericKeyNumberForKeycode(int keycode) {
        switch (keycode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
        }
        return -1;
    }

    public void multitapDeleteLastChar() {
        if (this.text.length() > 0) {
            this.text.deleteCharAt(this.text.length() - 1);
        }
    }

    public void multitapDeleteAllChars() {
        this.text = new StringBuffer();
    }

    public void add(byte event, char key) {
        this.evtArray_type[this.pointerWrite] = event;
        this.evtArray_key[this.pointerWrite] = key;
        this.pointerWrite = (short)(this.pointerWrite + 1);
        if (this.pointerWrite == this.evtArray_key.length) {
            this.pointerWrite = 0;
        }
        this.hasMoreKeys = true;
    }

    private void elementReaded() {
        this.pointerRead = (short)(this.pointerRead + 1);
        if (this.pointerRead == this.evtArray_key.length) {
            this.pointerRead = 0;
        }
        this.hasMoreKeys = this.pointerRead != this.pointerWrite;
    }

    public void setMultitap(boolean flag, int maxTextSize) {
        this.multitap = flag;
        this.maxTextSize = maxTextSize;
        if (this.multitap) {
            this.text = new StringBuffer();
        }
    }

    public static char getActionByKeycode(int keycode) {
        switch (keycode) {
            case -7: {
                return '\u0000';
            }
            case -6: {
                return '\u0001';
            }
            case -5: {
                return '\u0002';
            }
            case -3: {
                return '\u0003';
            }
            case -4: {
                return '\u0004';
            }
            case -1: {
                return '\u0005';
            }
            case -2: {
                return '\u0006';
            }
            case -8: {
                return '\t';
            }
        }
        return '\b';
    }
}

