/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import zed.rollNRun.ui.MainCanvas;

public class PWRecordStore {
    public static String alias = "";
    public static String aliasToBeCreated = "";
    public static String password = "";
    public static long firstExecutionTimeStamp = 0L;
    static final int XTEA_DELTA = -1640531527;
    static int[] xteaKey = new int[]{1264675176, 1635021685, 543255413, 1936225653};

    public static void saveUserDataRS() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            ((OutputStream)dos).write(PWRecordStore.saveString(alias));
            ((OutputStream)dos).write(PWRecordStore.saveString(password));
            dos.writeLong(firstExecutionTimeStamp);
            dos.writeByte(MainCanvas.langId);
            ((OutputStream)dos).write(PWRecordStore.saveString(MainCanvas.unlockedChar.toString()));
            ((OutputStream)dos).write(PWRecordStore.saveString(MainCanvas.unlockedWorld.toString()));
            dos.writeByte(MainCanvas.selChar);
            dos.writeByte(MainCanvas.selWorld);
            dos.writeBoolean(MainCanvas.firsttime);
            dos.writeInt(MainCanvas.distance);
            dos.writeInt(MainCanvas.coins);
            PWRecordStore.store("udrol", baos);
            dos.close();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadUserDataRS() {
        try {
            DataInputStream dis = PWRecordStore.load("udrol");
            if (dis != null) {
                alias = PWRecordStore.readString(dis);
                password = PWRecordStore.readString(dis);
                firstExecutionTimeStamp = dis.readLong();
                MainCanvas.langId = dis.readByte();
                MainCanvas.unlockedChar = new StringBuffer(PWRecordStore.readString(dis));
                MainCanvas.unlockedWorld = new StringBuffer(PWRecordStore.readString(dis));
                MainCanvas.selChar = dis.readByte();
                MainCanvas.selWorld = dis.readByte();
                MainCanvas.firsttime = dis.readBoolean();
                MainCanvas.distance = dis.readInt();
                MainCanvas.coins = dis.readInt();
            } else {
                alias = "";
                password = "";
                firstExecutionTimeStamp = System.currentTimeMillis();
                MainCanvas.langId = (byte)-1;
                PWRecordStore.saveUserDataRS();
            }
        }
        catch (Exception e) {
            alias = "";
            password = "";
            firstExecutionTimeStamp = System.currentTimeMillis();
            MainCanvas.langId = (byte)-1;
            PWRecordStore.saveUserDataRS();
        }
    }

    public static void deleteRecordStore(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            RecordStore.deleteRecordStore((String)recordStoreName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void store(String recordStoreName, ByteArrayOutputStream baos) {
        PWRecordStore.store(recordStoreName, baos.toByteArray());
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void store(String recordStoreName, byte[] data) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            byte[] b = PWRecordStore.xteaEncrypt(data);
            db.addRecord(b, 0, b.length);
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataInputStream load(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(PWRecordStore.xteaDecrypt(re.nextRecord()));
            DataInputStream dis = new DataInputStream(bais);
            db.closeRecordStore();
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String readString(ByteArrayInputStream bais) {
        String aux = null;
        try {
            DataInputStream dis = new DataInputStream(bais);
            aux = PWRecordStore.readString(dis);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aux;
    }

    public static String readString(DataInputStream dis) {
        try {
            int lenght = dis.readByte();
            if (lenght > 0) {
                byte[] bAux = new byte[lenght];
                int i = 0;
                while (i < lenght) {
                    bAux[i] = dis.readByte();
                    ++i;
                }
                return new String(bAux);
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static byte[] saveString(String str) {
        byte[] tmp;
        if (str == null) {
            str = "";
        }
        try {
            tmp = str.getBytes("UTF-8");
        }
        catch (Exception e) {
            tmp = str.getBytes();
        }
        byte[] bAux = new byte[tmp.length + 1];
        bAux[0] = (byte)tmp.length;
        int i = 0;
        while (i < tmp.length) {
            bAux[i + 1] = tmp[i];
            ++i;
        }
        return bAux;
    }

    public static final byte[] xteaEncrypt(byte[] in) {
        int blocks = in.length / 8;
        int rest = in.length % 8;
        if (rest > 0) {
            ++blocks;
        }
        byte[] source = new byte[blocks * 8];
        byte[] result = new byte[source.length];
        System.arraycopy(in, 0, source, 0, in.length);
        int i = 0;
        while (i < blocks) {
            System.arraycopy(PWRecordStore.engineCrypt(source, i * 8, false), 0, result, i * 8, 8);
            ++i;
        }
        return result;
    }

    static final byte[] engineCrypt(byte[] source, int offset, boolean decrypt) {
        int v0 = source[offset++] & 0xFF | (source[offset++] & 0xFF) << 8 | (source[offset++] & 0xFF) << 16 | source[offset++] << 24;
        int v1 = source[offset++] & 0xFF | (source[offset++] & 0xFF) << 8 | (source[offset++] & 0xFF) << 16 | source[offset++] << 24;
        int n = 32;
        if (!decrypt) {
            int sum = 0;
            while (n-- > 0) {
                v1 += ((v0 += (v1 << 4 ^ v1 >> 5) + v1 ^ sum + xteaKey[sum & 3]) << 4 ^ v0 >> 5) + v0 ^ (sum += -1640531527) + xteaKey[sum >> 11 & 3];
            }
        } else {
            int sum = -957401312;
            while (n-- > 0) {
                v0 -= ((v1 -= (v0 << 4 ^ v0 >> 5) + v0 ^ sum + xteaKey[sum >> 11 & 3]) << 4 ^ v1 >> 5) + v1 ^ (sum -= -1640531527) + xteaKey[sum & 3];
            }
        }
        byte[] result = new byte[8];
        int desp = 0;
        result[desp++] = (byte)v0;
        result[desp++] = (byte)(v0 >>> 8);
        result[desp++] = (byte)(v0 >>> 16);
        result[desp++] = (byte)(v0 >>> 24);
        result[desp++] = (byte)v1;
        result[desp++] = (byte)(v1 >>> 8);
        result[desp++] = (byte)(v1 >>> 16);
        result[desp++] = (byte)(v1 >>> 24);
        return result;
    }

    public static byte[] xteaDecrypt(byte[] in) {
        byte[] result = new byte[in.length];
        int blocks = in.length / 8;
        int i = 0;
        while (i < blocks) {
            System.arraycopy(PWRecordStore.engineCrypt(in, i * 8, true), 0, result, i * 8, 8);
            ++i;
        }
        return result;
    }

    public static final String byteArrayToHexString(byte[] b, boolean spaced) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
            if (spaced) {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString().toUpperCase();
    }
}

