/*
 * Decompiled with CFR 0.152.
 */
package zed.rollNRun.helper.util;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import zed.rollNRun.helper.ZEDConstants;

public class PWSoundBox
implements PlayerListener {
    public static PWSoundBox mObjSoundBox;
    Player player;
    public static byte soundIndex;
    public String soundStatus = "";

    static {
        soundIndex = (byte)-1;
    }

    public static PWSoundBox getInstance() {
        if (mObjSoundBox == null) {
            mObjSoundBox = new PWSoundBox();
        }
        return mObjSoundBox;
    }

    public void loadSound(byte _index) {
        try {
            InputStream bis = "".getClass().getResourceAsStream("/" + ZEDConstants.Sound.SOUND_URL[_index]);
            if (bis != null) {
                VolumeControl vc;
                if (ZEDConstants.Sound.SOUND_EXT[_index] == 0) {
                    this.player = Manager.createPlayer((InputStream)bis, (String)"audio/midi");
                }
                if (ZEDConstants.Sound.SOUND_EXT[_index] == 1) {
                    this.player = Manager.createPlayer((InputStream)bis, (String)"audio/x-wav");
                }
                if (ZEDConstants.Sound.SOUND_EXT[_index] == 2) {
                    this.player = Manager.createPlayer((InputStream)bis, (String)"audio/amr");
                }
                if (ZEDConstants.Sound.SOUND_EXT[_index] == 3) {
                    this.player = Manager.createPlayer((InputStream)bis, (String)"audio/mpeg");
                }
                if ((vc = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
                    vc.setLevel(100);
                }
                this.player.addPlayerListener((PlayerListener)this);
                if (this.player != null) {
                    this.player.realize();
                    this.player.prefetch();
                    this.player.setMediaTime(0L);
                }
                Thread.sleep(5L);
                Thread.yield();
                System.out.println("loaded : " + ZEDConstants.Sound.SOUND_URL[_index]);
                bis.close();
                bis = null;
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught in loadSound while loading " + ZEDConstants.Sound.SOUND_URL[_index] + " sound : " + e);
        }
    }

    public void play(final byte _index) {
        soundIndex = _index;
        new Thread(new Runnable(){

            public void run() {
                try {
                    if (PWSoundBox.this.player == null) {
                        PWSoundBox.this.loadSound(_index);
                    }
                    if (PWSoundBox.this.player != null) {
                        if (PWSoundBox.this.player.getState() == 400) {
                            return;
                        }
                        if (_index == 0 || _index == 7) {
                            PWSoundBox.this.player.setLoopCount(-1);
                        }
                        PWSoundBox.this.player.start();
                    } else {
                        System.out.println("Problem while loading sound!!");
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception while playing sound in play() : " + e);
                }
            }
        }).start();
    }

    public boolean checkPlayerStatus() {
        boolean status = false;
        if (this.player != null && this.player.getState() == 400) {
            status = true;
        }
        return status;
    }

    public void resume(byte _index) {
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.getState() == 300) {
                this.player.start();
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught in resume() : " + e);
        }
    }

    public void pause(byte _index) {
        soundIndex = (byte)-1;
        if (this.player == null) {
            return;
        }
        try {
            if (this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught in pause() : " + e);
        }
    }

    public void stop(byte _index) {
        this.unloadSound();
    }

    public void stopAll() {
        this.unloadSound();
    }

    public void unloadSound() {
        if (this.player == null) {
            return;
        }
        try {
            switch (this.player.getState()) {
                case 400: {
                    this.player.stop();
                }
                case 200: {
                    this.player.deallocate();
                }
            }
            this.player.close();
            this.player = null;
        }
        catch (Exception e) {
            System.out.println("Exception caught in unloadSound() " + e);
        }
    }

    public void playerUpdate(Player arg0, String arg1, Object arg2) {
    }
}

