/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import modules.Gfx;
import modules.GfxEnums;
import modules.Lib;
import modules.Timer;

public class Anim {
    private static String animPath;
    private static String[] animImageFilenames;
    private static Image[] animImages;
    private static short[][][] animData;
    private static short[] animTypes;
    private static short[] animFrameCounter;
    private static short[] animLoopCounter;
    private static int[] animTimeStart;
    private static short[] animTimePerFrame;
    private static final short ANIM_TIME_NOTSTARTED = -1;
    private static final short ANIM_TIME_DEFAULT_FRAMETIME = 0;
    private static boolean[] animPausedSet;
    private static short[] animLevelPause;
    private static long[] animPauseTime;
    private static final short ANIM_MAX = 600;
    private static final short ANIM_LOOP_INFINITE = -1;
    private static final short ANIM_FIRST_FRAME = 0;
    private static final short animNumFrames = 7;
    private static short[] animEvent;
    static short[] animClipRectangle;
    private static boolean[] animRepaintLastFrame;
    public static final short ANIM_OPTION_LOOP_INFINITE = -1;
    public static final short ANIM_OPTION_REPAINT_LAST_FRAME = -2;
    private static final short ANIM_READY = 0;
    private static final short ANIM_SET = 1;
    private static final short ANIM_END = 2;
    static String imageFileName;
    private static int _animCurrentTime;
    private static int _animClipX;
    private static int _animClipY;
    private static int _animClipW;
    private static int _animClipH;
    private static short _animFrameOffsetX;
    private static short _animFrameOffsetY;
    private static short[] _animFrameData;
    private static int _anim_i;
    private static int _anim_i2;
    public static short[][] animDesignData;
    public static final int ANIM_DESIGN_GROUP = 0;
    public static final int ANIM_DESIGN_ANIM = 1;
    public static final int ANIM_DESIGN_FRAME = 2;
    public static final int ANIM_DESIGN_POSX = 3;
    public static final int ANIM_DESIGN_POSY = 4;
    public static final int ANIM_DESIGN_WIDTH = 5;
    public static final int ANIM_DESIGN_HEIGHT = 6;
    private static short[] animDesign;
    private static short animDesignGroup;
    private static int animEnd;
    private static final int ANIM_DESIGN_DATA_MAX = 7;
    public static final int ANIM_WIDTH = 3;
    public static final int ANIM_HEIGHT = 4;
    private static short animDesignAnimCount;
    private static boolean _animIsIdx;
    private static short _animDesignCont;
    private static int _animDesignResul;

    public static void animLoadImage(int n) {
        for (int i = 0; i < animData[n].length; ++i) {
            if (animData[n][i][0] == -1 || animImages[animData[n][i][0]] != null) continue;
            try {
                imageFileName = animImageFilenames[animData[n][i][0]].substring(0, 4).compareTo("null") == 0 ? "null.png" : animImageFilenames[animData[n][i][0]];
                Anim.animImages[Anim.animData[n][i][0]] = Image.createImage((String)(animPath + imageFileName));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void animUnloadImage(int n) {
        for (int i = 0; i < animData[n].length; ++i) {
            if (animData[n][i][0] == -1 || animImages[animData[n][i][0]] == null) continue;
            try {
                if (animImageFilenames[animData[n][i][0]].substring(0, 4).compareTo("null") == 0) continue;
                Anim.animImages[Anim.animData[n][i][0]] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void animInit(String string) throws Exception {
        Anim._animInit(string, 600);
    }

    public static void animInit(String string, int n) throws Exception {
        Anim._animInit(string, n);
    }

    private static void _animInit(String string, int n) throws Exception {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
        animTypes = new short[n];
        animFrameCounter = new short[n];
        animLoopCounter = new short[n];
        animEvent = new short[n];
        animRepaintLastFrame = new boolean[n];
        for (n2 = 0; n2 < animFrameCounter.length; n2 = (int)((short)(n2 + 1))) {
            Anim.animTypes[n2] = n2;
            Anim.animFrameCounter[n2] = 0;
            Anim.animLoopCounter[n2] = -1;
        }
        animPath = dataInputStream.readUTF();
        short s = dataInputStream.readShort();
        animImageFilenames = new String[s];
        animImages = new Image[s];
        for (n2 = 0; n2 < animImageFilenames.length; ++n2) {
            Anim.animImageFilenames[n2] = dataInputStream.readUTF();
        }
        s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        animData = new short[s2][][];
        for (n2 = 0; n2 < animData.length; ++n2) {
            s = dataInputStream.readShort();
            Anim.animData[n2] = new short[s][7];
            for (int i = 0; i < animData[n2].length; ++i) {
                for (int j = 0; j < 7; ++j) {
                    Anim.animData[n2][i][j] = dataInputStream.readShort();
                }
            }
        }
        dataInputStream.close();
        animTimePerFrame = new short[600];
        animTimeStart = new int[600];
        for (n2 = 0; n2 < animTimePerFrame.length; ++n2) {
            Anim.animTimePerFrame[n2] = 0;
            Anim.animTimeStart[n2] = -1;
        }
        animPausedSet = new boolean[600];
        animLevelPause = new short[600];
    }

    public static void animImageReset(String string, String string2) {
        for (int i = 0; i < animImageFilenames.length; ++i) {
            if (animImageFilenames[i].compareTo(string) != 0) continue;
            Anim.animImageFilenames[i] = string2;
            try {
                Anim.animImages[i] = Image.createImage((String)(animPath + animImageFilenames[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void animCreate(int n, int n2, int n3) {
        Anim.animCreate(n, n2, n3, 0);
    }

    public static void animCreate(int n, int n2, int n3, int n4) {
        Anim.animTypes[n] = (short)n2;
        Anim.animTimePerFrame[n] = (short)n4;
        Anim.animReset(n, n3);
    }

    public static void animReset(int n, int n2) {
        Anim.animFrameCounter[n] = 0;
        if (n2 == -2) {
            Anim.animLoopCounter[n] = 1;
            Anim.animRepaintLastFrame[n] = true;
        } else {
            Anim.animLoopCounter[n] = (short)n2;
            Anim.animRepaintLastFrame[n] = false;
        }
        Anim.animTimeStart[n] = -1;
        Anim.animPausedSet[n] = false;
        Lib.events[Anim.animEvent[n]] = 0;
    }

    public static void animSetFrameTime(short s, short s2) {
        Anim.animTimePerFrame[s] = s2;
    }

    public static void animDraw(Graphics graphics, int n, int n2) {
        Anim.animDraw(graphics, n, animDesignData[n2][3], animDesignData[n2][4]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean animDraw(Graphics graphics, int n, int n2, int n3) {
        if (animPausedSet[n]) {
            return true;
        }
        Lib.events[Anim.animEvent[n]] = 1;
        if (animFrameCounter[n] >= animData[animTypes[n]].length) {
            Anim.animFrameCounter[n] = 0;
            if (animLoopCounter[n] > 0) {
                int n4 = n;
                animLoopCounter[n4] = (short)(animLoopCounter[n4] - 1);
            }
            if (animLoopCounter[n] == 0) {
                Anim.animTimeStart[n] = -1;
                if (animEvent[n] != 0) {
                    Lib.events[Anim.animEvent[n]] = 2;
                }
                if (!animRepaintLastFrame[n]) return false;
                Anim.animFrameCounter[n] = (short)(animData[animTypes[n]].length - 1);
            }
        } else if (animLoopCounter[n] == 0) {
            Anim.animTimeStart[n] = -1;
            if (!animRepaintLastFrame[n]) return false;
            Anim.animFrameCounter[n] = (short)(animData[animTypes[n]].length - 1);
        }
        Anim.animDrawFrame(graphics, n, animFrameCounter[n], n2, n3);
        _animCurrentTime = (int)(Timer.timer_GlobalTimer % Integer.MAX_VALUE);
        if (animTimeStart[n] == -1) {
            Anim.animTimeStart[n] = _animCurrentTime;
        }
        if (animTimeStart[n] > _animCurrentTime) {
            int n5 = n;
            animTimeStart[n5] = animTimeStart[n5] + Integer.MAX_VALUE;
        }
        if (_animCurrentTime - animTimeStart[n] < animTimePerFrame[n]) return true;
        Anim.animTimeStart[n] = _animCurrentTime;
        int n6 = n;
        animFrameCounter[n6] = (short)(animFrameCounter[n6] + 1);
        return true;
    }

    public static boolean animTerminate(int n) {
        return animLoopCounter[n] == 0;
    }

    public static void animDrawFrame(Graphics graphics, int n, int n2, int n3) {
        Anim.animDrawFrame(graphics, n, n2, animDesignData[n3][3], animDesignData[n3][4]);
    }

    public static void animDrawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        _animClipX = graphics.getClipX();
        _animClipY = graphics.getClipY();
        _animClipW = graphics.getClipWidth();
        _animClipH = graphics.getClipHeight();
        _animFrameData = animData[animTypes[n]][n2];
        _animFrameOffsetX = _animFrameData[5];
        _animFrameOffsetY = _animFrameData[6];
        Gfx.gfxClip(graphics, n3 + _animFrameOffsetX, n4 + _animFrameOffsetY, _animFrameData[3], _animFrameData[4]);
        if (animClipRectangle != null) {
            Gfx.gfxClipRect(graphics, animClipRectangle[0], animClipRectangle[1], animClipRectangle[2], animClipRectangle[3]);
        }
        graphics.drawImage(animImages[_animFrameData[0]], n3 - _animFrameData[1] + _animFrameOffsetX, n4 - _animFrameData[2] + _animFrameOffsetY, 0);
        Gfx.gfxClip(graphics, _animClipX, _animClipY, _animClipW, _animClipH);
    }

    public static void animDrawFrameNoClip(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(animImages[animData[animTypes[n]][n2][0]], n3, n4, 0);
    }

    public static void animSetClipRectangle(short s, short s2, short s3, short s4) {
        animClipRectangle = new short[4];
        Anim.animClipRectangle[0] = s;
        Anim.animClipRectangle[1] = s2;
        Anim.animClipRectangle[2] = s3;
        Anim.animClipRectangle[3] = s4;
    }

    public static void animSetClipRectangle(int n) {
        animClipRectangle = new short[4];
        Anim.animClipRectangle[0] = animDesignData[n][3];
        Anim.animClipRectangle[1] = animDesignData[n][4];
        Anim.animClipRectangle[2] = animDesignData[n][5];
        Anim.animClipRectangle[3] = animDesignData[n][6];
    }

    public static void animSetClipRectangle(short[] sArray) {
        animClipRectangle = sArray;
    }

    public static Image animGetImage(int n, int n2) {
        return animImages[animData[n][n2][0]];
    }

    public static short[] animGetData(int n, int n2) {
        return animData[animTypes[n]][animFrameCounter[n2]];
    }

    public static int animGetFrameWidth(int n, int n2) {
        _animFrameData = animData[animTypes[n]][n2];
        return _animFrameData[3];
    }

    public static int animGetFrameHeight(int n, int n2) {
        _animFrameData = animData[animTypes[n]][n2];
        return _animFrameData[4];
    }

    public static void animSetNoPause(int n) {
        Anim.animLevelPause[n] = -1;
    }

    static void animPause(short s) {
        Anim.animPauseTime[s] = Timer.timer_GlobalTimer;
        for (_anim_i = 0; _anim_i < animTimeStart.length; ++_anim_i) {
            if (animPausedSet[_anim_i] || animTimeStart[_anim_i] == -1 || animLevelPause[_anim_i] == -1) continue;
            Anim.animPausedSet[Anim._anim_i] = true;
            Anim.animLevelPause[Anim._anim_i] = s;
        }
    }

    static void animResume(short s) {
        Anim.animPauseTime[s] = Timer.timer_GlobalTimer - animPauseTime[s];
        for (_anim_i2 = 0; _anim_i2 < animTimeStart.length; ++_anim_i2) {
            if (!animPausedSet[_anim_i2] || animLevelPause[_anim_i2] != s) continue;
            int n = _anim_i2;
            animTimeStart[n] = (int)((long)animTimeStart[n] + animPauseTime[s] % Integer.MAX_VALUE);
            Anim.animPausedSet[Anim._anim_i2] = false;
            Anim.animLevelPause[Anim._anim_i2] = 0;
        }
    }

    public static boolean animInPause(int n) {
        return animPausedSet[n];
    }

    public static void animFinished(int n) {
        Anim.animTimeStart[n] = -1;
    }

    public static void animDesignInit(int n) {
        Anim._animDesignInit(n, 600);
    }

    public static void animDesignInit(int n, int n2) {
        Anim._animDesignInit(n, n2);
    }

    private static void _animDesignInit(int n, int n2) {
        try {
            int n3;
            animEnd = n;
            Anim._animInit("/anim.bin", n2);
            String string = "/design.bin";
            DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
            animDesignAnimCount = dataInputStream.readShort();
            int n4 = dataInputStream.readShort() + dataInputStream.readShort();
            animDesign = new short[n4];
            animDesignData = new short[animDesignAnimCount][7];
            int n5 = 0;
            for (n3 = 0; n3 < animDesignAnimCount; n3 = (int)((short)(n3 + 1))) {
                for (int n6 = 0; n6 < 7; n6 = (int)((short)(n6 + 1))) {
                    Anim.animDesignData[n3][n6] = dataInputStream.readShort();
                }
                if (animDesignData[n3][1] == -1) continue;
                Anim.animDesign[n5] = n3;
                Anim.animCreate(n5 + animEnd, animDesignData[n3][1], 1);
                n5 = (short)(n5 + 1);
            }
            for (n3 = 0; n3 < animDesignAnimCount; ++n3) {
                GfxEnums.gfxEnumsBounds(n3, Lib.SCREEN_WIDTH, Lib.SCREEN_HEIGHT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void animDesignLoadImage(int n) {
        try {
            animDesignGroup = animDesignData[n][0];
            do {
                if (animDesignData[n][1] == -1) continue;
                Anim.animLoadImage(animDesignData[n][1]);
            } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void animDesignUnloadImage(int n) {
        try {
            animDesignGroup = animDesignData[n][0];
            do {
                if (animDesignData[n][1] == -1) continue;
                Anim.animUnloadImage(animDesignData[n][1]);
            } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void animDesignReset(int n, int n2) {
        try {
            animDesignGroup = animDesignData[n][0];
            do {
                Anim.animReset(Anim.animDesignIndexAnim(n), n2);
            } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean animDesignTerminate(int n) {
        return Anim.animTerminate(Anim.animDesignIndexAnim(n));
    }

    public static boolean animDesignDraw(Graphics graphics, int n) {
        return Anim.animDesignDrawOffset(graphics, n, 0, 0);
    }

    public static boolean animDesignDrawOffset(Graphics graphics, int n, int n2, int n3) {
        animDesignGroup = animDesignData[n][0];
        do {
            if (animDesignData[n][1] == -1) continue;
            if (animDesignData[n][2] != -1) {
                Anim.animDrawFrame(graphics, Anim.animDesignIndexAnim(n), animDesignData[n][2], animDesignData[n][3] + n2, animDesignData[n][4] + n3);
                continue;
            }
            Anim.animDraw(graphics, Anim.animDesignIndexAnim(n), animDesignData[n][3] + n2, animDesignData[n][4] + n3);
        } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
        return true;
    }

    public static boolean animDesignDrawPosAbs(Graphics graphics, int n, int n2, int n3) {
        animDesignGroup = animDesignData[n][0];
        do {
            if (animDesignData[n][1] == -1) continue;
            if (animDesignData[n][2] != -1) {
                Anim.animDrawFrame(graphics, Anim.animDesignIndexAnim(n), animDesignData[n][2], n2, n3);
                continue;
            }
            Anim.animDraw(graphics, Anim.animDesignIndexAnim(n), n2, n3);
        } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
        return true;
    }

    private static int animDesignIndexAnim(int n) {
        _animIsIdx = false;
        _animDesignCont = 0;
        _animDesignResul = 0;
        while (!_animIsIdx && _animDesignCont < animDesign.length) {
            if (animDesign[_animDesignCont] == n) {
                _animDesignResul = _animDesignCont;
                _animIsIdx = true;
                continue;
            }
            _animDesignCont = (short)(_animDesignCont + 1);
        }
        return _animDesignResul + animEnd;
    }

    public static void animSetEvent(int n, short s) {
        Anim.animEvent[n] = s;
        Lib.events[Anim.animEvent[n]] = 0;
    }

    public static void animDesignSetEvent(int n, short s) {
        Anim.animSetEvent(Anim.animDesignIndexAnim(n), s);
    }

    public static void animDesignSetFrameTime(int n, short s) {
        animDesignGroup = animDesignData[n][0];
        do {
            Anim.animTimePerFrame[Anim.animDesignIndexAnim((int)n)] = s;
        } while (++n < animDesignAnimCount && animDesignData[n][0] != -1 && animDesignData[n][0] == animDesignGroup);
    }

    static {
        animPausedSet = null;
        animLevelPause = null;
        animPauseTime = new long[10];
        imageFileName = "null.png";
        animEnd = 0;
        animDesignAnimCount = 0;
    }
}

