/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.ea.sdk.SDKString;
import modules.Anim;
import modules.Sys;

public class Score {
    private static final int SCORE_CATEGORIES = 5;
    private static final int SCORE_PLAYER_COUNT = 4;
    static int SCORE_WINNER_POINTS = 12;
    static final int[] TIME_CATEGORY_GAME = new int[]{16, 16, 16, 60, 60, 16, 60, 16, 60, 60, 60, 60, 60};
    static final int TIME_GAME_SOCIAL = 60;
    private static int[] scorePlayer;
    private static SDKString[] scoreCategoryLiterals;
    private static int[] scoreCategoryValues;
    private static int[] scoreCategoryPoints;
    private static int scoreMaxLevelTime;
    private static int scoreWinner;
    private static int scoreGuiFvScaleX;
    private static int scoreGuiFvScaleY;
    private static int scoreGuiFvScaleH;
    private static int scoreGuiFvCursorX;
    private static int scoreGuiFvPlayer1PathX;
    private static int scoreGuiFvPlayer2PathX;
    private static int scoreGuiFvPlayer3PathX;
    private static int scoreGuiFvPlayer4PathX;
    private static int scoreGuiFvPlayerPathY;
    private static int scoreGuiFvPlayerPathH;
    private static int scoreGuiMaxLevelTime;
    static int offsetScoreGuiPlayer;

    public static void scoreNew(int n) {
        SCORE_WINNER_POINTS = n;
        scorePlayer = new int[4];
        scoreCategoryValues = new int[5];
        scoreCategoryPoints = new int[5];
        scoreCategoryLiterals = new SDKString[5];
        n = -1;
        Score.scoreGuiNew();
    }

    public static void scoreReset() {
        Score.scorePlayer[0] = 0;
    }

    public static void scoreLevelNew(int n) {
        if (n >= TIME_CATEGORY_GAME.length) {
            n = TIME_CATEGORY_GAME.length - 1;
        }
        scoreMaxLevelTime = TIME_CATEGORY_GAME[n];
        Score.scoreCategoryValuesInit(scoreMaxLevelTime);
        Score.scoreGuiLevelNew(scoreMaxLevelTime);
    }

    public static int scoreGetScoreWinner() {
        return SCORE_WINNER_POINTS;
    }

    public static void scoreAddPoints(int n) {
        Score.scorePlayerIncrement(0, n);
    }

    public static int scoreGetPoints(int n) {
        return scorePlayer[n];
    }

    public static int scoreLevelGetPoints(int n) {
        return scoreCategoryPoints[Score.scoreGetIndex(n)];
    }

    public static SDKString[] scoreLevelGetCategoryLiterals() {
        return scoreCategoryLiterals;
    }

    public static int[] scoreLevelGetCategoryValues() {
        return scoreCategoryValues;
    }

    public static SDKString scoreLevelGetCategory(int n) {
        return scoreCategoryLiterals[Score.scoreGetIndex(n)];
    }

    public static int scoreGetCategoryIndex(int n) {
        return Score.scoreGetIndex(n);
    }

    public static boolean scoreHasWinner() {
        return scoreWinner != -1;
    }

    public static int scoreGetWinner() {
        return SCORE_WINNER_POINTS;
    }

    public static boolean scorePlayerIsWinner() {
        return scorePlayer[0] >= SCORE_WINNER_POINTS;
    }

    static void scorePlayerIncrement(int n, int n2) {
        Score.scorePlayer[n] = scorePlayer[n] + n2;
        if (scorePlayer[n] >= SCORE_WINNER_POINTS && scoreWinner == -1) {
            scoreWinner = n;
        }
    }

    private static int scoreGetIndex(int n) {
        if (n == 0) {
            return 4;
        }
        if (n >= scoreMaxLevelTime) {
            return 0;
        }
        for (int i = 0; i < scoreCategoryValues.length - 1; ++i) {
            if (n > scoreCategoryValues[i] || n <= scoreCategoryValues[i + 1]) continue;
            return i;
        }
        return -1;
    }

    private static void scoreCategoryValuesInit(int n) {
        int n2 = 4;
        for (int i = 0; i < n2; ++i) {
            Score.scoreCategoryValues[i] = (n2 - i) * n / n2;
        }
        Score.scoreCategoryValues[n2] = 0;
    }

    private static void scoreCategoryLiteralsInit() {
        for (int i = 0; i < TIME_CATEGORY_GAME.length; ++i) {
            Score.scoreCategoryPoints[i] = TIME_CATEGORY_GAME.length - i;
        }
    }

    private static void scoreGuiNew() {
        short[] sArray = Anim.animDesignData[333];
        scoreGuiFvCursorX = sArray[3];
        scoreGuiFvScaleX = sArray[3];
        scoreGuiFvScaleY = sArray[4];
        scoreGuiFvScaleH = sArray[6];
        sArray = Anim.animDesignData[392];
        scoreGuiFvPlayerPathY = sArray[4];
        scoreGuiFvPlayerPathH = sArray[6];
    }

    private static void scoreGuiLevelNew(int n) {
        scoreGuiMaxLevelTime = n;
    }

    public static int scoreGuiGetScaleX(int n) {
        return scoreGuiFvScaleX;
    }

    public static int scoreGuiGetScaleY(int n) {
        return Sys.sysInterpolate(scoreGuiMaxLevelTime, 0, scoreGuiFvScaleY, scoreGuiFvScaleY + scoreGuiFvScaleH, n);
    }

    public static int scoreGuiGetCursorX() {
        return scoreGuiFvCursorX;
    }

    public static int scoreGuiGetCursorY(int n) {
        return Score.scoreGuiGetScaleY(n);
    }

    public static int scoreGuiGetPlayerPathX() {
        return Anim.animDesignData[392][3];
    }

    public static int scoreGuiGetPlayerPathY(int n) {
        offsetScoreGuiPlayer = 0;
        if (n >= SCORE_WINNER_POINTS) {
            n = SCORE_WINNER_POINTS;
            offsetScoreGuiPlayer = Anim.animDesignData[396][6];
        }
        return Sys.sysInterpolate(SCORE_WINNER_POINTS, 0, scoreGuiFvPlayerPathY, scoreGuiFvPlayerPathY + scoreGuiFvPlayerPathH, n) - offsetScoreGuiPlayer;
    }

    public static int scoreGuiGetPlayerScoreFromPathY(int n, int n2, int n3) {
        int n4 = Sys.sysInterpolate(scoreGuiFvPlayerPathY, scoreGuiFvPlayerPathY + scoreGuiFvPlayerPathH, SCORE_WINNER_POINTS, 0, n2);
        return Sys.sysDistance(n3, n4) <= 1 ? n3 : n4;
    }

    static {
        offsetScoreGuiPlayer = 0;
    }
}

