/*
 * Decompiled with CFR 0.152.
 */
package modules;

import main.cGame;
import modules.Gfx;
import modules.Lib;
import modules.Timer;
import modules.cFsm;

public class Loader {
    private static final int LOADER_PERCENT_MAX = 100;
    private static final int LOADER_LAPSO = 600;
    private static final int LOADER_PERCENT_INCREMENT = 2;
    private static final int LOADER_SHOW_THRESHOLD_TIME = 500;
    private static volatile int loaderPercent = 100;
    private static volatile short loaderId;
    private static volatile boolean loaderStarted;
    private static volatile boolean loaderFinished;
    private static volatile long loaderTime;
    private static volatile long loaderShowThresholdTime;
    private static volatile short loaderGfxId;
    private static volatile boolean loaderDraw100Percent;
    private static volatile boolean loaderDraw100PercentDoneIt;
    private static volatile boolean loaderShowUsed;
    private static volatile boolean loaderLoadMode;
    private static volatile int loaderShowTime;

    public static void loaderStart(short s, short s2) {
        Loader.loaderStartPrivate(s, s2, 500, true);
    }

    public static void loaderStart(short s, short s2, int n, boolean bl) {
        Loader.loaderStartPrivate(s, s2, n, bl);
    }

    private static void loaderStartPrivate(short s, short s2, int n, boolean bl) {
        loaderId = s;
        loaderPercent = 0;
        loaderTime = Timer.timer_GlobalTimer;
        loaderShowThresholdTime = Timer.timer_GlobalTimer;
        loaderShowUsed = false;
        loaderGfxId = s2;
        loaderShowTime = n;
        loaderLoadMode = bl;
        Lib.events[43] = 1;
        Loader.loaderLauch();
    }

    public static int loaderGetProgress() {
        return loaderPercent;
    }

    public static boolean loaderFinished() {
        return loaderFinished;
    }

    public static boolean loaderLoadMode() {
        return loaderLoadMode;
    }

    private static void loaderLauch() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    cFsm.lib.systemGC();
                    loaderStarted = true;
                    loaderFinished = false;
                    loaderDraw100Percent = false;
                    loaderDraw100PercentDoneIt = false;
                    Gfx.gfxDoRepaint(10);
                    cGame.doLoad(loaderId);
                    loaderDraw100Percent = true;
                    loaderFinished = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(10);
        thread.start();
    }

    static void loaderDo() {
        if (loaderStarted) {
            if (Timer.timer_GlobalTimer - loaderTime >= 600L) {
                loaderTime = Timer.timer_GlobalTimer;
                if ((loaderPercent += 2) >= 100) {
                    loaderPercent = 100;
                }
                if (loaderDraw100Percent) {
                    loaderPercent = 100;
                    if (loaderDraw100PercentDoneIt) {
                        Lib.events[43] = 2;
                        loaderStarted = false;
                        loaderFinished = true;
                    }
                    loaderDraw100PercentDoneIt = true;
                }
            }
            if (!loaderShowUsed && !loaderFinished) {
                if (Timer.timer_GlobalTimer - loaderShowThresholdTime >= (long)loaderShowTime) {
                    loaderShowUsed = true;
                    Gfx.gfxShow(loaderGfxId, (short)43, false);
                }
            }
        }
    }
}

