/*
 * Decompiled with CFR 0.152.
 */
package modules;

import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import modules.cMIDlet;

public class Sound {
    private static short soundCount;
    private static boolean soundEnable;
    private static String soundMimeType;
    private static boolean soundVibrateSupported;
    private static boolean soundClassFound;
    private static final short SOUND_NOT_LOADED = -1;
    private static final short SOUND_SPLASH_IDX = 0;
    private static final short SOUND_INGAMEMENU_IDX = 1;
    private static String[] soundFilenames;
    private static Player[] soundServer;
    private static short soundLastPlayedId;
    private static short soundLastPlayedName;
    static boolean soundIsPlayed;

    public static void soundInit(String[] stringArray, String string) {
        soundMimeType = Sound.soundCheckMIMESupport(string);
        soundVibrateSupported = Sound.soundCheckVibrateSupport();
        soundClassFound = Sound.soundCheckClassSupport();
        soundEnable = false;
        soundFilenames = stringArray;
        soundIsPlayed = false;
        soundCount = 1;
        soundServer = new Player[soundCount];
    }

    public static void soundSetEnable(boolean bl) {
        soundEnable = bl;
        if (!soundEnable) {
            Sound.soundStopAll();
        }
    }

    public static boolean soundIsEnabled() {
        return soundEnable;
    }

    public static boolean soundSupported() {
        return soundMimeType != null && soundClassFound;
    }

    public static boolean soundVibrateSupported() {
        return soundVibrateSupported;
    }

    private static boolean soundCheckClassSupport() {
        try {
            Class<?> clazz = Class.forName("javax.microedition.media.Manager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static boolean soundCheckVibrateSupport() {
        try {
            return Display.getDisplay((MIDlet)cMIDlet.midlet).vibrate(0);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String soundCheckMIMESupport(String string) {
        String[] stringArray = Manager.getSupportedProtocols((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = Manager.getSupportedContentTypes((String)stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string.equals(stringArray2[j])) continue;
                return string;
            }
        }
        return null;
    }

    public static void soundCreateServer() {
    }

    public static void soundDestroyServer() {
    }

    public static void soundPlay(short s, boolean bl) {
        if (soundEnable) {
            Sound.soundPlayPrivate(s, bl);
        }
    }

    public static void soundStop() {
        Sound.soundStopPrivate();
    }

    public static void soundLoop(short s, short s2) {
        Sound.soundLoopPrivate(s, s2);
    }

    public static void soundUnload(short s) {
        Sound.soundUnloadPrivate(s);
    }

    public static void soundLoad(short s) {
        Sound.soundLoadPrivate(s);
    }

    public static void soundLoad(short s, short s2) {
    }

    private static void soundPlayPrivate(short s, boolean bl) {
        if (!Sound.soundSupported()) {
            return;
        }
        if (soundEnable) {
            try {
                Sound.soundStopPrivate();
                soundLastPlayedName = s;
                soundLastPlayedId = 0;
                if (soundServer[0] == null) {
                    Sound.soundLoadPrivate(s);
                }
                soundServer[0].prefetch();
                soundServer[0].start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void soundStopPrivate() {
        if (!Sound.soundSupported()) {
            return;
        }
        try {
            if (soundServer[soundLastPlayedId] != null) {
                soundServer[soundLastPlayedId].stop();
            }
            Sound.soundUnloadPrivate(soundLastPlayedId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void soundUnload() {
        if (soundServer != null) {
            for (short s = 0; s < soundServer.length; s = (short)(s + 1)) {
                Sound.soundUnloadPrivate(s);
            }
        }
    }

    public static void soundStopAll() {
        Sound.soundStop();
    }

    public static void soundVibrate(int n) {
        if (!Sound.soundVibrateSupported()) {
            return;
        }
        try {
            Display.getDisplay((MIDlet)cMIDlet.midlet).vibrate(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void soundManageOnCall(boolean bl) {
        if (bl) {
            Sound.soundUnload();
        }
    }

    private static void soundLoopPrivate(short s, short s2) {
        if (!Sound.soundSupported()) {
            return;
        }
        try {
            int n = 0;
            soundServer[n].setLoopCount((int)s2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void soundUnloadPrivate(short s) {
        if (!Sound.soundSupported()) {
            return;
        }
        int n = 0;
        try {
            n = 0;
            if (soundServer[n] != null) {
                soundServer[n].close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Sound.soundServer[n] = null;
    }

    private static void soundLoadPrivate(short s) {
        if (!Sound.soundSupported()) {
            return;
        }
        try {
            int n = 0;
            InputStream inputStream = soundFilenames.getClass().getResourceAsStream(soundFilenames[s]);
            Player player = Manager.createPlayer((InputStream)inputStream, (String)soundMimeType);
            player.realize();
            player.prefetch();
            Sound.soundServer[n] = player;
            if (s == 0 || s == 1) {
                Sound.soundLoopPrivate(s, (short)-1);
            } else {
                Sound.soundLoopPrivate(s, (short)1);
            }
            inputStream.close();
            inputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        soundEnable = false;
        soundVibrateSupported = false;
        soundClassFound = false;
        soundLastPlayedId = 0;
        soundLastPlayedName = (short)-1;
        soundIsPlayed = false;
    }
}

