/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class DuckHuntCanvas
extends Canvas
implements Runnable,
PlayerListener {
    private static final int MAX_MONSTER_CYCLE = 10;
    private static final int MOVE_NONE = 0;
    private static final int MOVE_LEFT = 1;
    private static final int MOVE_RIGHT = 2;
    private static final int MOVE_UP = 3;
    private static final int MOVE_DOWN = 4;
    private static final boolean RENDER_FULL_SCREEN = true;
    private static final int FULL_SCREEN_HEIGHT = 260;
    private static final boolean FAST_COLLISION_DETECT = true;
    private static final String RESOURCE_FOLDER = "/duckhunt/";
    private static final int MOUNTAIN_MOVE_STEP = 2;
    private static final int SKY_MOVE_STEP = 1;
    private static final boolean RENDER_GRASS = true;
    private static final int GRASS_LAYERS = 2;
    private static final int[] GRASS_MOVE_STEP = new int[]{3, 4, 6, 9};
    private static final int GROUND_COLOUR = 4293906;
    private static final int DUCK_FLY_FRAMES = 10;
    private static int DUCK_FLY_WIDTH = 43;
    private static int DUCK_FLY_HEIGHT = 61;
    private static final int DUCK_WAVE_FRAMES = 10;
    private static int DUCK_WAVE_WIDTH = 65;
    private static int DUCK_WAVE_HEIGHT = 65;
    private static final int DUCK_WALK_FRAMES = 10;
    private static int DUCK_WALK_WIDTH = 86;
    private static int DUCK_WALK_HEIGHT = 60;
    private static final int DUCK_KING_FRAMES = 10;
    private static int DUCK_KING_WIDTH = 85;
    private static int DUCK_KING_HEIGHT = 60;
    private static final int AMMO_X = 5;
    private static final int AMMO_Y = 20;
    private static final int AMMO_HEIGHT = 5;
    private static final int SCORE_X = 5;
    private static final int SCORE_Y = 5;
    private static final String SCORE_STRING = "Score:";
    private static final String TIME_STRING = "Time:";
    private static final int WAVING_DUCK_SCORE = 7;
    private static final int FLYING_DUCK_SCORE = 7;
    private static final int WALKING_DUCK_SCORE = 7;
    private static final int KING_DUCK_SCORE = 7;
    private DuckHuntCanvasListener listener = null;
    private Image skyImage;
    private Image mountainImage;
    private Image groundImage;
    private Image sightImage;
    private Image sightOnTargetImage;
    private Image shellImage;
    private Image bulletHoleImage;
    private Image reloadImage;
    private Image resultImage;
    private Image elementalSplitImage;
    private Image panelImage;
    private Image gameOverImage;
    private String nextSound = "";
    private boolean alienAppear = false;
    private boolean drawElementalSplit = false;
    private Image[] duckFlyImages = new Image[10];
    private Image[] duckWaveImages = new Image[10];
    private Image[] duckWalkImages = new Image[10];
    private Image[] duckKingImages = new Image[10];
    private Random rand = new Random();
    private int w;
    private int h;
    private boolean paused = false;
    private Thread thread = null;
    private int delay = 20;
    private boolean cleared = false;
    private int frame = 0;
    private int moveDirection = 0;
    private int skyX;
    private int mountainX;
    private int mountainY;
    private int groundY;
    private int menuY;
    private int groundHeight;
    private int[] grassX = new int[2];
    private int[] grassY = new int[2];
    private int sightWidth = 0;
    private int sightXMovementLimit = 80;
    private int sightYMovementLimit = 95;
    private int sightX = 0;
    private int sightY = 0;
    private int sightXOffset = 0;
    private int sightYOffset = 0;
    private int sightXAcceleration = 0;
    private int sightYAcceleration = 0;
    private boolean onTarget = false;
    private boolean autoCentreSight = false;
    private int autoCentreTimeout = 30;
    private int autoCentreCounter = 0;
    private int score = 0;
    private int ammo = 6;
    private boolean fireGun = false;
    private int GUN_Y_OFFSET = 25;
    private int drawMuzzleFlash = 0;
    private int reloadCounter = 0;
    private int shotsFired = 0;
    private int shotsOnTarget = 0;
    private int countTargetAfterKingAppear = 0;
    private int difficulty = 1;
    private int[] diff_reloadSpeed = new int[]{16, 20, 14};
    private int[] diff_sightMovementStep = new int[]{4, 4, 4};
    private int[] diff_ammoMax = new int[]{30, 20, 14};
    private int reloadSpeed = this.diff_reloadSpeed[this.difficulty];
    private int AMPLITUDE = 10;
    private int duck_FlyY = 50;
    private int duck_WalkY = 180;
    private int duck_WaveY = 80;
    private int duck_KingY = 150;
    private int sightMovementStep = this.diff_sightMovementStep[this.difficulty];
    private int[] diff_MovementStep = new int[]{1, 3, 5};
    private int ammoMax = this.diff_ammoMax[this.difficulty];
    private int alienMovementStep = this.diff_MovementStep[this.difficulty];
    private int duckFlyX = -65;
    private int duckFlyY = 50;
    private int duckFlyMovementStep = this.alienMovementStep;
    private int duckFlyShotCounter = 0;
    private int duckWalkX = -65;
    private int duckWalkY = 180;
    private int duckWalkMovementStep = this.alienMovementStep;
    private int duckWalkShotCounter = 0;
    private long countTime = 0L;
    private int duckWaveX = -65;
    private int duckWaveY = 80;
    private int duckWaveMovementStep = this.alienMovementStep;
    private int duckWaveShotCounter = 0;
    private int duckKingX = -65;
    private int duckKingY = 150;
    private int duckKingMovementStep = this.alienMovementStep;
    private int duckKingShotCounter = 0;
    private int orbitFly = 0;
    private int orbitWave = 0;
    private int orbitWalk = 0;
    private int orbitKing = 0;
    private FontRenderer outlineFont;
    private long startTime = 0L;
    private long pauseTime = 0L;
    private long appearElementalSplitTime;
    private long timeLimit = 120L;
    private long elapsedGameTime = 0L;
    private boolean gameover = false;
    private boolean invertY = false;
    private HighScoreTable highScoreTable;
    private boolean displayHighScoreTable = false;
    private boolean doneHs = false;
    private Vector displayText = new Vector();
    private boolean displayTextPage = false;
    private int scrollOffset = 0;
    private boolean scrollAtBottom = false;
    private Image scrollUpImage;
    private Image scrollDownImage;
    private boolean soundEnabled = false;
    private boolean useSoundCache = false;
    private SoundManager soundManager = null;
    private Player musicPlayer;
    private InputStream inputStream;

    public DuckHuntCanvas(DuckHuntCanvasListener l, SoundManager s) {
        this.setFullScreenMode(true);
        this.loadResources();
        this.outlineFont = new FontRenderer("/duckhunt/fonts/freon_outline");
        this.listener = l;
        System.out.println("Setting up sound, setting Mime type to midi");
        this.soundManager = s;
        this.soundManager.setSoundMimeType("audio/x-wav");
        this.paused = false;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.sightX = (this.w - this.sightImage.getWidth()) / 2;
        this.sightY = (this.h - this.sightImage.getHeight()) / 2;
        this.sightWidth = this.sightImage.getWidth();
        this.menuY = this.h - 14;
        this.sightXMovementLimit = (this.w - 20) / 2;
        this.sightYMovementLimit = (this.h - 20) / 2;
        this.startTime = System.currentTimeMillis();
    }

    private void loadResources() {
        try {
            int i;
            this.skyImage = this.loadImage("/duckhunt/bg.png");
            this.resultImage = this.loadImage("/duckhunt/result.png");
            this.elementalSplitImage = this.loadImage("/duckhunt/elemental_split.png");
            for (i = 0; i < 5; ++i) {
                this.duckFlyImages[2 * i] = this.loadImage("/duckhunt/duck_fly/enemy01_" + 2 * i + ".png");
                this.duckFlyImages[2 * i + 1] = this.loadImage("/duckhunt/duck_fly/enemy01_" + 2 * i + ".png");
            }
            for (i = 0; i < 5; ++i) {
                this.duckWaveImages[2 * i] = this.loadImage("/duckhunt/duck_wave/enemy04_" + 2 * i + ".png");
                this.duckWaveImages[2 * i + 1] = this.loadImage("/duckhunt/duck_wave/enemy04_" + 2 * i + ".png");
            }
            for (i = 0; i < 5; ++i) {
                this.duckKingImages[2 * i] = this.loadImage("/duckhunt/duck_king/enemy04_" + 2 * i + ".png");
                this.duckKingImages[2 * i + 1] = this.loadImage("/duckhunt/duck_king/enemy04_" + 2 * i + ".png");
            }
            for (i = 0; i < 5; ++i) {
                this.duckWalkImages[2 * i] = this.loadImage("/duckhunt/duck_walk/enemy02_" + 2 * i + ".png");
                this.duckWalkImages[2 * i + 1] = this.loadImage("/duckhunt/duck_walk/enemy02_" + 2 * i + ".png");
            }
            DUCK_FLY_WIDTH = this.duckFlyImages[0].getWidth();
            DUCK_FLY_HEIGHT = this.duckFlyImages[0].getHeight();
            DUCK_WAVE_WIDTH = this.duckWaveImages[0].getWidth();
            DUCK_WAVE_HEIGHT = this.duckWaveImages[0].getHeight();
            DUCK_WALK_WIDTH = this.duckWalkImages[0].getWidth();
            DUCK_WALK_HEIGHT = this.duckWalkImages[0].getHeight();
            DUCK_KING_WIDTH = this.duckKingImages[0].getWidth();
            DUCK_KING_HEIGHT = this.duckKingImages[0].getHeight();
            this.sightImage = this.loadImage("/duckhunt/sight.png");
            this.sightOnTargetImage = this.loadImage("/duckhunt/sight_ontarget.png");
            this.shellImage = this.loadImage("/duckhunt/shell.png");
            this.reloadImage = this.loadImage("/duckhunt/reload.png");
            this.bulletHoleImage = this.loadImage("/duckhunt/shot.png");
            this.scrollUpImage = this.loadImage("/up.png");
            this.scrollDownImage = this.loadImage("/down.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSound(int v) {
        boolean bl = this.soundEnabled = v == 0;
        if (this.soundEnabled) {
            this.loadSound();
        }
    }

    public boolean getSoundSetting() {
        return this.soundEnabled;
    }

    private void loadSound() {
        try {
            if (this.musicPlayer != null) {
                return;
            }
            this.inputStream = this.getClass().getResourceAsStream("/sounds/shotgun.wav");
            this.musicPlayer = Manager.createPlayer((InputStream)this.inputStream, (String)"audio/x-wav");
            this.musicPlayer.prefetch();
            this.musicPlayer.setLoopCount(2);
            this.musicPlayer.addPlayerListener((PlayerListener)this);
            VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
            volumeControl.setLevel(100);
            volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
            volumeControl.setLevel(100);
            this.inputStream = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    private Image loadImage(String res) {
        Image tmp = null;
        try {
            tmp = Image.createImage((String)res);
        }
        catch (Exception e) {
            System.out.println("Unable to load image: " + res);
        }
        return tmp;
    }

    public void setDifficulty(int diff) {
        this.difficulty = diff;
        this.reloadSpeed = this.diff_reloadSpeed[this.difficulty];
        this.sightMovementStep = this.diff_sightMovementStep[this.difficulty];
        this.ammoMax = this.diff_ammoMax[this.difficulty];
        this.duckFlyMovementStep = this.alienMovementStep = this.diff_MovementStep[this.difficulty];
        this.duckWaveMovementStep = this.alienMovementStep;
        this.duckKingMovementStep = this.alienMovementStep;
        this.duckWalkMovementStep = this.alienMovementStep;
        System.out.println("Difficulty: " + diff);
        this.resetGame();
    }

    public void setInvertY(int y) {
        this.invertY = y != 0;
    }

    public void displayHighScore(HighScoreTable hs) {
        this.displayHighScoreTable = true;
        this.displayTextPage = false;
        this.highScoreTable = hs;
        System.gc();
        if (this.panelImage == null) {
            this.panelImage = this.loadImage("/duckhunt/panel.png");
        }
    }

    public void setHighScore(HighScoreTable hst) {
        this.highScoreTable = hst;
    }

    public void displayText(String txt) {
        this.displayTextPage = true;
        this.displayHighScoreTable = false;
        this.scrollOffset = 0;
        System.gc();
        if (this.panelImage == null) {
            this.panelImage = this.loadImage("/duckhunt/panel.png");
        }
        this.displayText = this.outlineFont.wrapStringToVector(txt, this.panelImage.getWidth() - 60);
    }

    public void resetGame() {
        this.countTargetAfterKingAppear = 0;
        this.paused = false;
        this.startTime = System.currentTimeMillis();
        this.timeLimit = 120L;
        this.moveDirection = 0;
        this.score = 0;
        this.frame = 0;
        this.onTarget = false;
        this.ammo = this.ammoMax;
        this.shotsFired = 0;
        this.shotsOnTarget = 0;
        this.alienAppear = false;
        this.drawElementalSplit = false;
        this.fireGun = false;
        this.drawMuzzleFlash = 0;
        this.sightXOffset = 0;
        this.sightYOffset = 0;
        this.pauseTime = 0L;
        this.elapsedGameTime = 0L;
        this.gameover = false;
        this.nextSound = "";
        this.displayHighScoreTable = false;
        this.displayTextPage = false;
        this.doneHs = false;
        this.duckFlyX = -this.rnd(this.w);
        this.duckKingX = -this.rnd(this.w);
        this.duckWalkX = -this.rnd(this.w);
        this.duckWaveX = -this.rnd(this.w);
        if (this.duckFlyX > -40) {
            this.duckFlyX += -40;
        }
        if (this.duckKingX > -40) {
            this.duckKingX += -40;
        }
        if (this.duckWalkX > -40) {
            this.duckWalkX += -40;
        }
        if (this.duckWaveX > -40) {
            this.duckWaveX += -40;
        }
        this.duck_FlyY = this.h / 5;
        this.duck_WaveY = 2 * this.h / 5;
        this.duck_KingY = 3 * this.h / 5;
        this.duck_WalkY = 3 * this.h / 5;
        this.duckFlyY = this.h / 5;
        this.duckWaveY = 2 * this.h / 5;
        this.duckKingY = 3 * this.h / 5;
        this.duckWalkY = 3 * this.h / 5;
        if (this.soundEnabled) {
            this.loadSound();
        }
    }

    public void startNewGame() {
        this.resetGame();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void purge() {
        this.panelImage = null;
        try {
            if (this.musicPlayer != null) {
                this.musicPlayer.stop();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            this.inputStream = null;
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.thread) {
            DuckHuntCanvas duckHuntCanvas = this;
            synchronized (duckHuntCanvas) {
                if (!this.paused && !this.gameover) {
                    ++this.frame;
                    if (this.reloadCounter > 0) {
                        --this.reloadCounter;
                        if (this.reloadCounter == 0) {
                            this.ammo = this.ammoMax;
                        }
                    }
                    this.moveSight();
                    this.moveThings();
                    this.checkSight();
                    this.doSounds();
                    this.elapsedGameTime = (System.currentTimeMillis() - this.startTime) / 1000L;
                    if (this.elapsedGameTime >= this.timeLimit) {
                        this.gameover = true;
                        this.panelImage = this.loadImage("/duckhunt/panel.png");
                        this.gameOverImage = this.loadImage("/duckhunt/gameover.png");
                        this.highScoreTable.addScore("", this.getScore(), this.getAccuracy());
                        try {
                            RecordManager.save(this.highScoreTable.toByteArray(), "game_scores");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.drawElementalSplit = System.currentTimeMillis() - this.appearElementalSplitTime > 1000L && System.currentTimeMillis() - this.appearElementalSplitTime < 3000L && this.appearElementalSplitTime > 0L;
                } else if (this.gameover && this.panelImage == null && !this.displayHighScoreTable && !this.displayTextPage) {
                    this.panelImage = this.loadImage("/duckhunt/panel.png");
                }
                this.repaint();
                this.serviceRepaints();
            }
        }
    }

    public void doSounds() {
        try {
            this.soundEnabled = Adubu.getSoundState();
            if (this.soundEnabled) {
                if (this.useSoundCache) {
                    if (!(this.nextSound.equals("shotgun") || this.nextSound.equals("reload") || this.nextSound.equals("shotgun_quack1") || this.nextSound.equals("shotgun_quack2") || !this.nextSound.equals("click"))) {
                        // empty if block
                    }
                } else if (this.nextSound.equals("shotgun")) {
                    this.soundManager.playSound("/sounds/shotgun.wav", 1, "audio/x-wav");
                } else if (this.nextSound.equals("reload")) {
                    this.soundManager.playSound("/sounds/shotgun_reload.wav", 1, "audio/x-wav");
                } else if (this.nextSound.equals("shotgun_quack1")) {
                    this.soundManager.playSound("/sounds/shotgun.wav", 1, "audio/x-wav");
                } else if (this.nextSound.equals("shotgun_quack2")) {
                    this.soundManager.playSound("/sounds/shotgun.wav", 1, "audio/x-wav");
                } else if (this.nextSound.equals("click")) {
                    this.soundManager.playSound("/sounds/click.wav", 1, "audio/x-wav");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nextSound = "";
    }

    public void pause() {
        this.paused = true;
        this.cleared = false;
        this.pauseTime = System.currentTimeMillis();
    }

    public void resume() {
        this.paused = false;
        this.cleared = false;
        this.displayHighScoreTable = false;
        this.displayTextPage = false;
        this.panelImage = null;
        System.gc();
        this.startTime += System.currentTimeMillis() - this.pauseTime;
    }

    public void terminate() {
        this.thread = null;
        this.paused = true;
    }

    private void moveLandscape() {
        block7: {
            block6: {
                if (this.moveDirection != 1 || this.sightXOffset >= -(this.sightXMovementLimit >> 1)) break block6;
                ++this.skyX;
                if (this.skyX >= 0) {
                    this.skyX = -this.w;
                }
                this.mountainX += 2;
                if (this.mountainX >= 0) {
                    this.mountainX = -this.w;
                }
                for (int i = 0; i < 2; ++i) {
                    int n = i;
                    this.grassX[n] = this.grassX[n] + GRASS_MOVE_STEP[i];
                    if (this.grassX[i] < 0) continue;
                    this.grassX[i] = -this.w;
                }
                break block7;
            }
            if (this.moveDirection != 2 || this.sightXOffset <= this.sightXMovementLimit >> 1) break block7;
            --this.skyX;
            if (this.skyX <= -this.w) {
                this.skyX = 0;
            }
            this.mountainX -= 2;
            if (this.mountainX <= -this.w) {
                this.mountainX = 0;
            }
            for (int i = 0; i < 2; ++i) {
                int n = i;
                this.grassX[n] = this.grassX[n] - GRASS_MOVE_STEP[i];
                if (this.grassX[i] > -this.w) continue;
                this.grassX[i] = 0;
            }
        }
    }

    public void moveSight() {
        if (this.moveDirection == 2) {
            if (this.sightXOffset < this.sightXMovementLimit) {
                this.sightXOffset += this.sightMovementStep + (this.sightXAcceleration >> 2);
            }
        } else if (this.moveDirection == 1) {
            if (this.sightXOffset > -this.sightXMovementLimit) {
                this.sightXOffset -= this.sightMovementStep;
                this.sightXOffset -= this.sightXAcceleration >> 2;
            }
        } else if (this.moveDirection == 3) {
            if (this.sightYOffset > -this.sightYMovementLimit) {
                this.sightYOffset -= this.sightMovementStep;
                this.sightYOffset -= this.sightYAcceleration >> 2;
            }
        } else if (this.moveDirection == 4 && this.sightYOffset < this.sightYMovementLimit) {
            this.sightYOffset += this.sightMovementStep + (this.sightYAcceleration >> 2);
        }
        if (this.autoCentreSight && this.moveDirection == 0) {
            if (this.autoCentreCounter <= 0 && this.sightXOffset != 0) {
                this.sightXOffset += this.sightXOffset < 0 ? 1 : -1;
            }
            if (this.autoCentreCounter <= 0 && this.sightYOffset != 0) {
                this.sightYOffset += this.sightYOffset < 0 ? 1 : -1;
            }
            --this.autoCentreCounter;
        }
    }

    public void moveThings() {
        ++this.countTime;
        if (this.countTime % 2L == 0L) {
            this.duckFlyX += this.duckFlyMovementStep;
            if (this.orbitFly == 0) {
                this.duckFlyY = (int)((double)this.duck_FlyY + (double)(this.h / 5) * Math.sin((float)((double)this.duckFlyX * Math.PI / 2.0) / (float)(this.w / 4)));
            }
        }
        if (this.duckFlyShotCounter > 0) {
            --this.duckFlyShotCounter;
        }
        if (this.duckFlyX > this.w || this.duckFlyShotCounter == 1) {
            this.duckFlyX = -201;
            this.duckFlyShotCounter = 0;
            this.orbitFly = this.rnd(2);
            this.duckFlyY = this.duck_FlyY;
        }
        if (this.countTime % 2L == 0L) {
            this.duckWalkX += this.duckWalkMovementStep;
            if (this.orbitWalk == 0) {
                this.duckWalkY = (int)((double)this.duck_WalkY + (double)(this.h / 5) * Math.sin((float)((double)this.duckWalkX * Math.PI / 2.0) / (float)(this.w / 4)));
            }
        }
        if (this.duckWalkShotCounter > 0) {
            --this.duckWalkShotCounter;
        }
        if (this.duckWalkX > this.w || this.duckWalkShotCounter == 1) {
            this.duckWalkX = -201;
            this.duckWalkShotCounter = 0;
            this.orbitWalk = this.rnd(2);
            this.duckWalkY = this.duck_WalkY;
        }
        if (this.countTime % 2L == 0L) {
            this.duckWaveX += this.duckWaveMovementStep;
            if (this.orbitWave == 0) {
                this.duckWaveY = (int)((double)this.duck_WaveY + (double)(this.h / 5) * Math.sin((float)((double)this.duckWaveX * Math.PI / 2.0) / (float)(this.w / 4)));
            }
        }
        if (this.duckWaveShotCounter > 0) {
            --this.duckWaveShotCounter;
        }
        if (this.duckWaveX > this.w || this.duckWaveShotCounter == 1) {
            this.duckWaveX = -201;
            this.duckWaveShotCounter = 0;
            this.orbitWave = this.rnd(2);
            this.duckWaveY = this.duck_WaveY;
        }
        if (this.countTime % 2L == 0L) {
            this.duckKingX += this.duckKingMovementStep;
            if (this.orbitKing == 0) {
                this.duckKingY = (int)((double)this.duck_KingY + (double)(this.h / 5) * Math.sin((float)((double)this.duckKingX * Math.PI / 2.0) / (float)(this.w / 4)));
            }
        }
        if (this.duckKingShotCounter > 0) {
            --this.duckKingShotCounter;
        }
        if (this.duckKingX > this.w && this.duckKingX - this.duckKingMovementStep <= this.w && this.alienAppear) {
            this.alienAppear = false;
        }
        if (this.duckKingX > this.w || this.duckKingShotCounter == 1) {
            this.duckKingX = -201;
            this.duckKingShotCounter = 0;
            this.orbitKing = this.rnd(2);
            this.duckKingY = this.duck_KingY;
        }
    }

    public void checkSight() {
        int duckFrame;
        int y;
        int x;
        this.onTarget = false;
        int sx = this.sightX + this.sightXOffset + (this.sightImage.getWidth() >> 1);
        int sy = this.sightY + this.sightYOffset + (this.sightImage.getHeight() >> 1);
        if (this.duckFlyShotCounter == 0 && sx >= this.duckFlyX && sx <= this.duckFlyX + DUCK_FLY_WIDTH && sy >= this.duckFlyY && sy <= this.duckFlyY + DUCK_FLY_HEIGHT) {
            this.onTarget = true;
            if (this.duckFlyShotCounter > 0) {
                --this.duckFlyShotCounter;
            }
            x = this.sightX + this.sightXOffset - this.duckFlyX + (this.sightWidth >> 1);
            y = this.sightY + this.sightYOffset - this.duckFlyY + (this.sightWidth >> 1);
            duckFrame = this.frame % 10;
            if (this.fireGun && this.checkCollision(this.duckFlyImages[duckFrame], x, y, 0)) {
                this.duckFlyShotCounter = 5;
                this.fireGun = false;
                this.score += 7;
                this.nextSound = "shotgun_quack1";
                ++this.shotsOnTarget;
                if (!this.alienAppear) {
                    ++this.countTargetAfterKingAppear;
                    if (this.countTargetAfterKingAppear % 10 == 0) {
                        this.duckKingX = -this.rnd(this.w);
                        this.alienAppear = true;
                    }
                }
            }
        }
        if (this.duckWaveShotCounter == 0 && sx >= this.duckWaveX && sx <= this.duckWaveX + DUCK_WAVE_WIDTH && sy >= this.duckWaveY && sy <= this.duckWaveY + DUCK_WAVE_HEIGHT) {
            this.onTarget = true;
            if (this.duckWaveShotCounter > 0) {
                --this.duckWaveShotCounter;
            }
            x = this.sightX + this.sightXOffset - this.duckWaveX + (this.sightWidth >> 1);
            y = this.sightY + this.sightYOffset - this.duckWaveY + (this.sightWidth >> 1);
            duckFrame = this.frame % 10;
            if (this.fireGun && this.checkCollision(this.duckWaveImages[duckFrame], x, y, 0)) {
                this.duckWaveShotCounter = 5;
                this.fireGun = false;
                this.score += 7;
                ++this.shotsOnTarget;
                if (!this.alienAppear) {
                    ++this.countTargetAfterKingAppear;
                    if (this.countTargetAfterKingAppear % 10 == 0) {
                        this.duckKingX = -this.rnd(this.w);
                        this.alienAppear = true;
                    }
                }
            }
        }
        if (this.alienAppear && this.duckKingShotCounter == 0 && sx >= this.duckKingX && sx <= this.duckKingX + DUCK_KING_WIDTH && sy >= this.duckKingY && sy <= this.duckKingY + DUCK_KING_HEIGHT) {
            this.onTarget = true;
            if (this.duckKingShotCounter > 0) {
                --this.duckKingShotCounter;
            }
            x = this.sightX + this.sightXOffset - this.duckKingX + (this.sightWidth >> 1);
            y = this.sightY + this.sightYOffset - this.duckKingY + (this.sightWidth >> 1);
            duckFrame = this.frame % 10;
            if (this.fireGun && this.checkCollision(this.duckKingImages[duckFrame], x, y, 0)) {
                this.duckKingShotCounter = 5;
                this.duckFlyShotCounter = 5;
                this.duckWalkShotCounter = 5;
                this.duckWaveShotCounter = 5;
                this.fireGun = false;
                this.score += 7;
                ++this.shotsOnTarget;
                this.timeLimit += 15L;
                this.alienAppear = false;
                this.countTargetAfterKingAppear = 0;
                if (this.duckWalkX > -40 && this.duckWalkX < this.w) {
                    this.onTarget = true;
                    if (this.duckWalkShotCounter > 0) {
                        --this.duckWalkShotCounter;
                    }
                    x = this.sightX + this.sightXOffset - this.duckWalkX + (this.sightWidth >> 1);
                    y = this.sightY + this.sightYOffset - this.duckWalkY + (this.sightWidth >> 1);
                    duckFrame = this.frame % 10;
                    this.duckWalkShotCounter = 5;
                    this.fireGun = false;
                    this.score += 7;
                    this.nextSound = "shotgun_quack1";
                    ++this.shotsOnTarget;
                    ++this.shotsFired;
                }
                if (this.duckWaveX > -40 && this.duckWaveX < this.w) {
                    this.onTarget = true;
                    if (this.duckWaveShotCounter > 0) {
                        --this.duckWaveShotCounter;
                    }
                    x = this.sightX + this.sightXOffset - this.duckWaveX + (this.sightWidth >> 1);
                    y = this.sightY + this.sightYOffset - this.duckWaveY + (this.sightWidth >> 1);
                    duckFrame = this.frame % 10;
                    this.duckWaveShotCounter = 5;
                    this.fireGun = false;
                    this.score += 7;
                    this.nextSound = "shotgun_quack1";
                    ++this.shotsOnTarget;
                    ++this.shotsFired;
                }
                if (this.duckFlyX > -40 && this.duckFlyX < this.w) {
                    this.onTarget = true;
                    if (this.duckFlyShotCounter > 0) {
                        --this.duckFlyShotCounter;
                    }
                    x = this.sightX + this.sightXOffset - this.duckFlyX + (this.sightWidth >> 1);
                    y = this.sightY + this.sightYOffset - this.duckFlyY + (this.sightWidth >> 1);
                    duckFrame = this.frame % 10;
                    this.duckFlyShotCounter = 5;
                    this.fireGun = false;
                    this.score += 7;
                    this.nextSound = "shotgun_quack1";
                    ++this.shotsOnTarget;
                    ++this.shotsFired;
                }
                this.appearElementalSplitTime = System.currentTimeMillis();
            }
        }
        if (this.duckWalkShotCounter == 0 && sx >= this.duckWalkX && sx <= this.duckWalkX + DUCK_WALK_WIDTH && sy >= this.duckWalkY && sy <= this.duckWalkY + DUCK_WALK_HEIGHT) {
            this.onTarget = true;
            if (this.duckWalkShotCounter > 0) {
                --this.duckWalkShotCounter;
            }
            x = this.sightX + this.sightXOffset - this.duckWalkX + (this.sightWidth >> 1);
            y = this.sightY + this.sightYOffset - this.duckWalkY + (this.sightWidth >> 1);
            duckFrame = this.frame % 10;
            if (this.fireGun && this.checkCollision(this.duckWalkImages[duckFrame], x, y, 0)) {
                this.duckWalkShotCounter = 5;
                this.fireGun = false;
                this.score += 7;
                this.nextSound = "shotgun_quack1";
                ++this.shotsOnTarget;
                if (!this.alienAppear) {
                    ++this.countTargetAfterKingAppear;
                    if (this.countTargetAfterKingAppear % 10 == 0) {
                        this.duckKingX = -this.rnd(this.w);
                        this.alienAppear = true;
                    }
                }
            }
        }
        if (this.drawMuzzleFlash > 0) {
            --this.drawMuzzleFlash;
        }
        this.fireGun = false;
    }

    private boolean checkCollision(Image img, int x, int y, int radius) {
        return true;
    }

    public void paint(Graphics g) {
        if (!this.cleared) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.w, this.h);
            this.cleared = true;
        }
        boolean horizonOffset = false;
        if (this.gameover && this.panelImage != null) {
            g.drawImage(this.resultImage, 0, 0, 20);
        } else {
            g.drawImage(this.skyImage, 0, 0, 20);
            if (this.drawElementalSplit) {
                g.drawImage(this.elementalSplitImage, (this.w - this.elementalSplitImage.getWidth()) / 2, (this.h - this.elementalSplitImage.getHeight()) / 2, 20);
            }
        }
        if (this.displayHighScoreTable) {
            this.renderHighScoreTable(g);
        } else if (this.displayTextPage) {
            this.renderTextPage(g);
        } else {
            this.renderDucks(g);
            if (this.onTarget) {
                g.drawImage(this.sightOnTargetImage, this.sightX + this.sightXOffset, this.sightY + this.sightYOffset, 20);
            } else {
                g.drawImage(this.sightImage, this.sightX + this.sightXOffset, this.sightY + this.sightYOffset, 20);
            }
            this.renderUI(g);
        }
    }

    public void renderUI(Graphics g) {
        if (!this.gameover) {
            this.outlineFont.drawString(g, "Menu", 6, this.menuY);
            if (this.paused) {
                this.outlineFont.drawString(g, "Paused!", this.w - this.outlineFont.stringWidth("Paused!") >> 1, this.h - this.outlineFont.getHeight() >> 1);
                this.outlineFont.drawString(g, "Resume", this.w - 40, this.menuY);
            } else {
                this.outlineFont.drawString(g, "Pause", this.w - 40, this.menuY);
            }
            this.outlineFont.drawString(g, SCORE_STRING + this.score, 5, 5);
            this.outlineFont.drawString(g, TIME_STRING + (this.timeLimit - this.elapsedGameTime), this.w - 50, 5);
            if (this.ammo == 0 && !this.paused) {
                g.drawImage(this.reloadImage, this.w - this.reloadImage.getWidth() >> 1, this.h - this.reloadImage.getHeight() >> 1, 20);
            }
        }
        if (this.gameover && this.panelImage != null) {
            int panelX = this.w - this.panelImage.getWidth() >> 1;
            int panelY = this.h - this.panelImage.getHeight() >> 1;
            g.drawImage(this.panelImage, panelX, panelY, 20);
            int x = this.panelImage.getWidth() / 2 - this.gameOverImage.getWidth() / 2;
            int y = panelY + 4;
            this.outlineFont.drawString(g, "Score: " + this.score, panelX + (this.panelImage.getWidth() - this.outlineFont.stringWidth("Score: " + this.score)) / 2, y += this.gameOverImage.getHeight() + 5);
            this.outlineFont.drawString(g, "Highest: " + this.highScoreTable.getHightestScore(), panelX + (this.panelImage.getWidth() - this.outlineFont.stringWidth("Hightest: " + this.highScoreTable.getHightestScore())) / 2, y += this.outlineFont.getHeight() + 5);
            y += this.outlineFont.getHeight() + 5;
            int accuracy = 0;
            if (this.shotsFired > 0) {
                accuracy = this.shotsOnTarget * 100 / this.shotsFired;
            }
            this.outlineFont.drawString(g, "Accuracy: " + accuracy + "%", panelX + (this.panelImage.getWidth() - this.outlineFont.stringWidth("Accuracy: " + accuracy + "%")) / 2, y);
            y += this.outlineFont.getHeight() * 2;
            String rating = "Duck Lover!";
            if (accuracy < 40) {
                rating = "Birdwatcher!";
            } else if (accuracy < 60) {
                rating = "Nothing Special!";
            } else if (accuracy < 80) {
                rating = "Sharp Shooter!";
            } else if (accuracy < 100) {
                rating = "Duck Destroyer!!";
            }
        }
    }

    public void renderDucks(Graphics g) {
        int duckFrame;
        if (this.duckFlyX > -40) {
            if (this.duckFlyShotCounter > 0 && this.duckFlyShotCounter < 5) {
                g.drawImage(this.duckFlyImages[0], this.duckFlyX, this.duckFlyY, 20);
                g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
            } else {
                duckFrame = this.frame % 10;
                g.drawImage(this.duckFlyImages[duckFrame], this.duckFlyX, this.duckFlyY, 20);
            }
        }
        if (this.duckWalkX > -40) {
            if (this.duckWalkShotCounter > 0 && this.duckWalkShotCounter < 5) {
                g.drawImage(this.duckWalkImages[0], this.duckWalkX, this.duckWalkY, 20);
                g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
            } else {
                duckFrame = this.frame % 10;
                g.drawImage(this.duckWalkImages[duckFrame], this.duckWalkX, this.duckWalkY, 20);
            }
        }
        if (this.duckWaveX > -40) {
            if (this.duckWaveShotCounter > 0 && this.duckWaveShotCounter < 5) {
                g.drawImage(this.duckWaveImages[0], this.duckWaveX, this.duckWaveY, 20);
                g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
            } else {
                duckFrame = this.frame % 10;
                g.drawImage(this.duckWaveImages[duckFrame], this.duckWaveX, this.duckWaveY, 20);
            }
        }
        if (this.duckKingX > -40 && this.alienAppear) {
            if (this.duckKingShotCounter > 0 && this.duckKingShotCounter < 5) {
                System.out.println("King was killed");
                g.drawImage(this.duckKingImages[0], this.duckKingX, this.duckKingY, 20);
                g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
                if (this.duckFlyX > -40) {
                    g.drawImage(this.duckFlyImages[0], this.duckFlyX, this.duckFlyY, 20);
                    g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
                }
                if (this.duckWalkX > -40) {
                    g.drawImage(this.duckWalkImages[0], this.duckWalkX, this.duckWalkY, 20);
                    g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
                }
                if (this.duckWaveX > -40) {
                    g.drawImage(this.duckWaveImages[0], this.duckWaveX, this.duckWaveY, 20);
                    g.drawImage(this.bulletHoleImage, this.sightX + this.sightXOffset + (this.sightImage.getWidth() - this.bulletHoleImage.getWidth() >> 1), this.sightY + this.sightYOffset + (this.sightImage.getHeight() - this.bulletHoleImage.getHeight() >> 1), 20);
                }
            } else {
                duckFrame = this.frame % 10;
                g.drawImage(this.duckKingImages[duckFrame], this.duckKingX, this.duckKingY, 20);
            }
        }
    }

    public void renderHighScoreTable(Graphics g) {
        int panelX = this.w - this.panelImage.getWidth() >> 1;
        int panelY = this.h - this.panelImage.getHeight() >> 1;
        g.drawImage(this.panelImage, panelX, panelY, 20);
        int x = this.panelImage.getWidth() / 2 - this.outlineFont.stringWidth("High Scores") / 2;
        int y = panelY + 10;
        this.outlineFont.drawString(g, "High Scores", panelX + x, y);
        y += this.outlineFont.getHeight() + this.outlineFont.getHeight() / 2;
        for (int i = 0; i < 5; ++i) {
            int a = this.highScoreTable.getAccuracy(i);
            String rating = "Duck Lover!";
            if (a < 40) {
                rating = "Birdwatcher!";
            } else if (a < 60) {
                rating = "Nothing Special!";
            } else if (a < 80) {
                rating = "Sharp Shooter!";
            } else if (a < 100) {
                rating = "Duck Destroyer!!";
            }
            this.outlineFont.drawString(g, i + 1 + ".", panelX + 25 + 10, y);
            this.outlineFont.drawString(g, this.highScoreTable.getName(i), panelX + 25 + 20, y);
            this.outlineFont.drawString(g, " " + this.highScoreTable.getScore(i), panelX + 25 + 65, y);
            this.outlineFont.drawString(g, rating, panelX + 25 + 20, y += this.outlineFont.getHeight());
            y += this.outlineFont.getHeight();
            y += this.outlineFont.getHeight() / 2;
        }
    }

    public void renderTextPage(Graphics g) {
        int panelX = this.w - this.panelImage.getWidth() >> 1;
        int panelY = this.h - this.panelImage.getHeight() >> 1;
        g.drawImage(this.panelImage, panelX, panelY, 20);
        int x = panelX + 36;
        int y = panelY + 32;
        for (int i = this.scrollOffset; i < this.displayText.size(); ++i) {
            if (y < panelY + this.panelImage.getHeight() - this.outlineFont.getHeight() - 18) {
                String s = (String)this.displayText.elementAt(i);
                this.outlineFont.drawString(g, s, x, y);
                if (i == this.displayText.size() - 1) {
                    this.scrollAtBottom = true;
                }
                y += this.outlineFont.getHeight() + 1;
                continue;
            }
            this.scrollAtBottom = false;
            break;
        }
        if (this.scrollOffset > 0) {
            g.drawImage(this.scrollUpImage, this.w / 2 - 2, panelY + this.panelImage.getHeight() - 10, 20);
        }
        if (!this.scrollAtBottom) {
            g.drawImage(this.scrollDownImage, this.w / 2 - 2, panelY + this.panelImage.getHeight() - 6, 20);
        }
    }

    public void keyPressed(int keyCode) {
        int ga = this.getGameAction(keyCode);
        if (this.displayTextPage) {
            if (ga == 6) {
                if (!this.scrollAtBottom) {
                    ++this.scrollOffset;
                }
                this.repaint();
            } else if (ga == 1) {
                if (this.scrollOffset > 0) {
                    --this.scrollOffset;
                }
                this.repaint();
            }
            if ((keyCode == -6 || keyCode == -7) && this.listener != null) {
                this.listener.duckHuntCanvasClose(this);
                this.repaint();
            }
            return;
        }
        if (this.gameover || this.displayHighScoreTable) {
            if (this.listener != null) {
                this.listener.duckHuntCanvasClose(this);
            }
            return;
        }
        if (keyCode == -6) {
            if (this.listener != null) {
                this.listener.duckHuntCanvasClose(this);
            }
        } else if (keyCode == -7) {
            if (!this.paused) {
                this.pause();
            } else {
                this.resume();
            }
        }
        if (this.paused || this.gameover) {
            return;
        }
        if (ga == 2) {
            this.moveDirection = 1;
        } else if (ga == 5) {
            this.moveDirection = 2;
        } else if (!this.invertY && ga == 1 || this.invertY && ga == 6) {
            this.moveDirection = 3;
        } else if (!this.invertY && ga == 6 || this.invertY && ga == 1) {
            this.moveDirection = 4;
        } else if (ga == 8 && this.ammo > 0 && this.reloadCounter == 0) {
            this.fireGun = true;
            this.nextSound = "shotgun";
            ++this.shotsFired;
            this.drawMuzzleFlash = 4;
        } else if (ga == 8 && this.ammo == 0 && this.reloadCounter == 0) {
            this.nextSound = "click";
        } else if (keyCode == 49 && this.reloadCounter == 0 && this.ammo < this.ammoMax) {
            this.reloadCounter = this.reloadSpeed;
            this.nextSound = "reload";
        }
    }

    public void keyReleased(int keyCode) {
        if (this.paused || this.gameover) {
            return;
        }
        int ga = this.getGameAction(keyCode);
        if (ga == 2) {
            this.moveDirection = 0;
            this.sightXAcceleration = 0;
            this.autoCentreCounter = this.autoCentreTimeout;
        } else if (ga == 5) {
            this.moveDirection = 0;
            this.sightXAcceleration = 0;
            this.autoCentreCounter = this.autoCentreTimeout;
        } else if (!this.invertY && ga == 1 || this.invertY && ga == 6) {
            this.moveDirection = 0;
            this.sightYAcceleration = 0;
            this.autoCentreCounter = this.autoCentreTimeout;
        } else if (!this.invertY && ga == 6 || this.invertY && ga == 1) {
            this.moveDirection = 0;
            this.sightYAcceleration = 0;
            this.autoCentreCounter = this.autoCentreTimeout;
        }
    }

    public boolean isGameOver() {
        return this.gameover;
    }

    public void doneHighScore(boolean val) {
        this.doneHs = val;
    }

    public boolean doneHighScore() {
        return this.doneHs;
    }

    public boolean isHighScore() {
        return this.displayHighScoreTable;
    }

    public boolean isTextPage() {
        return this.displayTextPage;
    }

    public int getScore() {
        return this.score;
    }

    public int getAccuracy() {
        if (this.shotsFired == 0) {
            return 0;
        }
        return this.shotsOnTarget * 100 / this.shotsFired;
    }

    public void showNotify() {
        this.cleared = false;
    }

    public void hideNotify() {
        if (this.paused) {
            this.paused = true;
            this.cleared = false;
        } else {
            this.pause();
        }
    }

    private int rnd(int v) {
        return Math.abs(this.rand.nextInt() % v);
    }

    public void playerUpdate(Player arg0, String arg1, Object arg2) {
    }
}

