/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenuCanvas
extends Canvas {
    private static final String RESOURCE_FOLDER = "/duckhunt/";
    private static final int GRASS_LAYERS = 2;
    private boolean mRunning;
    private String[] mMenus = new String[]{"New game", "Resume", "Settings", "Instructions", "Exit"};
    private int mSelectedIndex;
    private Image imBtn_nomal;
    private Image imBtn_active;
    private FontRenderer outlineFont;
    private Adubu mDuckHunt;
    private boolean isResume = false;
    private Image skyImage;
    private Image mountainImage;
    private Image bbImage;
    private int groundY;
    private int mountainY;
    private int[] grassX = new int[2];
    private int[] grassY = new int[2];
    private Image[] grassImages = new Image[2];
    private int w;
    private int h;

    public MainMenuCanvas(Adubu duckHunt) {
        this.mDuckHunt = duckHunt;
        this.mSelectedIndex = 0;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.init();
        this.setFullScreenMode(true);
    }

    private void init() {
        try {
            this.imBtn_active = Image.createImage((String)"/duckhunt/btn_active_bg.png");
            this.imBtn_nomal = Image.createImage((String)"/duckhunt/btn_normal_bg.png");
            this.outlineFont = new FontRenderer("/duckhunt/fonts/freon_outline");
            this.outlineFont.setFontSpacing(-1);
            this.skyImage = Image.createImage((String)"/duckhunt/bg.png");
            this.bbImage = Image.createImage((String)"/duckhunt/bb.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void paint(Graphics g) {
        g.drawRect(0, 0, this.w, this.h);
        g.drawImage(this.skyImage, 0, 0, 20);
        g.drawImage(this.bbImage, this.w - this.bbImage.getWidth(), 5, 20);
        int yOffsetMenu = this.bbImage.getHeight();
        for (int i = 0; i < this.mMenus.length; ++i) {
            if (!this.isResume && i == 1) continue;
            if (i == this.mSelectedIndex) {
                g.drawImage(this.imBtn_active, this.w / 2, yOffsetMenu, 17);
            } else {
                g.drawImage(this.imBtn_nomal, this.w / 2, yOffsetMenu, 17);
            }
            this.outlineFont.drawString(g, this.mMenus[i], (this.w - this.outlineFont.stringWidth(this.mMenus[i])) / 2, yOffsetMenu + (this.imBtn_active.getHeight() - 10) / 2);
            yOffsetMenu += this.imBtn_active.getHeight() + 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.mRunning) {
            MainMenuCanvas mainMenuCanvas = this;
            synchronized (mainMenuCanvas) {
                try {
                    this.repaint();
                    this.serviceRepaints();
                    ((Object)((Object)this)).wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int ga = this.getGameAction(keyCode);
        int total = this.isResume ? this.mMenus.length - 1 : this.mMenus.length - 1;
        switch (ga) {
            case 6: {
                if (!this.isResume && this.mSelectedIndex == 0) {
                    ++this.mSelectedIndex;
                }
                this.mSelectedIndex = this.mSelectedIndex >= total ? 0 : this.mSelectedIndex + 1;
                break;
            }
            case 1: {
                if (!this.isResume && this.mSelectedIndex == 2) {
                    --this.mSelectedIndex;
                }
                this.mSelectedIndex = this.mSelectedIndex <= 0 ? total : this.mSelectedIndex - 1;
                break;
            }
            case 8: {
                this.mDuckHunt.goTO(this.mSelectedIndex);
                break;
            }
            default: {
                super.keyPressed(keyCode);
            }
        }
        System.out.println("mse: " + this.mSelectedIndex);
        this.repaint();
    }

    public boolean isResume() {
        return this.isResume;
    }

    public void setResume(boolean isResume) {
        this.isResume = isResume;
    }

    private int rnd(int v) {
        return Math.abs(new Random().nextInt() % v);
    }
}

