/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontRenderer {
    private static final int UPPER_CHARS = 26;
    private static final int LOWER_CHARS = 26;
    private static final int NUMBER_CHARS = 17;
    private static final int SYMBOL_CHARS = 26;
    private int[] upperCharWidths;
    private int[] upperCharOffsets;
    private int[] lowerCharWidths;
    private int[] lowerCharOffsets;
    private int[] numCharWidths;
    private int[] numCharOffsets;
    private int[] symbolCharWidths;
    private int[] symbolCharOffsets;
    private Image fontImage;
    private int fontHeight;
    private int spaceWidth = 4;
    private int fontColour = 0;
    private int fontSpacing = 1;
    private int sourceCharacterSpacing = 1;
    private int baseline = 0;
    private int canvasY = 0;
    private int canvasWidth = 1000;
    private int canvasHeight = 1000;

    public FontRenderer(String res) {
        String dat_res;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
    }

    public FontRenderer(String res, Canvas canv) {
        String dat_res;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
        this.setCanvasDimensions(0, canv.getWidth(), canv.getHeight());
    }

    public FontRenderer(String res, int w, int h) {
        String dat_res;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
        this.setCanvasDimensions(0, w, h);
    }

    public FontRenderer(String res, int spacing) {
        String dat_res;
        this.sourceCharacterSpacing = spacing;
        String png_res = res + ".png";
        if (!png_res.startsWith("/")) {
            png_res = "/" + png_res;
        }
        if (!(dat_res = res + ".dat").startsWith("/")) {
            dat_res = "/" + dat_res;
        }
        this.loadFont(png_res, dat_res);
    }

    public void setCanvasDimensions(int y_offset, int w, int h) {
        this.canvasY = y_offset;
        this.canvasWidth = w;
        this.canvasHeight = h;
    }

    private void loadFont(String res, String dat) {
        int i;
        System.out.println("Loading font " + res + " ...");
        try {
            this.fontImage = Image.createImage((String)res);
        }
        catch (Exception e) {
            System.out.println("Unable to load font resource: " + res);
            return;
        }
        this.baseline = this.fontHeight = this.fontImage.getHeight() - 3 >> 2;
        Vector data = FontRenderer.splitString("\n", this.loadTextResource(dat));
        int startLine = 0;
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector upper = FontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector lower = FontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector nums = FontRenderer.splitString(",", (String)data.elementAt(startLine++));
        while (((String)data.elementAt(startLine)).length() == 0 || ((String)data.elementAt(startLine)).startsWith("#") || ((String)data.elementAt(startLine)).startsWith("$")) {
            if (((String)data.elementAt(startLine)).startsWith("$")) {
                this.parseSetting((String)data.elementAt(startLine));
            }
            ++startLine;
        }
        Vector symbs = FontRenderer.splitString(",", (String)data.elementAt(startLine++));
        this.upperCharWidths = new int[26];
        this.upperCharOffsets = new int[26];
        this.lowerCharWidths = new int[26];
        this.lowerCharOffsets = new int[26];
        this.numCharWidths = new int[17];
        this.numCharOffsets = new int[17];
        this.symbolCharWidths = new int[26];
        this.symbolCharOffsets = new int[26];
        for (i = 0; i < this.upperCharWidths.length; ++i) {
            this.upperCharOffsets[i] = 0;
            this.upperCharWidths[i] = 0;
        }
        for (i = 0; i < this.lowerCharWidths.length; ++i) {
            this.lowerCharOffsets[i] = 0;
            this.lowerCharWidths[i] = 0;
        }
        for (i = 0; i < this.numCharWidths.length; ++i) {
            this.numCharOffsets[i] = 0;
            this.numCharWidths[i] = 0;
        }
        for (i = 0; i < this.symbolCharWidths.length; ++i) {
            this.symbolCharOffsets[i] = 0;
            this.symbolCharWidths[i] = 0;
        }
        Enumeration e = upper.elements();
        int i2 = 0;
        int offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.upperCharWidths.length) {
                System.out.println("Warning: Too many character widths defined for uppercase characters");
                break;
            }
            this.upperCharWidths[i2] = Integer.parseInt((String)e.nextElement());
            this.upperCharOffsets[i2] = offset;
            offset += this.upperCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.upperCharWidths.length) {
            System.out.println("Warning: Missing " + (this.upperCharWidths.length - i2) + " character definitions for uppercase characters");
        }
        e = lower.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.lowerCharWidths.length) {
                System.out.println("Warning: Too many character widths defined for lowercase characters");
                break;
            }
            this.lowerCharWidths[i2] = Integer.parseInt((String)e.nextElement());
            this.lowerCharOffsets[i2] = offset;
            offset += this.lowerCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.numCharWidths.length) {
            System.out.println("Warning: Missing " + (this.lowerCharWidths.length - i2) + " character definitions for lowercase characters");
        }
        e = nums.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.numCharWidths.length) {
                System.out.println("Warning: Too many character widths defined for number characters");
                break;
            }
            this.numCharWidths[i2] = Integer.parseInt((String)e.nextElement());
            this.numCharOffsets[i2] = offset;
            offset += this.numCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.numCharWidths.length) {
            System.out.println("Warning: Missing " + (this.numCharWidths.length - i2) + " character definitions for number characters");
        }
        e = symbs.elements();
        i2 = 0;
        offset = 0;
        while (e.hasMoreElements()) {
            if (i2 >= this.symbolCharWidths.length) {
                System.out.println("Warning: Too many character widths defined for symbol characters");
                break;
            }
            this.symbolCharWidths[i2] = Integer.parseInt((String)e.nextElement());
            this.symbolCharOffsets[i2] = offset;
            offset += this.symbolCharWidths[i2++] + this.sourceCharacterSpacing;
        }
        if (i2 < this.symbolCharWidths.length) {
            System.out.println("Warning: Missing " + (this.symbolCharWidths.length - i2) + " character definitions for symbol characters");
        }
        symbs = null;
        nums = null;
        lower = null;
        upper = null;
        data = null;
        System.gc();
    }

    private void parseSetting(String s) {
        String settingName = "";
        String settingValue = "";
        System.out.println("Parsing setting " + s);
        if (s.startsWith("$")) {
            int eq = (s = s.substring(1)).indexOf("=");
            if (eq >= 0) {
                settingName = s.substring(0, eq).toLowerCase().trim();
                settingValue = s.substring(eq + 1).toLowerCase().trim();
                if (settingName.equals("baseline")) {
                    try {
                        this.baseline = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("colour")) {
                    try {
                        this.fontColour = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("png_character_spacing")) {
                    try {
                        this.sourceCharacterSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                } else if (settingName.equals("font_spacing")) {
                    try {
                        this.fontSpacing = Integer.parseInt(settingValue);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Warning: Illegal integer setting value $" + s);
                    }
                }
            } else {
                System.out.println("Warning: Invalid setting $" + s);
            }
        }
    }

    public int drawString(Graphics g, String s, int x, int y) {
        return this.drawString(g, s, x, y, -1, 0);
    }

    public int drawString(Graphics g, String s, int x, int y, int bgcol) {
        return this.drawString(g, s, x, y, bgcol, 0);
    }

    public int drawString(Graphics g, String s, int x, int y, int bgcol, int wrapWidth) {
        int prevClipX = g.getClipX();
        int prevClipY = g.getClipY();
        int prevClipW = g.getClipWidth();
        int prevClipH = g.getClipHeight();
        int width = 0;
        int lines = 1;
        if (wrapWidth > 0) {
            s = this.wrapString(s, wrapWidth);
        }
        char[] chars = s.toCharArray();
        if (bgcol >= 0) {
            int blankWidth = this.stringWidth(chars);
            g.setColor(bgcol);
            g.fillRect(x, y, blankWidth, this.fontHeight);
        }
        boolean drawChar = true;
        for (int c = 0; c < chars.length; ++c) {
            int offset = chars[c];
            drawChar = true;
            if (x + width > this.canvasWidth || x + width < -15) {
                drawChar = false;
            } else if (y < this.canvasY - this.fontHeight || y > this.canvasY + this.canvasHeight) {
                drawChar = false;
            }
            if (chars[c] == '\n') {
                y += this.fontHeight;
                width = 0;
                ++lines;
                continue;
            }
            if (offset == 32) {
                width += this.spaceWidth;
                continue;
            }
            if (offset >= 33 && offset <= 47) {
                offset -= 33;
                if (drawChar) {
                    g.setClip(x + width, y, this.symbolCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.symbolCharOffsets[offset] + width, y - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset >= 48 && offset <= 64) {
                offset -= 48;
                if (drawChar) {
                    g.setClip(x + width, y, this.numCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.numCharOffsets[offset] + width, y - (this.fontHeight << 1) - 2, 0x10 | 4);
                }
                width += this.numCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset >= 65 && offset <= 90) {
                offset -= 65;
                if (drawChar) {
                    g.setClip(x + width, y, this.upperCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.upperCharOffsets[offset] + width, y, 0x10 | 4);
                }
                width += this.upperCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset >= 91 && offset <= 96) {
                offset = offset - 91 + 15;
                if (drawChar) {
                    g.setClip(x + width, y, this.symbolCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.symbolCharOffsets[offset] + width, y - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset >= 97 && offset <= 122) {
                offset -= 97;
                if (drawChar) {
                    g.setClip(x + width, y, this.lowerCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.lowerCharOffsets[offset] + width, y - this.fontHeight - 1, 0x10 | 4);
                }
                width += this.lowerCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset >= 123 && offset <= 126) {
                offset = offset - 123 + 21;
                if (drawChar) {
                    g.setClip(x + width, y, this.symbolCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.symbolCharOffsets[offset] + width, y - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
                continue;
            }
            if (offset == 163) {
                offset = offset - 163 + 25;
                if (drawChar) {
                    g.setClip(x + width, y, this.symbolCharWidths[offset], this.fontHeight);
                    g.drawImage(this.fontImage, x - this.symbolCharOffsets[offset] + width, y - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                }
                width += this.symbolCharWidths[offset] + this.fontSpacing;
                continue;
            }
            System.out.println("Warning: No symbol for " + chars[c] + " (" + offset + ")");
        }
        g.setClip(prevClipX, prevClipY, prevClipW, prevClipH);
        return lines;
    }

    public int stringWidth(String s) {
        return this.stringWidth(s.toCharArray());
    }

    public int stringWidth(char[] chars) {
        int width = 0;
        int offset = 0;
        try {
            for (int c = chars.length; c != 0; --c) {
                offset = chars[c - 1];
                if (chars[c - 1] == '[') {
                    System.out.println("offset[" + offset);
                }
                if (offset == 32) {
                    width += this.spaceWidth;
                    continue;
                }
                if (offset >= 33 && offset <= 47) {
                    width += this.symbolCharWidths[offset -= 33] + this.fontSpacing;
                    continue;
                }
                if (offset >= 48 && offset <= 64) {
                    width += this.numCharWidths[offset -= 48] + this.fontSpacing;
                    continue;
                }
                if (offset >= 65 && offset <= 90) {
                    width += this.upperCharWidths[offset -= 65] + this.fontSpacing;
                    continue;
                }
                if (offset >= 91 && offset <= 96) {
                    offset = offset - 91 + 15;
                    width += this.symbolCharWidths[offset] + this.fontSpacing;
                    continue;
                }
                if (offset >= 97 && offset <= 122) {
                    width += this.lowerCharWidths[offset -= 97] + this.fontSpacing;
                    continue;
                }
                if (offset >= 123 && offset <= 126) {
                    offset = offset - 123 + 21;
                    width += this.symbolCharWidths[offset] + this.fontSpacing;
                    continue;
                }
                if (offset != 163) continue;
                offset = offset - 163 + 25;
                width += this.symbolCharWidths[offset] + this.fontSpacing;
            }
        }
        catch (Exception e) {
            System.out.println("offset=" + offset);
        }
        return width;
    }

    public int charWidth(char c) {
        int width = 0;
        int offset = c;
        if (offset == 32) {
            width = this.spaceWidth;
        } else if (offset >= 33 && offset <= 47) {
            width = this.symbolCharWidths[offset -= 33] + this.fontSpacing;
        } else if (offset >= 48 && offset <= 64) {
            width = this.numCharWidths[offset -= 48] + this.fontSpacing;
        } else if (offset >= 65 && offset <= 90) {
            width = this.upperCharWidths[offset -= 65] + this.fontSpacing;
        } else if (offset >= 91 && offset <= 96) {
            offset = offset - 91 + 15;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        } else if (offset >= 97 && offset <= 122) {
            width = this.lowerCharWidths[offset -= 97] + this.fontSpacing;
        } else if (offset >= 123 && offset <= 126) {
            offset = offset - 123 + 21;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        } else if (offset == 163) {
            offset = offset - 163 + 25;
            width = this.symbolCharWidths[offset] + this.fontSpacing;
        }
        return width;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public void setFontSpacing(int v) {
        this.fontSpacing = v;
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public void setSpaceWidth(int v) {
        this.spaceWidth = v;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    private String loadTextResource(String res) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream is = null;
            is = this.getClass().getResourceAsStream(res);
            if (is != null) {
                int chr;
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                is.close();
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load text resource: " + res);
            return "";
        }
        return sb.toString();
    }

    public static Vector splitString(String c, String text) {
        int length;
        Vector<String> lines = new Vector<String>();
        for (int i = length = text.trim().length(); i != 0; --i) {
            int num = text.indexOf(c);
            if (num < 0) {
                lines.addElement(text);
                break;
            }
            lines.addElement(text.substring(0, num));
            text = text.substring(num + c.length(), text.length());
        }
        return lines;
    }

    private String arrayToString(int[] arr) {
        StringBuffer sb = new StringBuffer("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(arr[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public String wrapString(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        Vector lines = FontRenderer.splitString("\n", s);
        int lsize = lines.size();
        for (int i = 0; i < lsize; ++i) {
            Vector words = FontRenderer.splitString(" ", ((String)lines.elementAt(i)).trim());
            int lineWidth = 0;
            int wsize = words.size();
            for (int j = 0; j < wsize; ++j) {
                String word = (String)words.elementAt(j);
                int wordWidth = this.stringWidth(word);
                if (lineWidth + 4 + wordWidth >= w) {
                    wrapped.append('\n');
                    if (wordWidth > w) {
                        wrapped.append(this.wrapWord(word, w));
                        lineWidth = this.stringWidth(this.wrapWord(word, w));
                        continue;
                    }
                    wrapped.append((String)words.elementAt(j));
                    lineWidth = wordWidth;
                    continue;
                }
                if (lineWidth > 0) {
                    wrapped.append(' ');
                    lineWidth += 4;
                }
                wrapped.append((String)words.elementAt(j));
                lineWidth += wordWidth;
            }
            wrapped.append("\n");
        }
        return wrapped.toString();
    }

    public Vector wrapStringToVector(String s, int w) {
        return FontRenderer.splitString("\n", this.wrapString(s, w));
    }

    private String wrapWord(String s, int w) {
        StringBuffer wrapped = new StringBuffer("");
        int dashWidth = this.charWidth('-');
        int wordWidth = 0;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            int cWidth = this.charWidth(c);
            if (wordWidth + dashWidth + this.charWidth(c) > w) {
                wrapped.append('-');
                wrapped.append('\n');
                wrapped.append(c);
                wordWidth = cWidth;
                continue;
            }
            wrapped.append(c);
            wordWidth += cWidth;
        }
        return wrapped.toString();
    }

    public void purge() {
        this.fontImage = null;
        this.upperCharWidths = null;
        this.upperCharOffsets = null;
        this.lowerCharWidths = null;
        this.lowerCharOffsets = null;
        this.numCharWidths = null;
        this.numCharOffsets = null;
        this.symbolCharWidths = null;
        this.symbolCharOffsets = null;
    }
}

