/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundManager
implements Runnable {
    private String cachedSoundRes = "";
    private String soundRes = "";
    private String soundMimeType = "audio/x-wav";
    private int loop;
    private Player p = null;
    private Thread t = null;
    private InputStream[] cachedSoundStreams;
    private boolean interrupted = false;
    private boolean cachedPlayMode = false;
    private int cacheIndex = 0;

    public void run() {
        block10: {
            try {
                if (this.cachedPlayMode) {
                    this.cachedSoundStreams[this.cacheIndex].reset();
                    this.p = Manager.createPlayer((InputStream)this.cachedSoundStreams[this.cacheIndex], (String)this.soundMimeType);
                    this.p.realize();
                    this.p.start();
                    while (!this.interrupted) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception ex) {}
                    }
                } else {
                    this.createPlayer();
                    this.p.realize();
                    this.p.start();
                    while (!this.interrupted) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            catch (Exception e) {
                if (this.p == null) break block10;
                this.p.close();
                this.p = null;
            }
        }
    }

    private void createPlayer() {
        block2: {
            try {
                InputStream is = this.getClass().getResourceAsStream(this.soundRes);
                this.p = Manager.createPlayer((InputStream)is, (String)this.soundMimeType);
                this.p.setLoopCount(this.loop);
            }
            catch (Exception e) {
                if (this.p == null) break block2;
                this.p.close();
                this.p = null;
            }
        }
    }

    private void killPlayer() {
        try {
            this.interrupted = true;
            this.t = null;
            Thread.sleep(50L);
            if (this.p != null) {
                this.p.stop();
                this.p.close();
                this.p = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound() {
        this.killPlayer();
    }

    public void cacheSounds(String[] res) throws IOException {
        this.cachedSoundStreams = new InputStream[res.length];
        for (int i = 0; i < res.length; ++i) {
            this.cachedSoundStreams[i] = this.getClass().getResourceAsStream(res[i]);
            if (this.cachedSoundStreams[i] == null) {
                throw new IOException("Unable to cache sound " + res[i]);
            }
            this.cachedSoundStreams[i].mark(999999);
        }
    }

    public void playSound(String r) {
        this.killPlayer();
        this.soundRes = r;
        this.interrupted = false;
        this.cachedPlayMode = false;
        this.t = new Thread(this);
        this.t.start();
    }

    public void playSound(String r, int loopCount, String type) {
        this.killPlayer();
        this.soundRes = r;
        this.interrupted = false;
        this.cachedPlayMode = false;
        this.setLoopCount(loopCount);
        this.setSoundMimeType(type);
        this.t = new Thread(this);
        this.t.start();
    }

    public void playSound(int i) throws ArrayIndexOutOfBoundsException {
        this.killPlayer();
        this.interrupted = false;
        this.cachedPlayMode = true;
        this.cacheIndex = i;
        if (i > this.cachedSoundStreams.length || i < 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal cached sound index " + i + ">=" + this.cachedSoundStreams.length);
        }
        this.t = new Thread(this);
        this.t.start();
    }

    public void setSoundMimeType(String type) {
        this.soundMimeType = type;
    }

    public String getSoundMimeType(String type) {
        return this.soundMimeType;
    }

    public void setLoopCount(int loopCount) {
        this.loop = loopCount;
    }
}

