/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordManager {
    public static void save(byte[] arr, String name) throws RecordStoreException {
        RecordStore recstor = null;
        try {
            recstor = RecordStore.openRecordStore((String)name, (boolean)true);
            recstor.setRecord(1, arr, 0, arr.length);
            recstor.closeRecordStore();
        }
        catch (InvalidRecordIDException idex) {
            try {
                recstor = RecordStore.openRecordStore((String)name, (boolean)true);
                recstor.addRecord(arr, 0, arr.length);
                recstor.closeRecordStore();
            }
            catch (RecordStoreFullException rsfe) {
                throw new RecordStoreException("RecordStore full trying to save " + name + "\n\n" + rsfe.toString());
            }
            catch (RecordStoreNotFoundException rsnfe) {
                throw new RecordStoreException("RecordStore not found trying to save " + name + "\n\n" + rsnfe.toString());
            }
            catch (RecordStoreNotOpenException rsnoe) {
                throw new RecordStoreException("RecordStore not open trying to save " + name + "\n\n" + rsnoe.toString());
            }
            finally {
                try {
                    recstor.closeRecordStore();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        catch (RecordStoreFullException rsfe) {
            throw new RecordStoreException("RecordStore full trying to update " + name + "\n\n" + rsfe.toString());
        }
        catch (RecordStoreNotFoundException rsnfe) {
            throw new RecordStoreException("RecordStore not found trying to update " + name + "\n\n" + rsnfe.toString());
        }
        catch (RecordStoreNotOpenException rsnoe) {
            throw new RecordStoreException("RecordStore not open trying to update " + name + "\n\n" + rsnoe.toString());
        }
    }

    public static void save(int intval, String name) throws IOException, RecordStoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(intval);
            RecordManager.save(baos.toByteArray(), name);
        }
        catch (RecordStoreException rse) {
            throw rse;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static void save(long longval, String name) throws IOException, RecordStoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeLong(longval);
            RecordManager.save(baos.toByteArray(), name);
        }
        catch (RecordStoreException rse) {
            throw rse;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static void save(String strval, String name) throws IOException, RecordStoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeUTF(strval);
            RecordManager.save(baos.toByteArray(), name);
        }
        catch (RecordStoreException rse) {
            throw rse;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static void save(boolean boolval, String name) throws IOException, RecordStoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeBoolean(boolval);
            RecordManager.save(baos.toByteArray(), name);
        }
        catch (RecordStoreException rse) {
            throw rse;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static byte[] load(String name) throws RecordStoreException {
        byte[] data = null;
        RecordStore recstor = null;
        try {
            recstor = RecordStore.openRecordStore((String)name, (boolean)true);
            if (recstor.getNumRecords() > 0) {
                data = recstor.getRecord(1);
            }
            recstor.closeRecordStore();
        }
        catch (RecordStoreException e) {
            recstor.closeRecordStore();
            throw e;
        }
        return data;
    }

    public static void delete(String name) throws RecordStoreException {
        RecordStore.deleteRecordStore((String)name);
    }

    public static boolean exists(String name) {
        String[] recStores = RecordStore.listRecordStores();
        if (recStores == null) {
            return false;
        }
        for (int i = 0; i < recStores.length; ++i) {
            if (!recStores[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static int byteArrayToInt(byte[] arr) throws IOException {
        if (arr == null) {
            return 0;
        }
        if (arr.length < 4) {
            return 0;
        }
        int val = 0;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        val = is.readInt();
        return val;
    }

    public static long byteArrayToLong(byte[] arr) throws IOException {
        if (arr == null) {
            return 0L;
        }
        long val = 0L;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        val = is.readLong();
        return val;
    }

    public static String byteArrayToString(byte[] arr) throws IOException {
        if (arr == null) {
            return "";
        }
        String val = "";
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        val = is.readUTF();
        return val;
    }

    public static boolean byteArrayToBoolean(byte[] arr) throws IOException {
        if (arr == null) {
            return false;
        }
        boolean val = false;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        val = is.readBoolean();
        return val;
    }
}

