/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Group;
import cocos2d.extensions.cc3d.CC3Mesh;
import cocos2d.extensions.cc3d.CC3Node;
import cocos2d.extensions.cc3d.CC3Vector;
import java.util.Stack;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.World;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CC3Utils {
    private static CC3Vector a = new CC3Vector();
    private static StringBuffer a = new StringBuffer(3);
    private static Stack a = new Stack();

    public static final int GenerateID(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (n3-- > 0) {
            n2 = n2 * 1664525 + 1013904223 + string.charAt(n3);
        }
        return Math.abs(n2) & 0x3FFFFFFF;
    }

    public static CC3Vector RGB2HSV(int n2) {
        float f2;
        float f3;
        float f4 = n2 >> 16 & 0xFF;
        float f5 = n2 >> 8 & 0xFF;
        float f6 = n2 & 0xFF;
        if (f4 > f5) {
            f3 = f5;
            f2 = f4;
        } else {
            f3 = f4;
            f2 = f5;
        }
        if (f6 > f2) {
            f2 = f6;
        }
        if (f6 < f3) {
            f3 = f6;
        }
        if ((f3 = f2 - f3) != 0.0f) {
            f6 = f4 == f2 ? (f5 - f6) / f3 * 60.0f : (f5 == f2 ? (2.0f + (f6 - f4) / f3) * 60.0f : (4.0f + (f4 - f5) / f3) * 60.0f);
            f4 = (int)(f3 / 255.0f * 100.0f);
        } else {
            f6 = 0.0f;
            f4 = 0.0f;
        }
        f5 = f2 * 100.0f;
        a.set(f6, f4, f5);
        return a;
    }

    public static int HSV2RGB(float f2, float f3, float f4) {
        float f5;
        int n2 = (int)(f2 * 6.0f);
        f2 = f2 * 6.0f - (float)n2;
        float f6 = f4 * (1.0f - f3);
        float f7 = f4 * (1.0f - f2 * f3);
        f2 = f4 * (1.0f - (1.0f - f2) * f3);
        switch (n2) {
            default: {
                f3 = f4;
                f5 = f2;
                f2 = f6;
                break;
            }
            case 1: {
                f3 = f7;
                f5 = f4;
                f2 = f6;
                break;
            }
            case 2: {
                f3 = f6;
                f5 = f4;
                break;
            }
            case 3: {
                f3 = f6;
                f5 = f7;
                f2 = f4;
                break;
            }
            case 4: {
                f3 = f2;
                f5 = f6;
                f2 = f4;
                break;
            }
            case 5: {
                f3 = f4;
                f5 = f6;
                f2 = f7;
            }
        }
        return 0xFF000000 | (int)(f3 * 256.0f) << 16 | (int)(f5 * 256.0f) << 8 | (int)(f2 * 256.0f);
    }

    public static StringBuffer getStringBuffer(String string) {
        a.setLength(0);
        a.append(string);
        return a;
    }

    public static String zeroPad(int n2, int n3) {
        a.delete(0, a.length());
        String string = String.valueOf(n2);
        n3 -= string.length();
        while (n3-- > 0) {
            a.append('0');
        }
        a.append(n2);
        return a.toString();
    }

    public static final void bytefill(byte[] byArray, byte n2) {
        int n3 = byArray.length;
        if (n3 > 0) {
            byArray[0] = n2;
        }
        for (n2 = 1; n2 < n3; n2 += n2) {
            System.arraycopy(byArray, 0, byArray, n2, n3 - n2 < n2 ? n3 - n2 : n2);
        }
    }

    public static final void objfill(Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        if (n2 > 0) {
            objectArray[0] = object;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(objectArray, 0, objectArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static final void intfill(int[] nArray, int n2) {
        int n3 = nArray.length;
        if (n3 > 0) {
            nArray[0] = n2;
        }
        for (n2 = 1; n2 < n3; n2 += n2) {
            System.arraycopy(nArray, 0, nArray, n2, n3 - n2 < n2 ? n3 - n2 : n2);
        }
    }

    public static final void floatfill(float[] fArray, float f2) {
        int n2 = fArray.length;
        if (n2 > 0) {
            fArray[0] = f2;
        }
        for (int i2 = 1; i2 < n2; i2 += i2) {
            System.arraycopy(fArray, 0, fArray, i2, n2 - i2 < i2 ? n2 - i2 : i2);
        }
    }

    public static final void charfill(char[] cArray, char n2) {
        int n3 = cArray.length;
        if (n3 > 0) {
            cArray[0] = n2;
        }
        for (n2 = 1; n2 < n3; n2 += n2) {
            System.arraycopy(cArray, 0, cArray, n2, n3 - n2 < n2 ? n3 - n2 : n2);
        }
    }

    public static void printArray(float[] fArray) {
        System.out.println("size: " + fArray.length);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            System.out.print(fArray[i2] + ", ");
        }
        System.out.println(" ");
    }

    public static void printArray(short[] sArray) {
        System.out.println("size: " + sArray.length);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            System.out.print(sArray[i2] + ", ");
        }
        System.out.println(" ");
    }

    public static void printArray(byte[] byArray) {
        System.out.println("size: " + byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            System.out.print(byArray[i2] + ", ");
        }
        System.out.println(" ");
    }

    public static void printArray(int[] nArray) {
        System.out.println("size: " + nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            System.out.print(nArray[i2] + ", ");
        }
        System.out.println(" ");
    }

    public static float scalePolygonsToHighResolution(float[] fArray, short[] sArray) {
        int n2 = fArray.length;
        while (n2-- != 0) {
            sArray[n2] = (short)fArray[n2];
        }
        return 1.0f;
    }

    public static void objectsSharigTexture(Texture2D texture2D, World world, Object3D[] object3DArray) {
        if (texture2D != null) {
            int n2 = 0;
            try {
                while (world.getChildCount() > 0) {
                    Mesh mesh;
                    Node node = world.getChild(0);
                    if (node instanceof Mesh && (mesh = (Mesh)node).getAppearance(0).getTexture(0) != null && texture2D.getUserID() == mesh.getAppearance(0).getTexture(0).getUserID()) {
                        object3DArray[n2++] = mesh;
                    }
                    world.removeChild(node);
                }
                return;
            }
            catch (Exception exception) {
                cocos2d.CCLog("exception enumerating linked objects");
                exception.printStackTrace();
            }
        }
    }

    public static final Object3D loadLinkedObjects(String string, int n2, Object3D[] object3DArray) {
        if (!a.contains(string)) {
            try {
                World world = Loader.load((String)string);
                for (int i2 = 0; i2 < ((Object3D[])world).length; ++i2) {
                    if (!(world[i2] instanceof World)) continue;
                    world = (World)world[i2];
                    Node node = (Node)world.find(n2);
                    world.removeChild(node);
                    if (node instanceof Mesh) {
                        CC3Utils.objectsSharigTexture(((Mesh)node).getAppearance(0).getTexture(0), world, object3DArray);
                    }
                    return node;
                }
            }
            catch (Exception exception) {}
            a.push(string);
        }
        return null;
    }

    public static final Texture2D loadTexture(String string, boolean bl) {
        Texture2D texture2D = null;
        try {
            Image image = Image.createImage((String)string);
            Image2D image2D = new Image2D(bl ? 100 : 99, (Object)image);
            texture2D = new Texture2D(image2D);
        }
        catch (Exception exception) {
            cocos2d.CCLog("cannot load " + string + " as texture because of " + exception.toString());
        }
        return texture2D;
    }

    public static IndexBuffer[] getIndexBuffers(Mesh mesh) {
        IndexBuffer[] indexBufferArray = new IndexBuffer[mesh.getSubmeshCount()];
        for (int i2 = 0; i2 < indexBufferArray.length; ++i2) {
            indexBufferArray[i2] = mesh.getIndexBuffer(i2);
        }
        return indexBufferArray;
    }

    public static int getPolygonCount(CC3Node cC3Node) {
        int n2;
        block3: {
            block2: {
                n2 = 0;
                if (!(cC3Node instanceof CC3Mesh)) break block2;
                IndexBuffer[] indexBufferArray = CC3Utils.getIndexBuffers((Mesh)cC3Node.m3gObject);
                int n3 = indexBufferArray.length;
                while (n3-- != 0) {
                    n2 += indexBufferArray[n3].getIndexCount() / 3;
                }
                break block3;
            }
            if (!(cC3Node instanceof CC3Group)) break block3;
            int n4 = cC3Node.children.size();
            while (n4-- != 0) {
                n2 += CC3Utils.getPolygonCount((CC3Node)cC3Node.children.elementAt(n4));
            }
        }
        return n2;
    }

    public static Appearance[] getAppearances(Mesh mesh) {
        Appearance[] appearanceArray = new Appearance[mesh.getSubmeshCount()];
        for (int i2 = 0; i2 < appearanceArray.length; ++i2) {
            appearanceArray[i2] = (Appearance)mesh.getAppearance(i2).duplicate();
        }
        return appearanceArray;
    }

    public static Appearance[] getAppearancesPointer(Mesh mesh) {
        Appearance[] appearanceArray = new Appearance[mesh.getSubmeshCount()];
        for (int i2 = 0; i2 < appearanceArray.length; ++i2) {
            appearanceArray[i2] = mesh.getAppearance(i2);
        }
        return appearanceArray;
    }

    public static final void fixAppearance(Appearance appearance) {
        CompositingMode compositingMode = appearance.getCompositingMode();
        Material material = appearance.getMaterial();
        if (appearance.getTexture(0) != null) {
            appearance.getPolygonMode().setCulling(160);
            if (compositingMode != null && compositingMode.getBlending() == 64) {
                appearance.setMaterial(null);
                appearance.getTexture(0).setBlending(228);
                appearance.getPolygonMode().setShading(164);
            } else if (material != null) {
                appearance.getTexture(0).setBlending(227);
                appearance.getPolygonMode().setShading(165);
            } else if (material == null) {
                appearance.getTexture(0).setBlending(228);
            }
            appearance.setMaterial(null);
            return;
        }
        appearance.setMaterial(null);
    }

    public static int[] getRawFaces(int[] nArray, int[] nArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2] - 2;
        }
        int[] nArray3 = new int[n2 * 3];
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < nArray.length) {
            int n5 = 0;
            while (n5 < nArray[n3] - 2) {
                int n6;
                int n7 = nArray2[n4];
                int n8 = nArray2[n4 + 1];
                int n9 = n6 = nArray2[n4 + 2];
                int n10 = n7;
                int n11 = n8;
                if (!(n10 == n11 || n10 == n9 || n11 == n9)) {
                    if ((n5 & 1) == 0) {
                        nArray3[n2++] = n7;
                        nArray3[n2++] = n8;
                        nArray3[n2++] = n6;
                    } else {
                        nArray3[n2++] = n6;
                        nArray3[n2++] = n8;
                        nArray3[n2++] = n7;
                    }
                }
                ++n5;
                ++n4;
            }
            ++n3;
            n4 += 2;
        }
        int[] nArray4 = new int[n2];
        System.arraycopy(nArray3, 0, nArray4, 0, n2);
        return nArray4;
    }
}

