/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Math;
import cocos2d.extensions.cc3d.CC3Utils;
import cocos2d.extensions.cc3d.CC3Vector;

public class CC4Vector {
    public float x;
    public float y;
    public float z;
    public float w;

    public static CC4Vector fromString(String string) {
        CC4Vector cC4Vector = new CC4Vector();
        cC4Vector.set(string);
        return cC4Vector;
    }

    public CC4Vector(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public CC4Vector(CC3Vector cC3Vector) {
        this.x = cC3Vector.x;
        this.y = cC3Vector.y;
        this.z = cC3Vector.z;
        this.w = 1.0f;
    }

    public CC4Vector(CC4Vector cC4Vector) {
        this.x = cC4Vector.x;
        this.y = cC4Vector.y;
        this.z = cC4Vector.z;
        this.w = cC4Vector.w;
    }

    public CC4Vector() {
    }

    public void swap(CC4Vector cC4Vector) {
        float f2 = this.x;
        this.x = cC4Vector.x;
        cC4Vector.x = f2;
        f2 = this.y;
        this.y = cC4Vector.y;
        cC4Vector.y = f2;
        f2 = this.z;
        this.z = cC4Vector.z;
        cC4Vector.z = f2;
        f2 = this.w;
        this.w = cC4Vector.w;
        cC4Vector.w = f2;
    }

    public void setAngleAxis(float f2, float f3, float f4, float f5) {
        double d2 = Math.sin(f2 / 2.0f);
        this.x = (float)((double)f3 * d2);
        this.y = (float)((double)f4 * d2);
        this.z = (float)((double)f5 * d2);
        this.w = (float)Math.cos(f2 / 2.0f);
    }

    public void set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public void set(CC4Vector cC4Vector) {
        this.x = cC4Vector.x;
        this.y = cC4Vector.y;
        this.z = cC4Vector.z;
        this.w = cC4Vector.w;
    }

    public void set(String stringArray) {
        stringArray = stringArray.substring(1, stringArray.length() - 2);
        stringArray = cocos2d.split((String)stringArray, ",");
        this.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]));
    }

    public boolean isEqual(CC4Vector cC4Vector) {
        return cC4Vector.x == this.x && cC4Vector.y == this.y && cC4Vector.z == this.z && cC4Vector.w == this.w;
    }

    public boolean isEqual(float f2, float f3, float f4) {
        return this.x == f2 && this.y == f3 && this.z == f4;
    }

    public CC4Vector copy() {
        return new CC4Vector(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return CC3Utils.getStringBuffer("[").append(this.x).append(',').append(this.y).append(',').append(this.z).append(',').append(this.w).append(']').toString();
    }

    public String toShortString() {
        return CC3Utils.getStringBuffer("[").append(CC3Math.shortenFloat(this.x)).append(',').append(CC3Math.shortenFloat(this.y)).append(',').append(CC3Math.shortenFloat(this.z)).append(',').append(CC3Math.shortenFloat(this.w)).append(']').toString();
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public final float lengthFast() {
        return (float)CC3Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public final void mul(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }

    public final void div(float f2) {
        this.x /= f2;
        this.y /= f2;
        this.z /= f2;
        this.w /= f2;
    }

    public final void add(CC4Vector cC4Vector) {
        this.x += cC4Vector.x;
        this.y += cC4Vector.y;
        this.z += cC4Vector.z;
        this.w += cC4Vector.w;
    }

    public final void setAdd(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        this.x = cC4Vector.x + cC4Vector2.x;
        this.y = cC4Vector.y + cC4Vector2.y;
        this.z = cC4Vector.z + cC4Vector2.z;
        this.w = cC4Vector.w + cC4Vector2.w;
    }

    public final void sub(CC4Vector cC4Vector) {
        this.x -= cC4Vector.x;
        this.y -= cC4Vector.y;
        this.z -= cC4Vector.z;
        this.w -= cC4Vector.w;
    }

    public final void setSub(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        this.x = cC4Vector.x - cC4Vector2.x;
        this.y = cC4Vector.y - cC4Vector2.y;
        this.z = cC4Vector.z - cC4Vector2.z;
        this.w = cC4Vector.w - cC4Vector2.w;
    }

    public final float dot(CC4Vector cC4Vector) {
        return this.x * cC4Vector.x + this.y * cC4Vector.y + this.z * cC4Vector.z + this.w * cC4Vector.w;
    }

    public final void setCross(CC4Vector cC4Vector, CC4Vector cC4Vector2) {
        this.x = cC4Vector.y * cC4Vector2.z - cC4Vector.z * cC4Vector2.y;
        this.y = cC4Vector.z * cC4Vector2.x - cC4Vector.x * cC4Vector2.z;
        this.z = cC4Vector.x * cC4Vector2.y - cC4Vector.y * cC4Vector2.x;
        this.w = 0.0f;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public final void normalize() {
        float f2 = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }

    public final void normalizeFast() {
        float f2 = (float)(1.0 / CC3Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w));
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.w *= f2;
    }
}

