/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Math;
import cocos2d.extensions.cc3d.CC3Utils;
import cocos2d.extensions.cc3d.CC4Vector;

public class CC3Vector {
    public float x;
    public float y;
    public float z;

    public static CC3Vector fromString(String string) {
        CC3Vector cC3Vector = new CC3Vector();
        cC3Vector.set(string);
        return cC3Vector;
    }

    public CC3Vector() {
    }

    public CC3Vector(CC3Vector cC3Vector) {
        this.set(cC3Vector);
    }

    public CC3Vector(CC4Vector cC4Vector) {
        this.set(cC4Vector);
    }

    public CC3Vector(float f2, float f3, float f4) {
        this.set(f2, f3, f4);
    }

    public void set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void set(String stringArray) {
        stringArray = cocos2d.split(stringArray.substring(1, stringArray.length() - 1), ",");
        this.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    public void swap(CC3Vector cC3Vector) {
        float f2 = this.x;
        this.x = cC3Vector.x;
        cC3Vector.x = f2;
        f2 = this.y;
        this.y = cC3Vector.y;
        cC3Vector.y = f2;
        f2 = this.z;
        this.z = cC3Vector.z;
        cC3Vector.z = f2;
    }

    public void set(CC3Vector cC3Vector) {
        this.x = cC3Vector.x;
        this.y = cC3Vector.y;
        this.z = cC3Vector.z;
    }

    public void set(CC4Vector cC4Vector) {
        this.x = cC4Vector.x;
        this.y = cC4Vector.y;
        this.z = cC4Vector.z;
    }

    public boolean isEqual(CC3Vector cC3Vector) {
        return cC3Vector.x == this.x && cC3Vector.y == this.y && cC3Vector.z == this.z;
    }

    public boolean isEqual(float f2, float f3, float f4) {
        return this.x == f2 && this.y == f3 && this.z == f4;
    }

    public CC3Vector copy() {
        return new CC3Vector(this.x, this.y, this.z);
    }

    public String toString() {
        return CC3Utils.getStringBuffer("[").append(this.x).append(',').append(this.y).append(',').append(this.z).append(']').toString();
    }

    public void project(float[] fArray) {
        float f2 = 1.0f / (this.x * fArray[12] + this.y * fArray[13] + this.z * fArray[14] + fArray[15]);
        this.set((this.x * fArray[0] + this.y * fArray[1] + this.z * fArray[2] + fArray[3]) * f2, (this.x * fArray[4] + this.y * fArray[5] + this.z * fArray[6] + fArray[7]) * f2, (this.x * fArray[8] + this.y * fArray[9] + this.z * fArray[10] + fArray[11]) * f2);
    }

    public String toShortString() {
        return CC3Utils.getStringBuffer("[").append(CC3Math.shortenFloat(this.x)).append(',').append(CC3Math.shortenFloat(this.y)).append(',').append(CC3Math.shortenFloat(this.z)).append(']').toString();
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final float lengthFast() {
        return (float)CC3Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final void mul(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
    }

    public final void div(float f2) {
        this.x /= f2;
        this.y /= f2;
        this.z /= f2;
    }

    public final void add(CC3Vector cC3Vector) {
        this.x += cC3Vector.x;
        this.y += cC3Vector.y;
        this.z += cC3Vector.z;
    }

    public final void setAdd(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        this.x = cC3Vector.x + cC3Vector2.x;
        this.y = cC3Vector.y + cC3Vector2.y;
        this.z = cC3Vector.z + cC3Vector2.z;
    }

    public final void add(float f2, float f3, float f4) {
        this.x += f2;
        this.y += f3;
        this.z += f4;
    }

    public final void sub(CC3Vector cC3Vector) {
        this.x -= cC3Vector.x;
        this.y -= cC3Vector.y;
        this.z -= cC3Vector.z;
    }

    public final void setSub(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        this.x = cC3Vector.x - cC3Vector2.x;
        this.y = cC3Vector.y - cC3Vector2.y;
        this.z = cC3Vector.z - cC3Vector2.z;
    }

    public final float dot(CC3Vector cC3Vector) {
        return this.x * cC3Vector.x + this.y * cC3Vector.y + this.z * cC3Vector.z;
    }

    public final void setCross(CC3Vector cC3Vector, CC3Vector cC3Vector2) {
        this.x = cC3Vector.y * cC3Vector2.z - cC3Vector.z * cC3Vector2.y;
        this.y = cC3Vector.z * cC3Vector2.x - cC3Vector.x * cC3Vector2.z;
        this.z = cC3Vector.x * cC3Vector2.y - cC3Vector.y * cC3Vector2.x;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void normalize() {
        double d2;
        double d3 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d2 > 1.0E-6) {
            d3 = 1.0 / Math.sqrt(d3);
            this.x = (float)((double)this.x * d3);
            this.y = (float)((double)this.y * d3);
            this.z = (float)((double)this.z * d3);
        }
    }

    public final void normalizeFast() {
        double d2;
        double d3 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (d2 > 1.0E-6) {
            d3 = 1.0 / CC3Math.sqrt(d3);
            this.x = (float)((double)this.x * d3);
            this.y = (float)((double)this.y * d3);
            this.z = (float)((double)this.z * d3);
        }
    }
}

