/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D.util;

public class FXVector {
    public int xFX = 0;
    public int yFX = 0;
    private static FXVector a = new FXVector();
    private static FXVector b = new FXVector();
    public static final FXVector M_UNITY = new FXVector(4096, 0);

    public FXVector() {
    }

    public FXVector(int n2, int n3) {
        this.xFX = n2;
        this.yFX = n3;
    }

    public FXVector(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public static FXVector newVector(int n2, int n3) {
        return new FXVector(n2 << 12, n3 << 12);
    }

    public final void assign(FXVector fXVector) {
        this.xFX = fXVector.xFX;
        this.yFX = fXVector.yFX;
    }

    public final void assignFX(int n2, int n3) {
        this.xFX = n2;
        this.yFX = n3;
    }

    public final void assignDiff(FXVector fXVector, FXVector fXVector2) {
        this.xFX = fXVector.xFX - fXVector2.xFX;
        this.yFX = fXVector.yFX - fXVector2.yFX;
    }

    public final void assignScaledFX(FXVector fXVector, long l2) {
        this.xFX = (int)(l2 * (long)fXVector.xFX >> 12);
        this.yFX = (int)(l2 * (long)fXVector.yFX >> 12);
    }

    public boolean equals(Object object) {
        if (object instanceof FXVector) {
            return this.xFX == ((FXVector)object).xFX && this.yFX == ((FXVector)object).yFX;
        }
        return false;
    }

    public final void add(FXVector fXVector) {
        this.xFX += fXVector.xFX;
        this.yFX += fXVector.yFX;
    }

    public final void add(FXVector fXVector, long l2) {
        this.xFX += (int)(l2 * (long)fXVector.xFX >> 12);
        this.yFX += (int)(l2 * (long)fXVector.yFX >> 12);
    }

    public final void addFX(int n2, int n3, long l2) {
        this.xFX += (int)(l2 * (long)n2 >> 12);
        this.yFX += (int)(l2 * (long)n3 >> 12);
    }

    public final void add2FX(FXVector fXVector, long l2) {
        this.xFX += (int)(l2 * (long)fXVector.xFX >> 24);
        this.yFX += (int)(l2 * (long)fXVector.yFX >> 24);
    }

    public final void subtract(FXVector fXVector) {
        this.xFX -= fXVector.xFX;
        this.yFX -= fXVector.yFX;
    }

    public final void multFX(long l2) {
        this.xFX = (int)(l2 * (long)this.xFX >> 12);
        this.yFX = (int)(l2 * (long)this.yFX >> 12);
    }

    public final void mult(int n2) {
        this.xFX *= n2;
        this.yFX *= n2;
    }

    public final FXVector timesFX(long l2) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = (int)(l2 * (long)this.xFX >> 12);
        fXVector.yFX = (int)(l2 * (long)this.yFX >> 12);
        return fXVector;
    }

    public final FXVector times(int n2) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = this.xFX * n2;
        fXVector.yFX = this.yFX * n2;
        return fXVector;
    }

    public final FXVector dividedByFX(int n2) {
        FXVector fXVector = new FXVector();
        new FXVector().xFX = (int)(((long)this.xFX << 12) / (long)n2);
        fXVector.yFX = (int)(((long)this.yFX << 12) / (long)n2);
        return fXVector;
    }

    public final void divideByFX(int n2) {
        this.xFX = (int)(((long)this.xFX << 12) / (long)n2);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n2);
    }

    public final void divideBy(int n2) {
        this.xFX /= n2;
        this.yFX /= n2;
    }

    public final void transpose() {
        this.xFX ^= this.yFX;
        this.yFX = this.xFX ^ this.yFX;
        this.xFX ^= this.yFX;
    }

    public final void turnRight() {
        int n2 = this.xFX;
        this.xFX = this.yFX;
        this.yFX = -n2;
    }

    public final int lengthSquare() {
        return (int)((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX >> 24);
    }

    public final int lengthSquareFX() {
        return (int)((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX >> 12);
    }

    public final int lengthFX() {
        int n2;
        int n3 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n4 = n2 = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n3 < n2) {
            n3 ^= n2;
            n2 = n3 ^ n2;
            n3 ^= n2;
        }
        if ((n3 = n3 - (n3 >> 5) - (n3 >> 7) + ((n2 += n2 >> 1) >> 2) + (n2 >> 6)) == 0) {
            return 0;
        }
        return (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n3 + (long)n3) >> 1;
    }

    public final int preciseLengthFX() {
        int n2;
        int n3 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n4 = n2 = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n3 < n2) {
            n3 ^= n2;
            n2 = n3 ^ n2;
            n3 ^= n2;
        }
        if ((n3 = n3 - (n3 >> 5) - (n3 >> 7) + ((n2 += n2 >> 1) >> 2) + (n2 >> 6)) == 0) {
            return 0;
        }
        n3 = (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n3 + (long)n3) >> 1;
        return (int)(((long)this.xFX * (long)this.xFX + (long)this.yFX * (long)this.yFX) / (long)n3 + (long)n3) >> 1;
    }

    public static final int fastLengthFX(int n2, int n3) {
        n2 = n2 < 0 ? -n2 : n2;
        int n4 = n3 = n3 < 0 ? -n3 : n3;
        if (n2 < n3) {
            n2 ^= n3;
            n3 = n2 ^ n3;
            n2 ^= n3;
        }
        n3 += n3 >> 1;
        return n2 - (n2 >> 5) - (n2 >> 7) + (n3 >> 2) + (n3 >> 6);
    }

    public final int fastLengthFX() {
        int n2;
        int n3 = this.xFX < 0 ? -this.xFX : this.xFX;
        int n4 = n2 = this.yFX < 0 ? -this.yFX : this.yFX;
        if (n3 < n2) {
            n3 ^= n2;
            n2 = n3 ^ n2;
            n3 ^= n2;
        }
        n2 += n2 >> 1;
        return n3 - (n3 >> 5) - (n3 >> 7) + (n2 >> 2) + (n2 >> 6);
    }

    public final int distFX(FXVector fXVector) {
        a.assignDiff(fXVector, this);
        return a.lengthFX();
    }

    public final void normalize() {
        int n2 = this.lengthFX();
        if (n2 == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n2);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n2);
    }

    public final void normalizePrecise() {
        int n2 = this.preciseLengthFX();
        if (n2 == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n2);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n2);
    }

    public final void normalizeFast() {
        int n2 = this.fastLengthFX();
        if (n2 == 0) {
            return;
        }
        this.xFX = (int)(((long)this.xFX << 12) / (long)n2);
        this.yFX = (int)(((long)this.yFX << 12) / (long)n2);
    }

    public final long dotFX(FXVector fXVector) {
        return (long)this.xFX * (long)fXVector.xFX + (long)this.yFX * (long)fXVector.yFX >> 12;
    }

    public final long crossFX(FXVector fXVector) {
        return (long)this.xFX * (long)fXVector.yFX - (long)this.yFX * (long)fXVector.xFX >> 12;
    }

    public final void crossScalarFX(long l2) {
        long l3 = this.xFX;
        this.xFX = (int)(l2 * (long)this.yFX >> 12);
        this.yFX = -((int)(l2 * l3 >> 12));
    }

    public final void crossScalar2FX(long l2) {
        long l3 = this.xFX;
        this.xFX = (int)(l2 * (long)this.yFX >> 24);
        this.yFX = -((int)(l2 * l3 >> 24));
    }

    public final int distanceFX(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, int n2) {
        a.assignDiff(this, fXVector);
        long l2 = (long)FXVector.a.xFX * (long)fXVector3.xFX + (long)FXVector.a.yFX * (long)fXVector3.yFX >> 12;
        if (l2 < 0L) {
            return Integer.MAX_VALUE;
        }
        if (l2 > (long)n2) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs((long)FXVector.a.xFX * (long)fXVector3.yFX - (long)FXVector.a.yFX * (long)fXVector3.xFX >> 12);
    }

    public final int distanceFX(FXVector fXVector, FXVector fXVector2) {
        b.assignDiff(fXVector2, fXVector);
        b.normalize();
        return this.distanceFX(fXVector, fXVector2, b, fXVector.distFX(fXVector2));
    }

    public final boolean leftOf(FXVector fXVector, FXVector fXVector2) {
        a.assignDiff(fXVector2, fXVector);
        b.assignDiff(this, fXVector);
        return (long)FXVector.a.xFX * (long)FXVector.b.yFX - (long)FXVector.a.yFX * (long)FXVector.b.xFX >> 12 > 0L;
    }

    public static boolean intersect(FXVector fXVector, FXVector fXVector2, FXVector fXVector3, FXVector fXVector4, FXVector fXVector5) {
        FXVector fXVector6 = a;
        FXVector fXVector7 = b;
        fXVector6.assignDiff(fXVector2, fXVector);
        fXVector7.assignDiff(fXVector4, fXVector3);
        long l2 = (long)fXVector7.xFX * (long)fXVector6.yFX - (long)fXVector7.yFX * (long)fXVector6.xFX >> 12;
        if (l2 == 0L) {
            return false;
        }
        long l3 = ((long)fXVector.xFX * (long)fXVector6.yFX - (long)fXVector.yFX * (long)fXVector6.xFX >> 12) - fXVector3.crossFX(fXVector6);
        long l4 = ((long)fXVector.xFX * (long)fXVector7.yFX - (long)fXVector.yFX * (long)fXVector7.xFX >> 12) - fXVector3.crossFX(fXVector7);
        if (l2 > 0L && (l3 < -l2 || l3 > l2 || l4 < -l2 || l4 > l2) || l2 < 0L && (l3 > -l2 || l3 < l2 || l4 > -l2 || l4 < l2)) {
            return false;
        }
        int n2 = fXVector.xFX + (int)(l4 * (long)fXVector6.xFX / l2);
        int n3 = fXVector3.xFX + (int)(l3 * (long)fXVector7.xFX / l2);
        fXVector5.xFX = (n2 + n3) / 2;
        n2 = fXVector.yFX + (int)(l4 * (long)fXVector6.yFX / l2);
        n3 = fXVector3.yFX + (int)(l3 * (long)fXVector7.yFX / l2);
        fXVector5.yFX = (n2 + n3) / 2;
        return true;
    }

    public final void maxFX(int n2) {
        this.xFX = Math.max(this.xFX, n2);
        this.yFX = Math.max(this.yFX, n2);
    }

    public final void minFX(int n2) {
        this.xFX = Math.min(this.xFX, n2);
        this.yFX = Math.min(this.yFX, n2);
    }

    public final void max(FXVector fXVector) {
        this.xFX = Math.max(this.xFX, fXVector.xFX);
        this.yFX = Math.max(this.yFX, fXVector.yFX);
    }

    public final void min(FXVector fXVector) {
        this.xFX = Math.min(this.xFX, fXVector.xFX);
        this.yFX = Math.min(this.yFX, fXVector.yFX);
    }

    public final boolean isInRect(FXVector fXVector, FXVector fXVector2) {
        return this.xFX >= fXVector.xFX && this.yFX >= fXVector.yFX && this.xFX <= fXVector2.xFX && this.yFX <= fXVector2.yFX;
    }

    public final int xAsInt() {
        if (this.xFX >= 0) {
            return this.xFX >> 12;
        }
        return this.xFX + 4096 - 1 >> 12;
    }

    public final int yAsInt() {
        if (this.yFX >= 0) {
            return this.yFX >> 12;
        }
        return this.yFX + 4096 - 1 >> 12;
    }
}

