/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.tokyodrift;

import at.emini.physics2D.Body;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXUtil;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import cocos2d.cocos2d;
import cocos2d.types.CCPoint;
import com.kitmaker.tokyodrift.shapeData;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class PhysicsWorld
extends World {
    private CCPoint a = CCPoint.zero();

    public PhysicsWorld() {
    }

    private PhysicsWorld(World world) {
        super(world);
    }

    public void fastForward(int n2) {
        int n3 = FXUtil.toFX(50) / 1000;
        this.setTimestepFX(n3);
        n2 = n2 * 1000 / 50;
        System.out.println("fast forward " + n2 + " frames");
        while (n2-- != 0) {
            this.tick();
        }
    }

    public static PhysicsWorld loadLevel(String string) {
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        return new PhysicsWorld(PhysicsWorld.loadWorld(new PhysicsFileReader(string), new shapeData()));
    }

    public static shapeData getShapeData(Object object) {
        return (shapeData)((Body)object).getUserData();
    }

    public void removeBody(Body body) {
        if (body != null) {
            super.removeBody(body);
        }
    }

    public void clearWorld() {
        while (this.getBodyCount() > 0) {
            Body body = this.getBodies()[0];
            body.setDynamic(false);
            body.setInteracting(false);
            body.forceUpdate(FXUtil.toFX(1));
            this.removeBody(body);
        }
        while (this.getConstraintCount() > 0) {
            this.removeConstraint(this.getConstraints()[0]);
        }
        this.setLandscape(new Landscape());
        ((Vector)((Object)this.a)).removeAllElements();
    }

    public void draw(Graphics graphics, int n2, int n3) {
        int n4 = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        graphics.setColor(-1);
        graphics.setClip(0, -cocos2d.SCREEN_HEIGHT, n3, n3);
        graphics.fillRect(0, -cocos2d.SCREEN_HEIGHT, n3, n3);
        graphics.setColor(0, 0, 0);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            int n6 = n2;
            Body body = bodyArray[n3];
            Graphics graphics2 = graphics;
            PhysicsWorld physicsWorld = this;
            FXVector[] fXVectorArray = body.getVertices();
            if (fXVectorArray.length == 1) {
                n5 = body.shape().getBoundingRadiusFX() >> 12;
                graphics2.setColor(-16777216);
                graphics2.drawArc(body.positionFX().xAsInt() / n6 - n5 + physicsWorld.a.x, -cocos2d.SCREEN_HEIGHT + body.positionFX().yAsInt() / n6 - n5 + physicsWorld.a.y, n5 << 1, n5 << 1, 0, 360);
                continue;
            }
            graphics2.setColor(-16777216);
            for (n5 = 0; n5 < fXVectorArray.length - 1; ++n5) {
                graphics2.drawLine(fXVectorArray[n5].xAsInt() / n6 + physicsWorld.a.x, -cocos2d.SCREEN_HEIGHT + fXVectorArray[n5].yAsInt() / n6 + physicsWorld.a.y, fXVectorArray[n5 + 1].xAsInt() / n6 + physicsWorld.a.x, -cocos2d.SCREEN_HEIGHT + fXVectorArray[n5 + 1].yAsInt() / n6 + physicsWorld.a.y);
            }
            graphics2.drawLine(fXVectorArray[fXVectorArray.length - 1].xAsInt() / n6 + physicsWorld.a.x, -cocos2d.SCREEN_HEIGHT + fXVectorArray[fXVectorArray.length - 1].yAsInt() / n6 + physicsWorld.a.y, fXVectorArray[0].xAsInt() / n6 + physicsWorld.a.x, -cocos2d.SCREEN_HEIGHT + fXVectorArray[0].yAsInt() / n6 + physicsWorld.a.y);
        }
        Landscape landscape = this.getLandscape();
        graphics.setColor(-16777216);
        for (n4 = 0; n4 < landscape.segmentCount(); ++n4) {
            graphics.drawLine(landscape.startPoint(n4).xAsInt() / n2 + this.a.x, -cocos2d.SCREEN_HEIGHT + landscape.startPoint(n4).yAsInt() / n2 + this.a.y, landscape.endPoint(n4).xAsInt() / n2 + this.a.x, -cocos2d.SCREEN_HEIGHT + landscape.endPoint(n4).yAsInt() / n2 + this.a.y);
        }
    }
}

