/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Math;
import cocos2d.extensions.cc3d.CC3Renderer;
import cocos2d.extensions.cc3d.CC3Transform;
import cocos2d.extensions.cc3d.CC3Vector;
import cocos2d.nodes.CCNode;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;

public class CC3Node
extends CCNode {
    public float cullingSphereRadius = 0.0f;
    public Node m3gObject;
    public final CC3Vector position = new CC3Vector();
    public final CC3Vector scale = new CC3Vector(1.0f, 1.0f, 1.0f);
    public final CC3Vector rotation = new CC3Vector();
    public final CC3Vector upVector = new CC3Vector();
    public final CC3Vector viewVector = new CC3Vector();
    public final CC3Vector sideVector = new CC3Vector();
    public boolean isTransparent = false;
    public CC3Transform objTransform = new CC3Transform();
    private CC3Node a = null;

    public void setScope(int n2) {
        this.m3gObject.setScope(n2);
    }

    public void setAlpha(int n2) {
        this.m3gObject.setAlphaFactor((float)n2 / 255.0f);
        super.setAlpha(n2);
    }

    public void lockViewAt(CC3Node cC3Node) {
        this.a = cC3Node;
    }

    public void unlockView() {
        this.a = null;
    }

    public void setPosition(CC3Vector cC3Vector) {
        this.setPosition(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void setPosition(float f2, float f3, float f4) {
        this.position.set(f2, f3, f4);
        this.objTransform.internalMatrix[3] = f2;
        this.objTransform.internalMatrix[7] = f3;
        this.objTransform.internalMatrix[11] = f4;
        this.objTransform.isUpdated = true;
    }

    public void setScale(float f2) {
        this.setScale(f2, f2, f2);
    }

    public void setScale(int n2) {
        this.setScale(n2, n2, n2);
    }

    public void setScale(float f2, float f3, float f4) {
        this.objTransform.postScale(1.0f / this.scale.x * f2, 1.0f / this.scale.y * f3, 1.0f / this.scale.z * f4);
        this.scale.set(f2, f3, f4);
    }

    public void postScale(float f2, float f3, float f4) {
        this.objTransform.postScale(f2, f3, f4);
        this.scale.x *= f2;
        this.scale.y *= f3;
        this.scale.z *= f4;
    }

    public final void translate(CC3Vector cC3Vector) {
        this.translate(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public final void translate(float f2, float f3, float f4) {
        if (f2 != 0.0f || f3 != 0.0f || f4 != 0.0f) {
            this.objTransform.internalMatrix[3] = this.objTransform.internalMatrix[3] + f2;
            this.objTransform.internalMatrix[7] = this.objTransform.internalMatrix[7] + f3;
            this.objTransform.internalMatrix[11] = this.objTransform.internalMatrix[11] + f4;
            this.objTransform.isUpdated = true;
            this.position.set(this.objTransform.internalMatrix[3], this.objTransform.internalMatrix[7], this.objTransform.internalMatrix[11]);
        }
    }

    public void move(CC3Vector cC3Vector) {
        this.move(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void move(float f2, float f3, float f4) {
        if (f2 != 0.0f || f3 != 0.0f || f4 != 0.0f) {
            this.objTransform.postTranslate(f2, f3, f4);
            this.position.set(this.objTransform.internalMatrix[3], this.objTransform.internalMatrix[7], this.objTransform.internalMatrix[11]);
        }
    }

    public final void setVisible(boolean bl) {
        this.visible = bl;
        this.m3gObject.setRenderingEnable(bl);
    }

    public void setViewVector(float f2, float f3, float f4) {
        if (!this.viewVector.isEqual(f2, f3, f4)) {
            this.upVector.set(0.0f, 1.0f, 0.0f);
            this.viewVector.set(f2, f3, f4);
            this.viewVector.normalizeFast();
            this.sideVector.setCross(this.upVector, this.viewVector);
            this.upVector.setCross(this.viewVector, this.sideVector);
            this.objTransform.internalMatrix[0] = this.sideVector.x * this.scale.x;
            this.objTransform.internalMatrix[1] = this.upVector.x * this.scale.y;
            this.objTransform.internalMatrix[2] = this.viewVector.x * this.scale.z;
            this.objTransform.internalMatrix[4] = this.sideVector.y * this.scale.x;
            this.objTransform.internalMatrix[5] = this.upVector.y * this.scale.y;
            this.objTransform.internalMatrix[6] = this.viewVector.y * this.scale.z;
            this.objTransform.internalMatrix[8] = this.sideVector.z * this.scale.x;
            this.objTransform.internalMatrix[9] = this.upVector.z * this.scale.y;
            this.objTransform.internalMatrix[10] = this.viewVector.z * this.scale.z;
            this.objTransform.isUpdated = true;
            CC3Math.getRotation(this.objTransform.internalMatrix, this.rotation);
        }
    }

    public void setViewVector(float[] fArray) {
        this.setViewVector(fArray[0], fArray[1], fArray[2]);
    }

    public void setViewVector(CC3Vector cC3Vector) {
        this.setViewVector(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void copyTransform(Transform transform) {
        this.objTransform.set(transform);
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.position.set(this.objTransform.internalMatrix[3], this.objTransform.internalMatrix[7], this.objTransform.internalMatrix[11]);
    }

    public void rotate(float f2, float f3, float f4, float f5) {
        if (f3 + f4 + f5 == 1.0f) {
            this.objTransform.postRotateNormalized(f2, f3, f4, f5);
        } else {
            this.objTransform.postRotate(f2, f3, f4, f5);
        }
        this.rotation.x += f2 * f3;
        this.rotation.y += f2 * f4;
        this.rotation.z += f2 * f5;
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
    }

    public void setRotation() {
        this.setRotation(this.rotation.x, this.rotation.y, this.rotation.z);
    }

    public void setRotation(CC3Vector cC3Vector) {
        this.setRotation(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void setRotation(float f2, float f3, float f4) {
        this.rotation.set(f2, f3, f4);
        this.objTransform.setIdentity();
        this.objTransform.postRotateNormalized(f2, 1.0f, 0.0f, 0.0f);
        this.objTransform.postRotateNormalized(f3, 0.0f, 1.0f, 0.0f);
        this.objTransform.postRotateNormalized(f4, 0.0f, 0.0f, 1.0f);
        this.objTransform.internalMatrix[3] = this.position.x;
        this.objTransform.internalMatrix[7] = this.position.y;
        this.objTransform.internalMatrix[11] = this.position.z;
        this.viewVector.set(this.objTransform.internalMatrix[2], this.objTransform.internalMatrix[6], this.objTransform.internalMatrix[10]);
        this.upVector.set(this.objTransform.internalMatrix[1], this.objTransform.internalMatrix[5], this.objTransform.internalMatrix[9]);
        this.sideVector.set(this.objTransform.internalMatrix[0], this.objTransform.internalMatrix[4], this.objTransform.internalMatrix[8]);
        this.objTransform.postScale(this.scale.x, this.scale.y, this.scale.z);
    }

    public final void setLookAt(float f2, float f3, float f4) {
        if (this.position.x == f2 && this.position.z == f4) {
            this.position.x += 1.0E-4f;
        }
        this.setViewVector(this.position.x - f2, this.position.y - f3, this.position.z - f4);
    }

    public final void setLookAt(CC3Vector cC3Vector) {
        this.setLookAt(cC3Vector.x, cC3Vector.y, cC3Vector.z);
    }

    public void update(float f2, CC3Renderer cC3Renderer) {
        if (this.visible) {
            if (this.objTransform.isUpdated) {
                this.m3gObject.setTransform(this.objTransform.getTransform());
                this.objTransform.isUpdated = false;
            }
            if (this.a != null) {
                this.setLookAt(this.a.position);
            }
        }
    }

    public void drawDebug(Graphics graphics, CC3Renderer cC3Renderer) {
        cC3Renderer.drawAxes(graphics, this.viewVector, this.upVector, this.sideVector, this.position);
    }

    public CC3Node duplicate() {
        CC3Node cC3Node = new CC3Node();
        new CC3Node().m3gObject = (Node)this.m3gObject.duplicate();
        cC3Node.isTransparent = this.isTransparent;
        cC3Node.scale.set(this.scale);
        cC3Node.position.set(this.position);
        cC3Node.viewVector.set(this.viewVector);
        cC3Node.sideVector.set(this.sideVector);
        cC3Node.upVector.set(this.upVector);
        cC3Node.objTransform.set(this.objTransform);
        return cC3Node;
    }

    public String toString() {
        String[] stringArray = super.toString();
        stringArray = cocos2d.split(cocos2d.split((String)stringArray, "@")[0], ".");
        return stringArray[stringArray.length - 1] + ":" + this.position + ":" + this.scale + ":" + this.rotation;
    }
}

