/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.tokyodrift;

import cocos2d.SimpleAudioEngine;
import cocos2d.extensions.MyIO;
import cocos2d.extensions.cc3d.CC3Utils;
import com.kitmaker.tokyodrift.CarSetup;
import com.kitmaker.tokyodrift.loc;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MyData {
    public static int LEVEL = 0;
    private static final StringBuffer a = new StringBuffer(20);
    private static final Vector a = new Vector(5, 10);
    static int a = 5000;
    public static String currentLevelData = "";
    static final CarSetup a = new CarSetup();
    public static final int VOLUME_LOW = 33;
    public static final int VOLUME_MED = 66;
    public static final int VOLUME_HIGH = 100;

    public static void loadLevel() {
        try {
            int n2;
            InputStream inputStream = a.getClass().getResourceAsStream("/l" + (LEVEL + 1) + ".txt");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = dataInputStream.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            currentLevelData = stringBuffer.toString();
            dataInputStream.close();
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static void loadData() {
        try {
            a.fromString(MyIO.load("carSetup"));
            a = Integer.parseInt(MyIO.load("cash"));
            SimpleAudioEngine.sharedEngine().setVolumeMusic(Integer.parseInt(MyIO.load("musicVol")));
        }
        catch (Exception exception) {
            SimpleAudioEngine.sharedEngine().setVolumeMusic(75);
        }
        String string = MyIO.load("lang");
        if ("es".equals(string)) {
            loc.setES();
            return;
        }
        if ("br".equals(string)) {
            loc.setBR();
            return;
        }
        if ("ar".equals(string)) {
            loc.setAR();
            return;
        }
        if ("be".equals(string)) {
            loc.setBE();
            return;
        }
        loc.setEN();
    }

    public static void saveData() {
        MyIO.save("carSetup", a.toString());
        MyIO.save("cash", "" + a);
        MyIO.save("musicVol", "" + SimpleAudioEngine.sharedEngine().getVolumeMusic());
    }

    public static void saveBestLap(int n2, long l2) {
        MyIO.save("map" + n2, "" + l2);
    }

    public static long getBestLap(int n2) {
        String string = MyIO.load("map" + n2);
        if (string == null || "".equals(string)) {
            return 300000L;
        }
        return Long.parseLong(string);
    }

    public static String[] Split(String object, String string) {
        a.setLength(0);
        a.removeAllElements();
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (string.indexOf((int)object[i2]) != -1) {
                if (a.length() <= 0) continue;
                a.addElement(a.toString());
                a.setLength(0);
                continue;
            }
            a.append((char)object[i2]);
        }
        if (a.length() > 0) {
            a.addElement(a.toString());
        }
        Object[] objectArray = new String[a.size()];
        a.copyInto(objectArray);
        return objectArray;
    }

    public static void toggleSoundVolume() {
        switch (SimpleAudioEngine.sharedEngine().getVolumeMusic()) {
            case 33: {
                SimpleAudioEngine.sharedEngine().setVolumeMusic(66);
                SimpleAudioEngine.sharedEngine().setVolumeFx(61);
                break;
            }
            case 66: {
                SimpleAudioEngine.sharedEngine().setVolumeMusic(100);
                SimpleAudioEngine.sharedEngine().setVolumeFx(95);
                break;
            }
            case 100: {
                SimpleAudioEngine.sharedEngine().setMute(true);
                SimpleAudioEngine.sharedEngine().setVolumeMusic(0);
                break;
            }
            default: {
                SimpleAudioEngine.sharedEngine().setVolumeMusic(33);
                SimpleAudioEngine.sharedEngine().setVolumeFx(28);
                SimpleAudioEngine.sharedEngine().setMute(false);
            }
        }
        MyData.saveData();
    }

    public static String getSoundLabel() {
        String string;
        switch (SimpleAudioEngine.sharedEngine().getVolumeMusic()) {
            case 33: {
                string = "Sound:Low";
                break;
            }
            case 66: {
                string = "Sound:Med";
                break;
            }
            case 100: {
                string = "Sound:High";
                break;
            }
            default: {
                string = SimpleAudioEngine.sharedEngine().isMuted() ? "Sound:Off" : "Sound:On";
            }
        }
        String string2 = string;
        return loc.localize(string, false);
    }

    public static final String displayMiliseconds(long l2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = (int)(l2 / 1000L) / 60;
        stringBuffer.append(CC3Utils.zeroPad(n2, 2)).append(":");
        int n3 = (int)(l2 / 1000L) % 60;
        stringBuffer.append(CC3Utils.zeroPad(n3, 2)).append(":");
        int n4 = (int)l2 - n3 * 1000 - n2 * 60000;
        stringBuffer.append(CC3Utils.zeroPad(n4, 3));
        return stringBuffer.toString();
    }
}

