/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.tokyodrift;

import at.emini.physics2D.Body;
import at.emini.physics2D.Shape;
import at.emini.physics2D.util.FXVector;
import cocos2d.extensions.cc3d.CC3Group;
import cocos2d.extensions.cc3d.CC3Mesh;
import cocos2d.extensions.cc3d.CC3Renderer;
import cocos2d.extensions.cc3d.CC3Vector;
import com.kitmaker.tokyodrift.FXConverter;
import com.kitmaker.tokyodrift.PhysicsWorld;
import com.kitmaker.tokyodrift.Vehicle;

public class TrafficCone
extends CC3Mesh {
    private static Shape b = Shape.createCircle(20);
    private Body c = new Body(FXVector.newVector(0, 0), b, true);
    private CC3Vector f = new CC3Vector();
    private boolean g = false;
    private Vehicle h;
    private PhysicsWorld i;

    public TrafficCone(PhysicsWorld physicsWorld, Vehicle vehicle) {
        super("cone.m3g", 1);
        this.h = vehicle;
        this.i = physicsWorld;
        this.lodDistance = 40;
        this.hideDistance = 800;
        this.c.addCollisionLayer(10);
        this.c.setInteracting(false);
        this.c.setRotatable(false);
        this.c.setGravityAffected(false);
    }

    public void switchToLod(int n2) {
        super.switchToLod(n2);
        if (!this.g) {
            if (n2 == 1) {
                this.i.addBody(this.c);
                this.c.setInteracting(true);
                this.g = true;
                return;
            }
        } else {
            if (n2 == -1) {
                this.g = false;
                this.i.removeBody(this.c);
                this.c.velocityFX().xFX = 0;
                this.c.velocityFX().yFX = 0;
                return;
            }
            this.c.setInteracting(n2 == 1);
        }
    }

    public void setPosition(float f2, float f3, float f4) {
        super.setPosition(f2, f3, f4);
        this.c.positionFX().xFX = FXConverter.a(f2);
        this.c.positionFX().yFX = FXConverter.a(f4);
    }

    public void update(float f2, CC3Renderer cC3Renderer) {
        super.update(f2, cC3Renderer);
        f2 = FXConverter.a(this.c.positionFX().xFX);
        float f3 = FXConverter.a(this.c.positionFX().yFX);
        float f4 = this.position.y;
        boolean bl = !this.f.isEqual(f2, f4, f3);
        if (bl) {
            this.c.velocityFX().xFX -= this.c.velocityFX().xFX / 40;
            this.c.velocityFX().yFX -= this.c.velocityFX().yFX / 40;
            if (this.currentLod == 1) {
                f4 = this.h.position.y;
            } else if (this.currentLod == -1) {
                f4 = ((CC3Group)this.parent.parent).heightAtPositionRay(this.position);
            }
            super.setPosition(f2, f4, f3);
            this.f.set(f2, f4, f3);
        }
    }

    static {
        b.setFriction(1);
        b.setElasticity(0);
    }
}

