/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions.cc3d;

import cocos2d.cocos2d;
import cocos2d.extensions.cc3d.CC3Utils;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.m3g.Object3D;

public class CC3Cache {
    private static Hashtable a = new Hashtable();

    public static void purge() {
        a.clear();
    }

    public static void push(String string, int n2, Object3D object3D) {
        if (object3D != null && !CC3Cache.isCached(string, n2)) {
            if (!string.startsWith("/")) {
                string = "/".concat(string);
            }
            a.put(string + n2, object3D);
        }
    }

    public static Object3D get(String string, int n2) {
        return CC3Cache.get(string, n2, false);
    }

    public static Object3D get(String string, int n2, boolean bl) {
        Object3D object3D;
        if (!string.startsWith("/")) {
            string = "/".concat(string);
        }
        if ((object3D = (Object3D)a.get(string + n2)) == null) {
            object3D = CC3Cache.getFromDisk(string, n2, bl);
        }
        if (object3D == null) {
            if (!string.endsWith("_hd.m3g")) {
                cocos2d.CCLog("Cannot find and load " + string + " (" + n2 + ")");
            }
            return null;
        }
        return object3D.duplicate();
    }

    public static Object3D getNoCache(String string, int n2) {
        return CC3Cache.getFromDisk(string, n2, false);
    }

    public static Object3D getFromDisk(String string, int n2, boolean bl) {
        if (!string.startsWith("/")) {
            string = "/".concat(string);
        }
        Object3D object3D = null;
        if (string.endsWith("m3g")) {
            Object3D[] object3DArray = new Object3D[64];
            object3D = CC3Utils.loadLinkedObjects(string, n2, object3DArray);
            int n3 = object3DArray.length;
            while (n3-- != 0) {
                if (object3DArray[n3] == null || object3DArray[n3].getUserID() == -1) continue;
                a.put(string + object3DArray[n3].getUserID(), object3DArray[n3]);
            }
        } else if (string.endsWith("png") || string.endsWith("jpg")) {
            object3D = CC3Utils.loadTexture(string, bl);
        }
        if (object3D != null) {
            a.put(string + n2, object3D);
        } else if (!string.endsWith("_hd.m3g")) {
            cocos2d.CCLog("Cannot find and load " + string + " (" + n2 + ")");
        }
        return object3D;
    }

    public static boolean isCached(String string, int n2) {
        if (!string.startsWith("/")) {
            string = "/".concat(string);
        }
        return a.containsKey(string + n2);
    }

    public static void remove(String string, int n2) {
        if (!string.startsWith("/")) {
            string = "/".concat(string);
        }
        a.remove(string + n2);
    }

    public static void remove(String string) {
        if (!string.startsWith("/")) {
            string = "/".concat(string);
        }
        Enumeration enumeration = a.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            a.remove(string2);
        }
    }
}

