/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.types.CCRect;
import cocos2d.types.CCSpriteFrame;
import cocos2d.types.CCTexture2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class CCSpriteFrameCache {
    private static final Hashtable a = new Hashtable(5);
    private static final Vector b = new Vector(3, 1);
    private static CCSpriteFrameCache c = null;

    public static final CCSpriteFrameCache sharedFrameCache() {
        if (c == null) {
            c = new CCSpriteFrameCache();
        }
        return c;
    }

    public final void invalidateSpriteFrameByName(String string) {
        a.remove(string);
    }

    public final void invalidateSpriteFrame(CCSpriteFrame cCSpriteFrame) {
        a.remove(cCSpriteFrame.name);
    }

    public final CCSpriteFrame getSpriteFrame(String object, boolean bl) {
        CCSpriteFrame cCSpriteFrame;
        String string = object;
        if (bl) {
            string = string + "flip";
        }
        if ((cCSpriteFrame = (CCSpriteFrame)a.get(string)) == null && string.endsWith(".png")) {
            cCSpriteFrame = (CCSpriteFrame)a.get(string.substring(0, string.length() - 4));
        }
        if (cCSpriteFrame == null) {
            object = CCTextureCache.sharedTextureCache().addImage((String)object);
            if (bl) {
                CCTexture2D cCTexture2D = CCTextureCache.sharedTextureCache().textureForKey(string);
                if (cCTexture2D == null) {
                    cCTexture2D = CCTextureCache.sharedTextureCache().addToCache(CCTexture2D.flipTexture((CCTexture2D)object));
                }
                cCSpriteFrame = CCSpriteFrame.frameWithTextureAndFrame(cCTexture2D, CCRect.make(0, 0, cCTexture2D.width, cCTexture2D.height));
            } else {
                cCSpriteFrame = CCSpriteFrame.frameWithTextureAndFrame((CCTexture2D)object, CCRect.make(0, 0, ((CCTexture2D)object).width, ((CCTexture2D)object).height));
            }
            cCSpriteFrame.name = string;
            a.put(string, cCSpriteFrame);
        }
        return cCSpriteFrame;
    }

    public final CCSpriteFrame buildSpriteFrame(String string, Image object, boolean bl) {
        CCTexture2D cCTexture2D = CCTextureCache.sharedTextureCache().textureForKey(string);
        if (cCTexture2D == null) {
            cCTexture2D = new CCTexture2D(string, (Image)object);
            CCTextureCache.sharedTextureCache().addToCache(cCTexture2D);
        }
        object = CCSpriteFrame.frameWithTextureAndFrame(cCTexture2D, CCRect.make(0, 0, cCTexture2D.width, cCTexture2D.height));
        if (bl) {
            cocos2d.CCLog("CCSpriteFrameCache: You cannot flip CCTextures created from images");
        }
        object.name = string;
        return object;
    }

    private CCSpriteFrameCache() {
    }

    public final String printState() {
        return "cache size:" + a.size() + "\ncontents:" + a.toString();
    }

    public final void addSpriteFramesWithFile(String string) {
        if (!b.contains(string)) {
            try {
                KXmlParser kXmlParser = new KXmlParser();
                InputStream inputStream = this.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + string);
                if (inputStream == null) {
                    cocos2d.CCLog("CCSpriteFrameCache: cannot find xml with name " + string);
                    return;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                kXmlParser.setInput(inputStreamReader);
                kXmlParser.nextTag();
                kXmlParser.require(2, null, "TextureAtlas");
                CCTexture2D cCTexture2D = CCTextureCache.sharedTextureCache().addImage(kXmlParser.getAttributeValue("", "imagePath"));
                while (kXmlParser.nextTag() != 3) {
                    kXmlParser.require(2, null, "sprite");
                    String string2 = kXmlParser.getAttributeValue("", "n");
                    int n2 = Integer.parseInt(kXmlParser.getAttributeValue("", "x"));
                    int n3 = Integer.parseInt(kXmlParser.getAttributeValue("", "y"));
                    int n4 = Integer.parseInt(kXmlParser.getAttributeValue("", "w"));
                    int n5 = Integer.parseInt(kXmlParser.getAttributeValue("", "h"));
                    String string3 = kXmlParser.getAttributeValue("", "r");
                    CCSpriteFrame cCSpriteFrame = CCSpriteFrame.frameWithTextureAndFrame(cCTexture2D, CCRect.make(n2, n3, n4, n5));
                    try {
                        cCSpriteFrame.offsetInPixels.x = Integer.parseInt(kXmlParser.getAttributeValue("", "oX"));
                        cCSpriteFrame.offsetInPixels.y = Integer.parseInt(kXmlParser.getAttributeValue("", "oY"));
                        cCSpriteFrame.originalSizeInPixels.width = Integer.parseInt(kXmlParser.getAttributeValue("", "oW"));
                        cCSpriteFrame.originalSizeInPixels.height = Integer.parseInt(kXmlParser.getAttributeValue("", "oH"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    cCSpriteFrame.isRotated = string3 != null;
                    cCSpriteFrame.name = string2;
                    a.put(string2, cCSpriteFrame);
                    this.skipSubTree(kXmlParser);
                }
                kXmlParser.require(3, null, "TextureAtlas");
                kXmlParser.next();
                kXmlParser.require(1, null, null);
                inputStreamReader.close();
                inputStream.close();
            }
            catch (XmlPullParserException xmlPullParserException) {
                cocos2d.CCLog("CCSpriteFrameCache: xml parsing error " + xmlPullParserException.toString());
            }
            catch (IOException iOException) {
                cocos2d.CCLog("CCSpriteFrameCache: IO error " + iOException.toString());
            }
            b.addElement(string);
        }
    }

    public final void removeSpriteFramesWithFile(String object) {
        if (b.removeElement(object)) {
            try {
                KXmlParser kXmlParser = new KXmlParser();
                InputStream inputStream = this.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + (String)object);
                if (inputStream == null) {
                    cocos2d.CCLog("CCSpriteFrameCache: cannot find xml with name " + (String)object);
                    return;
                }
                object = new InputStreamReader(inputStream);
                kXmlParser.setInput((Reader)object);
                kXmlParser.nextTag();
                kXmlParser.require(2, null, "TextureAtlas");
                CCTextureCache.sharedTextureCache().removeTextureForKey(kXmlParser.getAttributeValue("", "imagePath"));
                while (kXmlParser.nextTag() != 3) {
                    kXmlParser.require(2, null, "sprite");
                    String string = kXmlParser.getAttributeValue("", "n");
                    this.invalidateSpriteFrameByName(string);
                    this.skipSubTree(kXmlParser);
                }
                kXmlParser.require(3, null, "TextureAtlas");
                kXmlParser.next();
                kXmlParser.require(1, null, null);
                ((InputStreamReader)object).close();
                inputStream.close();
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                cocos2d.CCLog("CCSpriteFrameCache: xml parsing error " + xmlPullParserException.toString());
                return;
            }
            catch (IOException iOException) {
                cocos2d.CCLog("CCSpriteFrameCache: IO error " + iOException.toString());
            }
        }
    }

    public final void skipSubTree(XmlPullParser xmlPullParser) {
        xmlPullParser.require(2, null, null);
        int n2 = 1;
        while (n2 > 0) {
            int n3 = xmlPullParser.next();
            if (n3 == 3) {
                --n2;
                continue;
            }
            if (n3 != 2) continue;
            ++n2;
        }
    }

    public final CCSpriteFrame spriteFrameByName(String string) {
        CCSpriteFrame cCSpriteFrame = (CCSpriteFrame)a.get(string);
        if (cCSpriteFrame != null) {
            return cCSpriteFrame;
        }
        if (string.endsWith(".png") && (cCSpriteFrame = (CCSpriteFrame)a.get(string.substring(0, string.length() - 4))) != null) {
            return cCSpriteFrame;
        }
        cocos2d.CCLog("CCSpriteFrameCache: Cannot find frame with name " + string);
        return null;
    }

    public final void purgeSpriteFrameCache() {
        a.clear();
        b.removeAllElements();
    }
}

