/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXMatrix;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Shape {
    protected FXVector[] d;
    int[] e;
    int f = 0;
    private int a;
    int g;
    private int b;
    int h;
    long i = 0L;
    protected int j = 0;
    protected int k = 1024;
    int l = 4096;
    long m = 0x1000000L;
    long n = 4096L;
    long o = 0x1000000L;
    int p = -1;
    protected UserData q = null;
    protected FXVector r = new FXVector();
    public static final int MAX_MASS_FX = 0x1000001;

    public static Shape createRectangle(int n2, int n3) {
        FXVector[] fXVectorArray = new FXVector[4];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(-(n2 <<= 12) / 2, -(n3 <<= 12) / 2);
        fXVectorArray2[1] = new FXVector(-n2 / 2, n3 / 2);
        fXVectorArray2[2] = new FXVector(n2 / 2, n3 / 2);
        fXVectorArray2[3] = new FXVector(n2 / 2, -n3 / 2);
        return new Shape(fXVectorArray2);
    }

    public static Shape createCircle(int n2) {
        FXVector[] fXVectorArray = new FXVector[1];
        FXVector[] fXVectorArray2 = fXVectorArray;
        fXVectorArray[0] = new FXVector(0, n2 << 12);
        return new Shape(fXVectorArray2);
    }

    public static Shape createRegularPolygon(int n2, int n3) {
        FXVector[] fXVectorArray = new FXVector[n3];
        FXVector fXVector = new FXVector(0, n2 << 12);
        for (int i2 = 0; i2 < n3; ++i2) {
            FXMatrix fXMatrix = FXMatrix.createRotationMatrix((int)(105414356L * (long)((i2 << 1) + 1) / (long)(n3 << 1)));
            fXVectorArray[n3 - 1 - i2] = fXMatrix.mult(fXVector);
        }
        return new Shape(fXVectorArray);
    }

    public static Shape loadShape(PhysicsFileReader object, UserData userData) {
        int n2 = ((PhysicsFileReader)object).getVersion();
        if (n2 <= 512) {
            ((PhysicsFileReader)object).next();
        }
        int n3 = ((PhysicsFileReader)object).next();
        FXVector[] fXVectorArray = new FXVector[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fXVectorArray[i2] = ((PhysicsFileReader)object).nextVector();
        }
        Shape shape = new Shape(fXVectorArray);
        shape.setElasticityFX(((PhysicsFileReader)object).nextIntFX());
        shape.setFrictionFX(((PhysicsFileReader)object).nextIntFX());
        if (n2 >= 1280) {
            shape.setMassFX(((PhysicsFileReader)object).nextIntFX());
        }
        if (((PhysicsFileReader)object).getVersion() > 1536) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                shape.q = userData.createNewUserData((String)object, 2);
            }
        }
        return shape;
    }

    public Shape(FXVector[] fXVectorArray) {
        if (fXVectorArray.length > 12) {
            return;
        }
        this.d = fXVectorArray;
        this.c();
        this.setMass(1);
    }

    public Shape(Shape shape) {
        this.d = new FXVector[shape.d.length];
        System.arraycopy(shape.d, 0, this.d, 0, this.d.length);
        this.setElasticityFX(shape.j);
        this.setFrictionFX(shape.k);
        this.c();
        this.setMassFX(shape.l);
        if (shape.q != null) {
            this.q = shape.q.copy();
        }
    }

    protected Shape() {
    }

    protected final void c() {
        this.a();
        this.a = 0;
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            FXVector fXVector = this.d[i2];
            if (fXVector.lengthSquare() <= this.a * this.a) continue;
            this.a = fXVector.lengthFX() >> 12;
        }
        this.g = this.a << 12;
        this.b();
        Shape shape = this;
        this.b = this.h = shape.g << 1;
        for (int i3 = 0; i3 < shape.e.length && shape.e[i3] >= 0; i3 += 2) {
            long l2;
            FXVector fXVector = new FXVector(shape.d[shape.e[i3]]);
            fXVector.subtract(shape.d[shape.e[i3 + 1]]);
            fXVector.normalize();
            long l3 = l2 = (long)shape.d[0].xFX * (long)fXVector.yFX - (long)shape.d[0].yFX * (long)fXVector.xFX >> 12;
            for (int i4 = 1; i4 < shape.d.length; ++i4) {
                long l4 = (long)shape.d[i4].xFX * (long)fXVector.yFX - (long)shape.d[i4].yFX * (long)fXVector.xFX >> 12;
                if (l4 < l3) {
                    l3 = l4;
                    continue;
                }
                if (l4 <= l2) continue;
                l2 = l4;
            }
            if ((long)shape.h < l2 - l3) {
                shape.h = (int)(l2 - l3);
            }
            if ((long)shape.b <= l2 - l3) continue;
            shape.b = (int)(l2 - l3);
        }
    }

    public void correctCentroid() {
        if (this.d.length < 3) {
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = this.d.length - 1;
        while (n2 < this.d.length) {
            long l4 = (long)this.d[n2].xFX * (long)this.d[n3].yFX - (long)this.d[n2].yFX * (long)this.d[n3].xFX >> 12;
            l2 += l4 * (long)(this.d[n2].xFX + this.d[n3].xFX) >> 12;
            l3 += l4 * (long)(this.d[n2].yFX + this.d[n3].yFX) >> 12;
            n3 = n2++;
        }
        l2 = (l2 << 12) / (this.i * 6L);
        l3 = (l3 << 12) / (this.i * 6L);
        for (n2 = 0; n2 < this.d.length; ++n2) {
            this.d[n2].subtract(new FXVector((int)l2, (int)l3));
        }
        this.c();
    }

    public FXVector[] getCorners() {
        return this.d;
    }

    public int getBoundingRadiusSquare() {
        return this.a * this.a;
    }

    public int getBoundingRadiusFX() {
        return this.g;
    }

    void a() {
        if (this.d.length == 1) {
            this.e = new int[0];
            this.f = 0;
            return;
        }
        this.e = new int[this.d.length << 1];
        Vector<FXVector> vector = new Vector<FXVector>();
        int n2 = 0;
        int n3 = this.d.length - 1;
        while (n2 < this.d.length) {
            FXVector fXVector = new FXVector(this.d[n2]);
            fXVector.subtract(this.d[n3]);
            fXVector.normalize();
            boolean bl = true;
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                FXVector fXVector2 = (FXVector)vector.elementAt(i2);
                if (Math.abs((long)fXVector.xFX * (long)fXVector2.xFX + (long)fXVector.yFX * (long)fXVector2.yFX >> 12) <= 4088L) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.e[vector.size() << 1] = n2;
                this.e[(vector.size() << 1) + 1] = n3;
                vector.addElement(fXVector);
            }
            n3 = n2++;
        }
        this.f = vector.size() << 1;
        for (n2 = vector.size() << 1; n2 < this.e.length; ++n2) {
            this.e[n2] = -1;
        }
    }

    public void setFriction(int n2) {
        this.k = (n2 << 12) / 100;
    }

    public void setFrictionFX(int n2) {
        this.k = n2;
    }

    public int getFrictionFX() {
        return this.k;
    }

    public void setElasticity(int n2) {
        this.j = (n2 << 12) / 100;
    }

    public void setElasticityFX(int n2) {
        this.j = n2;
    }

    public int getElasticityFX() {
        return this.j;
    }

    public final void setMass(int n2) {
        this.setMassFX(n2 << 12);
    }

    public final void setMassFX(int n2) {
        if (this.i == 0L) {
            this.n = 0x1000001L;
            this.m = 0L;
            this.o = 0L;
            return;
        }
        this.l = n2;
        this.m = 0x1000000000L / (long)n2;
        this.b();
    }

    public int getMass() {
        return this.l >> 12;
    }

    public int getMassFX() {
        return this.l;
    }

    public int getId() {
        return this.p;
    }

    public long getAreaFX() {
        return this.i;
    }

    void b() {
        this.i = 0L;
        this.n = 0L;
        if (this.d.length == 1) {
            this.i = 52707178L * (long)((int)((long)this.g * (long)this.g) >> 24) >> 12;
            this.n = (int)((long)(this.l / 2) * (long)this.g * (long)this.g >> 24);
        } else if (this.d.length > 2) {
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                FXVector fXVector = this.d[i2];
                FXVector fXVector2 = this.d[i2 + 1 >= this.d.length ? 0 : i2 + 1];
                long l2 = (long)fXVector2.xFX * (long)fXVector.yFX - (long)fXVector2.yFX * (long)fXVector.xFX >> 12;
                this.i += l2 / 2L;
                long l3 = fXVector.xFX;
                long l4 = fXVector.yFX;
                long l5 = fXVector2.xFX;
                long l6 = fXVector2.yFX;
                long l7 = (int)((l3 * l3 + l5 * l3 + l5 * l5) / 12L >> 12);
                long l8 = (int)((l4 * l4 + l6 * l4 + l6 * l6) / 12L >> 12);
                this.n += l2 * (l7 + l8) >> 12;
            }
            this.n = (this.n << 12) / this.i * (long)this.l >> 12;
        }
        if (this.i > 0L) {
            long l9 = 0L;
            long l10 = 0L;
            int n2 = 0;
            int n3 = this.d.length - 1;
            while (n2 < this.d.length) {
                long l11 = (long)this.d[n2].xFX * (long)this.d[n3].yFX - (long)this.d[n2].yFX * (long)this.d[n3].xFX >> 12;
                l9 += l11 * (long)(this.d[n2].xFX + this.d[n3].xFX) >> 12;
                l10 += l11 * (long)(this.d[n2].yFX + this.d[n3].yFX) >> 12;
                n3 = n2++;
            }
            l9 = (l9 << 12) / (this.i * 6L);
            l10 = (l10 << 12) / (this.i * 6L);
            this.r.assignFX((int)l9, (int)l10);
        } else {
            this.r.assignFX(0, 0);
        }
        this.n += (long)this.l * (long)this.r.lengthSquareFX() >> 12;
        if (this.n == 0L) {
            this.o = Integer.MAX_VALUE;
            return;
        }
        this.o = 0x1000000000L / this.n;
    }

    protected final void a(FXVector fXVector, FXMatrix fXMatrix, FXVector[] fXVectorArray) {
        if (fXVectorArray.length < this.d.length) {
            return;
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            fXMatrix.mult(this.d[i2], fXVectorArray[i2]);
            fXVectorArray[i2].xFX += fXVector.xFX;
            fXVectorArray[i2].yFX += fXVector.yFX;
        }
    }

    public UserData getUserData() {
        return this.q;
    }

    public void setUserData(UserData userData) {
        this.q = userData;
    }
}

