/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

import cocos2d.types.CCPoint;
import cocos2d.types.CCSize;

public class CCRect {
    public CCPoint position;
    public CCSize size;

    public CCRect() {
        this(0, 0, 0, 0);
    }

    public static CCRect make(CCPoint cCPoint, CCSize cCSize) {
        return new CCRect(cCPoint.x, cCPoint.y, cCSize.width, cCSize.height);
    }

    public static CCRect make(int n2, int n3, int n4, int n5) {
        return new CCRect(n2, n3, n4, n5);
    }

    private CCRect(int n2, int n3, int n4, int n5) {
        this.position = CCPoint.ccp(n2, n3);
        this.size = CCSize.make(n4, n5);
    }

    public boolean contains(int n2, int n3) {
        return this.size.width > 0 && this.size.height > 0 && n2 >= this.position.x && n2 < this.position.x + this.size.width && n3 >= this.position.y && n3 < this.position.y + this.size.height;
    }

    public String toString() {
        return "[" + this.position.x + ',' + this.position.y + ',' + this.size.width + ',' + this.size.height + ']';
    }

    public static boolean equalToRect(CCRect cCRect, CCRect cCRect2) {
        return CCPoint.equalToPoint(cCRect.position, cCRect2.position) && CCSize.equalToSize(cCRect.size, cCRect2.size);
    }

    public static boolean containsPoint(CCRect cCRect, CCPoint cCPoint) {
        return cCPoint.x >= CCRect.minX(cCRect) && cCPoint.y >= CCRect.minY(cCRect) && cCPoint.x < CCRect.maxX(cCRect) && cCPoint.y < CCRect.maxY(cCRect);
    }

    public static boolean containsRect(CCRect cCRect, CCRect cCRect2) {
        return !CCRect.isEmptyRect(cCRect2) && CCRect.minX(cCRect) <= CCRect.minX(cCRect2) && CCRect.minY(cCRect) <= CCRect.minY(cCRect2) && CCRect.maxX(cCRect) >= CCRect.maxX(cCRect2) && CCRect.maxY(cCRect) >= CCRect.maxY(cCRect2);
    }

    public static int maxX(CCRect cCRect) {
        return cCRect.position.x + cCRect.size.width;
    }

    public static int maxY(CCRect cCRect) {
        return cCRect.position.y + cCRect.size.height;
    }

    public static int midX(CCRect cCRect) {
        return cCRect.position.x + (cCRect.size.width >> 1);
    }

    public static int midY(CCRect cCRect) {
        return cCRect.position.y + (cCRect.size.height >> 1);
    }

    public static int minX(CCRect cCRect) {
        return cCRect.position.x;
    }

    public static int minY(CCRect cCRect) {
        return cCRect.position.y;
    }

    public static int width(CCRect cCRect) {
        return cCRect.size.width;
    }

    public static int height(CCRect cCRect) {
        return cCRect.size.height;
    }

    public static boolean isEmptyRect(CCRect cCRect) {
        return cCRect.size.width <= 0 || cCRect.size.height <= 0;
    }

    public static boolean intersectsRect(CCRect cCRect, CCRect cCRect2) {
        return CCRect.maxX(cCRect) > CCRect.minX(cCRect2) && CCRect.maxX(cCRect2) > CCRect.minX(cCRect) && CCRect.maxY(cCRect) > CCRect.minY(cCRect2) && CCRect.maxY(cCRect2) > CCRect.minY(cCRect);
    }

    final CCRect a() {
        return CCRect.make(this.position, this.size);
    }
}

