/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int _status;
    private int gameMode;
    private int interuption = 0;
    private static final int STATUS_GAME_READY = 0;
    private static final int STATUS_GAME_PLAY = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    public static final int _BUTTON_RESTART = 0;
    public static final int _BUTTON_MAIN_MENU = 1;
    private static final int TOTAL_COMP_IDS = 2;
    private Rectangle[] _RectButton = new Rectangle[2];
    private Rectangle _restScore;
    private Rectangle rectGameArea;
    private Rectangle rectTitle;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectBest;
    private Rectangle rectActual;
    private int selectedCompId;
    private int icount;
    private static PreparedText _actualScore;
    private static PreparedText _bestScore;
    private static PreparedText _actualMode;
    private String _ModeName = "";
    private boolean needRepaint;
    private static final int _MODE_CLASSIC = 0;
    private static final int _MODE_ARCADE = 1;
    private static final int _MODE_ZEN = 2;
    private static final int _MODE_RUSH = 3;
    private static final int _MODE_DIFFICULTY_EASY = 0;
    private static final int _MODE_DIFFICULTY_MEDIUM = 1;
    private static final int _MODE_DIFFICULTY_HARD = 2;
    private static int _totalRowTiles;
    private static int _totalColTiles;
    private int _gameMode = 0;
    private int _level = 0;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int cycle = 10;

    public ScreenGame(MainCanvas mainCanvas, int _mode, int _level) {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
        this.mainCanvas = mainCanvas;
        this._gameMode = _mode;
        this._level = _level;
        this._status = 0;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{12, 1, 3, 13, 14, 6, 4, 7, 5, 8, 9});
        Resources.loadSprites(new int[]{7, 6, 1, 0, 4, 3});
        Resources.loadGFonts(new int[]{0, 1});
        Resources.loadText(0);
        this.calculatePositions();
        this.prepareTxt();
        RMSObjects.game.restartGame(this._gameMode, this._level);
        this.loadBestScore();
    }

    private void prepareTxt() {
        _actualScore = new PreparedText(Resources.resGFonts[1]);
        _bestScore = new PreparedText(Resources.resGFonts[0]);
        _actualMode = new PreparedText(Resources.resGFonts[0]);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{1, 3, 13, 14, 6, 4, 7, 5, 8, 9});
        Resources.freeSprites(new int[]{7, 6, 1, 0, 4, 3});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
    }

    public void beforeInteruption() {
        this._status = 0;
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void loadBestScore() {
        block0 : switch (this._gameMode) {
            case 0: {
                switch (this._level) {
                    case 0: {
                        this.loadScore(0);
                        System.out.println("1 best: " + this.bestScoreSave);
                        break;
                    }
                    case 1: {
                        this.loadScore(1);
                        break;
                    }
                    case 2: {
                        this.loadScore(2);
                    }
                }
                break;
            }
            case 1: {
                switch (this._level) {
                    case 0: {
                        this.loadScore(3);
                        break;
                    }
                    case 1: {
                        this.loadScore(4);
                        break;
                    }
                    case 2: {
                        this.loadScore(5);
                    }
                }
                break;
            }
            case 2: {
                switch (this._level) {
                    case 0: {
                        this.loadScore(6);
                        break;
                    }
                    case 1: {
                        this.loadScore(7);
                        break;
                    }
                    case 2: {
                        this.loadScore(8);
                    }
                }
                break;
            }
            case 3: {
                switch (this._level) {
                    case 0: {
                        this.loadScore(9);
                        break block0;
                    }
                    case 1: {
                        this.loadScore(10);
                        break block0;
                    }
                    case 2: {
                        this.loadScore(11);
                    }
                }
            }
        }
        System.out.println("best: " + this.bestScoreSave);
    }

    private void loadScore(int _RMS) {
        RMSObjects.createRMSConnect(_RMS);
        if (!RMSObjects.rmsConnects[_RMS].load()) {
            RMSObjects.rmsConnects[_RMS].create();
            System.out.println("vytvaram _RMS: " + _RMS);
        }
        Vector scores = RMSObjects.bestScores.getScoresForGame(0);
        block0 : switch (this._gameMode) {
            case 0: {
                switch (this._level) {
                    case 0: {
                        scores = RMSObjects.cE.getScoresForGame(0);
                        System.out.println("2 best: " + this.bestScoreSave);
                        break;
                    }
                    case 1: {
                        scores = RMSObjects.cM.getScoresForGame(0);
                        break;
                    }
                    case 2: {
                        scores = RMSObjects.cH.getScoresForGame(0);
                    }
                }
                break;
            }
            case 1: {
                switch (this._level) {
                    case 0: {
                        scores = RMSObjects.aE.getScoresForGame(0);
                        break;
                    }
                    case 1: {
                        scores = RMSObjects.aM.getScoresForGame(0);
                        break;
                    }
                    case 2: {
                        scores = RMSObjects.aH.getScoresForGame(0);
                    }
                }
                break;
            }
            case 2: {
                switch (this._level) {
                    case 0: {
                        scores = RMSObjects.zE.getScoresForGame(0);
                        break;
                    }
                    case 1: {
                        scores = RMSObjects.zM.getScoresForGame(0);
                        break;
                    }
                    case 2: {
                        scores = RMSObjects.zH.getScoresForGame(0);
                    }
                }
                break;
            }
            case 3: {
                switch (this._level) {
                    case 0: {
                        scores = RMSObjects.rA.getScoresForGame(0);
                        break block0;
                    }
                    case 1: {
                        scores = RMSObjects.rM.getScoresForGame(0);
                        break block0;
                    }
                    case 2: {
                        scores = RMSObjects.rH.getScoresForGame(0);
                    }
                }
            }
        }
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
            System.out.println("3 best: " + this.bestScoreSave);
        } else {
            System.out.println("4 best: " + this.bestScoreSave);
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (this._gameMode == 0) {
            if (this.bestScoreSave == 0) {
                this.bestScoreSave = 10000000;
            }
            if (RMSObjects.game.getSeconds() < this.bestScoreSave) {
                scoreItem.scoreValue = RMSObjects.game.getSeconds();
                System.out.println("SAVE VALUE: " + scoreItem.scoreValue);
                RMSObjects.bestScores.userName = Integer.toString(0);
                RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
                switch (this._level) {
                    case 0: {
                        scoreItem.scoreValue = RMSObjects.game.getSeconds();
                        RMSObjects.cE.userName = Integer.toString(0);
                        RMSObjects.cE.insertScoreItem(scoreItem, 0);
                        this.saveScore(0);
                        break;
                    }
                    case 1: {
                        scoreItem.scoreValue = RMSObjects.game.getSeconds();
                        RMSObjects.cM.userName = Integer.toString(0);
                        RMSObjects.cM.insertScoreItem(scoreItem, 0);
                        this.saveScore(1);
                        break;
                    }
                    case 2: {
                        scoreItem.scoreValue = RMSObjects.game.getSeconds();
                        RMSObjects.cH.userName = Integer.toString(0);
                        RMSObjects.cH.insertScoreItem(scoreItem, 0);
                        this.saveScore(2);
                    }
                }
            }
        } else if (this._gameMode == 1) {
            if (RMSObjects.game.get_score() > this.bestScoreSave) {
                scoreItem.scoreValue = RMSObjects.game.get_score();
                RMSObjects.bestScores.userName = Integer.toString(0);
                RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
                switch (this._level) {
                    case 0: {
                        RMSObjects.aE.userName = Integer.toString(0);
                        RMSObjects.aE.insertScoreItem(scoreItem, 0);
                        this.saveScore(3);
                        break;
                    }
                    case 1: {
                        RMSObjects.aM.userName = Integer.toString(0);
                        RMSObjects.aM.insertScoreItem(scoreItem, 0);
                        this.saveScore(4);
                        break;
                    }
                    case 2: {
                        RMSObjects.aH.userName = Integer.toString(0);
                        RMSObjects.aH.insertScoreItem(scoreItem, 0);
                        this.saveScore(5);
                    }
                }
            }
        } else if (this._gameMode == 2) {
            if (RMSObjects.game.get_score() > this.bestScoreSave) {
                scoreItem.scoreValue = RMSObjects.game.get_score();
                RMSObjects.bestScores.userName = Integer.toString(0);
                RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
                switch (this._level) {
                    case 0: {
                        RMSObjects.zE.userName = Integer.toString(0);
                        RMSObjects.zE.insertScoreItem(scoreItem, 0);
                        this.saveScore(6);
                        break;
                    }
                    case 1: {
                        RMSObjects.zM.userName = Integer.toString(0);
                        RMSObjects.zM.insertScoreItem(scoreItem, 0);
                        this.saveScore(7);
                        break;
                    }
                    case 2: {
                        RMSObjects.zH.userName = Integer.toString(0);
                        RMSObjects.zH.insertScoreItem(scoreItem, 0);
                        this.saveScore(8);
                    }
                }
            }
        } else if (this._gameMode == 3) {
            if (RMSObjects.game.get_score() == 0) {
                return;
            }
            if (RMSObjects.game.getSeconds() == 0) {
                return;
            }
            int decade = RMSObjects.game.get_score() / RMSObjects.game.getSeconds() * 1000;
            int floa = RMSObjects.game.get_score() % RMSObjects.game.getSeconds() * 10;
            scoreItem.scoreValue = decade + floa;
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
            if (this.bestScoreSave < decade + floa) {
                switch (this._level) {
                    case 0: {
                        RMSObjects.rA.userName = Integer.toString(0);
                        RMSObjects.rA.insertScoreItem(scoreItem, 0);
                        this.saveScore(9);
                        break;
                    }
                    case 1: {
                        RMSObjects.rM.userName = Integer.toString(0);
                        RMSObjects.rM.insertScoreItem(scoreItem, 0);
                        this.saveScore(10);
                        break;
                    }
                    case 2: {
                        RMSObjects.rH.userName = Integer.toString(0);
                        RMSObjects.rH.insertScoreItem(scoreItem, 0);
                        this.saveScore(11);
                    }
                }
            }
        }
    }

    private void saveScore(int _RMS) {
        if (!RMSObjects.rmsConnects[_RMS].isExist()) {
            RMSObjects.rmsConnects[_RMS].create();
            System.out.println("create: " + _RMS);
        }
        RMSObjects.rmsConnects[_RMS].save();
        System.out.println("save: " + _RMS);
    }

    private void calculatePositions() {
        int _offsetX;
        this._restScore = new Rectangle(0, 0, this.mainCanvas.getWidth(), Resources.resImgs[13].getHeight() >> 2);
        Sprite _buttonSprite = Resources.resSprs[1];
        int _buttonHeight = Resources.resImgs[13].getHeight();
        int _buttonWidth = this.mainCanvas.getWidth() >> 1;
        int _posX = _offsetX = _buttonWidth % _buttonSprite.getWidth();
        int _posY = this.mainCanvas.getHeight() - _buttonHeight;
        this._RectButton[0] = new Rectangle(_posX, _posY, _buttonWidth - _offsetX, _buttonHeight);
        this._RectButton[1] = new Rectangle(_posX += _buttonWidth - _offsetX, _posY, _buttonWidth - _offsetX, _buttonHeight);
        _totalColTiles = this._RectButton[0].width / _buttonSprite.getWidth();
        _totalRowTiles = this._RectButton[0].height / _buttonSprite.getHeight();
    }

    public void update(long lastRunLenght) {
        if (RMSObjects.game.is_levelDone()) {
            this._status = 2;
            this.mainCanvas.repaint();
        } else if (RMSObjects.game.is_gameOver()) {
            this._status = 2;
            this.selectedCompId = -1;
            this.mainCanvas.repaint();
        }
        if (this._status == 0) {
            this.mainCanvas.repaint();
        } else if (this._status == 1) {
            RMSObjects.game.update(lastRunLenght);
            this.mainCanvas.repaint();
        }
    }

    public void paint(Graphics g) {
        g.setColor(970808);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this._status == 2) {
            this.paintResult(g);
            this.paintResultButton(g);
        } else {
            RMSObjects.game.paint(g);
            this.paintProgressBar(g);
            this.paintScore(g);
        }
    }

    public void paintScore(Graphics _g) {
        if (this._gameMode == 0) {
            _actualScore.prepareText("" + RMSObjects.game.getSeconds() + ":" + RMSObjects.game.getStotiny() + "" + RMSObjects.game.getTisiciny(), this._restScore.width);
        } else if (this._gameMode == 1) {
            _actualScore.prepareText("" + RMSObjects.game.get_score(), this._restScore.width);
        } else if (this._gameMode == 2) {
            _actualScore.prepareText("" + RMSObjects.game.get_score(), this._restScore.width);
        } else if (this._gameMode == 3) {
            System.out.println();
            if (RMSObjects.game.getSeconds() != 0) {
                if (RMSObjects.game.get_score() % RMSObjects.game.getSeconds() > 9) {
                    _actualScore.prepareText("" + RMSObjects.game.get_score() / RMSObjects.game.getSeconds() + "," + RMSObjects.game.get_score() % RMSObjects.game.getSeconds() + "/S", this._restScore.width);
                } else {
                    _actualScore.prepareText("" + RMSObjects.game.get_score() / RMSObjects.game.getSeconds() + ",0" + RMSObjects.game.get_score() % RMSObjects.game.getSeconds() + "/S", this._restScore.width);
                }
            } else {
                _actualScore.prepareText("0,00/S", this._restScore.width);
            }
        }
        _actualScore.drawText(_g, this._restScore, 0, 3);
    }

    public void paintProgressBar(Graphics _g) {
        if (this._gameMode == 0) {
            _g.setColor(15539236);
            _g.fillRect(0, 0, this._restScore.width, this._restScore.height);
            _g.setColor(7802386);
            _g.drawRect(0, 0, this._restScore.width, this._restScore.height);
            _g.setColor(11670811);
            int _width = 0;
            if (this._level == 0) {
                _width = this._restScore.width / 25;
            }
            if (this._level == 1) {
                _width = this._restScore.width / 50;
            }
            if (this._level == 2) {
                _width = this._restScore.width / 100;
            }
            _g.fillRect(0, 0, RMSObjects.game.get_score() * _width, this._restScore.height);
        } else if (this._gameMode == 2) {
            _g.setColor(15539236);
            _g.fillRect(0, 0, this._restScore.width, this._restScore.height);
            _g.setColor(7802386);
            _g.drawRect(0, 0, this._restScore.width, this._restScore.height);
            _g.setColor(11670811);
            int _width = 0;
            if (this._level == 0) {
                _width = this._restScore.width / 15;
            }
            if (this._level == 1) {
                _width = this._restScore.width / 30;
            }
            if (this._level == 2) {
                _width = this._restScore.width / 60;
            }
            _g.fillRect(0, 0, this._restScore.width - RMSObjects.game.getSeconds() * _width, this._restScore.height);
        } else {
            _g.setColor(15539236);
            _g.fillRect(0, 0, this._restScore.width, this._restScore.height);
            _g.setColor(7802386);
            _g.drawRect(0, 0, this._restScore.width, this._restScore.height);
        }
    }

    public void paintResult(Graphics _g) {
        Image _logo = Resources.resImgs[3];
        if (RMSObjects.game.is_levelDone()) {
            _g.setColor(970808);
            _actualScore = new PreparedText(Resources.resGFonts[0]);
            _bestScore = new PreparedText(Resources.resGFonts[0]);
            _actualMode = new PreparedText(Resources.resGFonts[0]);
        } else if (RMSObjects.game.is_gameOver()) {
            _g.setColor(970808);
            _actualScore = new PreparedText(Resources.resGFonts[1]);
            _bestScore = new PreparedText(Resources.resGFonts[1]);
            _actualMode = new PreparedText(Resources.resGFonts[1]);
        }
        String score = "";
        String best = "" + Resources.resTexts[0].getHashedString(84).toString();
        _g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        _g.drawImage(_logo, this.mainCanvas.getWidth() / 2, this.mainCanvas.getHeight() - Resources.resImgs[13].getHeight() >> 2, 3);
        switch (this._gameMode) {
            case 0: {
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                this._ModeName = Resources.resTexts[0].getHashedString(85).toString();
                if (RMSObjects.game.is_levelDone()) {
                    score = "" + RMSObjects.game.getSeconds() + " S ";
                    if (this.bestScoreSave == 0) {
                        this.bestScoreSave = 10000000;
                    }
                    if (RMSObjects.game.getSeconds() < this.bestScoreSave) {
                        best = "" + Resources.resTexts[0].getHashedString(15).toString();
                        _bestScore.prepareText(best, this.mainCanvas.getWidth());
                        break;
                    }
                    _bestScore.prepareText(best + ": " + this.bestScoreSave + " S", this.mainCanvas.getWidth());
                    break;
                }
                if (!RMSObjects.game.is_gameOver()) break;
                score = "" + Resources.resTexts[0].getHashedString(13).toString();
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                if (this.bestScoreSave != 0) {
                    _bestScore.prepareText(best + ": " + this.bestScoreSave + " S", this.mainCanvas.getWidth());
                    break;
                }
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                break;
            }
            case 1: {
                this._ModeName = Resources.resTexts[0].getHashedString(86).toString();
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                if (RMSObjects.game.is_levelDone()) {
                    score = "" + RMSObjects.game.get_score();
                    if (RMSObjects.game.get_score() > this.bestScoreSave) {
                        best = "" + Resources.resTexts[0].getHashedString(15).toString();
                        _bestScore.prepareText(best, this.mainCanvas.getWidth());
                        break;
                    }
                    _bestScore.prepareText(best + ": " + this.bestScoreSave, this.mainCanvas.getWidth());
                    break;
                }
                if (!RMSObjects.game.is_gameOver()) break;
                score = "" + RMSObjects.game.get_score();
                _bestScore.prepareText(best + ": " + this.bestScoreSave, this.mainCanvas.getWidth());
                break;
            }
            case 2: {
                this._ModeName = Resources.resTexts[0].getHashedString(87).toString();
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                if (RMSObjects.game.is_levelDone()) {
                    score = "" + RMSObjects.game.get_score();
                    if (RMSObjects.game.get_score() > this.bestScoreSave) {
                        best = "" + Resources.resTexts[0].getHashedString(15).toString();
                        _bestScore.prepareText(best, this.mainCanvas.getWidth());
                        break;
                    }
                    _bestScore.prepareText(Resources.resTexts[0].getHashedString(84) + ": " + this.bestScoreSave, this.mainCanvas.getWidth());
                    break;
                }
                if (!RMSObjects.game.is_gameOver()) break;
                score = "" + RMSObjects.game.get_score();
                _bestScore.prepareText(Resources.resTexts[0].getHashedString(84) + ": " + this.bestScoreSave, this.mainCanvas.getWidth());
                break;
            }
            case 3: {
                this._ModeName = Resources.resTexts[0].getHashedString(88).toString();
                _bestScore.prepareText("", this.mainCanvas.getWidth());
                int decade = RMSObjects.game.get_score() / RMSObjects.game.getSeconds() * 1000;
                int floa = RMSObjects.game.get_score() % RMSObjects.game.getSeconds() * 10;
                score = RMSObjects.game.getSeconds() % RMSObjects.game.getSpeed() > 9 ? "" + RMSObjects.game.get_score() / RMSObjects.game.getSeconds() + "," + RMSObjects.game.get_score() % RMSObjects.game.getSeconds() + "/S" : "" + RMSObjects.game.get_score() / RMSObjects.game.getSeconds() + ",0" + RMSObjects.game.get_score() % RMSObjects.game.getSeconds() + "/S";
                int drawBestD = this.bestScoreSave / 1000;
                int drawBestF = (this.bestScoreSave - this.bestScoreSave / 1000) / 10;
                if (decade + floa > this.bestScoreSave) {
                    best = "" + Resources.resTexts[0].getHashedString(15).toString();
                    _bestScore.prepareText(best, this.mainCanvas.getWidth());
                    break;
                }
                _bestScore.prepareText(Resources.resTexts[0].getHashedString(84) + ": " + drawBestD + "," + drawBestF + "/S", this.mainCanvas.getWidth());
            }
        }
        _actualMode.prepareText(this._ModeName, this.mainCanvas.getWidth());
        _actualScore.prepareText(score, this.mainCanvas.getWidth());
        Rectangle _aMode = new Rectangle(0, this.mainCanvas.getHeight() >> 1, this.mainCanvas.getWidth(), _actualMode.getTextHeight());
        Rectangle _aScore = new Rectangle(0, (this.mainCanvas.getHeight() >> 1) + _actualMode.getTextHeight(), this.mainCanvas.getWidth(), _actualMode.getTextHeight());
        Rectangle _aBest = new Rectangle(0, (this.mainCanvas.getHeight() >> 1) + (_actualMode.getTextHeight() << 1), this.mainCanvas.getWidth(), _actualMode.getTextHeight());
        if (RMSObjects.game.is_gameOver()) {
            _g.setColor(15539236);
            _g.fillRect(_aMode.x, _aMode.y, _aMode.width, _aMode.height);
            _g.fillRect(_aScore.x, _aScore.y, _aScore.width, _aScore.height);
            _g.fillRect(_aBest.x, _aBest.y, _aBest.width, _aBest.height);
        }
        _actualMode.drawText(_g, _aMode, 0, 3);
        _actualScore.drawText(_g, _aScore, 0, 3);
        _bestScore.drawText(_g, _aBest, 0, 3);
    }

    private void paintResultButton(Graphics g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        Image _restart = Resources.resImgs[7];
        Image _menu = Resources.resImgs[4];
        if (this.selectedCompId == 0) {
            this.paintButtonBg(g, _buttonReleased, 0);
            g.drawImage(_restart, this._RectButton[0].x + (this._RectButton[0].width >> 1), this._RectButton[0].y + (this._RectButton[0].height >> 1), 3);
        } else {
            this.paintButtonBg(g, _buttonPressed, 0);
            g.drawImage(_restart, this._RectButton[0].x + (this._RectButton[0].width >> 1), this._RectButton[0].y + (this._RectButton[0].height >> 1), 3);
        }
        if (this.selectedCompId == 1) {
            this.paintButtonBg(g, _buttonReleased, 1);
            g.drawImage(_menu, this._RectButton[1].x + (this._RectButton[1].width >> 1), this._RectButton[1].y + (this._RectButton[1].height >> 1), 3);
        } else {
            this.paintButtonBg(g, _buttonPressed, 1);
            g.drawImage(_menu, this._RectButton[1].x + (this._RectButton[1].width >> 1), this._RectButton[1].y + (this._RectButton[1].height >> 1), 3);
        }
    }

    private void paintButtonBg(Graphics _g, Sprite _buttonSprite, int _buttonRect) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int _x = this._RectButton[_buttonRect].x; _x < this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width; _x += _buttonSprite.getWidth()) {
            for (int _y = this._RectButton[_buttonRect].y; _y < this._RectButton[_buttonRect].y + this._RectButton[_buttonRect].height; _y += _buttonSprite.getHeight()) {
                _buttonSprite.setFrame(this.getButtonTileSprite(_actualTileX, _actualTileY));
                _buttonSprite.setPosition(_x, _y);
                _buttonSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getButtonTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < _totalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == _totalColTiles - 1) {
            return 2;
        }
        if (_y == _totalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < _totalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == _totalColTiles - 1 && _y < _totalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == _totalRowTiles - 1 && _x < _totalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == _totalRowTiles - 1 && _x == _totalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    private void restart() {
        this._gameMode = this._gameMode;
        this._level = this._level;
        this._status = 0;
        this.prepareTxt();
        RMSObjects.game.restartGame(this._gameMode, this._level);
    }

    private void goToMainMenu() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void keyPressed(int keyCode) {
        this.mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        switch (this._status) {
            case 0: {
                if (keyCode == 49) {
                    RMSObjects.game.pressTile(1);
                    this._status = 1;
                    break;
                }
                if (keyCode == 50) {
                    RMSObjects.game.pressTile(2);
                    this._status = 1;
                    break;
                }
                if (keyCode == 51) {
                    RMSObjects.game.pressTile(3);
                    this._status = 1;
                    break;
                }
                if (keyCode == 52) {
                    RMSObjects.game.pressTile(1);
                    this._status = 1;
                    break;
                }
                if (keyCode == 53) {
                    RMSObjects.game.pressTile(2);
                    this._status = 1;
                    break;
                }
                if (keyCode == 54) {
                    RMSObjects.game.pressTile(3);
                    this._status = 1;
                    break;
                }
                if (keyCode == 55) {
                    RMSObjects.game.pressTile(1);
                    this._status = 1;
                    break;
                }
                if (keyCode == 56) {
                    RMSObjects.game.pressTile(2);
                    this._status = 1;
                    break;
                }
                if (keyCode != 57) break;
                RMSObjects.game.pressTile(3);
                this._status = 1;
                break;
            }
            case 1: {
                if (keyCode == 49) {
                    RMSObjects.game.pressTile(1);
                    break;
                }
                if (keyCode == 50) {
                    RMSObjects.game.pressTile(2);
                    break;
                }
                if (keyCode == 51) {
                    RMSObjects.game.pressTile(3);
                    break;
                }
                if (keyCode == 52) {
                    RMSObjects.game.pressTile(1);
                    break;
                }
                if (keyCode == 53) {
                    RMSObjects.game.pressTile(2);
                    break;
                }
                if (keyCode == 54) {
                    RMSObjects.game.pressTile(3);
                    break;
                }
                if (keyCode == 55) {
                    RMSObjects.game.pressTile(1);
                    break;
                }
                if (keyCode == 56) {
                    RMSObjects.game.pressTile(2);
                    break;
                }
                if (keyCode != 57) break;
                RMSObjects.game.pressTile(3);
                break;
            }
            case 2: {
                if (this.selectedCompId == 0) {
                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                        this.selectedCompId = 1;
                    } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                        this.selectedCompId = 1;
                    } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                        if (this._gameMode == 0) {
                            if (RMSObjects.game.is_levelDone()) {
                                this.saveBestScore();
                            }
                        } else if (this._gameMode == 2) {
                            if (RMSObjects.game.is_levelDone()) {
                                this.saveBestScore();
                            }
                        } else {
                            this.saveBestScore();
                        }
                        this.loadBestScore();
                        this.restart();
                    }
                    if (!Keys.isFKRightCode(keyCode)) break;
                    if (this._gameMode == 0) {
                        if (RMSObjects.game.is_levelDone()) {
                            this.saveBestScore();
                        }
                    } else if (this._gameMode == 2) {
                        if (RMSObjects.game.is_levelDone()) {
                            this.saveBestScore();
                        }
                    } else {
                        this.saveBestScore();
                    }
                    this.loadBestScore();
                    this.restart();
                    break;
                }
                if (this.selectedCompId != 1) break;
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    this.selectedCompId = 0;
                } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    this.selectedCompId = 0;
                } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                    if ((this._gameMode == 0 || this._gameMode == 2) && RMSObjects.game.is_levelDone()) {
                        this.saveBestScore();
                    }
                    this.goToMainMenu();
                }
                if (!Keys.isFKLeftCode(keyCode)) break;
                if ((this._gameMode == 2 || this._gameMode == 0) && RMSObjects.game.is_levelDone()) {
                    this.saveBestScore();
                }
                this.goToMainMenu();
            }
        }
        this.mainCanvas.repaint();
    }

    public void pointerPressed(int x, int y) {
        if (this._status == 0) {
            RMSObjects.game.pointerPressed(x, y);
            this._status = 1;
            return;
        }
        if (this._status == 1) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        if (this._status == 2) {
            block4: for (int i = 0; i < this._RectButton.length; ++i) {
                if (this._RectButton[i] == null || !this._RectButton[i].contains(x, y)) continue;
                this.selectedCompId = i;
                switch (this.selectedCompId) {
                    case 0: {
                        if (this._gameMode == 0) {
                            if (RMSObjects.game.is_levelDone()) {
                                this.saveBestScore();
                            }
                        } else if (this._gameMode == 2 && RMSObjects.game.is_levelDone()) {
                            this.saveBestScore();
                        }
                        this.loadBestScore();
                        this.restart();
                        continue block4;
                    }
                    case 1: {
                        this.saveBestScore();
                        this.goToMainMenu();
                    }
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (this._status == 0) {
            return;
        }
        if (this._status == 1) {
            return;
        }
        if (this._status == 2) {
            block3: for (int i = 0; i < this._RectButton.length; ++i) {
                if (this._RectButton[i] == null || !this._RectButton[i].contains(x, y)) continue;
                this.selectedCompId = i;
                switch (this.selectedCompId) {
                    case 0: {
                        continue block3;
                    }
                }
            }
        }
    }

    static {
        _totalRowTiles = 0;
        _totalColTiles = 0;
    }
}

