/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Resources;
import sk.inlogic.text.PreparedText;

public class Tile {
    private int _speed = 0;
    private int _positionX = 0;
    private int _positionY = 0;
    private int _tileWidth = 0;
    private int _tileHeight = 0;
    private int _totalTilesX = 0;
    private int _totalTilesY = 0;
    private boolean _activeTile = true;
    private boolean _greenTile = false;
    private static PreparedText _tileName;
    private Sprite _tileGreenLight;
    private Sprite _tileGreenDark;
    private Sprite _tileRedLight;
    private Sprite _tileRedDark;
    private Image _skullDark;
    private Image _skullLight;
    private Image _swoosh;
    private boolean _outOfScreen = false;
    private boolean ile = false;

    public Tile(int _x, int _y, int _width, int _height, int _totalTilesX, int _totalTilesY, boolean _greenTile) {
        _tileName = new PreparedText(Resources.resGFonts[1]);
        this._positionX = _x;
        this._positionY = _y;
        this._tileWidth = _width;
        this._tileHeight = _height;
        this._totalTilesX = _totalTilesX;
        this._totalTilesY = _totalTilesY;
        this._greenTile = _greenTile;
        this._tileGreenLight = Resources.resSprs[0];
        this._tileGreenDark = Resources.resSprs[1];
        this._tileRedLight = Resources.resSprs[3];
        this._tileRedDark = Resources.resSprs[4];
        this._skullLight = Resources.resImgs[8];
        this._skullDark = Resources.resImgs[9];
        this._swoosh = Resources.resImgs[12];
    }

    public void update() {
    }

    public void paint(Graphics _g) {
        if (this.is_greenTile()) {
            if (this.is_activeTile()) {
                this.paintTile(_g, this._tileGreenLight, this.is_greenTile(), this.is_activeTile());
            } else {
                this.paintTile(_g, this._tileGreenDark, this.is_greenTile(), this.is_activeTile());
            }
        } else if (this.is_activeTile()) {
            this.paintTile(_g, this._tileRedLight, this.is_greenTile(), this.is_activeTile());
        } else {
            this.paintTile(_g, this._tileRedDark, this.is_greenTile(), this.is_activeTile());
        }
    }

    private void paintTile(Graphics _g, Sprite _tileSprite, boolean _green, boolean _active) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int _x = this._positionX; _x < this._positionX + this._tileWidth; _x += _tileSprite.getWidth()) {
            for (int _y = this._positionY; _y < this._positionY + this._tileHeight; _y += _tileSprite.getHeight()) {
                _tileSprite.setFrame(this.getTileSprite(_actualTileX, _actualTileY));
                _tileSprite.setPosition(_x, _y);
                _tileSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
        if (_green && !_active) {
            _g.drawImage(this._swoosh, this._positionX + (this._tileWidth >> 1), this._positionY + (this._tileHeight >> 1), 3);
        }
        if (!_green) {
            if (_active) {
                _g.drawImage(this._skullDark, this._positionX + (this._tileWidth >> 1), this._positionY + (this._tileHeight >> 1), 3);
            } else {
                _g.drawImage(this._skullLight, this._positionX + (this._tileWidth >> 1), this._positionY + (this._tileHeight >> 1), 3);
            }
        }
    }

    private int getTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._totalTilesX - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._totalTilesX - 1) {
            return 2;
        }
        if (_y == this._totalTilesY - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._totalTilesY - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._totalTilesX - 1 && _y < this._totalTilesY - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._totalTilesY - 1 && _x < this._totalTilesX - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._totalTilesY - 1 && _x == this._totalTilesX - 1) {
            return 8;
        }
        return 4;
    }

    public void set_speed(int _speed) {
        this._speed = _speed;
    }

    public int get_speed() {
        return this._speed;
    }

    public void speedInccrement(int _speed) {
        this._speed += _speed;
    }

    public void inc_positionX(int _positionX) {
        this._positionX += _positionX;
    }

    public void set_positionX(int _positionX) {
        this._positionX = _positionX;
    }

    public int get_positionX() {
        return this._positionX;
    }

    public void inc_positionY(int _positionY) {
        this._positionY += _positionY;
    }

    public void set_positionY(int _positionY) {
        this._positionY = _positionY;
    }

    public int get_positionY() {
        return this._positionY;
    }

    public void set_totalTilesX(int _totalTilesX) {
        this._totalTilesX = _totalTilesX;
    }

    public int get_totalTilesX() {
        return this._totalTilesX;
    }

    public void set_totalTilesY(int _totalTilesY) {
        this._totalTilesY = _totalTilesY;
    }

    public int get_totalTilesY() {
        return this._totalTilesY;
    }

    public void set_activeTile(boolean _activeTile) {
        this._activeTile = _activeTile;
    }

    public boolean is_activeTile() {
        return this._activeTile;
    }

    public void set_greenTile(boolean _greenTile) {
        this._greenTile = _greenTile;
    }

    public boolean is_greenTile() {
        return this._greenTile;
    }

    public void setIle(boolean ile) {
        this.ile = ile;
    }

    public boolean isIle() {
        return this.ile;
    }
}

