/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Tile;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game {
    private static final int _MODE_CLASSIC = 0;
    private static final int _MODE_ARCADE = 1;
    private static final int _MODE_ZEN = 2;
    private static final int _MODE_RUSH = 3;
    public int _gameMode;
    private static final int _MODE_DIFFICULTY_EASY = 0;
    private static final int _MODE_DIFFICULTY_MEDIUM = 1;
    private static final int _MODE_DIFFICULTY_HARD = 2;
    public int _gameDifficulty;
    public int _TOTAL_TILE_ROWS = 1;
    public int _TOTAL_TILE_COLS = 1;
    public int _TOTAL_ROWS = 7;
    public int _TOTAL_COLS = 3;
    public Rectangle[][] _tilesRectangles;
    public Tile[][] _gameTile;
    public Rectangle _TILE;
    private int _TILE_WIDTH;
    private int _TILE_HEIGHT;
    private int speed = 5;
    private int shift = 5;
    private boolean deactivateTile = false;
    private boolean _gameOver = false;
    private boolean _levelDone = false;
    private int _elapsuedTime = 0;
    private int _goalTIME = 0;
    private int _goalTILE = 0;
    private boolean firstInput = true;
    private int _acceptablePositionY = 1;
    private int _score = 0;
    public int _HEIGHT = 0;
    private boolean _accSpeed = true;
    private boolean _stop = false;
    int selectedTile = -1;

    public void Game() {
    }

    public void restartGame(int _mode, int _level) {
        this._gameMode = _mode;
        this._gameDifficulty = _level;
        this.initRectangles();
        this.restartAllVar();
        this.initStartGreenTiles();
        this.prepareGoal();
        Particles.resetParticles();
    }

    private void restartAllVar() {
        if (this._gameMode == 1) {
            if (this._gameDifficulty == 0) {
                this.setSpeed(this._TILE.height >> 4);
            } else if (this._gameDifficulty == 1) {
                this.setSpeed((this._TILE.height >> 4) + (this._TILE.height >> 5));
            } else {
                this.setSpeed((this._TILE.height >> 4) + (this._TILE.height >> 5) + (this._TILE.height >> 5));
            }
        } else if (this._gameMode == 3) {
            if (this._gameDifficulty == 0) {
                this.setSpeed(this._TILE.height >> 4);
            } else if (this._gameDifficulty == 1) {
                this.setSpeed((this._TILE.height >> 4) + (this._TILE.height >> 5));
            } else {
                this.setSpeed((this._TILE.height >> 4) + (this._TILE.height >> 5) + (this._TILE.height >> 5));
            }
        } else {
            this.setSpeed(5);
        }
        this.deactivateTile = false;
        this._gameOver = false;
        this._levelDone = false;
        this._elapsuedTime = 0;
        this._goalTIME = 0;
        this._goalTILE = 0;
        this.firstInput = true;
        this._acceptablePositionY = 1;
        this._score = 0;
    }

    private void initRectangles() {
        int offsetX;
        this._tilesRectangles = new Rectangle[this._TOTAL_COLS][this._TOTAL_ROWS];
        this._gameTile = new Tile[this._TOTAL_COLS][this._TOTAL_ROWS];
        Sprite _buttonSprite = Resources.resSprs[1];
        int _rectangleWidth = MainCanvas.WIDTH / this._TOTAL_COLS;
        int _rectangleHeight = MainCanvas.HEIGHT >> 2;
        int _posX = offsetX = MainCanvas.WIDTH % this._TOTAL_COLS + (_rectangleWidth - MainCanvas.WIDTH % this._TOTAL_COLS) % _buttonSprite.getWidth();
        int _posY = 0;
        this._TILE_WIDTH = _rectangleWidth -= offsetX;
        this._TILE_HEIGHT = _rectangleHeight = _rectangleWidth + _rectangleWidth / _buttonSprite.getWidth() / 2 * _buttonSprite.getWidth();
        this._TILE = new Rectangle(_posX, _posY, this._TILE_WIDTH, this._TILE_HEIGHT);
        this._TOTAL_TILE_COLS = this._TILE.width / _buttonSprite.getWidth();
        this._TOTAL_TILE_ROWS = this._TILE.height / _buttonSprite.getHeight();
        int _finalXoffset = MainCanvas.WIDTH - this._TOTAL_COLS * _rectangleWidth;
        for (int _x = 0; _x < this._TOTAL_COLS; ++_x) {
            for (int _y = this._TOTAL_ROWS - 1; _y >= 0; --_y) {
                this._tilesRectangles[_x][_y] = new Rectangle((_finalXoffset >> 1) + _x * _rectangleWidth, MainCanvas.HEIGHT - _rectangleHeight - _y * _rectangleHeight, _rectangleWidth, _rectangleHeight);
                this._gameTile[_x][_y] = new Tile((_finalXoffset >> 1) + _x * _rectangleWidth, MainCanvas.HEIGHT - _rectangleHeight - _y * _rectangleHeight, _rectangleWidth, _rectangleHeight, this._TOTAL_TILE_COLS, this._TOTAL_TILE_ROWS, false);
            }
        }
        this.shift = this._TILE_HEIGHT >> 1;
    }

    private void prepareGoal() {
        switch (this._gameMode) {
            case 0: {
                if (this._gameDifficulty == 0) {
                    this._goalTILE = 25;
                }
                if (this._gameDifficulty == 1) {
                    this._goalTILE = 50;
                }
                if (this._gameDifficulty == 2) {
                    this._goalTILE = 100;
                }
                this._goalTIME = 0;
                break;
            }
            case 1: {
                this._goalTILE = 0;
                this._goalTIME = 0;
                break;
            }
            case 2: {
                if (this._gameDifficulty == 0) {
                    this._goalTIME = 15000;
                }
                if (this._gameDifficulty == 1) {
                    this._goalTIME = 30000;
                }
                if (this._gameDifficulty == 2) {
                    this._goalTIME = 60000;
                }
                this._goalTILE = 0;
                break;
            }
            case 3: {
                this._goalTILE = 0;
                this._goalTIME = 0;
            }
        }
    }

    private void initStartGreenTiles() {
        int _x = 0;
        for (int _y = 1; _y < this._TOTAL_ROWS; ++_y) {
            _x = RandomNum.getRandomUInt(this._TOTAL_COLS - 1);
            this._gameTile[_x][_y].set_greenTile(true);
        }
    }

    private void resetRow(int _y, int _xP) {
        int _x;
        for (_x = 0; _x < this._TOTAL_COLS; ++_x) {
            if (!this._gameTile[_x][_y].is_greenTile() || this._gameTile[_x][_y].is_activeTile()) {
                // empty if block
            }
            this._gameTile[_x][_y].set_greenTile(false);
            this._gameTile[_x][_y].set_activeTile(true);
        }
        _x = 0;
        _x = RandomNum.getRandomUInt(this._TOTAL_COLS);
        this._gameTile[_x][_y].set_greenTile(true);
    }

    public void paint(Graphics _g) {
        _g.setColor(0);
        _g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        for (int _x = 0; _x < this._TOTAL_COLS; ++_x) {
            for (int _y = 0; _y < this._TOTAL_ROWS; ++_y) {
                if (this._stop) {
                    if (!this._gameTile[_x][_y].isIle()) continue;
                    this._gameTile[_x][_y].paint(_g);
                    continue;
                }
                this._gameTile[_x][_y].paint(_g);
            }
        }
        Particles.paint(_g, 0);
        Particles.paint(_g, 1);
    }

    public void update(long lastRunLenght) {
        if (this._gameMode == 0) {
            this._elapsuedTime = (int)((long)this._elapsuedTime + lastRunLenght);
        } else if (this._gameMode == 1) {
            this._elapsuedTime = (int)((long)this._elapsuedTime + lastRunLenght);
            if (this.get_score() % this._TOTAL_ROWS == 0 && this._accSpeed) {
                this.setSpeed(this.getSpeed() + (this._tilesRectangles[0][0].height >> 5));
                this._accSpeed = false;
            }
            if (this.get_score() % this._TOTAL_ROWS != 0 && !this._accSpeed) {
                this._accSpeed = true;
            }
        } else if (this._gameMode == 2) {
            this._elapsuedTime = (int)((long)this._elapsuedTime + lastRunLenght);
        } else if (this._gameMode == 3) {
            this._elapsuedTime = (int)((long)this._elapsuedTime + lastRunLenght);
            if (this.get_score() % this._TOTAL_ROWS == 0 && this._accSpeed) {
                this.setSpeed(this.getSpeed() + (this._tilesRectangles[0][0].height >> 5));
                this._accSpeed = false;
            }
            if (this.get_score() % this._TOTAL_ROWS != 0 && !this._accSpeed) {
                this._accSpeed = true;
            }
        }
        this.checkLevelDone();
        for (int _x = 0; _x < this._TOTAL_COLS; ++_x) {
            for (int _y = 0; _y < this._TOTAL_ROWS; ++_y) {
                boolean add;
                int newY;
                int oldspeed;
                if (this._gameMode == 1) {
                    oldspeed = this._gameTile[_x][_y].get_positionY();
                    this._tilesRectangles[_x][_y].y += this.getSpeed();
                    this._gameTile[_x][_y].inc_positionY(this.getSpeed());
                    if (this._gameTile[_x][_y].get_positionY() != oldspeed + this.getSpeed()) {
                        this._tilesRectangles[_x][_y].y += oldspeed - this.getSpeed();
                        this._gameTile[_x][_y].inc_positionY(oldspeed - this.getSpeed());
                    }
                    if (this._gameTile[_x][_y].get_positionY() >= MainCanvas.HEIGHT && this._gameTile[_x][_y].is_greenTile() && this._gameTile[_x][_y].is_activeTile() && this._acceptablePositionY == _y) {
                        this.set_gameOver(true);
                        System.out.println("GAME OVER x: " + this._gameTile[_x][_y].get_positionX() + " y: " + this._gameTile[_x][_y].get_positionY());
                        return;
                    }
                    if (this._tilesRectangles[_x][_y].y >= MainCanvas.HEIGHT) {
                        newY = _y - 1;
                        add = false;
                        if (newY < 0) {
                            newY = 6;
                            add = true;
                        }
                        this._tilesRectangles[_x][_y].y = this._gameTile[_x][newY].get_positionY() - this._TILE.height + (add ? this.getSpeed() : 0);
                        this._gameTile[_x][_y].set_positionY(this._gameTile[_x][newY].get_positionY() - this._TILE.height + (add ? this.getSpeed() : 0));
                        this.resetRow(_y, _x);
                        add = false;
                    }
                } else if (this._gameMode == 3) {
                    oldspeed = this._gameTile[_x][_y].get_positionY();
                    this._tilesRectangles[_x][_y].y += this.getSpeed();
                    this._gameTile[_x][_y].inc_positionY(this.getSpeed());
                    if (this._gameTile[_x][_y].get_positionY() != oldspeed + this.getSpeed()) {
                        this._tilesRectangles[_x][_y].y += oldspeed - this.getSpeed();
                        this._gameTile[_x][_y].inc_positionY(oldspeed - this.getSpeed());
                    }
                    if (this._gameTile[_x][_y].get_positionY() >= MainCanvas.HEIGHT && this._gameTile[_x][_y].is_greenTile() && this._gameTile[_x][_y].is_activeTile() && this._acceptablePositionY == _y) {
                        this.set_gameOver(true);
                        System.out.println("GAME OVER x: " + this._gameTile[_x][_y].get_positionX() + " y: " + this._gameTile[_x][_y].get_positionY());
                        return;
                    }
                    if (this._tilesRectangles[_x][_y].y >= MainCanvas.HEIGHT) {
                        newY = _y - 1;
                        add = false;
                        if (newY < 0) {
                            newY = 6;
                            add = true;
                        }
                        this._tilesRectangles[_x][_y].y = this._gameTile[_x][newY].get_positionY() - this._TILE.height + (add ? this.getSpeed() : 0);
                        this._gameTile[_x][_y].set_positionY(this._gameTile[_x][newY].get_positionY() - this._TILE.height + (add ? this.getSpeed() : 0));
                        this.resetRow(_y, _x);
                        add = false;
                    }
                } else if (this._gameMode == 0) {
                    if (this.deactivateTile) {
                        this._tilesRectangles[_x][_y].y += this.shift << 1;
                        this._gameTile[_x][_y].inc_positionY(this.shift << 1);
                    }
                    if (this._tilesRectangles[_x][_y].y >= MainCanvas.HEIGHT) {
                        this._tilesRectangles[_x][_y].y = MainCanvas.HEIGHT - this._TOTAL_ROWS * this._TILE.height;
                        this._gameTile[_x][_y].set_positionY(MainCanvas.HEIGHT - this._TOTAL_ROWS * this._TILE.height);
                        this.resetRow(_y, _x);
                    }
                } else if (this._gameMode == 2) {
                    if (this.deactivateTile) {
                        this._tilesRectangles[_x][_y].y += this.shift << 1;
                        this._gameTile[_x][_y].inc_positionY(this.shift << 1);
                    }
                    if (this._tilesRectangles[_x][_y].y >= MainCanvas.HEIGHT) {
                        this._tilesRectangles[_x][_y].y = MainCanvas.HEIGHT - this._TOTAL_ROWS * this._TILE.height;
                        this._gameTile[_x][_y].set_positionY(MainCanvas.HEIGHT - this._TOTAL_ROWS * this._TILE.height);
                        this.resetRow(_y, _x);
                    }
                }
                if (this._gameTile[_x][_y].get_positionY() >= MainCanvas.HEIGHT && this._gameTile[_x][_y].is_greenTile() && !this._gameTile[_x][_y].is_activeTile()) continue;
            }
        }
        Particles.update();
        this.deactivateTile = false;
    }

    public void createParticles(Rectangle _rect, boolean _green) {
        Sprite _particles = _green ? Resources.resSprs[6] : Resources.resSprs[7];
        Particles.createParticle(_rect.x + (_rect.width >> 1), _rect.y + (_rect.height >> 1), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), _particles, 0, 10, 0);
        Particles.createParticle(_rect.x + (_rect.width >> 1), _rect.y + (_rect.height >> 1), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), _particles, 0, 10, 0);
        Particles.createParticle(_rect.x + (_rect.width >> 1), _rect.y + (_rect.height >> 1), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), _particles, 0, 10, 0);
        Particles.createParticle(_rect.x + (_rect.width >> 1), _rect.y + (_rect.height >> 1), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), _particles, 0, 10, 0);
        Particles.createParticle(_rect.x + (_rect.width >> 1), _rect.y + (_rect.height >> 1), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), RandomNum.getRandomInt(8, 3), _particles, 0, 10, 0);
    }

    public void pressTile(int _col) {
        Tile _tile = null;
        if (_col == 1) {
            System.out.println("_row: " + _col);
            _tile = this.getlowestTile(_col - 1);
            _tile.set_activeTile(false);
            this.createParticles(new Rectangle(_tile.get_positionX(), _tile.get_positionY() + this._tilesRectangles[0][0].height, this._tilesRectangles[0][0].width, this._tilesRectangles[0][0].height), _tile.is_greenTile());
            this.deactivateTile = true;
            if (_tile.is_greenTile()) {
                this.set_score(this.get_score() + 1);
            } else {
                this.set_gameOver(true);
            }
        } else if (_col == 2) {
            System.out.println("_row: " + _col);
            _tile = this.getlowestTile(_col - 1);
            _tile.set_activeTile(false);
            this.createParticles(new Rectangle(_tile.get_positionX(), _tile.get_positionY() + this._tilesRectangles[0][0].height, this._tilesRectangles[0][0].width, this._tilesRectangles[0][0].height), _tile.is_greenTile());
            this.deactivateTile = true;
            if (_tile.is_greenTile()) {
                this.set_score(this.get_score() + 1);
            } else {
                this.set_gameOver(true);
            }
        } else if (_col == 3) {
            System.out.println("_acceptablePositionY " + this._acceptablePositionY);
            _tile = this.getlowestTile(_col - 1);
            _tile.set_activeTile(false);
            this.createParticles(new Rectangle(_tile.get_positionX(), _tile.get_positionY() + this._tilesRectangles[0][0].height, this._tilesRectangles[0][0].width, this._tilesRectangles[0][0].height), _tile.is_greenTile());
            this.deactivateTile = true;
            if (_tile.is_greenTile()) {
                this.set_score(this.get_score() + 1);
            } else {
                this.set_gameOver(true);
            }
        }
    }

    private Tile getlowestTile(int _x) {
        System.out.println("_acceptablePositionY " + this._acceptablePositionY);
        Tile _lowestTile = null;
        if (this.firstInput) {
            this.firstInput = false;
            for (int _y = 1; _y < this._TOTAL_ROWS; ++_y) {
                if (_lowestTile == null) {
                    _lowestTile = this._gameTile[_x][_y];
                    continue;
                }
                if (_lowestTile.get_positionY() >= this._gameTile[_x][_y].get_positionY()) continue;
                _lowestTile = this._gameTile[_x][_y];
            }
            ++this._acceptablePositionY;
            return _lowestTile;
        }
        int _y = this._acceptablePositionY;
        if (_lowestTile == null) {
            _lowestTile = this._gameTile[_x][_y];
        } else if (_lowestTile.get_positionY() < this._gameTile[_x][_y].get_positionY()) {
            _lowestTile = this._gameTile[_x][_y];
        }
        ++this._acceptablePositionY;
        if (this._acceptablePositionY > this._TOTAL_ROWS - 1) {
            this._acceptablePositionY = 0;
        }
        return _lowestTile;
    }

    private void checkLevelDone() {
        block0 : switch (this._gameMode) {
            case 0: {
                switch (this._gameDifficulty) {
                    case 0: {
                        if (this._score < this._goalTILE) break;
                        this.set_levelDone(true);
                        break;
                    }
                    case 1: {
                        if (this._score < this._goalTILE) break;
                        this.set_levelDone(true);
                        break;
                    }
                    case 2: {
                        if (this._score < this._goalTILE) break;
                        this.set_levelDone(true);
                    }
                }
                break;
            }
            case 1: {
                switch (this._gameDifficulty) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                System.out.println("mode zen");
                switch (this._gameDifficulty) {
                    case 0: {
                        if (this._goalTIME > this._elapsuedTime) break;
                        this.set_levelDone(true);
                        break;
                    }
                    case 1: {
                        if (this._goalTIME > this._elapsuedTime) break;
                        this.set_levelDone(true);
                        break;
                    }
                    case 2: {
                        System.out.println("diff hard: " + this._elapsuedTime + " , _goalTIME: " + this._goalTIME);
                        if (this._goalTIME > this._elapsuedTime) break;
                        this.set_levelDone(true);
                    }
                }
                break;
            }
            case 3: {
                switch (this._gameDifficulty) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        for (int _x = 0; _x < this._TOTAL_COLS; ++_x) {
            for (int _y = 0; _y < this._TOTAL_ROWS; ++_y) {
                if (!this._tilesRectangles[_x][_y].contains(x, y)) continue;
                if (this.firstInput) {
                    this.firstInput = false;
                }
                if (this._acceptablePositionY != _y) {
                    return;
                }
                Tile _tile = this._gameTile[_x][_y];
                _tile.set_activeTile(false);
                this.createParticles(new Rectangle(_tile.get_positionX(), _tile.get_positionY() + this._tilesRectangles[0][0].height, this._tilesRectangles[0][0].width, this._tilesRectangles[0][0].height), _tile.is_greenTile());
                this.deactivateTile = true;
                if (_tile.is_greenTile()) {
                    this.set_score(this.get_score() + 1);
                } else {
                    this.set_gameOver(true);
                }
                ++this._acceptablePositionY;
                if (this._acceptablePositionY <= this._TOTAL_ROWS - 1) continue;
                this._acceptablePositionY = 0;
            }
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void set_score(int _score) {
        this._score = _score;
    }

    public int get_score() {
        return this._score;
    }

    public int getSeconds() {
        return this._elapsuedTime / 1000;
    }

    public int getStotiny() {
        return this._elapsuedTime % 1000 / 100;
    }

    public int getTisiciny() {
        return this._elapsuedTime % 1000 % 100 / 10;
    }

    public void set_levelDone(boolean _levelDone) {
        this._levelDone = _levelDone;
    }

    public boolean is_levelDone() {
        return this._levelDone;
    }

    public void set_gameOver(boolean _gameOver) {
        this._gameOver = _gameOver;
    }

    public boolean is_gameOver() {
        return this._gameOver;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getSpeed() {
        return this.speed;
    }
}

