/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas mainCanvas;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "sk"};
    public static final int _BUTTON_LANGUAGE_EN = 0;
    public static final int _BUTTON_LANGUAGE_DE = 1;
    public static final int _BUTTON_LANGUAGE_FR = 2;
    public static final int _BUTTON_LANGUAGE_ES = 3;
    public static final int _BUTTON_LANGUAGE_PT = 4;
    public static final int _BUTTON_LANGUAGE_SK = 5;
    private Rectangle[] _RectButton = new Rectangle[6];
    private PreparedText _buttonTitle;
    private int _totalColTiles;
    private int _totalRowTiles;
    private int selectedCompId;
    private static final int selectorPadding = 0;
    int x;
    int y;

    public ScreenLanguage(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImage(13);
        Resources.loadSprites(new int[]{0, 2, 5});
        Resources.loadGFont(0);
        this.calculatePositions();
        this.selectedCompId = -1;
        this.calculateSelectorPos();
        this.prepareTxt();
    }

    private void prepareTxt() {
        this._buttonTitle = new PreparedText(Resources.resGFonts[0]);
    }

    public void afterHide() {
        Resources.freeImage(13);
        Resources.freeSprites(new int[]{0, 2, 5});
        Resources.freeGFont(0);
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int offsetX;
        Sprite _buttonSprite = Resources.resSprs[0];
        int _buttonHeight = Resources.resImgs[13].getHeight();
        int _buttonWidth = this.mainCanvas.getWidth() >> 1;
        int _posX = offsetX = _buttonWidth % _buttonSprite.getWidth();
        int _posY = (this.mainCanvas.getHeight() >> 1) - _buttonHeight - (_buttonHeight >> 1);
        this._RectButton[0] = new Rectangle(_posX, _posY, _buttonWidth - offsetX, _buttonHeight);
        this._RectButton[1] = new Rectangle(_posX += _buttonWidth - offsetX, _posY, _buttonWidth - offsetX, _buttonHeight);
        this._RectButton[2] = new Rectangle(_posX -= _buttonWidth - offsetX, _posY += _buttonHeight, _buttonWidth - offsetX, _buttonHeight);
        this._RectButton[3] = new Rectangle(_posX += _buttonWidth - offsetX, _posY, _buttonWidth - offsetX, _buttonHeight);
        this._RectButton[4] = new Rectangle(_posX -= _buttonWidth - offsetX, _posY += _buttonHeight, _buttonWidth - offsetX, _buttonHeight);
        this._RectButton[5] = new Rectangle(_posX += _buttonWidth - offsetX, _posY, _buttonWidth - offsetX, _buttonHeight);
        this._totalColTiles = this._RectButton[0].width / _buttonSprite.getWidth();
        this._totalRowTiles = this._RectButton[0].height / _buttonSprite.getHeight();
    }

    private void calculateSelectorPos() {
        if (MainCanvas.touchActivated) {
            return;
        }
    }

    public void update(long lastRunLenght) {
    }

    public void keyPressed(int keyCode) {
        this.mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this.selectedCompId % 2 == 1) {
                    --this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this.selectedCompId % 2 == 0) {
                    ++this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this.selectedCompId / 2 > 0) {
                    this.selectedCompId -= 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this.selectedCompId != 5 && this.selectedCompId != 4 && this.selectedCompId / 2 < 3) {
                    this.selectedCompId += 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.selectedCompId == 2) {
                    MainCanvas._frLang = true;
                }
                Resources.initLangDirs(langCodes[this.selectedCompId]);
                this.mainCanvas.changeLastActiveScreen(new ScreenSplash(this.mainCanvas));
            } else if (Keys.isActionGeneratedByKey(-6, keyCode)) {
                if (this.selectedCompId == 2) {
                    MainCanvas._frLang = true;
                }
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            } else if (Keys.isActionGeneratedByKey(-7, keyCode)) {
                if (this.selectedCompId == 2) {
                    MainCanvas._frLang = true;
                }
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            }
        }
        this.mainCanvas.repaint();
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(970808);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.paintMenuButtons(g);
    }

    private void paintMenuButtons(Graphics g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[2];
        if (this.selectedCompId == 0) {
            this.paintButtonBg(g, _buttonReleased, 0);
            this.paintMenuButtonsTitle(g, 0);
        } else {
            this.paintButtonBg(g, _buttonPressed, 0);
            this.paintMenuButtonsTitle(g, 0);
        }
        if (this.selectedCompId == 1) {
            this.paintButtonBg(g, _buttonReleased, 1);
            this.paintMenuButtonsTitle(g, 1);
        } else {
            this.paintButtonBg(g, _buttonPressed, 1);
            this.paintMenuButtonsTitle(g, 1);
        }
        if (this.selectedCompId == 2) {
            this.paintButtonBg(g, _buttonReleased, 2);
            this.paintMenuButtonsTitle(g, 2);
        } else {
            this.paintButtonBg(g, _buttonPressed, 2);
            this.paintMenuButtonsTitle(g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(g, _buttonReleased, 3);
            this.paintMenuButtonsTitle(g, 3);
        } else {
            this.paintButtonBg(g, _buttonPressed, 3);
            this.paintMenuButtonsTitle(g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(g, _buttonReleased, 4);
            this.paintMenuButtonsTitle(g, 4);
        } else {
            this.paintButtonBg(g, _buttonPressed, 4);
            this.paintMenuButtonsTitle(g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(g, _buttonReleased, 5);
            this.paintMenuButtonsTitle(g, 5);
        } else {
            this.paintButtonBg(g, _buttonPressed, 5);
            this.paintMenuButtonsTitle(g, 5);
        }
    }

    private void paintMenuButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 0: {
                this._buttonTitle.prepareText("ENGLISH", this._RectButton[0].width);
                this._buttonTitle.drawText(_g, this._RectButton[0], 0, 3);
                break;
            }
            case 1: {
                this._buttonTitle.prepareText("DEUTSCH", this._RectButton[1].width);
                this._buttonTitle.drawText(_g, this._RectButton[1], 0, 3);
                break;
            }
            case 2: {
                this._buttonTitle.prepareText("FRAN\u00c7AIS", this._RectButton[2].width);
                this._buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                this._buttonTitle.prepareText("ESPA\u00d1OL", this._RectButton[3].width);
                this._buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                this._buttonTitle.prepareText("PORT.", this._RectButton[4].width);
                this._buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                this._buttonTitle.prepareText("SLOVENSKY", this._RectButton[5].width);
                this._buttonTitle.drawText(_g, this._RectButton[5], 0, 3);
            }
        }
    }

    private void paintButtonBg(Graphics _g, Sprite _buttonSprite, int _buttonRect) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int _x = this._RectButton[_buttonRect].x; _x < this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width; _x += _buttonSprite.getWidth()) {
            for (int _y = this._RectButton[_buttonRect].y; _y < this._RectButton[_buttonRect].y + this._RectButton[_buttonRect].height; _y += _buttonSprite.getHeight()) {
                _buttonSprite.setFrame(this.getButtonTileSprite(_actualTileX, _actualTileY));
                _buttonSprite.setPosition(_x, _y);
                _buttonSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getButtonTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._totalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._totalColTiles - 1) {
            return 2;
        }
        if (_y == this._totalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._totalColTiles - 1 && _y < this._totalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._totalRowTiles - 1 && _x < this._totalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._totalRowTiles - 1 && _x == this._totalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this._RectButton.length; ++i) {
            if (!this._RectButton[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this._RectButton[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }
}

