/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class CardPackUI
implements SAI,
CardPackUIDefs {
    ShellyCanvas pShelly = null;
    Object pNet = null;
    Game pGame = null;
    public static final int canvasHeight = ShellyCanvas.pShelly.getHeight();
    public static final int canvasWidth = ShellyCanvas.pShelly.getWidth();
    public static final int canvasWidthHalf = canvasWidth >> 1;
    public static final int canvasHeightHalf = canvasHeight >> 1;
    boolean bExtraSound = false;
    boolean bTuneLoaded = false;
    boolean wasInGame = false;
    boolean bInGame = false;
    boolean bMPmode = false;
    int gamePauseState;
    int tagLeaderType = 0;
    int tagBoardMode = 0;
    boolean leaderBoardReturnGL = false;
    int optHints = 14;
    int gameTypeSelected;
    int faceSelected = 0;
    static final int MNEUBAR_WIDTH;
    static final int MENUBAR_HEIGHT;
    static final int MENU_TITLE_HCENTER;
    static final int MENU_ITEMS_TOP;
    static final int MENU_ITEMS_BOTTOM;
    static final int MENU_SPACING_OFFSET;
    static final int MENU_TEXTBOX_X;
    static final int MENU_TEXTBOX_Y;
    static final int MENU_TEXTBOX_WIDTH;
    static final int MENU_TEXTBOX_HEIGHT;
    static final int MENU_TEXTBOX_YGAP;
    static final int MENU_GRADFILLBUFFER;
    static final int CHAT_INFORM_SIZE;
    static final int CHAT_MSG_SIZEX;
    static final int CHAT_MSG_SIZEY;
    static final int MENU_ARROWSIZE;
    static final int MENU_DISPLAY_CENTERED = 0;
    static final int MENU_DISPLAY_ONEATTOP = 1;
    int menuDisplayMode = 0;
    int menuTitleY = 0;
    int menuGap;
    int menuSpacing;
    int menuYStart;
    int menuMaxWidth;
    int menuArrowYtop;
    int menuArrowYbottom;
    static final int MAX_LOAD_PHASE = 20;
    static final int LOADING_BAR_WIDTH;
    static final int LOADING_BAR_HEIGHT;
    static final int LOADING_BACK_COLOUR = 0xFF0000;
    static final int LOADING_BOX_COLOUR = 0xFFFFFF;
    static final int LOADING_BAR_COLOUR = 255;
    private int loadPhase = 0;
    public static final int rmsVersion = 4662;
    int winsGin = 0;
    int winsHearts = 0;
    int winsSpades = 0;
    int lossGin = 0;
    int lossHearts = 0;
    int lossSpades = 0;
    public boolean resetLeaderboard;
    public String[] leaderboardnames = null;
    public String[] leaderboardscores = null;
    public String[] _buddyNames = null;
    public int _buddyCount = 0;
    public boolean buddymenu = false;
    public int lastBuddySelect = -1;
    public int lastFriendSelect = -1;
    public int lastFoeSelect = -1;
    public boolean bRoomIsPrivate = false;
    private int privateLobbyID = -1;
    private int demoFlash = 0;
    private static final int DEMO_FLASH_RATE = 10;
    public boolean bAccept = false;
    static final int[] arrowVertex;
    int avSelEmote = 0;
    long avSelTimer;
    String curList = null;
    String[] avlistOptions;
    int avListNum;
    boolean avListGroup = false;
    boolean bDataArrived = false;
    int avBackState;
    String avBackString;
    int avImageSize = -1;
    int avImageSel = -1;
    boolean bCurIsRoot;
    boolean avIsCurrentSel = false;
    Object objMessage = null;
    boolean bTuneOn = true;
    private char[] cheatBuffer = new char[CafeCardsEngine.cheatCodes[0].length()];
    final int nCheatBuffer = this.cheatBuffer.length;
    boolean bCheatLegal = false;
    long cheatMessageUntil = 0L;
    private boolean bNetFormMode = false;
    int currfont = -1;
    Object objFormHeader = null;
    Object objFormFooter = null;
    static String[] tstr;
    int waitCount = 0;
    Object netMsg = null;
    int chatState = 0;
    boolean bChatNotifyPending = false;
    int chatNum = 0;
    private int chatViewing = 0;
    long viewTime = 0L;
    long viewClockLast = 0L;
    int chatScrollPos = 0;
    int msgMaxScrollPos = 0;
    static final int CHAT_SOURCE_SEAT0 = 0;
    static final int CHAT_SOURCE_SEAT1 = 1;
    static final int CHAT_SOURCE_SEAT2 = 2;
    static final int CHAT_SOURCE_SEAT3 = 3;
    static final int CHAT_SOURCE_INFORM0 = 4;
    static final int CHAT_SOURCE_INFORM1 = 5;
    static final int CHAT_SOURCE_INFORM2 = 6;
    static final int CHAT_SOURCE_INFORM3 = 7;
    static final int CHAT_SOURCE_OUTOFROOM = 8;
    final int[] chatSource = new int[]{34, 0, -15, 5, 10, -5, 18, 0, -5, 9, -10, -5, 36, 7, -12, 36, 7, -12, 40, -7, -12, 40, -7, -12, 24, -15, 15};
    int chatBoundX1 = 0;
    int chatBoundY1 = 0;
    int chatBoundW = 0;
    int chatBoundH = 0;
    static final int BUBBLE_RADCURV = 6;
    static final int BUBBLE_TAG_RAD;
    static final int BUBBLE_TAG_RADEDGE = 13;
    static final int BUBBLE_RADRND = 8;
    static final int BUBBLE_ARROWBORDER = 6;
    static final int BUBBLE_OFFSET_EDGESET = 18;
    static final int BUBBLE_BORDER_COL = 0x660000;
    static final int BUBBLE_BORDER_COL2 = 14126734;
    static final int BUBBLE_COL = 0xFFFFFF;
    static final int BUBBLEBKG_COL = 0xFFFFFF;
    static final int BUBBLEBKG_COL2 = 0xFFE0E0;
    int msgPosX;
    int msgPosY;
    int msgPosSrc;
    int msgBubbleX;
    int msgBubbleY;
    int msgNumLines;
    int msgNumLinesTot;
    int msgBubbleHeight;
    int msgBubbleAnchor;
    Object objMsg = null;

    public CardPackUI() {
        ShellyCanvas.reportDebug("CLASS_ID=CardPackUI instantiating");
    }

    public void start(ShellyCanvas shellyCanvas) {
        this.pShelly = shellyCanvas;
        ShellyCanvas.reportDebug("******************** STNDARD CONFIG");
        String[] stringArray = new String[]{"c2mlogo", null, null, "GameTitle", null, "medium_font", "small_font_red", "small_font", "large_font", "large_font", "bg_01", "fg_01", "headcircle", "headlight", "menu_screen", "softkeys", "baredges", "cards", "cards_dark", "buttons", "bidcircle", "speech_bubble", "smileys", "arrows", "avatars", "cursor", "title.mid", "ping.mid"};
        this.pShelly.registerResourceList(stringArray);
    }

    public boolean init() {
        HFont hFont;
        this.pShelly.skipHideNotify();
        this.pShelly.fontCreate(0, 5, 1879048721, 0xFFFFFF);
        this.pShelly.fontCreate(1, 6, 1879048337, 0xA00000);
        this.pShelly.fontCreate(2, 7, 1879048337, 0xFFFFFF);
        this.pShelly.fontCreate(3, 8, 1879048722, 0xA00000);
        this.pShelly.fontCreate(4, 9, 1879048742, 0xA00000);
        this.pShelly.fontSetUsage(3, 0);
        this.pShelly.fontSetUsage(4, 1);
        this.pShelly.fontSetUsage(0, 2);
        this.pShelly.fontSetUsage(1, 4);
        this.pShelly.fontSetUsage(1, 5);
        if (this.pShelly.fontIsSoftFont(3)) {
            hFont = (HFont)this.pShelly.fontGetObject(3);
            hFont.setCharSpacing(-1);
        }
        if (this.pShelly.fontIsSoftFont(0)) {
            hFont = (HFont)this.pShelly.fontGetObject(0);
            hFont.setCharSpacing(-1);
        }
        this.pShelly.softKeySetOffsetX(38);
        int n = (canvasHeight >> 6) + 0;
        this.pShelly.softKeySetAboveBase(n);
        this.pShelly.softKeySetJustification(1);
        this.loadInMenuArt();
        this.loadSoftKeyArt();
        this.pShelly.menuHistoryInit(20);
        return false;
    }

    public void destroy() {
    }

    public boolean loadUI() {
        switch (this.loadPhase) {
            case 0: {
                this.pShelly.skipHideNotify();
                this.pGame = new Game(this, this.pShelly);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.bTuneLoaded = -1 != this.pShelly.soundCreate(0, 26, 65776);
                break;
            }
            case 5: {
                this.bExtraSound |= -1 != this.pShelly.soundCreate(1, 27, 128);
                break;
            }
            case 8: {
                this.bExtraSound |= -1 != this.pShelly.soundCreate(2, 27, 128);
                break;
            }
            case 13: {
                this.loadCommonArt();
                break;
            }
            case 17: {
                this.pShelly.skipHideNotify();
                this.LoadRms();
                if (!this.bTuneLoaded) break;
                this.setTuneOn(this.pShelly.soundIsOn());
                break;
            }
            default: {
                if (this.loadPhase < 20) break;
                return false;
            }
        }
        ++this.loadPhase;
        return true;
    }

    public void loadImageSafe(int n, int n2) {
        if (!this.pShelly.imageLoaded(n2)) {
            this.pShelly.imageCreate(n2, n, 0);
        }
        this.pShelly.garbageCollect();
    }

    void loadInMenuArt() {
        ShellyCanvas.reportTrace("MEM: loadInMenuArt()");
        this.loadImageSafe(14, 5);
        this.loadImageSafe(23, 14);
        this.loadImageSafe(16, 7);
    }

    void loadSoftKeyArt() {
        ShellyCanvas.reportTrace("MEM: loadSoftKeyArt()");
        this.loadImageSafe(15, 6);
    }

    void loadCommonArt() {
        ShellyCanvas.reportTrace("MEM: loadCommonArt()");
        this.loadImageSafe(21, 12);
    }

    void loadSmileyArt() {
        if (!this.pShelly.imageLoaded(13)) {
            ShellyCanvas.reportTrace("MEM: loadSmileyArt()");
            this.loadImageSafe(22, 13);
        }
    }

    void loadInGameArt() {
        ShellyCanvas.reportTrace("MEM: loadInGameArt()");
        this.loadImageSafe(24, 15);
        this.loadImageSafe(12, 3);
        this.loadImageSafe(13, 4);
        this.loadImageSafe(19, 10);
        this.loadImageSafe(20, 11);
        this.loadImageSafe(17, 8);
        this.loadImageSafe(18, 9);
        this.loadImageSafe(25, 16);
        this.loadImageSafe(10, 1);
        this.loadImageSafe(11, 2);
    }

    void dumpInMenuArt() {
        ShellyCanvas.reportTrace("MEM: dumpInMenuArt()");
        this.pShelly.imageRemove(5);
        this.pShelly.imageRemove(7);
    }

    void dumpInGameArt() {
        ShellyCanvas.reportTrace("MEM: dumpInGameArt()");
        if (this.pShelly.imageLoaded(15)) {
            this.pShelly.imageRemove(15);
        }
        this.pShelly.imageRemove(3);
        this.pShelly.imageRemove(4);
        this.pShelly.imageRemove(10);
        this.pShelly.imageRemove(11);
        this.pShelly.imageRemove(8);
        this.pShelly.imageRemove(9);
        this.pShelly.imageRemove(16);
        this.pShelly.imageRemove(1);
        this.pShelly.imageRemove(2);
    }

    void dumpSmileyArt() {
        ShellyCanvas.reportTrace("MEM: dumpSmileyArt()");
        this.pShelly.imageRemove(13);
    }

    public void suspendFinished() {
        int n = this.pShelly.stateGetCurrent();
        if (n >= 2000) {
            this.pShelly.fontSetUsage(1, 4);
            this.pShelly.stateChange(1900);
        }
    }

    public void paint(int n, ShellyGraphics shellyGraphics, boolean bl) {
        if (n >= 2000) {
            this.pGame.Game_Paint(n, shellyGraphics, bl);
            return;
        }
        this.backGroundPaint(shellyGraphics, n);
        switch (n) {
            case 1000: {
                int n2 = 0;
                if (this.loadPhase < 0) {
                    this.loadPhase = 0;
                }
                if (this.loadPhase > 0) {
                    n2 = LOADING_BAR_WIDTH * this.loadPhase / 20;
                }
                int n3 = canvasWidthHalf - (LOADING_BAR_WIDTH >> 1);
                int n4 = canvasHeight - (LOADING_BAR_HEIGHT << 1);
                shellyGraphics.setColor(0xFF0000);
                shellyGraphics.fillRect(n3, n4, LOADING_BAR_WIDTH, LOADING_BAR_HEIGHT);
                shellyGraphics.setColor(255);
                shellyGraphics.fillRect(n3, n4, n2, LOADING_BAR_HEIGHT);
                shellyGraphics.setColor(0xFFFFFF);
                shellyGraphics.drawRect(n3, n4, LOADING_BAR_WIDTH, LOADING_BAR_HEIGHT);
                String string = this.pShelly.bab(5) + " : " + " [" + this.loadPhase + '/' + 20 + ']';
                this.pShelly.textDraw(shellyGraphics, 3, string, canvasWidthHalf, canvasHeightHalf, 17);
                break;
            }
            case 1001: 
            case 1002: 
            case 1005: {
                this.menuPaint(shellyGraphics);
                break;
            }
            case 1003: 
            case 1004: {
                break;
            }
            case 1006: 
            case 1007: {
                this.menu_PaintTitle(shellyGraphics, this.pShelly.menuGetTitle());
                this.menu_PaintAvatarSelect(shellyGraphics);
                break;
            }
            case 1008: {
                this.menuPaint(shellyGraphics);
                this.menu_paintHighScore(shellyGraphics);
                break;
            }
            case 1010: {
                this.menuPaint(shellyGraphics);
                break;
            }
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1026: {
                this.helpPaint(shellyGraphics);
                break;
            }
            case 1011: {
                this.helpPaint(shellyGraphics);
                break;
            }
            case 1018: {
                this.menuPaint(shellyGraphics);
                break;
            }
            case 1024: {
                this.menuPaint(shellyGraphics);
                break;
            }
            case 1032: {
                break;
            }
            case 1030: 
            case 1031: 
            case 1037: 
            case 1039: 
            case 1040: {
                break;
            }
            case 1036: {
                this.helpPaint(shellyGraphics);
                break;
            }
            case 1041: {
                break;
            }
            case 1042: 
            case 1043: 
            case 1044: 
            case 1045: 
            case 1046: 
            case 1047: 
            case 1048: {
                break;
            }
            case 1061: 
            case 1062: 
            case 1063: 
            case 1065: 
            case 1066: 
            case 1067: {
                break;
            }
            case 1064: {
                break;
            }
            case 1900: 
            case 1901: 
            case 1902: {
                this.menuPaint(shellyGraphics);
                break;
            }
        }
    }

    public void paintDemoIndicator(ShellyGraphics shellyGraphics) {
        if (this.demoFlash < 5) {
            int n = 3;
            int n2 = 3;
            shellyGraphics.setColor(16185047);
            int n3 = this.pShelly.fontGetHeight(n) + (n2 << 1);
            int n4 = this.pShelly.getHeightwithSK() - n3 - (n2 << 1);
            shellyGraphics.fillRect(0, n4, this.pShelly.getWidth(), n3);
            this.pShelly.textDraw(shellyGraphics, n, this.pShelly.bab(51), this.pShelly.getMidX(), n4 + n2, 17);
        }
    }

    public void Ui_ChangeState(int n) {
        this.pShelly.softKeySet(-1, -1);
        this.pShelly.stateChange(n);
    }

    public void stateProcess(int n) {
        if (n >= 2000) {
            this.pGame.stateProcess(n);
            return;
        }
        switch (n) {
            case 1000: {
                if (!this.loadUI()) {
                    this.pShelly.stateChange(1001);
                }
                this.pShelly.paintSetRefresh();
                break;
            }
            case 1001: {
                if (this.pShelly.demoModeOn()) {
                    ++this.demoFlash;
                    this.demoFlash %= 10;
                    this.pShelly.paintSetRefresh();
                }
                this.pShelly.menuUpdate();
                break;
            }
            case 1002: 
            case 1005: 
            case 1010: 
            case 1018: 
            case 1024: {
                this.pShelly.menuUpdate();
                break;
            }
            case 1008: {
                this.pShelly.menuUpdateUser();
                break;
            }
            case 1003: 
            case 1004: {
                break;
            }
            case 1006: {
                this.pShelly.menuUpdate();
                this.menu_AvatarSelectProc();
                break;
            }
            case 1007: {
                break;
            }
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1026: {
                this.pShelly.helpUpdate();
                break;
            }
            case 1011: {
                this.pShelly.helpUpdate();
                break;
            }
            case 1032: {
                break;
            }
            case 1030: 
            case 1031: 
            case 1037: 
            case 1041: 
            case 1042: 
            case 1043: 
            case 1044: 
            case 1045: {
                break;
            }
            case 1036: {
                break;
            }
            case 1039: 
            case 1040: {
                break;
            }
            case 1048: {
                break;
            }
            case 1047: {
                break;
            }
            case 1046: {
                break;
            }
            case 1061: 
            case 1063: {
                break;
            }
            case 1062: {
                break;
            }
            case 1064: {
                break;
            }
            case 1065: {
                break;
            }
            case 1066: {
                break;
            }
            case 1067: {
                break;
            }
            case 1900: {
                this.pShelly.menuUpdate();
                break;
            }
            case 1901: 
            case 1902: {
                break;
            }
        }
    }

    public void stateExit(int n, int n2) {
        if (n >= 2000) {
            this.pGame.Game_StateExit(n, n2);
            return;
        }
        switch (n) {
            case 1005: {
                break;
            }
            case 1030: {
                break;
            }
            case 1031: {
                break;
            }
            case 1043: 
            case 1044: 
            case 1045: {
                break;
            }
            case 1900: {
                if (n2 < 2100) break;
                if (this.bAccept) {
                    this.pShelly.softKeySet(11, -1);
                } else {
                    this.pShelly.softKeySet(-1, 7);
                }
                this.pShelly.keyClear(397344);
                this.pGame.checkHintsExitingPause();
                break;
            }
        }
    }

    public boolean IsInGame() {
        return this.pShelly.stateGetCurrent() >= 2000;
    }

    public static boolean IsHelpState(int n) {
        return n >= 1010 && n <= 1016 || n == 13 || n == 14;
    }

    public static boolean IsOptionState(int n) {
        return n >= 1018 && n <= 1023 || n == 11;
    }

    public void stateEnter(int n, int n2) {
        if (n2 >= 2000) {
            this.pGame.Game_StateEnter(n, n2);
            return;
        }
        this.menuDisplayMode = 0;
        switch (n2) {
            case 1000: {
                this.pShelly.skipHideNotify();
                this.loadPhase = 0;
                this.pShelly.softKeySet(-1, -1);
                break;
            }
            case 1001: {
                this.pShelly.menuCreate(this.pShelly.bab(97), 0, 1, 0, 17, true, true, 4128);
                this.pShelly.menuAddItem(this.pShelly.bab(98), 1002);
                this.pShelly.menuAddItem(this.pShelly.bab(99), 1006);
                this.pShelly.menuAddItem(this.pShelly.bab(39), 1018);
                this.pShelly.menuAddItem(70, 1008);
                this.pShelly.menuAddItem(this.pShelly.bab(40), 1010);
                this.pShelly.menuhookAddMainItems();
                this.pShelly.menuClose();
                this.pShelly.garbageCollect();
                break;
            }
            case 1002: {
                this.pShelly.menuCreate(38, 0, 2, 0, 1001, true, true, 4128);
                this.pShelly.menuAddItem(this.pShelly.bab(73), 1024, 9);
                this.pShelly.menuAddItem(this.pShelly.bab(74), 1024, 10);
                this.pShelly.menuAddItem(this.pShelly.bab(75), 1024, 11);
                this.pShelly.menuAddItem(68, 1001);
                this.pShelly.menuClose();
                break;
            }
            case 1003: {
                break;
            }
            case 1004: {
                break;
            }
            case 1005: {
                break;
            }
            case 1006: {
                this.menu_InitAvatarSelect();
                break;
            }
            case 1007: {
                this.menu_ConfirmAvatarSelect();
                break;
            }
            case 1008: {
                this.pShelly.menuCreateUser(70, -1, 2, 0, 1001, true, 4128);
                break;
            }
            case 1010: {
                if (!CardPackUI.IsHelpState(n)) {
                    this.wasInGame = n >= 1900;
                }
                int n3 = this.wasInGame ? 1900 : 1001;
                this.pShelly.menuCreate(40, 0, 2, 0, n3, true, true, 4128);
                this.pShelly.menuAddItem(63, 1011);
                if (!this.wasInGame || this.gameTypeSelected == 3) {
                    this.pShelly.menuAddItem(73, 1012);
                }
                if (!this.wasInGame || this.gameTypeSelected == 1) {
                    this.pShelly.menuAddItem(74, 1013);
                }
                if (!this.wasInGame || this.gameTypeSelected == 2) {
                    this.pShelly.menuAddItem(75, 1014);
                }
                if (!this.wasInGame) {
                    this.pShelly.menuhookAddHelpItems();
                }
                this.pShelly.menuAddItem(68, n3);
                this.pShelly.menuClose();
                break;
            }
            case 1011: {
                this.createGeneralHelp();
                break;
            }
            case 1012: {
                this.pShelly.helpCreate(-1, 64, -1, 2, 0, 1010, true, 0, false);
                break;
            }
            case 1013: {
                this.pShelly.helpCreate(-1, 65, -1, 2, 0, 1010, true, 0, false);
                break;
            }
            case 1014: {
                this.pShelly.helpCreate(-1, 66, -1, 2, 0, 1010, true, 0, false);
                break;
            }
            case 1015: {
                break;
            }
            case 1016: {
                break;
            }
            case 1018: {
                if (!CardPackUI.IsOptionState(n)) {
                    this.wasInGame = n >= 1900;
                }
                int n4 = this.wasInGame ? 1900 : 1001;
                this.pShelly.menuCreate(39, 0, 2, 0, n4, true, true, 4128);
                this.pShelly.menuAddItem(this.pShelly.bab(94) + ": " + this.makeOnOffString(this.pShelly.soundIsOn()), 1019);
                if (!this.wasInGame || this.gameTypeSelected == 3) {
                    this.pShelly.menuAddItem(this.pShelly.bab(167) + ":  " + this.makeOnOffString((this.optHints & 2) != 0), 1021);
                }
                if (!this.wasInGame || this.gameTypeSelected == 1) {
                    this.pShelly.menuAddItem(this.pShelly.bab(168) + ":  " + this.makeOnOffString((this.optHints & 4) != 0), 1022);
                }
                if (!this.wasInGame || this.gameTypeSelected == 2) {
                    this.pShelly.menuAddItem(this.pShelly.bab(169) + ":  " + this.makeOnOffString((this.optHints & 8) != 0), 1023);
                }
                if (!this.wasInGame) {
                    this.pShelly.menuAddItem(68, n4);
                }
                this.pShelly.menuClose();
                break;
            }
            case 1019: {
                this.pShelly.soundSetON(!this.pShelly.soundIsOn());
                this.setTuneOn(this.pShelly.soundIsOn());
                this.pShelly.stateChange(1018);
                break;
            }
            case 1020: {
                break;
            }
            case 1021: {
                this.optHints = (this.optHints & 2) == 0 ? (this.optHints |= 2) : (this.optHints &= 0xFFFFFFFD);
                this.SaveRms();
                if (this.pGame != null) {
                    this.pGame.ResetHintFlags();
                }
                this.pShelly.stateChange(1018);
                break;
            }
            case 1022: {
                this.optHints = (this.optHints & 4) == 0 ? (this.optHints |= 4) : (this.optHints &= 0xFFFFFFFB);
                this.SaveRms();
                if (this.pGame != null) {
                    this.pGame.ResetHintFlags();
                }
                this.pShelly.stateChange(1018);
                break;
            }
            case 1023: {
                this.optHints = (this.optHints & 8) == 0 ? (this.optHints |= 8) : (this.optHints &= 0xFFFFFFF7);
                this.SaveRms();
                if (this.pGame != null) {
                    this.pGame.ResetHintFlags();
                }
                this.pShelly.stateChange(1018);
                break;
            }
            case 1024: {
                switch (this.pShelly.menuGetOptionTag()) {
                    case 9: {
                        this.gameTypeSelected = 3;
                        break;
                    }
                    case 10: {
                        this.gameTypeSelected = 1;
                        break;
                    }
                    case 11: {
                        this.gameTypeSelected = 2;
                    }
                }
                this.pShelly.menuCreate(this.pShelly.bab(76), 0, 2, 0, 1002, true, true, 4128);
                this.pShelly.menuAddItem(this.pShelly.bab(77), 1025);
                this.pShelly.menuAddItem(this.pShelly.bab(78), 1025);
                this.pShelly.menuAddItem(this.pShelly.bab(79), 1025);
                this.pShelly.menuClose();
                break;
            }
            case 1025: {
                this.pGame.difficulty = this.pShelly.menuGetSelection();
                this.startGame();
                break;
            }
            case 1026: {
                this.pShelly.helpCreate(-1, 119, -1, 2, 0, 1001, true, 0, false);
                break;
            }
            case 1032: {
                break;
            }
            case 1030: {
                break;
            }
            case 1031: {
                break;
            }
            case 1036: {
                break;
            }
            case 1037: {
                break;
            }
            case 1039: {
                break;
            }
            case 1040: {
                break;
            }
            case 1041: {
                break;
            }
            case 1042: {
                break;
            }
            case 1043: {
                break;
            }
            case 1044: 
            case 1045: {
                break;
            }
            case 1046: {
                break;
            }
            case 1048: {
                break;
            }
            case 1047: {
                break;
            }
            case 1061: {
                break;
            }
            case 1062: {
                break;
            }
            case 1063: {
                break;
            }
            case 1064: {
                break;
            }
            case 1065: {
                break;
            }
            case 1066: {
                break;
            }
            case 1067: {
                break;
            }
            case 1900: {
                if (n >= 1900) {
                    this.gamePauseState = n;
                }
                this.pShelly.menuCreate(17, 0, -1, 0, 0, true, false, 4128);
                this.pShelly.menuAddItem(38, this.gamePauseState);
                this.pShelly.menuAddItem(39, 1018);
                this.pShelly.menuAddItem(40, 1010);
                this.pShelly.menuAddItem(54, 1901);
                this.pShelly.menuClose();
                break;
            }
            case 1901: {
                this.pShelly.areYouSureStart(this.pShelly.bab(93), 1902, 1900);
                break;
            }
            case 1902: {
                this.bInGame = false;
                this.bRoomIsPrivate = false;
                this.pShelly.softKeySet(-1, -1);
                int n5 = 1002;
                this.pGame.game = null;
                this.dumpInGameArt();
                this.pGame.clearAvatarImages();
                this.pShelly.garbageCollect();
                this.pShelly.stateChange(n5);
                break;
            }
        }
    }

    String getBabNotNull(int n) {
        String string = this.pShelly.bab(n);
        if ("NULL".compareTo(string) != 0) {
            return string;
        }
        return "";
    }

    void createGeneralHelp() {
        String string = this.getBabNotNull(125) + this.getBabNotNull(126) + this.getBabNotNull(127) + this.getBabNotNull(128) + this.getBabNotNull(129) + this.getBabNotNull(130) + this.getBabNotNull(131) + this.getBabNotNull(132) + this.getBabNotNull(133) + this.getBabNotNull(134) + this.getBabNotNull(135);
        this.pShelly.helpCreate("", string, -1, 2, 0, 1010, true, 0, false);
    }

    void startGame() {
        this.bInGame = true;
        this.pShelly.skipHideNotify();
        this.loadInGameArt();
        this.pShelly.garbageCollect();
        switch (this.gameTypeSelected) {
            case 3: {
                this.Ui_ChangeState(2101);
                break;
            }
            case 1: {
                this.Ui_ChangeState(2201);
                break;
            }
            case 2: {
                this.Ui_ChangeState(2301);
            }
        }
        this.pGame.Game_InitFromUi();
    }

    public void menuPaint(ShellyGraphics shellyGraphics) {
        this.menu_PaintTitle(shellyGraphics, this.pShelly.menuGetTitle());
        this.menu_PaintItems(shellyGraphics);
    }

    public void menuInit() {
        int n;
        this.menuMaxWidth = 0;
        for (int i = 0; i < this.pShelly.menuGetNumItems(); ++i) {
            int n2 = this.pShelly.fontStringWidth(3, this.pShelly.menuGetItem(i));
            if (n2 <= this.menuMaxWidth) continue;
            this.menuMaxWidth = n2;
        }
        this.menuSpacing = MENUBAR_HEIGHT + (this.pShelly.fontGetHeight(3) >> 1) + 2 + MENU_SPACING_OFFSET;
        int n3 = MENU_ITEMS_BOTTOM;
        if (this.pShelly.menuGetTitle() == null) {
            n = this.menuTitleY = canvasHeight >> 3;
        } else {
            this.menuTitleY = MENU_TITLE_HCENTER;
            n = MENU_ITEMS_TOP;
        }
        int n4 = false | !this.pShelly.imageLoaded(14) ? MENU_ARROWSIZE : this.pShelly.imageGetHeight(14);
        int n5 = n3 - n;
        if (this.pShelly.menuGetNumItems() > n5 / this.menuSpacing) {
            this.menuArrowYtop = MENU_ITEMS_TOP + 0;
            this.menuArrowYbottom = MENU_ITEMS_BOTTOM;
            n += n4 >> 1;
            n3 -= n4 >> 1;
            n5 -= n4;
        }
        if (this.menuDisplayMode == 1) {
            this.menuYStart = n + (canvasHeight >> 4);
            this.pShelly.menuSetNumToShow(1);
        } else {
            this.pShelly.menuSetNumToShow(n5 / this.menuSpacing);
            n5 = this.menuSpacing * this.pShelly.menuGetNumToShow();
            this.menuYStart = n + n3 >> 1;
            this.menuYStart -= n5 >> 1;
        }
    }

    public void menu_PaintTitle(ShellyGraphics shellyGraphics, String string) {
        if (string == null) {
            return;
        }
        shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        this.setFont(4);
        this.drawString(shellyGraphics, string, canvasWidth >> 1, this.menuTitleY + -7, 3);
    }

    public void menu_PaintItems(ShellyGraphics shellyGraphics) {
        if (this.pShelly.menuGetNumItems() <= 0) {
            return;
        }
        int n = 0;
        this.setFont(3);
        int n2 = this.pShelly.menuGetNumToShow();
        int n3 = this.pShelly.menuGetTopDisplay();
        int n4 = MNEUBAR_WIDTH >> 1;
        int n5 = this.menuYStart + (this.pShelly.fontGetHeight(3) >> 1) + n;
        for (int i = n3; i < n3 + n2 && i < this.pShelly.menuGetNumItems(); ++i) {
            int n6;
            String string = this.pShelly.menuGetItem(i);
            int n7 = this.pShelly.fontStringWidth(3, string) + 2;
            shellyGraphics.setColor(12390416);
            if (n7 < MNEUBAR_WIDTH - 2) {
                n6 = MNEUBAR_WIDTH - n7 >> 1;
                if (n6 > 7) {
                    n6 = 7;
                }
                shellyGraphics.setClip(canvasWidthHalf - n4, n5, n6, 7);
                shellyGraphics.drawImage(7, canvasWidthHalf - n4, n5, 20);
                shellyGraphics.setClip(canvasWidthHalf + n4 - n6, n5, n6, 7);
                shellyGraphics.drawImage(7, canvasWidthHalf + n4, n5, 24);
            }
            shellyGraphics.setClip(canvasWidthHalf - n4, n5 + MENUBAR_HEIGHT - 7, 7, 7);
            shellyGraphics.drawImage(7, canvasWidthHalf - n4, n5 + MENUBAR_HEIGHT, 36);
            shellyGraphics.setClip(canvasWidthHalf + n4 - 7, n5 + MENUBAR_HEIGHT - 7, 7, 7);
            shellyGraphics.drawImage(7, canvasWidthHalf + n4, n5 + MENUBAR_HEIGHT, 40);
            shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
            shellyGraphics.drawLine(canvasWidthHalf - n4 + 6, n5 + MENUBAR_HEIGHT - 1, canvasWidthHalf - 6 + n4, n5 + MENUBAR_HEIGHT - 1);
            if (n7 < MNEUBAR_WIDTH - 16) {
                shellyGraphics.drawLine(canvasWidthHalf - n4 + 6, n5, (canvasWidth - n7 >> 1) - 1, n5);
                shellyGraphics.drawLine((canvasWidth + n7 >> 1) + 1, n5, canvasWidthHalf - 6 + n4, n5);
            }
            n6 = 0;
            if (n7 >= MNEUBAR_WIDTH - 2 && (n6 = this.pShelly.fontGetHeight(3) >> 3) > MENUBAR_HEIGHT - 12) {
                n6 = MENUBAR_HEIGHT - 12;
            }
            shellyGraphics.drawLine(canvasWidthHalf - n4, n5 + 6 + n6, canvasWidthHalf - n4, n5 + MENUBAR_HEIGHT - 6);
            shellyGraphics.drawLine(canvasWidthHalf + n4 - 1, n5 + 6 + n6, canvasWidthHalf + n4 - 1, n5 + MENUBAR_HEIGHT - 6);
            if (i == this.pShelly.menuGetSelection() && this.menuDisplayMode != 1) {
                shellyGraphics.setColor(9097874);
                int n8 = MNEUBAR_WIDTH - 14;
                int n9 = canvasWidthHalf - (n8 >> 1);
                for (int j = n5 + 2; j < n5 + MENUBAR_HEIGHT - 2; ++j) {
                    shellyGraphics.drawLine(n9, j, n9 + n8, j);
                    if (j - (n5 + 2) < 2) {
                        n8 += 2;
                        --n9;
                    }
                    if (n5 + MENUBAR_HEIGHT - 2 - j >= 3) continue;
                    n8 -= 2;
                    ++n9;
                }
            }
            this.drawString(shellyGraphics, string, canvasWidthHalf, n5 - (this.pShelly.fontGetHeight(3) >> 1), 17);
            n5 += this.menuSpacing;
        }
        if (n3 > 0) {
            this.drawArrow(shellyGraphics, canvasWidthHalf, this.menuArrowYtop, 2, true);
        }
        if (n3 + this.pShelly.menuGetNumToShow() < this.pShelly.menuGetNumItems()) {
            this.drawArrow(shellyGraphics, canvasWidthHalf, this.menuArrowYbottom, 0, true);
        }
    }

    void drawArrow(ShellyGraphics shellyGraphics, int n, int n2, int n3, boolean bl) {
        if (this.pShelly.imageLoaded(14)) {
            int n4 = this.pShelly.imageGetHeight(14);
            int n5 = this.pShelly.imageGetWidth(14);
            n3 += 2;
            int n6 = n5 >> 3;
            int n7 = ((n3 &= 3) << 1) + (bl ? 1 : 0);
            shellyGraphics.setClip(n - (n6 >> 1), n2 - (n4 >> 1), n6, n4);
            shellyGraphics.drawImage(14, n - n7 * n6 - (n6 >> 1), n2 - (n4 >> 1), 20);
            shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        } else {
            shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
            int n8 = arrowVertex[n3 * 6 + 0];
            int n9 = arrowVertex[n3 * 6 + 1];
            int n10 = arrowVertex[n3 * 6 + 2];
            int n11 = arrowVertex[n3 * 6 + 3];
            int n12 = arrowVertex[n3 * 6 + 4];
            int n13 = arrowVertex[n3 * 6 + 5];
            shellyGraphics.setColor(bl ? 15088186 : 12456466);
            shellyGraphics.drawLine(n + n8, n2 + n9, n + n10, n2 + n11);
            shellyGraphics.drawLine(n + n10, n2 + n11, n + n12, n2 + n13);
            shellyGraphics.drawLine(n + n12, n2 + n13, n + n8, n2 + n9);
            shellyGraphics.drawLine(n + (n8 << 1), n2 + (n9 << 1), n + (n10 << 1), n2 + (n11 << 1));
            shellyGraphics.drawLine(n + (n10 << 1), n2 + (n11 << 1), n + (n12 << 1), n2 + (n13 << 1));
            shellyGraphics.drawLine(n + (n12 << 1), n2 + (n13 << 1), n + (n8 << 1), n2 + (n9 << 1));
            shellyGraphics.setColor(bl ? 15120230 : 13280089);
            shellyGraphics.drawLine(n + n8 * 3, n2 + n9 * 3, n + n10 * 3, n2 + n11 * 3);
            shellyGraphics.drawLine(n + n10 * 3, n2 + n11 * 3, n + n12 * 3, n2 + n13 * 3);
            shellyGraphics.drawLine(n + n12 * 3, n2 + n13 * 3, n + n8 * 3, n2 + n9 * 3);
        }
    }

    public Object helpInit(String string, String string2, boolean bl) {
        String string3 = string;
        if (string2 != null) {
            string3 = string2.toUpperCase() + "\n\n" + string;
        }
        Object object = this.menu_PaintText_Init(string3);
        int n = this.pShelly.textGetNumLinesWrapped(0, object);
        int n2 = bl ? MENU_TEXTBOX_YGAP : MENU_TEXTBOX_YGAP << 1;
        int n3 = (MENU_TEXTBOX_HEIGHT - n2) / this.pShelly.fontGetHeight(0);
        this.pShelly.helpSetShowLines(n3, n);
        return object;
    }

    public void helpPaint(ShellyGraphics shellyGraphics) {
        this.menu_PaintText(shellyGraphics, this.pShelly.helpGetText(), this.pShelly.helpGetScrollPos(), this.pShelly.helpGetCanScrolDown());
    }

    public void backGroundPaint(ShellyGraphics shellyGraphics, int n) {
        if (n >= 2000) {
            return;
        }
        if (n == -1) {
            this.pShelly.backGroundPaint(shellyGraphics, n);
            this.pShelly.fontSetUsage(3, 4);
            return;
        }
        if (n == 7) {
            shellyGraphics.setColor(CardPackUI.lerp(15158605, 0x560000, 50));
            shellyGraphics.fillRect(0, 0, canvasWidth, canvasHeight);
            return;
        }
        if (n == 3 || n == 5 || n == 23) {
            this.pShelly.backGroundPaint(shellyGraphics, n);
            return;
        }
        shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        this.paintMenuBackdrop(shellyGraphics);
    }

    public Object menu_PaintText_Init(String string) {
        return this.pShelly.textWrap(0, string, MENU_TEXTBOX_WIDTH);
    }

    public void menu_PaintText(ShellyGraphics shellyGraphics, Object object) {
        this.menu_PaintText(shellyGraphics, object, 0, false);
    }

    public void menu_PaintText(ShellyGraphics shellyGraphics, Object object, int n, boolean bl) {
        if (object != null) {
            int n2;
            int n3 = this.pShelly.textGetHeightWrapped(0, object, 0) + (MENU_TEXTBOX_YGAP << 1);
            if (n3 < (n2 = MENU_TEXTBOX_HEIGHT)) {
                n2 = n3;
                n = 0;
            }
            shellyGraphics.setColor(0xFFFFFF);
            shellyGraphics.fillRect(MENU_TEXTBOX_X - 4, MENU_TEXTBOX_Y - 4, MENU_TEXTBOX_WIDTH + 8, n2 + 8);
            shellyGraphics.setColor(8063241);
            shellyGraphics.fillRect(MENU_TEXTBOX_X - 2, MENU_TEXTBOX_Y - 2, MENU_TEXTBOX_WIDTH + 4, n2 + 4);
            if (this.pShelly.helpGetAutoScroll()) {
                this.pShelly.textDrawWrappedSmooth(shellyGraphics, 0, object, MENU_TEXTBOX_X + (MENU_TEXTBOX_WIDTH >> 1), MENU_TEXTBOX_Y + MENU_TEXTBOX_YGAP, MENU_TEXTBOX_HEIGHT - (MENU_TEXTBOX_YGAP << 1), 17, n);
            } else {
                this.pShelly.textDrawWrapped(shellyGraphics, 0, object, MENU_TEXTBOX_X + (MENU_TEXTBOX_WIDTH >> 1), MENU_TEXTBOX_Y + MENU_TEXTBOX_YGAP, MENU_TEXTBOX_HEIGHT - (MENU_TEXTBOX_YGAP << 1), 17, n);
                if (n > 0) {
                    this.drawArrow(shellyGraphics, canvasWidth >> 1, MENU_TEXTBOX_Y - 1, 2, true);
                }
                int n4 = this.pShelly.textGetHeightWrapped(0, object, n);
                if (bl) {
                    this.drawArrow(shellyGraphics, canvasWidth >> 1, MENU_TEXTBOX_Y + MENU_TEXTBOX_HEIGHT, 0, true);
                }
            }
        }
    }

    void menu_ConfirmAvatarSelect() {
        this.faceSelected = this.pShelly.menuGetSelection();
        this.SaveRms();
        this.Ui_ChangeState(1001);
    }

    void menu_InitAvatarSelect() {
        this.loadImageSafe(24, 15);
        this.pGame.InitAvatarSystem();
        this.pShelly.menuCreate(96, 0, 2, 0, 1001, true, true, 4128);
        for (int i = 0; i < 12; ++i) {
            this.pShelly.menuAddItem("", 1007);
        }
        this.menuDisplayMode = 1;
        this.pShelly.menuClose();
        this.pShelly.menuSetSelection(this.faceSelected);
        this.avSelEmote = 0;
        this.avSelTimer = this.pShelly.getAppMillis();
    }

    void menu_AvatarSelectProc() {
        if (this.pShelly.getAppMillis() > this.avSelTimer + 1500L) {
            this.avSelEmote = (this.avSelEmote + 1) % 9;
            this.avSelTimer = this.pShelly.getAppMillis();
            this.pShelly.paintSetRefresh();
        }
    }

    void menu_PaintAvatarSelect(ShellyGraphics shellyGraphics) {
        int n;
        this.pGame.localHumanFace = n = this.pShelly.menuGetSelection();
        int n2 = this.pShelly.imageLoaded(14) ? this.pShelly.imageGetHeight(14) : 5;
        int n3 = this.menuYStart;
        this.drawArrow(shellyGraphics, canvasWidthHalf, n3, 2, true);
        this.pGame.drawAvatarFaceStd(shellyGraphics, canvasWidthHalf - Game.FACEREFOFFSETX, n3 += n2 + this.menuGap, -1, this.avSelEmote);
        this.drawArrow(shellyGraphics, canvasWidthHalf, n3 += Game.FACEHEIGHT + this.menuGap, 0, true);
        n3 += n2 + this.menuGap;
        if (this.faceSelected == n) {
            this.setFont(3);
            this.drawString(shellyGraphics, this.pShelly.bab(108), canvasWidthHalf, n3, 17);
        }
    }

    static String strToTitleCase(String string) {
        string = string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
        return string;
    }

    void menu_paintHighScore(ShellyGraphics shellyGraphics) {
        this.setFont(1);
        int n = this.pShelly.fontGetHeight(1);
        int n2 = 3 * canvasWidth >> 4;
        int n3 = 9 * canvasWidth >> 4;
        int n4 = 27 * canvasWidth >> 5;
        n += n >> 1;
        int n5 = MENU_ITEMS_TOP + n;
        this.drawString(shellyGraphics, this.pShelly.bab(71), n3, n5, 17);
        this.drawString(shellyGraphics, this.pShelly.bab(72), n4, n5, 24);
        this.drawString(shellyGraphics, this.pShelly.bab(73), n2, n5 += n, 20);
        this.drawString(shellyGraphics, String.valueOf(this.winsGin), n3, n5, 17);
        this.drawString(shellyGraphics, String.valueOf(this.lossGin), n4 -= this.pShelly.fontStringWidth(this.currfont, this.pShelly.bab(72)) >> 1, n5, 17);
        this.drawString(shellyGraphics, this.pShelly.bab(74), n2, n5 += n, 20);
        this.drawString(shellyGraphics, String.valueOf(this.winsHearts), n3, n5, 17);
        this.drawString(shellyGraphics, String.valueOf(this.lossHearts), n4, n5, 17);
        this.drawString(shellyGraphics, this.pShelly.bab(75), n2, n5 += n, 20);
        this.drawString(shellyGraphics, String.valueOf(this.winsSpades), n3, n5, 17);
        this.drawString(shellyGraphics, String.valueOf(this.lossSpades), n4, n5, 17);
    }

    public int getColorBackGround(int n) {
        if (n == -100) {
            return 0x4C4C4C;
        }
        if (n == 21) {
            return 0;
        }
        if (n == 16 || n == 15 || n == 7) {
            return 16185047;
        }
        if (this.pShelly.stateIsOuttro(n)) {
            if (this.pShelly.demoModeOn() || this.pShelly.buyMoreOuttroOn() && this.pShelly.buyMoreImage()) {
                return 16185047;
            }
            return 0;
        }
        if (this.pShelly.stateIsSplash(n)) {
            return 0;
        }
        return 16185047;
    }

    public int getColorForeGround(int n) {
        return 0xA00000;
    }

    public void paintMessageInit(String string) {
        this.objMessage = this.menu_PaintText_Init(string);
    }

    public void paintMessage(ShellyGraphics shellyGraphics) {
        this.menu_PaintText(shellyGraphics, this.objMessage);
    }

    public void paintDemoMsgInit(String string, boolean bl) {
        this.objMessage = this.menu_PaintText_Init(string);
    }

    public void paintDemoMsg(ShellyGraphics shellyGraphics) {
        this.backGroundPaint(shellyGraphics, this.pShelly.stateGetCurrent());
        this.paintSoftKeyBacking(shellyGraphics);
        this.menu_PaintText(shellyGraphics, this.objMessage);
    }

    public void areYouSurePaintInit(String string) {
        this.netMsg = this.menu_PaintText_Init(string + "\n\n" + this.pShelly.bab(45));
    }

    public void areYouSurePaint(ShellyGraphics shellyGraphics) {
        this.menu_PaintText(shellyGraphics, this.netMsg);
    }

    public void timeBarPaint(ShellyGraphics shellyGraphics, int n, boolean bl, String string, int n2) {
        int n3 = canvasHeight >> 8;
        boolean bl2 = bl && n < 400;
        this.pShelly.timeBarPaint(shellyGraphics, n3, n, 16185047, 0xA00000, bl2, string, 3, 17);
    }

    public void paintWidget(ShellyGraphics shellyGraphics, int n, int n2, int n3, int n4, int n5) {
    }

    public String getLicensorText() {
        return null;
    }

    public String getCreditText() {
        return this.pShelly.bab(67);
    }

    public final int getMenuState(int n) {
        switch (n) {
            case 0: {
                return 1001;
            }
            case 1: {
                return 1018;
            }
            case 2: {
                return 1010;
            }
        }
        return 0;
    }

    public void menuSKPressed(int n) {
    }

    public void notifyReport(int n, String string) {
    }

    public byte[] soundGetOTT(String string) {
        byte[] byArray = null;
        ShellyCanvas.reportTrace("soundGetOTT() : called to read  " + string);
        if (string.startsWith("/title")) {
            try {
                byte[] byArray2 = new byte[5000];
                int n = new Object().getClass().getResourceAsStream("/title.ott").read(byArray2);
                byArray = new byte[n];
                new Object().getClass().getResourceAsStream("/title.ott").read(byArray);
                ShellyCanvas.reportTrace("soundGetOTT() : read file of size " + byArray.length + " bytes");
            }
            catch (Exception exception) {
                ShellyCanvas.reportDebug("soundGetOTT() : file read error:   " + exception);
            }
        } else {
            byArray = new byte[]{2, 74, 58, 64, 4, 0, 21, 36, 90, 4, 96, -126, -48, 73, 24, 22, -127, -120, 26, -128, 0};
        }
        return byArray;
    }

    public void soundEvent(int n) {
    }

    public void soundSelectPlay() {
    }

    void setTuneOn(boolean bl) {
        if (!this.bTuneLoaded) {
            return;
        }
        this.bTuneOn = bl;
        if (this.bTuneOn) {
            this.pShelly.soundPlayLooped(0);
            this.pShelly.soundSetTuneContinuous(true);
        } else {
            this.pShelly.soundStop(0);
            this.pShelly.soundSetTuneContinuous(false);
        }
        this.SaveRms();
    }

    void LoadRms() {
        try {
            byte[] byArray = this.pShelly.savedataRead(0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            if (n != 4662) {
                ShellyCanvas.reportWarning("RMS data is from old version - using defaults");
                return;
            }
            this.bTuneOn = dataInputStream.readInt() > 0;
            this.optHints = dataInputStream.readInt();
            this.winsGin = dataInputStream.readInt();
            this.winsHearts = dataInputStream.readInt();
            this.winsSpades = dataInputStream.readInt();
            this.lossGin = dataInputStream.readInt();
            this.lossHearts = dataInputStream.readInt();
            this.lossSpades = dataInputStream.readInt();
            this.faceSelected = dataInputStream.readInt();
            ShellyCanvas.reportTrace("RMS Data Loaded OK!");
        }
        catch (Exception exception) {
            ShellyCanvas.reportError("No save data or bad - Using defaults: ");
            ShellyCanvas.reportError(" " + exception);
            return;
        }
    }

    void SaveRms() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(4662);
            dataOutputStream.writeInt(this.bTuneOn ? 1 : 0);
            dataOutputStream.writeInt(this.optHints);
            dataOutputStream.writeInt(this.winsGin);
            dataOutputStream.writeInt(this.winsHearts);
            dataOutputStream.writeInt(this.winsSpades);
            dataOutputStream.writeInt(this.lossGin);
            dataOutputStream.writeInt(this.lossHearts);
            dataOutputStream.writeInt(this.lossSpades);
            dataOutputStream.writeInt(this.faceSelected);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.pShelly.savedataWrite(0, byArray);
            ShellyCanvas.reportTrace("RMS Data Written ok");
        }
        catch (Exception exception) {
            ShellyCanvas.reportError("Appy() save data write failed");
            return;
        }
    }

    void ClearCheatBuffer() {
        for (int i = 0; i < this.nCheatBuffer; ++i) {
            this.cheatBuffer[i] = 64;
        }
        this.bCheatLegal = false;
    }

    void ProcessCheatKey() {
        if (this.pShelly.keyDownDB(1023) && !this.bCheatLegal) {
            int n = this.pShelly.keyGetNumericDB();
            char c = Integer.toString(n).charAt(0);
            for (int i = 1; i < this.nCheatBuffer; ++i) {
                this.cheatBuffer[i - 1] = this.cheatBuffer[i];
            }
            this.cheatBuffer[this.nCheatBuffer - 1] = c;
            String string = String.valueOf(this.cheatBuffer);
            if (CafeCardsEngine.IsValidCheat(string)) {
                this.bCheatLegal = true;
                this.cheatMessageUntil = System.currentTimeMillis() + 4000L;
            }
        }
    }

    void CheatPaint(ShellyGraphics shellyGraphics) {
        if (this.bCheatLegal && System.currentTimeMillis() < this.cheatMessageUntil) {
            shellyGraphics.setColor(0xFF00000);
            this.setFont(0);
            int n = this.pShelly.fontStringWidth(0, "CHEAT ACCEPTED") + 6;
            int n2 = this.pShelly.fontGetHeight(0) + 6;
            int n3 = canvasWidth - n >> 1;
            int n4 = n2 << 1;
            shellyGraphics.fillRect(n3, n4, n, n2);
            this.drawString(shellyGraphics, "CHEAT ACCEPTED", n3 + 3, n4 + 3, 20);
        }
    }

    public void paintMenuBackdrop(ShellyGraphics shellyGraphics) {
        shellyGraphics.setColor(16185047);
        shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        shellyGraphics.fillRect(0, 0, canvasWidth, canvasHeight);
        if (this.pShelly.imageGetHeight(5) < canvasHeight || !this.pShelly.imageLoaded(5)) {
            shellyGraphics.setColor(14468482);
            int n = this.pShelly.fontGetHeight(4) + 4 >> 1;
            shellyGraphics.fillRect(0, this.menuTitleY - n, canvasWidth, n << 1);
        }
        if (this.pShelly.imageGet(5) != null) {
            if (this.pShelly.imageGetHeight(5) < canvasHeight) {
                shellyGraphics.drawImage(5, canvasWidth >> 1, MENU_GRADFILLBUFFER + 1, 17);
            } else {
                shellyGraphics.drawImage(5, canvasWidth >> 1, canvasHeight >> 1, 3);
            }
        }
    }

    public void paintGraduatedBkg(ShellyGraphics shellyGraphics, int n, int n2) {
        int n3 = canvasHeight < 150 ? 16 : 32;
        int n4 = canvasHeight / n3 + 1;
        int n5 = 0;
        int n6 = 0;
        while (n5 < canvasHeight) {
            int n7 = CardPackUI.lerp(n, n2, 100 * n6 / n3);
            shellyGraphics.setColor(n7);
            shellyGraphics.fillRect(0, n5, canvasWidth, n4);
            n5 += n4;
            ++n6;
        }
    }

    private static int lerp(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n & 0xFF;
        int n6 = n2 & 0xFF;
        n5 += (n6 - n5) * n3 / 100;
        n4 = n5 &= 0xFF;
        n5 = (n & 0xFF00) >> 8;
        n6 = (n2 & 0xFF00) >> 8;
        n5 += (n6 - n5) * n3 / 100;
        n4 |= (n5 &= 0xFF) << 8;
        n5 = (n & 0xFF0000) >> 16;
        n6 = (n2 & 0xFF0000) >> 16;
        n5 += (n6 - n5) * n3 / 100;
        return n4 |= (n5 &= 0xFF) << 16;
    }

    String makeOnOffString(boolean bl) {
        return this.pShelly.bab(bl ? 43 : 44);
    }

    public void paintSoftKeyBacking(ShellyGraphics shellyGraphics) {
        if (!this.pShelly.imageLoaded(6)) {
            int n = this.pShelly.softKeyGetHeight() + 1;
            int n2 = canvasWidthHalf - 4;
            if (this.pShelly.softKeyGetLeft() != -1) {
                shellyGraphics.setColor(11275533);
                shellyGraphics.fillRect(0, canvasHeight - n, n2, n);
                shellyGraphics.setColor(15439006);
                shellyGraphics.drawRect(0, canvasHeight - n, n2, n);
            }
            if (this.pShelly.softKeyGetRight() != -1) {
                shellyGraphics.setColor(11275533);
                shellyGraphics.fillRect(canvasWidth - n2, canvasHeight - n, n2, n);
                shellyGraphics.setColor(15439006);
                shellyGraphics.drawRect(canvasWidth - n2, canvasHeight - n, n2, n);
            }
        } else {
            if (this.pShelly.softKeyGetLeft() == -1 && this.pShelly.softKeyGetRight() == -1) {
                return;
            }
            shellyGraphics.drawImage(6, 0, canvasHeight, 36);
        }
    }

    void setFont(int n) {
        this.currfont = n;
    }

    void drawString(ShellyGraphics shellyGraphics, String string, int n, int n2, int n3) {
        if (this.currfont == -1) {
            return;
        }
        this.pShelly.textDraw(shellyGraphics, this.currfont, string, n, n2, n3);
    }

    void drawString(ShellyGraphics shellyGraphics, int n, String string, int n2, int n3, int n4) {
        this.currfont = n;
        this.drawString(shellyGraphics, string, n2, n3, n4);
    }

    public void paintNetMessageInit(String string) {
        this.netMsg = this.menu_PaintText_Init(string);
    }

    public void paintNetMessage(ShellyGraphics shellyGraphics) {
        this.menu_PaintText(shellyGraphics, this.netMsg);
    }

    public void processError(int n, int n2, String string) {
    }

    public void processCommand(int n, DataInputStream dataInputStream) {
    }

    public void processMessage(int n, int n2, String string) {
    }

    public void processEvent(int n) {
    }

    public void DrawMessageInit(String string, int n, int n2, int n3, int n4) {
        this.msgPosX = n;
        this.msgPosY = n2;
        this.msgBubbleX = this.msgPosX;
        this.msgBubbleY = this.msgPosY;
        this.msgBubbleAnchor = n4;
        this.DrawMessageInitCommon(string);
    }

    private void DrawMessageInitCommon(String string) {
        int n = this.pShelly.fontGetHeight(1);
        int n2 = CHAT_MSG_SIZEX - 8 - 12;
        this.objMsg = this.pShelly.textWrap(1, string, n2);
        this.msgNumLinesTot = this.msgNumLines = this.pShelly.textGetNumLinesWrapped(1, this.objMsg);
        this.msgBubbleHeight = this.msgNumLines * n + 8 + 12;
        while (this.msgBubbleHeight > 0 && this.msgBubbleHeight > CHAT_MSG_SIZEY) {
            this.msgBubbleHeight -= n;
            --this.msgNumLines;
        }
        this.msgMaxScrollPos = this.msgNumLinesTot - this.msgNumLines;
        if (this.chatScrollPos >= this.msgMaxScrollPos) {
            this.chatScrollPos = this.msgMaxScrollPos;
        }
        this.DrawBubbleInit(this.msgBubbleX, this.msgBubbleY, CHAT_MSG_SIZEX, this.msgBubbleHeight, this.msgBubbleAnchor);
    }

    public void DrawMessage(ShellyGraphics shellyGraphics, int n) {
        if (n >= this.msgMaxScrollPos) {
            n = this.msgMaxScrollPos;
        }
        this.DrawBubble(shellyGraphics, this.msgBubbleX, this.msgBubbleY, CHAT_MSG_SIZEX, this.msgBubbleHeight, this.msgBubbleAnchor);
        int n2 = this.chatBoundX1 + 6;
        int n3 = this.chatBoundY1 + 6;
        int n4 = this.chatBoundH - 12;
        this.pShelly.textDrawWrapped(shellyGraphics, 1, this.objMsg, n2, n3, n4, 20, n);
        if (this.msgNumLines < this.msgNumLinesTot && n < this.msgNumLinesTot - this.msgNumLines) {
            this.drawArrow(shellyGraphics, this.chatBoundX1 + (this.chatBoundW >> 1), this.chatBoundY1 + this.chatBoundH - 1, 0, true);
        }
        if (this.msgNumLines < this.msgNumLinesTot && n > 0) {
            this.drawArrow(shellyGraphics, this.chatBoundX1 + (this.chatBoundW >> 1), this.chatBoundY1 + 1, 2, true);
        }
        if (this.chatState != 8) {
            if (this.chatViewing > 0) {
                this.drawArrow(shellyGraphics, this.chatBoundX1 + 1, this.chatBoundY1 + (this.chatBoundH >> 1), 1, true);
            }
            if (this.chatViewing < this.chatNum - 1 && this.chatNum > 1) {
                this.drawArrow(shellyGraphics, this.chatBoundX1 + this.chatBoundW - 1, this.chatBoundY1 + (this.chatBoundH >> 1), 3, true);
            }
        }
    }

    private void DrawBubbleInit(int n, int n2, int n3, int n4, int n5) {
        this.DrawBubble(null, n, n2, n3, n4, n5);
    }

    private void DrawBubble(ShellyGraphics shellyGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = n2;
        int n8 = 1;
        int n9 = 1;
        int n10 = 0;
        int n11 = 0;
        if ((n5 & 1) != 0) {
            n7 -= n4 >> 1;
            n9 = 0;
        } else if ((n5 & 0x20) != 0) {
            n7 -= n4;
            n9 = -n9;
            n11 = 1;
        }
        if ((n5 & 2) != 0) {
            n6 -= n3 >> 1;
            n8 = 0;
        } else if ((n5 & 8) != 0) {
            n6 -= n3;
            n8 = -n8;
            n10 = 1;
        }
        this.chatBoundX1 = n6 + 4;
        this.chatBoundY1 = n7 + 4;
        this.chatBoundW = n3 - 8;
        this.chatBoundH = n4 - 8;
        if (shellyGraphics == null) {
            return;
        }
        shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        shellyGraphics.setColor(0xFFFFFF);
        shellyGraphics.fillRoundRect(n6, n7, n3, n4, 8, 8);
        shellyGraphics.setColor(14126734);
        shellyGraphics.drawRoundRect(n6 + 1, n7 + 1, n3 - 2, n4 - 2, 6, 6);
        shellyGraphics.setColor(0x660000);
        shellyGraphics.drawRoundRect(n6, n7, n3, n4, 8, 8);
        if ((n5 & 2) != 0) {
            int n12 = n2 - 7 * n9;
            int n13 = n - 6;
            n7 = n12 - n11 * 25;
            n6 = n - 13 - 18;
            if (n12 > n2) {
                n12 = n2 - 1;
            }
            shellyGraphics.setClip(n13, n12, 13, 13);
            shellyGraphics.drawImage(12, n6, n7, 20);
        } else if ((n5 & 1) != 0) {
            int n14 = n - 7 * n8;
            int n15 = n2 - 6;
            n6 = n14 - n10 * 25 - 18;
            n7 = n2 - 13;
            if (n14 > n) {
                n14 = n - 1;
            }
            shellyGraphics.setClip(n14, n15, 13, 13);
            shellyGraphics.drawImage(12, n6, n7, 20);
        } else {
            int n16 = (n6 += n8 * 6 + n10 * (n3 + 1)) - n8 * BUBBLE_TAG_RAD;
            int n17 = (n7 += n9 * 6 + n11 * (n4 + 1)) - n9 * BUBBLE_TAG_RAD;
            if (n16 > n6) {
                n16 = n6;
            }
            if (n17 > n7) {
                n17 = n7;
            }
            shellyGraphics.setClip(n16, n17, BUBBLE_TAG_RAD, BUBBLE_TAG_RAD);
            shellyGraphics.drawImage(12, n6 - BUBBLE_TAG_RAD, n7 - BUBBLE_TAG_RAD, 20);
        }
        shellyGraphics.setClip(0, 0, canvasWidth, canvasHeight);
    }

    static {
        MENU_GRADFILLBUFFER = 0;
        MNEUBAR_WIDTH = 6 * canvasWidth / 11;
        MENUBAR_HEIGHT = 16 * canvasHeight / 220;
        MENU_TITLE_HCENTER = 58 * canvasHeight / 220;
        MENU_ITEMS_TOP = 68 * canvasHeight / 220;
        MENU_ITEMS_BOTTOM = canvasHeight - 28 * canvasHeight / 220;
        MENU_SPACING_OFFSET = 0;
        MENU_TEXTBOX_X = 10 * canvasWidth / 176;
        MENU_TEXTBOX_Y = 3 * canvasHeight / 10;
        MENU_TEXTBOX_WIDTH = canvasWidth - MENU_TEXTBOX_X - MENU_TEXTBOX_X;
        MENU_TEXTBOX_HEIGHT = canvasHeight - 26 * canvasHeight / 220 - MENU_TEXTBOX_Y;
        MENU_TEXTBOX_YGAP = 7 * canvasHeight / 220;
        CHAT_INFORM_SIZE = 15 * canvasWidth / 176;
        CHAT_MSG_SIZEX = 100 * canvasWidth / 176;
        CHAT_MSG_SIZEY = 80 * canvasHeight / 220;
        MENU_ARROWSIZE = 0;
        LOADING_BAR_WIDTH = ShellyCanvas.pShelly.getWidth() >> 2;
        LOADING_BAR_HEIGHT = ShellyCanvas.pShelly.getHeight() / 20;
        arrowVertex = new int[]{1, -1, -1, -1, 0, 1, 1, 1, 1, -1, -1, 0, -1, 1, 1, 1, 0, -1, -1, 1, -1, -1, 1, 0};
        tstr = new String[]{"+", "++", "+++", "++++", "+++++", "++++++", "+++++++"};
        BUBBLE_TAG_RAD = 9;
    }
}

