/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class ShellySound_MIDP2
implements ShellySound,
Runnable {
    private Player[] fxPlayer = new Player[24];
    private boolean[] bLooped = new boolean[24];
    private int lastsoundplayed = -1;
    private int currentPriority = -1;
    private long startTime = -1L;
    int iCurrentSound;

    ShellySound_MIDP2() {
        ShellyCanvas.reportDebug("CLASS_ID=ShellySound_MIDP2 instantiating");
    }

    public void clearSounds() {
        for (int i = 0; i < 24; ++i) {
            this.fxPlayer[i] = null;
        }
        this.currentPriority = -1;
        this.lastsoundplayed = -1;
    }

    public boolean loadSound(int n) {
        return true;
    }

    public boolean associate(int n, int n2) {
        return true;
    }

    public void removeSound(int n) {
        this.stopSound(n);
        this.fxPlayer[n] = null;
    }

    private boolean loadSoundData(int n) {
        String string = ShellyCanvas.pShelly.spcbGetResourceName(n);
        try {
            String string2 = null;
            if (string.endsWith(".wav")) {
                string2 = "audio/x-wav";
            } else if (string.endsWith(".amr")) {
                string2 = "audio/amr";
            } else if (string.endsWith(".mid")) {
                string2 = "audio/midi";
            } else {
                int n2 = string.indexOf(".");
                if (n2 >= 0) {
                    string = string.substring(0, n2 - 1);
                }
                string = string + ".wav";
                string2 = "audio/x-wav";
                ShellyCanvas.reportDebug("ShellySound_MIDP2: unknown format - fall back to wav");
            }
            if (string2 == null) {
                return false;
            }
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.fxPlayer[n] = Manager.createPlayer((InputStream)inputStream, (String)string2);
            this.fxPlayer[n].realize();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void playSound(int n, int n2) {
        this.playSound(n, n2 == -1);
    }

    public void playSound(int n, boolean bl) {
        this.iCurrentSound = n;
        this.bLooped[n] = bl;
        new Thread(this).start();
    }

    public void playSoundTimer(int n, boolean bl) {
        int n2;
        if (ShellyCanvas.pShelly.spcbGetMultiChannelOn()) {
            // empty if block
        }
        if (this.currentPriority > (n2 = ShellyCanvas.pShelly.spcbGetPriority(n) + (ShellyCanvas.pShelly.spcbGetEqualPriorityOverides() ? 1 : 0))) {
            return;
        }
        try {
            this.lastsoundplayed = n;
            this.currentPriority = ShellyCanvas.pShelly.spcbGetPriority(n);
            this.loadSoundData(n);
            if (this.fxPlayer[n] == null) {
                return;
            }
            this.fxPlayer[n].prefetch();
            this.fxPlayer[n].setLoopCount(bl ? -1 : 1);
            this.fxPlayer[n].start();
        }
        catch (Exception exception) {
            return;
        }
    }

    public void stopSound(int n) {
        if (this.fxPlayer[n] == null) {
            return;
        }
        try {
            this.lastsoundplayed = -1;
            this.currentPriority = -1;
            this.fxPlayer[n].stop();
            this.fxPlayer[n].deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAllSounds() {
        for (int i = 0; i < 24; ++i) {
            this.stopSound(i);
        }
    }

    public int soundPlaying() {
        return -999;
    }

    public boolean soundPlayingSupported() {
        return false;
    }

    public void update() {
    }

    public void run() {
        this.playSoundTimer(this.iCurrentSound, this.bLooped[this.iCurrentSound]);
    }
}

