/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.controller.Animation;
import com.jarbull.efw.controller.AnimationHolder;
import com.jarbull.efw.controller.IMemoryListener;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.controller.SoundHandler;
import com.jarbull.efw.controller.VideoHandler;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.game.Level;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.ActionAdapter;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.manager.GameModeHandler;
import com.jarbull.efw.manager.ScreenFactory;
import com.jarbull.efw.text.EFont;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.AdPanel;
import com.jarbull.efw.ui.Button;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.ImageView;
import com.jarbull.efw.ui.Label;
import com.jarbull.efw.ui.Layout;
import com.jarbull.efw.ui.OptionButton;
import com.jarbull.efw.ui.ProgressBar;
import com.jarbull.efw.ui.Screen;
import com.jarbull.efw.ui.ScreenHolder;
import com.jarbull.efw.ui.ShareButton;
import com.jarbull.efw.ui.TextBox;
import com.jarbull.efw.ui.VideoScreen;
import com.jarbull.efw.util.Ellipse;
import com.jarbull.efw.util.StringEx;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

class GameXmlReader {
    static final int ACTION_PERFORMED = 1;
    static final int ON_SELECTED = 2;
    static final int ON_DESELECTED = 3;
    static final int ON_VALUE_CHANGE = 4;
    static final int ON_SHOWN = 5;
    static final int ON_CLOSED = 6;
    static final int ON_ANIMATION_FINISHED = 7;
    static final int ON_ANIMATION_TIME_CHANGES = 8;
    private static String[] menuImages;
    private String[] pauseImages;
    private static String[] sounds;
    private String[] videos;
    private String menu_xml_path;
    private String game_xml_path;
    private String default_language_path;

    public GameXmlReader(EMidlet midlet) {
    }

    public void readMenuXml() throws XmlPullParserException, IOException {
        try {
            final KXmlParser parser = new KXmlParser();
            parser.setInput(new InputStreamReader(this.getClass().getResourceAsStream(this.menu_xml_path)));
            parser.nextTag();
            IMemoryListener listener = new IMemoryListener(){

                public void onHandlerLoaded() {
                    try {
                        GameXmlReader.this.readScreens(parser);
                        if (GameModeHandler.getInstance().mode == 0 && !EMidlet.getInstance().getProperties().isShowDemoScreen()) {
                            ScreenFactory.createDemoIntroScreen();
                            ScreenHolder.getInstance().setActiveScreenId("demointro");
                        } else {
                            ScreenHolder.getInstance().setActiveScreenId("intro");
                        }
                        EMidlet.getInstance().canvas.loading = false;
                    }
                    catch (XmlPullParserException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            };
            parser.nextTag();
            this.readImages(parser);
            this.readSounds(parser);
            this.readVideos(parser);
            ImageHandler.getInstance().setListener(listener);
            SoundHandler.getInstance().load(GameXmlReader.getMenuSounds());
            VideoHandler.getInstance().load(this.getVideos());
            ImageHandler.getInstance().load(GameXmlReader.getMenuImages());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readScreens(KXmlParser parser) throws XmlPullParserException, IOException {
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("screen")) {
                ScreenHolder.getInstance().addScreen(this.readScreen(parser), true);
                continue;
            }
            if (name.equals("mainmenuscreen")) {
                ScreenHolder.getInstance().addScreen(this.readMainMenuScreen(parser), true);
                continue;
            }
            if (name.equals("loadingscreen")) {
                ScreenHolder.getInstance().addScreen(this.readLoadingScreen(parser), false);
                continue;
            }
            if (name.equals("pausemenuscreen")) {
                ScreenHolder.getInstance().addScreen(this.readPauseMenuScreen(parser), false);
                continue;
            }
            if (!name.equals("videoscreen")) continue;
            ScreenHolder.getInstance().addScreen(this.readVideoScreen(parser), true);
        }
    }

    private Screen readPauseMenuScreen(KXmlParser parser) throws XmlPullParserException, IOException {
        Screen screen = new Screen("pausemenuscreen");
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("font")) {
                String fontName = parser.nextText();
                screen.setFontName(fontName);
                continue;
            }
            if (name.equals("text_orientation")) {
                String orientation = parser.nextText();
                if (orientation.equals("none")) {
                    screen.setTextOrientation(0);
                    continue;
                }
                if (orientation.equals("rot90")) {
                    screen.setTextOrientation(5);
                    continue;
                }
                if (orientation.equals("rot180")) {
                    screen.setTextOrientation(3);
                    continue;
                }
                if (!orientation.equals("rot270")) continue;
                screen.setTextOrientation(6);
                continue;
            }
            if (name.equals("writer_type")) {
                String writertype = parser.nextText();
                if (writertype.equals("hex")) {
                    screen.setWriterType(0);
                    continue;
                }
                if (writertype.equals("wex")) {
                    screen.setWriterType(1);
                    continue;
                }
                if (!writertype.equals("string")) continue;
                screen.setWriterType(2);
                continue;
            }
            if (name.equals("layout")) {
                screen.setLayout(this.readLayout(parser));
                continue;
            }
            if (name.equals("button")) {
                screen.addChild(this.readButton(parser, "button"));
                continue;
            }
            if (name.equals("optionbutton")) {
                screen.addChild(this.readButton(parser, "optionbutton"));
                continue;
            }
            if (name.equals("sharebutton")) {
                screen.addChild(this.readButton(parser, "sharebutton"));
                continue;
            }
            if (name.equals("imageview")) {
                screen.addChild(this.readImageView(parser));
                continue;
            }
            if (name.equals("label")) {
                screen.addChild(this.readLabel(parser));
                continue;
            }
            if (name.equals("adpanel")) {
                screen.addChild(this.readAdPanel(parser));
                continue;
            }
            if (!name.equals("actions")) continue;
            this.createScreenActionListener(screen);
            this.readActions(screen, parser);
        }
        return screen;
    }

    private Screen readLoadingScreen(KXmlParser parser) throws XmlPullParserException, IOException {
        Screen screen = new Screen("loadingscreen");
        while (parser.nextTag() != 3) {
            String fontName;
            String name = parser.getName();
            if (name.equals("font")) {
                fontName = parser.nextText();
                screen.setFontName(fontName);
            } else if (name.equals("text_orientation")) {
                fontName = parser.nextText();
                if (fontName.equals("none")) {
                    screen.setTextOrientation(0);
                } else if (fontName.equals("rot90")) {
                    screen.setTextOrientation(5);
                } else if (fontName.equals("rot180")) {
                    screen.setTextOrientation(3);
                } else if (fontName.equals("rot270")) {
                    screen.setTextOrientation(6);
                }
            }
            if (name.equals("layout")) {
                screen.setLayout(this.readLayout(parser));
                continue;
            }
            if (name.equals("progressbar")) {
                screen.addChild(this.readProgressBar(parser));
                continue;
            }
            if (name.equals("imageview")) {
                screen.addChild(this.readImageView(parser));
                continue;
            }
            if (!name.equals("label")) continue;
            screen.addChild(this.readLabel(parser));
        }
        return screen;
    }

    private Screen readMainMenuScreen(KXmlParser parser) throws XmlPullParserException, IOException {
        Screen screen = new Screen("mainmenuscreen");
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("font")) {
                String fontName = parser.nextText();
                screen.setFontName(fontName);
                continue;
            }
            if (name.equals("text_orientation")) {
                String orientation = parser.nextText();
                if (orientation.equals("none")) {
                    screen.setTextOrientation(0);
                    continue;
                }
                if (orientation.equals("rot90")) {
                    screen.setTextOrientation(5);
                    continue;
                }
                if (orientation.equals("rot180")) {
                    screen.setTextOrientation(3);
                    continue;
                }
                if (!orientation.equals("rot270")) continue;
                screen.setTextOrientation(6);
                continue;
            }
            if (name.equals("writer_type")) {
                String writertype = parser.nextText();
                if (writertype.equals("hex")) {
                    screen.setWriterType(0);
                    continue;
                }
                if (writertype.equals("wex")) {
                    screen.setWriterType(1);
                    continue;
                }
                if (!writertype.equals("string")) continue;
                screen.setWriterType(2);
                continue;
            }
            if (name.equals("layout")) {
                screen.setLayout(this.readLayout(parser));
                continue;
            }
            if (name.equals("button")) {
                screen.addChild(this.readButton(parser, "button"));
                continue;
            }
            if (name.equals("optionbutton")) {
                screen.addChild(this.readButton(parser, "optionbutton"));
                continue;
            }
            if (name.equals("sharebutton")) {
                screen.addChild(this.readButton(parser, "sharebutton"));
                continue;
            }
            if (name.equals("imageview")) {
                screen.addChild(this.readImageView(parser));
                continue;
            }
            if (name.equals("label")) {
                screen.addChild(this.readLabel(parser));
                continue;
            }
            if (name.equals("animations")) {
                this.readAnimations(screen, parser);
                continue;
            }
            if (!name.equals("actions")) continue;
            this.createScreenActionListener(screen);
            this.readActions(screen, parser);
        }
        return screen;
    }

    private Screen readScreen(KXmlParser parser) throws XmlPullParserException, IOException {
        Screen screen = null;
        screen = parser.getAttributeCount() == 1 ? new Screen(parser.getAttributeValue(0)) : new Screen(parser.getAttributeValue(0), Integer.parseInt(parser.getAttributeValue(1)));
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("font")) {
                String fontName = parser.nextText();
                screen.setFontName(fontName);
                continue;
            }
            if (name.equals("text_orientation")) {
                String orientation = parser.nextText();
                if (orientation.equals("none")) {
                    screen.setTextOrientation(0);
                    continue;
                }
                if (orientation.equals("rot90")) {
                    screen.setTextOrientation(5);
                    continue;
                }
                if (orientation.equals("rot180")) {
                    screen.setTextOrientation(3);
                    continue;
                }
                if (!orientation.equals("rot270")) continue;
                screen.setTextOrientation(6);
                continue;
            }
            if (name.equals("writer_type")) {
                String writertype = parser.nextText();
                if (writertype.equals("hex")) {
                    screen.setWriterType(0);
                    continue;
                }
                if (writertype.equals("wex")) {
                    screen.setWriterType(1);
                    continue;
                }
                if (!writertype.equals("string")) continue;
                screen.setWriterType(2);
                continue;
            }
            if (name.equals("layout")) {
                screen.setLayout(this.readLayout(parser));
                continue;
            }
            if (name.equals("button")) {
                screen.addChild(this.readButton(parser, "button"));
                continue;
            }
            if (name.equals("optionbutton")) {
                screen.addChild(this.readButton(parser, "optionbutton"));
                continue;
            }
            if (name.equals("sharebutton")) {
                screen.addChild(this.readButton(parser, "sharebutton"));
                continue;
            }
            if (name.equals("adpanel")) {
                screen.addChild(this.readAdPanel(parser));
                continue;
            }
            if (name.equals("imageview")) {
                screen.addChild(this.readImageView(parser));
                continue;
            }
            if (name.equals("label")) {
                screen.addChild(this.readLabel(parser));
                continue;
            }
            if (name.equals("progressbar")) {
                screen.addChild(this.readProgressBar(parser));
                continue;
            }
            if (name.equals("textbox")) {
                screen.addChild(this.readTextBox(parser));
                continue;
            }
            if (name.equals("actions")) {
                this.createScreenActionListener(screen);
                this.readActions(screen, parser);
                continue;
            }
            if (!name.equals("animations")) continue;
            this.readAnimations(screen, parser);
        }
        return screen;
    }

    private VideoScreen readVideoScreen(KXmlParser parser) throws XmlPullParserException, IOException {
        VideoScreen screen = new VideoScreen(parser.getAttributeValue(0), parser.getAttributeValue(1), (Canvas)EMidlet.getInstance().canvas);
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("fullscreen")) {
                String text = parser.nextText();
                screen.setFullScreen(text.equals("true") || text.equals("1"));
                continue;
            }
            if (!name.equals("actions")) continue;
            this.createVideoScreenActionListener(screen);
            this.readActions(screen, parser);
        }
        return screen;
    }

    private void readAnimations(Screen sender, KXmlParser parser) throws XmlPullParserException, IOException {
        int parameterCount = 0;
        int[] interval = new int[2];
        int loopCount = 0;
        int loopDelay = 0;
        int repeatMode = 0;
        String animationId = null;
        String animationType = null;
        String gameObjectName = null;
        String componentId = null;
        String[] param = null;
        String actionName = null;
        String actionParam = null;
        int worldTime = 0;
        if (parser.getName().equals("animations")) {
            String name;
            if (!parser.getAttributeValue(0).equals("")) {
                worldTime = Integer.parseInt(parser.getAttributeValue(0));
            }
            while (!(parser.nextTag() == 1 || (name = parser.getName()).equals("animations") && parser.getEventType() == 3)) {
                if (name.equals("animation") && parser.getEventType() == 2) {
                    animationId = parser.getAttributeValue(0);
                    parameterCount = parser.getAttributeCount();
                    if (parameterCount == 4) {
                        componentId = parser.getAttributeValue(1);
                        gameObjectName = parser.getAttributeValue(2);
                        animationType = parser.getAttributeValue(3);
                        continue;
                    }
                    if (parameterCount == 3) {
                        componentId = parser.getAttributeValue(1);
                        animationType = parser.getAttributeValue(2);
                        continue;
                    }
                    if (parameterCount != 2) continue;
                    animationType = parser.getAttributeValue(1);
                    continue;
                }
                if (name.equals("animation") && parser.getEventType() == 3) {
                    String actionParameter;
                    int[] parameters = new int[param.length];
                    for (int i = 0; i < param.length; ++i) {
                        parameters[i] = Integer.parseInt(param[i]);
                    }
                    Animation anim = null;
                    if (parameterCount == 4) {
                        EFLiteSprite tmpSprite = null;
                        if (gameObjectName.equals("getfg") || gameObjectName.equals("fg") || gameObjectName.equals("foreground")) {
                            tmpSprite = sender.getChild(componentId).getFg();
                        } else if (gameObjectName.equals("getbg") || gameObjectName.equals("bg") || gameObjectName.equals("background")) {
                            tmpSprite = sender.getChild(componentId).getBg();
                        } else if (gameObjectName.equals("getselectedbg") || gameObjectName.equals("selectedbg") || gameObjectName.equals("selected_background")) {
                            tmpSprite = ((Button)sender.getChild(componentId)).getSelectedBg();
                        } else if (gameObjectName.equals("getselectedfg") || gameObjectName.equals("selectedfg") || gameObjectName.equals("selected_foreground")) {
                            tmpSprite = ((Button)sender.getChild(componentId)).getSelectedFg();
                        }
                        if (actionName != null) {
                            final String actionParameter2 = actionParam;
                            anim = new Animation(animationId, tmpSprite, Integer.parseInt(animationType), parameters){

                                public void onAnimationFinished() {
                                    Action animAction = new Action(this, "SETANIMATIONENABLED", actionParameter2);
                                    animAction.doAction();
                                }
                            };
                        } else {
                            anim = new Animation(animationId, tmpSprite, Integer.parseInt(animationType), parameters);
                        }
                    } else if (parameterCount == 3) {
                        if (actionName != null) {
                            actionParameter = actionParam;
                            anim = new Animation(animationId, sender.getChild(componentId), Integer.parseInt(animationType), parameters){

                                public void onAnimationFinished() {
                                    Action animAction = new Action(this, "SETANIMATIONENABLED", actionParameter);
                                    animAction.doAction();
                                }
                            };
                        } else {
                            anim = new Animation(animationId, sender.getChild(componentId), Integer.parseInt(animationType), parameters);
                        }
                    } else if (actionName != null) {
                        actionParameter = actionParam;
                        anim = new Animation(animationId, EMidlet.getInstance().canvas.g, Integer.parseInt(animationType), parameters){

                            public void onAnimationFinished() {
                                Action animAction = new Action(this, "SETANIMATIONENABLED", actionParameter);
                                animAction.doAction();
                            }
                        };
                    } else {
                        anim = new Animation(animationId, EMidlet.getInstance().canvas.g, Integer.parseInt(animationType), parameters);
                    }
                    anim.setInterval(interval[0], interval[1]);
                    if (loopCount != 0) {
                        anim.setLoopCount(loopCount);
                    }
                    if (loopDelay != 0) {
                        anim.setLoopDelay(loopCount);
                    }
                    if (repeatMode != 0) {
                        anim.setRepeatMode(loopCount);
                    }
                    if (worldTime != 0) {
                        AnimationHolder.getInstance().setWorldTimeLimit(worldTime);
                    }
                    AnimationHolder.getInstance().addAnimation(anim);
                    animationId = null;
                    animationType = null;
                    gameObjectName = null;
                    componentId = null;
                    param = null;
                    continue;
                }
                if (name.equals("anim_param") && parser.getEventType() == 2) {
                    param = StringEx.split(parser.nextText(), ",");
                    continue;
                }
                if (name.equals("interval") && parser.getEventType() == 2) {
                    interval[0] = Integer.parseInt(parser.getAttributeValue(0));
                    interval[1] = Integer.parseInt(parser.getAttributeValue(1));
                    continue;
                }
                if (name.equals("loop_count") && parser.getEventType() == 2) {
                    loopCount = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (name.equals("loop_delay") && parser.getEventType() == 2) {
                    loopDelay = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (name.equals("repeat_mode") && parser.getEventType() == 2) {
                    repeatMode = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (name.equals("action") && parser.getEventType() == 2) {
                    actionName = parser.getAttributeValue(0);
                    continue;
                }
                if (!name.equals("param") || parser.getEventType() != 2) continue;
                actionParam = parser.nextText();
            }
        }
    }

    private Layout readLayout(KXmlParser parser) throws XmlPullParserException, IOException {
        Layout layout = new Layout();
        int start_angle = 0;
        int end_angle = 0;
        while (parser.nextTag() != 3) {
            String text;
            String name = parser.getName();
            if (name.equals("type")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                if (text.equals("vertical_center")) {
                    layout.setType(7);
                    continue;
                }
                if (text.equals("vertical_left")) {
                    layout.setType(6);
                    continue;
                }
                if (text.equals("vertical_right")) {
                    layout.setType(8);
                    continue;
                }
                if (text.equals("diagonal_left")) {
                    layout.setType(9);
                    continue;
                }
                if (text.equals("diagonal_right")) {
                    layout.setType(10);
                    continue;
                }
                if (text.equals("horizantal_center")) {
                    layout.setType(4);
                    continue;
                }
                if (text.equals("horizantal_bottom")) {
                    layout.setType(5);
                    continue;
                }
                if (text.equals("horizantal_top")) {
                    layout.setType(3);
                    continue;
                }
                if (text.equals("free")) {
                    layout.setType(1);
                    continue;
                }
                if (text.equals("vertical_horizontal_flow")) {
                    layout.setType(2);
                    continue;
                }
                if (!text.equals("elliptical")) continue;
                layout.setType(0);
                continue;
            }
            if (name.equals("x")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                layout.setArea(Integer.parseInt(text), layout.getAreaY(), layout.getAreaWidth(), layout.getAreaHeigth());
                continue;
            }
            if (name.equals("y")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                layout.setArea(layout.getAreaX(), Integer.parseInt(text), layout.getAreaWidth(), layout.getAreaHeigth());
                continue;
            }
            if (name.equals("width")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                layout.setArea(layout.getAreaX(), layout.getAreaY(), Integer.parseInt(text), layout.getAreaHeigth());
                continue;
            }
            if (name.equals("height")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                layout.setArea(layout.getAreaX(), layout.getAreaY(), layout.getAreaWidth(), Integer.parseInt(text));
                continue;
            }
            if (name.equals("ellipse")) {
                layout.setEllipse(this.readEllipse(parser));
                continue;
            }
            if (name.equals("angle_start")) {
                text = parser.nextText();
                start_angle = Integer.parseInt(text);
                layout.setAngleBetween(start_angle, end_angle);
                continue;
            }
            if (!name.equals("angle_end")) continue;
            text = parser.nextText();
            end_angle = Integer.parseInt(text);
            layout.setAngleBetween(start_angle, end_angle);
        }
        return layout;
    }

    private Ellipse readEllipse(KXmlParser parser) throws XmlPullParserException, IOException {
        Ellipse ellipse = new Ellipse();
        int a = 0;
        int b = 0;
        int x = 0;
        int y = 0;
        while (parser.nextTag() != 3) {
            String text;
            String name = parser.getName();
            if (name.equals("a")) {
                text = parser.nextText();
                a = Integer.parseInt(text);
                ellipse.setAB(a, b);
                continue;
            }
            if (name.equals("b")) {
                text = parser.nextText();
                b = Integer.parseInt(text);
                ellipse.setAB(a, b);
                continue;
            }
            if (name.equals("angle")) {
                text = parser.nextText();
                ellipse.setAngle(Integer.parseInt(text));
                continue;
            }
            if (name.equals("x")) {
                text = parser.nextText();
                x = Integer.parseInt(text);
                ellipse.setPosition(x, y);
                continue;
            }
            if (!name.equals("y")) continue;
            text = parser.nextText();
            y = Integer.parseInt(text);
            ellipse.setPosition(x, y);
        }
        return ellipse;
    }

    private void readComponent(Component component, KXmlParser parser) throws XmlPullParserException, IOException {
        while (parser.nextTag() != 3) {
            String text;
            String name = parser.getName();
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (name.equals("x")) {
                text = parser.nextText();
                x = Integer.parseInt(text);
                component.setPosition(x, component.getY());
                continue;
            }
            if (name.equals("y")) {
                text = parser.nextText();
                y = Integer.parseInt(text);
                component.setPosition(component.getX(), y);
                continue;
            }
            if (name.equals("width")) {
                text = parser.nextText();
                width = Integer.parseInt(text);
                component.setSize(width, component.getHeight());
                continue;
            }
            if (name.equals("height")) {
                text = parser.nextText();
                height = Integer.parseInt(text);
                component.setSize(component.getWidth(), height);
                continue;
            }
            if (name.equals("enabled")) {
                text = parser.nextText();
                component.setEnabled(text.equals("true") || text.equals("1"));
                continue;
            }
            if (name.equals("visible")) {
                text = parser.nextText();
                component.setVisible(text.equals("true") || text.equals("1"));
                continue;
            }
            if (name.equals("auto_resize")) {
                text = parser.nextText();
                component.setAutoResize(text.equals("true") || text.equals("1"));
                continue;
            }
            if (name.equals("auto_pos")) {
                text = parser.nextText();
                component.setAutoPos(text.equals("true") || text.equals("1"));
                continue;
            }
            if (name.equals("background_color")) {
                text = parser.nextText();
                component.setBgColor(Integer.parseInt(text, 16));
                continue;
            }
            if (name.equals("foreground_color")) {
                text = parser.nextText();
                component.setFgColor(Integer.parseInt(text, 16));
                continue;
            }
            if (name.equals("border_color")) {
                text = parser.nextText();
                component.setBorderColor(Integer.parseInt(text));
                continue;
            }
            if (name.equals("border_size")) {
                text = parser.nextText();
                component.setBorderSize(Integer.parseInt(text));
                continue;
            }
            if (name.equals("background")) {
                component.setBg(this.readSprite(parser));
                continue;
            }
            if (!name.equals("foreground")) continue;
            component.setFg(this.readSprite(parser));
        }
        parser.nextTag();
    }

    private EFLiteSprite readSprite(KXmlParser parser) throws XmlPullParserException, IOException {
        EFLiteSprite efl = null;
        String imagepath = null;
        int framewidth = -1;
        int frameheight = -1;
        int imagewidth = 0;
        int imageheight = 0;
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (name.equals("imagepath")) {
                imagepath = parser.nextText();
                continue;
            }
            if (name.equals("framewidth")) {
                framewidth = Integer.parseInt(parser.nextText());
                continue;
            }
            if (name.equals("frameheight")) {
                frameheight = Integer.parseInt(parser.nextText());
                continue;
            }
            if (name.equals("imagewidth")) {
                imagewidth = Integer.parseInt(parser.nextText());
                continue;
            }
            if (!name.equals("imageheight")) continue;
            imageheight = Integer.parseInt(parser.nextText());
        }
        efl = framewidth != -1 && frameheight != -1 ? new EFLiteSprite(imagepath, framewidth, frameheight, imagewidth, imageheight, false) : new EFLiteSprite(imagepath, imagewidth, imageheight, false);
        return efl;
    }

    private Button readButton(KXmlParser parser, String tag) throws XmlPullParserException, IOException {
        Button button = null;
        String fgText = null;
        if (tag.equals("button")) {
            button = new Button(parser.getAttributeValue(0));
        } else if (tag.equals("optionbutton")) {
            button = new OptionButton(parser.getAttributeValue(0));
        } else if (tag.equals("sharebutton")) {
            button = new ShareButton(parser.getAttributeValue(0));
        }
        parser.nextTag();
        this.readComponent(button, parser);
        while (parser.nextTag() != 3) {
            String text;
            String name = parser.getName();
            if (name.equals("alignment")) {
                text = parser.nextText();
                if (text.equals("LEFT_CENTER")) {
                    button.setAlignment(0);
                    continue;
                }
                if (text.equals("RIGHT_CENTER")) {
                    button.setAlignment(1);
                    continue;
                }
                if (!text.equals("CENTER")) continue;
                button.setAlignment(2);
                continue;
            }
            if (name.equals("text")) {
                text = parser.nextText();
                button.setText(text);
                continue;
            }
            if (name.equals("textKey")) {
                text = parser.nextText();
                if (tag.equals("optionbutton")) {
                    fgText = text;
                    continue;
                }
                button.setText(text, true);
                continue;
            }
            if (name.equals("selected_background_color")) {
                text = parser.nextText();
                button.setSelectedBgColor(Integer.parseInt(text));
                continue;
            }
            if (name.equals("selected_foreground_color")) {
                text = parser.nextText();
                button.setSelectedFgColor(Integer.parseInt(text));
                continue;
            }
            if (name.equals("selected_border_color")) {
                text = parser.nextText();
                button.setSelectedBorderColor(Integer.parseInt(text, 16));
                continue;
            }
            if (name.equals("selected_border_size")) {
                text = parser.nextText();
                button.setSelectedBorderSize(Integer.parseInt(text));
                continue;
            }
            if (name.equals("vertical_offset")) {
                text = parser.nextText();
                button.setVerticalOffset(Integer.parseInt(text));
                continue;
            }
            if (name.equals("horizontal_offset")) {
                text = parser.nextText();
                button.setHorizontalOffset(Integer.parseInt(text));
                continue;
            }
            if (name.equals("selected_background")) {
                button.setSelectedBg(this.readSprite(parser));
                continue;
            }
            if (!name.equals("selected_foreground")) continue;
            button.setSelectedFg(this.readSprite(parser));
        }
        parser.nextTag();
        if (tag.equals("optionbutton")) {
            Vector<String> optionText = new Vector<String>();
            Vector<String> optionImage = new Vector<String>();
            String name = null;
            boolean optionWithImage = false;
            while (parser.nextTag() != 3) {
                name = parser.getName();
                String text = parser.nextText();
                if (name.equals("option_key")) {
                    optionText.addElement(text);
                    continue;
                }
                if (!name.equals("image_path")) continue;
                optionImage.addElement(text);
                optionWithImage = true;
            }
            String[] values = new String[optionText.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (String)optionText.elementAt(i);
            }
            ((OptionButton)button).setValues(values, true);
            if (fgText != null || ((OptionButton)button).getEFLiteSpriteValues() == null) {
                button.setText(fgText, true);
            }
            if (optionWithImage) {
                String[] values1 = new String[optionImage.size()];
                for (int i = 0; i < values.length; ++i) {
                    values1[i] = (String)optionImage.elementAt(i);
                }
                EFLiteSprite[] valuesImagePath = new EFLiteSprite[values.length];
                for (int i = 0; i < values.length; ++i) {
                    valuesImagePath[i] = new EFLiteSprite(values1[i]);
                }
                ((OptionButton)button).setValues(values, true);
                ((OptionButton)button).setEFLiteSpriteValues(valuesImagePath);
            }
            parser.nextTag();
        }
        this.createComponentActionListener(button);
        this.readActions(button, parser);
        parser.nextTag();
        return button;
    }

    private void createComponentActionListener(Component actionSender) {
        actionSender.setActionListener(new ActionAdapter(){
            Vector actionPerformedVector = new Vector();
            Vector onSelectedVector = new Vector();
            Vector onDeselectedVector = new Vector();
            Vector onValueChangeVector = new Vector();
            Vector onAnimationTimeChangedVector = new Vector();

            public void actionPerformed() {
                if (this.actionPerformedVector != null) {
                    for (int i = 0; i < this.actionPerformedVector.size(); ++i) {
                        ((Action)this.actionPerformedVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onSelected() {
                if (this.onSelectedVector != null) {
                    for (int i = 0; i < this.onSelectedVector.size(); ++i) {
                        ((Action)this.onSelectedVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onDeselected() {
                if (this.onDeselectedVector != null) {
                    for (int i = 0; i < this.onDeselectedVector.size(); ++i) {
                        ((Action)this.onDeselectedVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onValueChange(String newValue) {
                if (this.onValueChangeVector != null) {
                    for (int i = 0; i < this.onValueChangeVector.size(); ++i) {
                        ((Action)this.onValueChangeVector.elementAt(i)).doAction();
                    }
                }
            }

            public void addAction(int actionType, Action action) {
                if (actionType == 1) {
                    this.actionPerformedVector.addElement(action);
                } else if (actionType == 2) {
                    this.onSelectedVector.addElement(action);
                } else if (actionType == 3) {
                    this.onDeselectedVector.addElement(action);
                } else if (actionType == 4) {
                    this.onValueChangeVector.addElement(action);
                } else if (actionType == 8) {
                    this.onAnimationTimeChangedVector.addElement(action);
                }
            }

            public void onAnimationTimeChange() {
                if (this.onAnimationTimeChangedVector != null) {
                    for (int i = 0; i < this.onAnimationTimeChangedVector.size(); ++i) {
                        ((Action)this.onAnimationTimeChangedVector.elementAt(i)).doAction();
                    }
                }
            }
        });
    }

    private void createScreenActionListener(Screen actionSender) {
        actionSender.setActionListener(new ActionAdapter(){
            Vector actionPerformedVector = new Vector();
            Vector onShownVector = new Vector();
            Vector onCloseVector = new Vector();
            Vector onAnimationTimeChangedVector = new Vector();

            public void actionPerformed() {
                if (this.actionPerformedVector != null) {
                    for (int i = 0; i < this.actionPerformedVector.size(); ++i) {
                        ((Action)this.actionPerformedVector.elementAt(i)).doAction();
                    }
                }
            }

            public void addAction(int actionType, Action action) {
                if (actionType == 5) {
                    this.onShownVector.addElement(action);
                } else if (actionType == 6) {
                    this.onCloseVector.addElement(action);
                } else if (actionType == 8) {
                    this.onAnimationTimeChangedVector.addElement(action);
                } else if (actionType == 1) {
                    this.actionPerformedVector.addElement(action);
                }
            }

            public void onShown() {
                if (this.onShownVector != null) {
                    for (int i = 0; i < this.onShownVector.size(); ++i) {
                        ((Action)this.onShownVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onClose() {
                if (this.onCloseVector != null) {
                    for (int i = 0; i < this.onCloseVector.size(); ++i) {
                        ((Action)this.onCloseVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onAnimationTimeChange() {
                if (this.onAnimationTimeChangedVector != null) {
                    for (int i = 0; i < this.onAnimationTimeChangedVector.size(); ++i) {
                        ((Action)this.onAnimationTimeChangedVector.elementAt(i)).doAction();
                    }
                }
            }
        });
    }

    private void createVideoScreenActionListener(VideoScreen actionSender) {
        actionSender.setActionListener(new ActionAdapter(){
            Vector actionPerformedVector = new Vector();
            Vector onShownVector = new Vector();
            Vector onCloseVector = new Vector();
            Vector onAnimationTimeChangedVector = new Vector();

            public void actionPerformed() {
                if (this.actionPerformedVector != null) {
                    for (int i = 0; i < this.actionPerformedVector.size(); ++i) {
                        ((Action)this.actionPerformedVector.elementAt(i)).doAction();
                    }
                }
            }

            public void addAction(int actionType, Action action) {
                if (actionType == 5) {
                    this.onShownVector.addElement(action);
                } else if (actionType == 6) {
                    this.onCloseVector.addElement(action);
                } else if (actionType == 8) {
                    this.onAnimationTimeChangedVector.addElement(action);
                } else if (actionType == 1) {
                    this.actionPerformedVector.addElement(action);
                }
            }

            public void onShown() {
                if (this.onShownVector != null) {
                    for (int i = 0; i < this.onShownVector.size(); ++i) {
                        ((Action)this.onShownVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onClose() {
                if (this.onCloseVector != null) {
                    for (int i = 0; i < this.onCloseVector.size(); ++i) {
                        ((Action)this.onCloseVector.elementAt(i)).doAction();
                    }
                }
            }

            public void onAnimationTimeChange() {
                if (this.onAnimationTimeChangedVector != null) {
                    for (int i = 0; i < this.onAnimationTimeChangedVector.size(); ++i) {
                        ((Action)this.onAnimationTimeChangedVector.elementAt(i)).doAction();
                    }
                }
            }
        });
    }

    private void readActions(Object sender, KXmlParser parser) throws XmlPullParserException, IOException {
        String name;
        int actionType = 0;
        String actionName = null;
        String param = null;
        while (!(parser.nextTag() == 1 || (name = parser.getName()).equals("actions") && parser.getEventType() == 3)) {
            if (name.equals("action_performed") && parser.getEventType() == 2) {
                actionType = 1;
                continue;
            }
            if (name.equals("on_selected") && parser.getEventType() == 2) {
                actionType = 2;
                continue;
            }
            if (name.equals("on_deselected") && parser.getEventType() == 2) {
                actionType = 3;
                continue;
            }
            if (name.equals("on_value_change") && parser.getEventType() == 2) {
                actionType = 4;
                continue;
            }
            if (name.equals("on_shown") && parser.getEventType() == 2) {
                actionType = 5;
                continue;
            }
            if (name.equals("on_close") && parser.getEventType() == 2) {
                actionType = 6;
                continue;
            }
            if (parser.getName().equals("action") && parser.getEventType() == 2) {
                actionName = parser.getAttributeValue(0);
                continue;
            }
            if (name.equals("param") && parser.getEventType() == 2) {
                param = parser.nextText();
                continue;
            }
            if (!name.equals("action") || parser.getEventType() != 3) continue;
            Action action = new Action(sender, actionName, param);
            if (sender instanceof Component) {
                ((Component)sender).getActionListener().addAction(actionType, action);
            } else if (sender instanceof Screen) {
                ((Screen)sender).getActionListener().addAction(actionType, action);
            } else if (sender instanceof VideoScreen) {
                ((VideoScreen)sender).getActionListener().addAction(actionType, action);
            }
            param = null;
        }
    }

    private void readImages(KXmlParser parser) throws XmlPullParserException, IOException {
        Vector<String> menuImageVector = new Vector<String>();
        Vector<String> pauseImageVector = new Vector<String>();
        int bgColor = 0;
        while (parser.nextTag() != 3) {
            int i;
            String name = parser.getName();
            if (name.equals("menu_images")) {
                while (parser.nextTag() != 3) {
                    String text = parser.nextText();
                    menuImageVector.addElement(text);
                }
                menuImages = new String[menuImageVector.size() + 4];
                for (i = 0; i < menuImageVector.size(); ++i) {
                    GameXmlReader.menuImages[i] = (String)menuImageVector.elementAt(i);
                }
                GameXmlReader.menuImages[GameXmlReader.menuImages.length - 4] = "/res/facebook.png";
                GameXmlReader.menuImages[GameXmlReader.menuImages.length - 3] = "/res/twitter.png";
                GameXmlReader.menuImages[GameXmlReader.menuImages.length - 2] = "/res/vk.png";
                GameXmlReader.menuImages[GameXmlReader.menuImages.length - 1] = "/res/jarbull.png";
            } else if (name.equals("pause_images")) {
                while (parser.nextTag() != 3) {
                    String text = parser.nextText();
                    pauseImageVector.addElement(text);
                }
                this.pauseImages = new String[pauseImageVector.size()];
                for (i = 0; i < pauseImageVector.size(); ++i) {
                    this.pauseImages[i] = (String)pauseImageVector.elementAt(i);
                }
            } else if (name.equals("bgColor")) {
                bgColor = Integer.parseInt(parser.nextText(), 16);
            }
            EMidlet.getInstance().canvas.setBgColor(bgColor);
        }
        parser.nextTag();
    }

    private void readSounds(KXmlParser parser) throws XmlPullParserException, IOException {
        Vector<String> soundsVector = new Vector<String>();
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (!name.equals("sound")) continue;
            String text = parser.nextText();
            soundsVector.addElement(text);
        }
        sounds = new String[soundsVector.size()];
        for (int i = 0; i < soundsVector.size(); ++i) {
            GameXmlReader.sounds[i] = (String)soundsVector.elementAt(i);
        }
        parser.nextTag();
    }

    private void readVideos(KXmlParser parser) throws XmlPullParserException, IOException {
        Vector<String> videosVector = new Vector<String>();
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if (!name.equals("video")) continue;
            String text = parser.nextText();
            videosVector.addElement(text);
        }
        this.videos = new String[videosVector.size()];
        for (int i = 0; i < videosVector.size(); ++i) {
            this.videos[i] = (String)videosVector.elementAt(i);
        }
        parser.nextTag();
    }

    private Label readLabel(KXmlParser parser) throws XmlPullParserException, IOException {
        Label label = new Label(parser.getAttributeValue(0), parser.getAttributeValue(1));
        parser.nextTag();
        this.readComponent(label, parser);
        while (parser.nextTag() != 3) {
            String text;
            String name = parser.getName();
            if (name.equals("alignment")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                if (text.equals("center")) {
                    label.setAlignment(1);
                    continue;
                }
                if (text.equals("left")) {
                    label.setAlignment(0);
                    continue;
                }
                if (!text.equals("right")) continue;
                label.setAlignment(2);
                continue;
            }
            if (name.equals("vertical_offset")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setVerticalOffset(Integer.parseInt(text));
                continue;
            }
            if (name.equals("horizontal_offset")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setHorizontalOffset(Integer.parseInt(text));
                continue;
            }
            if (name.equals("selectedborder_color")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setSelectedBorderColor(Integer.parseInt(text));
                continue;
            }
            if (name.equals("selectedborder_size")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setSelectedBorderSize(Integer.parseInt(text));
                continue;
            }
            if (name.equals("automatic_shift")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setAutomaticShift(text.equals("true"));
                continue;
            }
            if (name.equals("scrollBar_visibility")) {
                text = parser.nextText();
                if (text.equals("")) continue;
                label.setScrollBarVisibility(text.equals("true"));
                continue;
            }
            if (!name.equals("scrollBar_velocity") || (text = parser.nextText()).equals("")) continue;
            label.setShiftVelocity(Integer.parseInt(text));
        }
        parser.nextTag();
        return label;
    }

    private ProgressBar readProgressBar(KXmlParser parser) throws XmlPullParserException, IOException {
        ProgressBar pb = new ProgressBar(parser.getAttributeValue(0));
        parser.nextTag();
        this.readComponent(pb, parser);
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            String text = parser.nextText();
            if (name.equals("value") && !text.equals("")) {
                pb.setValue(Integer.parseInt(text));
                continue;
            }
            if (name.equals("type")) {
                if (text.equals("BOX_FILL")) {
                    pb.setType(11);
                    continue;
                }
                if (text.equals("ANIMATION")) {
                    pb.setType(10);
                    continue;
                }
                if (text.equals("CIRCULAR_FILL")) {
                    pb.setType(12);
                    continue;
                }
                if (!text.equals("CIRCULAR_LINE")) continue;
                pb.setType(13);
                continue;
            }
            if (name.equals("color_mode")) {
                if (text.equals("BOX_FILL")) {
                    pb.setColorMode(11);
                    continue;
                }
                if (text.equals("FADE")) {
                    pb.setColorMode(101);
                    continue;
                }
                if (!text.equals("GRADIENT")) continue;
                pb.setColorMode(102);
                continue;
            }
            if (name.equals("margin") && !text.equals("")) {
                pb.setMargin(Integer.parseInt(text));
                continue;
            }
            if (name.equals("fill_offset_x") && !text.equals("")) {
                pb.setFillOffset(Integer.parseInt(text), pb.getFillOffsetY());
                continue;
            }
            if (name.equals("fill_offset_y") && !text.equals("")) {
                pb.setFillOffset(pb.getFillOffsetX(), Integer.parseInt(text));
                continue;
            }
            if (!name.equals("trans_color") || text.equals("")) continue;
            pb.setTransColor(Integer.parseInt(text));
        }
        parser.nextTag();
        return pb;
    }

    private TextBox readTextBox(KXmlParser parser) throws XmlPullParserException, IOException {
        TextBox tb = new TextBox(parser.getAttributeValue(0));
        parser.nextTag();
        this.readComponent(tb, parser);
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            String text = parser.nextText();
            if (name.equals("char_offset_x")) {
                tb.setCharOffsetX(Integer.parseInt(text));
                continue;
            }
            if (name.equals("char_offset_y")) {
                tb.setCharOffsetY(Integer.parseInt(text));
                continue;
            }
            if (name.equals("text_char_offset_y")) {
                tb.setTextCharSetOffsetY(Integer.parseInt(text));
                continue;
            }
            if (name.equals("max_text_size")) {
                tb.setMaxTextSize(Integer.parseInt(text));
                continue;
            }
            if (!name.equals("initial_text")) continue;
            tb.setText(text);
        }
        parser.nextTag();
        tb.initializePositions();
        return tb;
    }

    private ImageView readImageView(KXmlParser parser) throws XmlPullParserException, IOException {
        ImageView iv = null;
        int attributeCount = parser.getAttributeCount();
        if (attributeCount == 2) {
            if (parser.getAttributeName(1).equals("imageId")) {
                iv = new ImageView(parser.getAttributeValue(0), parser.getAttributeValue(1));
            }
        } else if (attributeCount == 4) {
            iv = new ImageView(parser.getAttributeValue(0), parser.getAttributeValue(1), Integer.parseInt(parser.getAttributeValue(2)), Integer.parseInt(parser.getAttributeValue(3)));
        } else {
            return null;
        }
        parser.nextTag();
        this.readComponent(iv, parser);
        while (parser.nextTag() != 3) {
        }
        parser.nextTag();
        return iv;
    }

    private AdPanel readAdPanel(KXmlParser parser) throws XmlPullParserException, IOException {
        AdPanel adPanel = new AdPanel(parser.getAttributeValue(0));
        parser.nextTag();
        this.readComponent(adPanel, parser);
        while (parser.nextTag() != 3) {
            parser.nextText();
        }
        parser.nextTag();
        return adPanel;
    }

    public void readConfigXml(EMidlet midlet) throws XmlPullParserException, IOException {
        String text;
        String name;
        int defaultWidth = 240;
        int defaultHeight = 320;
        int currentWidth = 240;
        int currentHeight = 320;
        Vector<String> fontName = new Vector<String>();
        Vector<String> fontType = new Vector<String>();
        Vector<String> fontImage = new Vector<String>();
        Vector<String> fontIndexFile = new Vector<String>();
        KXmlParser parser = new KXmlParser();
        parser.setInput(new InputStreamReader(this.getClass().getResourceAsStream("/res/config.xml")));
        parser.nextTag();
        parser.nextTag();
        while (parser.nextTag() != 3) {
            name = parser.getName();
            text = parser.nextText();
            if (name.equals("demo_duration")) {
                midlet.demoDuration = Integer.parseInt(text);
                continue;
            }
            if (name.equals("game_id")) {
                midlet.gameId = Integer.parseInt(text);
                continue;
            }
            if (name.equals("efw_version")) {
                midlet.efwVersion = text;
                continue;
            }
            if (name.equals("game_version")) {
                midlet.gameVersion = text;
                continue;
            }
            if (name.equals("orientation")) {
                if (text.equals("vertical")) {
                    ResolutionHandler.getInstance().setOrientation(0);
                    continue;
                }
                if (!text.equals("horizontal")) continue;
                ResolutionHandler.getInstance().setOrientation(1);
                continue;
            }
            if (name.equals("default_width")) {
                defaultWidth = Integer.parseInt(text);
                continue;
            }
            if (name.equals("default_height")) {
                defaultHeight = Integer.parseInt(text);
                continue;
            }
            if (name.equals("current_width")) {
                currentWidth = Integer.parseInt(text);
                continue;
            }
            if (name.equals("current_height")) {
                currentHeight = Integer.parseInt(text);
                continue;
            }
            if (name.equals("menu_xml_path")) {
                this.menu_xml_path = text;
                continue;
            }
            if (name.equals("game_xml_path")) {
                this.game_xml_path = text;
                continue;
            }
            if (!name.equals("default_language_path")) continue;
            LocalizationSupport._MESSAGES_BUNDLE = this.default_language_path = text;
        }
        ResolutionHandler.getInstance().setCurrentSize(currentWidth, currentHeight);
        ResolutionHandler.getInstance().setDefaultSize(defaultWidth, defaultHeight);
        parser.nextTag();
        while (parser.nextTag() != 1 && !(name = parser.getName()).equals("fonts")) {
            if (name.equals("font")) continue;
            text = parser.nextText();
            if (name.equals("name")) {
                fontName.addElement(text);
                continue;
            }
            if (name.equals("type")) {
                fontType.addElement(text);
                continue;
            }
            if (name.equals("png_file")) {
                fontImage.addElement(text);
                continue;
            }
            if (!name.equals("index_file")) continue;
            fontIndexFile.addElement(text);
        }
        for (int i = 0; i < fontName.size(); ++i) {
            EFont myFont = null;
            if (((String)fontType.elementAt(i)).equals("HEX")) {
                myFont = new EFont((String)fontName.elementAt(i), (String)fontImage.elementAt(i), (String)fontIndexFile.elementAt(i), 0);
            } else if (((String)fontType.elementAt(i)).equals("WEX")) {
                myFont = new EFont((String)fontName.elementAt(i), (String)fontImage.elementAt(i), (String)fontIndexFile.elementAt(i), 1);
            }
            TextWriter.getInstance().loadFont(myFont);
        }
    }

    public void readGameXml(EMidlet midlet) throws IOException, XmlPullParserException {
        String name;
        KXmlParser parser = new KXmlParser();
        parser.setInput(new InputStreamReader(this.getClass().getResourceAsStream(this.game_xml_path)));
        Vector<String> levelImages = null;
        Vector<String> levelSounds = null;
        String levelId = null;
        parser.nextTag();
        while (parser.nextTag() != 1 && !(name = parser.getName()).equals("levels")) {
            if (name.equals("level") && parser.getEventType() == 2) {
                levelId = parser.getAttributeValue(0);
                levelImages = new Vector<String>();
                levelSounds = new Vector<String>();
                continue;
            }
            if (name.equals("level") && parser.getEventType() == 3) {
                String[] levelImagesArray = new String[levelImages.size()];
                for (int i = 0; i < levelImages.size(); ++i) {
                    levelImagesArray[i] = (String)levelImages.elementAt(i);
                }
                String[] levelSoundsArray = new String[levelSounds.size()];
                for (int i = 0; i < levelSounds.size(); ++i) {
                    levelSoundsArray[i] = (String)levelSounds.elementAt(i);
                }
                Level level = new Level(levelId, StringEx.merge(levelImagesArray, this.getPauseImages()), levelSoundsArray);
                LevelHolder.getInstance().addLevel(level);
                continue;
            }
            if (name.equals("image")) {
                levelImages.addElement(parser.nextText());
                continue;
            }
            if (!name.equals("sound")) continue;
            levelSounds.addElement(parser.nextText());
        }
    }

    public static String[] getMenuImages() {
        return menuImages;
    }

    public String[] getPauseImages() {
        return this.pauseImages;
    }

    public static String[] getMenuSounds() {
        return sounds;
    }

    public String[] getVideos() {
        return this.videos;
    }
}

