/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.io.RecordHandler;
import com.jarbull.efw.manager.EMidlet;
import java.util.Enumeration;
import java.util.Hashtable;

public class Settings {
    Hashtable settings = new Hashtable();
    boolean loaded = false;

    void load() {
        RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
        KeyValuePair[] records = RecordHandler.getInstance().getAllRecords();
        for (int i = 0; i < records.length; ++i) {
            KeyValuePair record = records[i];
            this.settings.put(record.getKey(), record.getValue());
        }
        RecordHandler.getInstance().closeRecordStore();
        this.loaded = true;
    }

    void save() {
        if (this.settings.size() <= 0) {
            return;
        }
        RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
        KeyValuePair[] records = new KeyValuePair[this.settings.size()];
        Enumeration settingsEnum = this.settings.keys();
        int i = 0;
        while (settingsEnum.hasMoreElements()) {
            String id = (String)settingsEnum.nextElement();
            records[i] = new KeyValuePair(id, (String)this.settings.get(id));
            ++i;
        }
        RecordHandler.getInstance().saveRecords(records);
        this.settings.clear();
        RecordHandler.getInstance().closeRecordStore();
        this.loaded = false;
    }

    public void add(KeyValuePair record) {
        if (this.loaded) {
            this.settings.put(record.getKey(), record.getValue());
        } else {
            RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
            RecordHandler.getInstance().saveRecord(record);
            RecordHandler.getInstance().closeRecordStore();
        }
    }

    public void remove(String key) {
        if (this.loaded) {
            this.settings.remove(key);
        } else {
            RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
            RecordHandler.getInstance().clearRecord(key);
            RecordHandler.getInstance().closeRecordStore();
        }
    }

    public String get(String key) {
        if (this.loaded) {
            return (String)this.settings.get(key);
        }
        RecordHandler.getInstance().openRecordStore(EMidlet.getInstance().getGameRecName());
        KeyValuePair record = RecordHandler.getInstance().getRecord(key);
        RecordHandler.getInstance().closeRecordStore();
        return record == null ? null : record.getValue();
    }
}

