/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLayer;
import javax.microedition.lcdui.Graphics;

public class EFTiledLayer
extends EFLayer {
    private int cellHeight;
    private int cellWidth;
    private int rows;
    private int columns;
    private int[][] cellMatrix;
    private int numberOfTiles;
    String sourceImagePath;
    int[] tileSetX;
    int[] tileSetY;
    private int[] anim_to_static;
    private int numOfAnimTiles;

    public EFTiledLayer(int columns, int rows, String imagePath, int tileWidth, int tileHeight) {
        super(columns < 1 || tileWidth < 1 ? -1 : columns * tileWidth, rows < 1 || tileHeight < 1 ? -1 : rows * tileHeight);
        if (ImageHandler.getInstance().getImage(imagePath).getWidth() % tileWidth != 0 || ImageHandler.getInstance().getImage(imagePath).getHeight() % tileHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.rows = rows;
        this.cellMatrix = new int[rows][columns];
        int noOfFrames = ImageHandler.getInstance().getImage(imagePath).getWidth() / tileWidth * (ImageHandler.getInstance().getImage(imagePath).getHeight() / tileHeight);
        this.createStaticSet(imagePath, noOfFrames + 1, tileWidth, tileHeight, true);
    }

    public int createAnimatedTile(int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        if (this.anim_to_static == null) {
            this.anim_to_static = new int[4];
            this.numOfAnimTiles = 1;
        } else if (this.numOfAnimTiles == this.anim_to_static.length) {
            int[] new_anim_tbl = new int[this.anim_to_static.length * 2];
            System.arraycopy(this.anim_to_static, 0, new_anim_tbl, 0, this.anim_to_static.length);
            this.anim_to_static = new_anim_tbl;
        }
        this.anim_to_static[this.numOfAnimTiles] = staticTileIndex;
        ++this.numOfAnimTiles;
        return -(this.numOfAnimTiles - 1);
    }

    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex >= this.numberOfTiles) {
            throw new IndexOutOfBoundsException();
        }
        animatedTileIndex = -animatedTileIndex;
        if (this.anim_to_static == null || animatedTileIndex <= 0 || animatedTileIndex >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        this.anim_to_static[animatedTileIndex] = staticTileIndex;
    }

    public int getAnimatedTile(int animatedTileIndex) {
        animatedTileIndex = -animatedTileIndex;
        if (this.anim_to_static == null || animatedTileIndex <= 0 || animatedTileIndex >= this.numOfAnimTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.anim_to_static[animatedTileIndex];
    }

    public void setCell(int col, int row, int tileIndex) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (tileIndex > 0 ? tileIndex >= this.numberOfTiles : tileIndex < 0 && (this.anim_to_static == null || -tileIndex >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        this.cellMatrix[row][col] = tileIndex;
    }

    public int getCell(int col, int row) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        return this.cellMatrix[row][col];
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        if (col < 0 || col >= this.columns || row < 0 || row >= this.rows || numCols < 0 || col + numCols > this.columns || numRows < 0 || row + numRows > this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (tileIndex > 0 ? tileIndex >= this.numberOfTiles : tileIndex < 0 && (this.anim_to_static == null || -tileIndex >= this.numOfAnimTiles)) {
            throw new IndexOutOfBoundsException();
        }
        for (int rowCount = row; rowCount < row + numRows; ++rowCount) {
            for (int columnCount = col; columnCount < col + numCols; ++columnCount) {
                this.cellMatrix[rowCount][columnCount] = tileIndex;
            }
        }
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            int tileIndex = 0;
            int ty = this.y;
            int row = 0;
            while (row < this.cellMatrix.length) {
                int tx = this.x;
                int totalCols = this.cellMatrix[row].length;
                int column = 0;
                while (column < totalCols) {
                    tileIndex = this.cellMatrix[row][column];
                    if (tileIndex != 0) {
                        if (tileIndex < 0) {
                            tileIndex = this.getAnimatedTile(tileIndex);
                        }
                        g.drawRegion(ImageHandler.getInstance().getImage(this.sourceImagePath), this.tileSetX[tileIndex], this.tileSetY[tileIndex], this.cellWidth, this.cellHeight, 0, tx, ty, 20);
                    }
                    ++column;
                    tx += this.cellWidth;
                }
                ++row;
                ty += this.cellHeight;
            }
        }
    }

    private void createStaticSet(String imagePath, int noOfFrames, int tileWidth, int tileHeight, boolean maintainIndices) {
        this.cellWidth = tileWidth;
        this.cellHeight = tileHeight;
        int imageW = ImageHandler.getInstance().getImage(imagePath).getWidth();
        int imageH = ImageHandler.getInstance().getImage(imagePath).getHeight();
        this.sourceImagePath = imagePath;
        this.numberOfTiles = noOfFrames;
        this.tileSetX = new int[this.numberOfTiles];
        this.tileSetY = new int[this.numberOfTiles];
        if (!maintainIndices) {
            this.rows = 0;
            while (this.rows < this.cellMatrix.length) {
                int totalCols = this.cellMatrix[this.rows].length;
                this.columns = 0;
                while (this.columns < totalCols) {
                    this.cellMatrix[this.rows][this.columns] = 0;
                    ++this.columns;
                }
                ++this.rows;
            }
            this.anim_to_static = null;
        }
        int currentTile = 1;
        for (int y = 0; y < imageH; y += tileHeight) {
            for (int x = 0; x < imageW; x += tileWidth) {
                this.tileSetX[currentTile] = x;
                this.tileSetY[currentTile] = y;
                ++currentTile;
            }
        }
    }
}

