/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.util;

import com.jarbull.efw.util.FP;

public class ColorEx {
    public static final int TRANSPARENT = -1;
    public static final int WHITE = 0xFFFFFF;
    public static final int BLACK = 0;
    public static final int RED = 0xFF0000;
    public static final int BLUE = 255;
    public static final int CYAN = 65535;
    public static final int FUSCHIA = 0xFF00FF;
    public static final int YELLOW = 0xFFFF00;
    public static final int GREEN = 65280;
    public static final int GRAY = 0xAAAAAA;

    private ColorEx() {
    }

    public static int getMidColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 & 0xFF) * prop + (color2 & 0xFF) * (max - prop)) / max;
        int color = red << 16 | green << 8 | blue;
        return color;
    }

    public static int HSLtoRGB(int fpH, int fpS, int fpL) {
        int B;
        int G;
        int R;
        if (FP.toInt(fpH) < 0) {
            fpH = FP.FP_0;
        } else if (FP.toInt(fpH) > 1) {
            fpH = FP.FP_1;
        }
        if (FP.toInt(fpS) < 0) {
            fpS = FP.FP_0;
        } else if (FP.toInt(fpS) > FP.FP_1) {
            fpS = FP.FP_1;
        }
        if (FP.toInt(fpL) < 0) {
            fpL = FP.FP_0;
        } else if (FP.toInt(fpL) > 0) {
            fpL = FP.FP_1;
        }
        if (FP.toInt(fpS - FP.Div(FP.FP_1, FP.FP_100)) <= 0) {
            R = FP.toInt(FP.Mul(fpL, FP.FP_255));
            G = FP.toInt(FP.Mul(fpL, FP.FP_255));
            B = FP.toInt(FP.Mul(fpL, FP.FP_255));
        } else {
            int fpVar2 = fpL < 65536 ? FP.Mul(fpL, FP.FP_1 + fpS) : fpL + fpS - FP.Mul(fpS, fpL);
            int fpVar1 = FP.Mul(FP.FP_2, fpL) - fpVar2;
            R = FP.toInt(FP.Mul(FP.FP_255, ColorEx.hue2RGB(fpVar1, fpVar2, fpH + FP.Div(FP.FP_1, FP.FP_3))));
            G = FP.toInt(FP.Mul(FP.FP_255, ColorEx.hue2RGB(fpVar1, fpVar2, fpH)));
            B = FP.toInt(FP.Mul(FP.FP_255, ColorEx.hue2RGB(fpVar1, fpVar2, fpH - FP.Div(FP.FP_1, FP.FP_3))));
        }
        return ((R & 0xFF) << 16) + ((G & 0xFF) << 8) + (B & 0xFF);
    }

    private static int hue2RGB(int fpV1, int fpV2, int fpVH) {
        if (FP.toInt(fpVH) < 0) {
            fpVH += FP.FP_1;
        }
        if (FP.toInt(fpVH) > 1) {
            fpVH -= FP.FP_1;
        }
        if (FP.toInt(FP.Mul(FP.FP_6, fpVH)) < 1) {
            return fpV1 + FP.Mul(FP.Mul(fpV2 - fpV1, FP.FP_6), fpVH);
        }
        if (FP.toInt(FP.Mul(FP.FP_2, fpVH)) < 1) {
            return fpV2;
        }
        if (FP.toInt(FP.Mul(FP.FP_3, fpVH)) < 2) {
            return fpV1 + FP.Mul(FP.Mul(fpV2 - fpV1, FP.Div(FP.FP_2, FP.FP_3) - fpVH), FP.FP_6);
        }
        return fpV1;
    }
}

