/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.ui.Component;
import javax.microedition.lcdui.Graphics;

public class ImageView
extends Component {
    private String imageId;
    private boolean tiled = false;
    private int rowCount;
    private int columnCount;
    private int[][] tileImageCoordinates;

    public ImageView(String id, String imageId) {
        super(id);
        this.imageId = imageId;
        ImageHandler.getInstance().load(imageId);
        this.width = ImageHandler.getInstance().getImage(imageId).getWidth();
        this.height = ImageHandler.getInstance().getImage(imageId).getHeight();
        this.x = 0;
        this.y = 0;
    }

    public ImageView(String id, String tileImageId, int imageViewWidth, int imageViewHeight) {
        super(id);
        this.imageId = tileImageId;
        this.width = imageViewWidth;
        this.height = imageViewHeight;
        this.tiled = true;
        ImageHandler.getInstance().load(tileImageId);
        this.initializeCoordinates();
    }

    private void initializeCoordinates() {
        int imageWidth = ImageHandler.getInstance().getImage(this.imageId).getWidth();
        int imageHeight = ImageHandler.getInstance().getImage(this.imageId).getHeight();
        this.columnCount = this.width / imageWidth;
        if (this.width % imageWidth != 0) {
            ++this.columnCount;
        }
        this.rowCount = this.height / imageHeight;
        if (this.height % imageHeight != 0) {
            ++this.rowCount;
        }
        this.tileImageCoordinates = new int[this.columnCount * this.rowCount][2];
        int k = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            for (int j = 0; j < this.rowCount; ++j) {
                this.tileImageCoordinates[k][0] = i * imageWidth;
                this.tileImageCoordinates[k][1] = j * imageHeight;
                ++k;
            }
        }
    }

    public String getImage() {
        return this.imageId;
    }

    public void setImage(String imageId) {
        this.imageId = imageId;
        ImageHandler.getInstance().load(imageId);
        this.width = ImageHandler.getInstance().getImage(imageId).getWidth();
        this.height = ImageHandler.getInstance().getImage(imageId).getHeight();
    }

    public void setTileImage(String imageId, int imageViewWidth, int imageViewHeight) {
        this.imageId = imageId;
        this.width = imageViewWidth;
        this.height = imageViewHeight;
        this.tiled = true;
        ImageHandler.getInstance().load(imageId);
        this.initializeCoordinates();
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        this.saveClip(g);
        g.translate(this.x, this.y);
        if (this.clipRegionActivated) {
            g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
        } else {
            g.setClip(0, 0, this.width, this.height);
        }
        if (this.tiled) {
            int tileLength = this.tileImageCoordinates.length;
            for (int i = 0; i < tileLength; ++i) {
                g.drawImage(ImageHandler.getInstance().getImage(this.imageId), this.tileImageCoordinates[i][0], this.tileImageCoordinates[i][1], 0);
            }
        } else {
            if (this.bg != null) {
                this.bg.paint(g);
            }
            g.drawImage(ImageHandler.getInstance().getImage(this.imageId), this.width / 2 - ImageHandler.getInstance().getImage(this.imageId).getWidth() / 2, this.height / 2 - ImageHandler.getInstance().getImage(this.imageId).getHeight() / 2, 0);
            if (this.fg != null) {
                this.fg.paint(g);
            }
            g.setColor(this.borderColor);
            for (int i = 0; i < this.borderSize; ++i) {
                g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
            }
        }
        g.translate(-this.x, -this.y);
        this.restoreClip(g);
    }
}

