/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLayer;
import com.jarbull.efw.game.ISprite;
import javax.microedition.lcdui.Graphics;

public class EFLiteSprite
extends EFLayer
implements ISprite {
    String sourceImagePath;
    int numberFrames;
    int[] frameCoordsX;
    int[] frameCoordsY;
    int srcFrameWidth;
    int srcFrameHeight;
    int[] frameSequence;
    private int sequenceIndex;
    private boolean customSequenceDefined;
    int dRefX;
    int dRefY;
    int imageWidth;
    int imageHeight;

    public EFLiteSprite(String imagePath) {
        super(ImageHandler.getInstance().getImage(imagePath).getWidth(), ImageHandler.getInstance().getImage(imagePath).getHeight());
        this.imageWidth = ImageHandler.getInstance().getImage(imagePath).getWidth();
        this.imageHeight = ImageHandler.getInstance().getImage(imagePath).getHeight();
        this.initializeFrames(imagePath, this.imageWidth, this.imageHeight, false);
    }

    public EFLiteSprite(String imagePath, int frameWidth, int frameHeight) {
        super(frameWidth, frameHeight);
        this.imageWidth = ImageHandler.getInstance().getImage(imagePath).getWidth();
        this.imageHeight = ImageHandler.getInstance().getImage(imagePath).getHeight();
        if (frameWidth < 1 || frameHeight < 1 || this.imageWidth % frameWidth != 0 || this.imageHeight % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        this.initializeFrames(imagePath, frameWidth, frameHeight, false);
    }

    public EFLiteSprite(String imagePath, int imageWidth, int imageHeight, boolean imageRequired) {
        super(imageWidth, imageHeight);
        if (!imageRequired) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.initializeFrames(imagePath, imageWidth, imageHeight, false);
        } else {
            System.out.println("   --if image is required use other constructor!--");
        }
    }

    public EFLiteSprite(String imagePath, int frameWidth, int frameHeight, int imageWidth, int imageHeight, boolean imageRequired) {
        super(frameWidth, frameHeight);
        if (!imageRequired) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            if (frameWidth < 1 || frameHeight < 1 || imageWidth % frameWidth != 0 || imageHeight % frameHeight != 0) {
                throw new IllegalArgumentException();
            }
            this.initializeFrames(imagePath, frameWidth, frameHeight, false);
        } else {
            System.out.println("   --if image is required use other constructor!--");
        }
    }

    public String getImageId() {
        return this.sourceImagePath;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.frameSequence.length) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public int getFrameSequenceLength() {
        return this.frameSequence.length;
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.frameSequence.length;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.frameSequence.length - 1 : --this.sequenceIndex;
    }

    public final void paint(Graphics g) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            g.drawRegion(ImageHandler.getInstance().getImage(this.sourceImagePath), this.frameCoordsX[this.frameSequence[this.sequenceIndex]], this.frameCoordsY[this.frameSequence[this.sequenceIndex]], this.srcFrameWidth, this.srcFrameHeight, 0, this.x, this.y, 20);
        }
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequenceIndex = 0;
            this.customSequenceDefined = false;
            this.frameSequence = new int[this.numberFrames];
            for (int i = 0; i < this.numberFrames; ++i) {
                this.frameSequence[i] = i;
            }
            return;
        }
        if (sequence.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (sequence[i] >= 0 && sequence[i] < this.numberFrames) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.customSequenceDefined = true;
        this.frameSequence = new int[sequence.length];
        System.arraycopy(sequence, 0, this.frameSequence, 0, sequence.length);
        this.sequenceIndex = 0;
    }

    public void setImage(String imagePath, int frameWidth, int frameHeight) {
        if (frameWidth < 1 || frameHeight < 1 || ImageHandler.getInstance().getImage(imagePath).getWidth() % frameWidth != 0 || ImageHandler.getInstance().getImage(imagePath).getHeight() % frameHeight != 0) {
            throw new IllegalArgumentException();
        }
        int noOfFrames = ImageHandler.getInstance().getImage(imagePath).getWidth() / frameWidth * (ImageHandler.getInstance().getImage(imagePath).getHeight() / frameHeight);
        boolean maintainCurFrame = true;
        if (noOfFrames < this.numberFrames) {
            maintainCurFrame = false;
            this.customSequenceDefined = false;
        }
        if (this.srcFrameWidth != frameWidth || this.srcFrameHeight != frameHeight) {
            this.setWidth(frameWidth);
            this.setHeight(frameHeight);
            this.initializeFrames(imagePath, frameWidth, frameHeight, maintainCurFrame);
        } else {
            this.initializeFrames(imagePath, frameWidth, frameHeight, maintainCurFrame);
        }
    }

    private void initializeFrames(String imagePath, int fWidth, int fHeight, boolean maintainCurFrame) {
        int numHorizontalFrames = this.imageWidth / fWidth;
        int numVerticalFrames = this.imageHeight / fHeight;
        this.sourceImagePath = imagePath;
        this.srcFrameWidth = fWidth;
        this.srcFrameHeight = fHeight;
        this.numberFrames = numHorizontalFrames * numVerticalFrames;
        this.frameCoordsX = new int[this.numberFrames];
        this.frameCoordsY = new int[this.numberFrames];
        if (!maintainCurFrame) {
            this.sequenceIndex = 0;
        }
        if (!this.customSequenceDefined) {
            this.frameSequence = new int[this.numberFrames];
        }
        int currentFrame = 0;
        for (int yy = 0; yy < this.imageHeight; yy += fHeight) {
            for (int xx = 0; xx < this.imageWidth; xx += fWidth) {
                this.frameCoordsX[currentFrame] = xx;
                this.frameCoordsY[currentFrame] = yy;
                if (!this.customSequenceDefined) {
                    this.frameSequence[currentFrame] = currentFrame;
                }
                ++currentFrame;
            }
        }
    }
}

