/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import javax.microedition.lcdui.Graphics;

public class Button
extends Component
implements IFocusable {
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte CENTER = 2;
    boolean selected;
    int alignment;
    int selectedFgColor;
    int selectedBgColor = -1;
    int selectedBorderColor;
    int selectedBorderSize;
    int verticalOffset;
    int horizontalOffset;
    EFLiteSprite selectedBg;
    EFLiteSprite selectedFg;
    String text;
    String textKey;

    public Button(String id) {
        super(id);
        this.bgColor = -1;
        this.fgColor = -1;
        this.borderColor = -1;
        this.selectedBorderColor = -1;
        this.selectedFgColor = -1;
        this.setAlignment(2);
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        g.translate(this.x, this.y);
        this.saveClip(g);
        if (this.clipRegionActivated) {
            g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
        } else {
            g.setClip(0, 0, this.width, this.height);
        }
        if (!this.selected) {
            if (this.bg != null) {
                this.bg.paint(g);
            } else if (this.bgColor != -1) {
                if (this.enabled) {
                    g.setColor(this.bgColor);
                } else {
                    g.setColor(60, 60, 60);
                }
                g.fillRoundRect(0, 0, this.width, this.height, 8, 8);
            }
            if (this.fg != null) {
                this.fg.paint(g);
            }
            if (this.text != null && !this.text.equals("")) {
                if (this.enabled) {
                    g.setColor(this.fgColor);
                } else {
                    g.setColor(60, 60, 60);
                }
                this.drawText(g);
            }
            if (this.borderSize > 0 && this.borderColor != -1) {
                if (this.enabled) {
                    g.setColor(this.borderColor);
                } else {
                    g.setColor(60, 60, 60);
                }
                for (int i = 0; i < this.borderSize; ++i) {
                    g.drawRoundRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1, 8, 8);
                }
            }
        } else {
            if (this.selectedBg != null) {
                this.selectedBg.paint(g);
            } else if (this.selectedBgColor != -1) {
                g.setColor(this.selectedBgColor);
                g.fillRoundRect(0, 0, this.width, this.height, 8, 8);
            }
            if (this.selectedFg != null) {
                this.selectedFg.paint(g);
            }
            if (this.text != null && !this.text.equals("")) {
                g.setColor(this.selectedFgColor);
                this.drawText(g);
            }
            if (this.selectedBorderSize > 0 && this.selectedBorderColor != -1) {
                g.setColor(this.selectedBorderColor);
                for (int i = 0; i < this.selectedBorderSize; ++i) {
                    g.drawRoundRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1, 8, 8);
                }
            }
        }
        this.restoreClip(g);
        g.translate(-this.x, -this.y);
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.setAlignment(this.alignment);
    }

    public void move(int dx, int dy) {
        super.move(dx, dy);
        this.setAlignment(this.alignment);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.alignSprite(this.fg);
        this.alignSprite(this.selectedFg);
    }

    private void alignSprite(EFLiteSprite sprite) {
        if (sprite == null) {
            return;
        }
        switch (this.alignment) {
            case 0: {
                sprite.setPosition(this.horizontalOffset, (this.height - sprite.getHeight()) / 2 + this.verticalOffset);
                break;
            }
            case 1: {
                sprite.setPosition(this.width - sprite.getWidth() - this.horizontalOffset, (this.height - sprite.getHeight()) / 2 + this.verticalOffset);
                break;
            }
            case 2: {
                sprite.setPosition((this.width - sprite.getWidth()) / 2, (this.height - sprite.getHeight()) / 2 + this.verticalOffset);
            }
        }
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalSpace) {
        this.horizontalOffset = horizontalSpace;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void setVerticalOffset(int verticalSpace) {
        this.verticalOffset = verticalSpace;
    }

    public EFLiteSprite getSelectedBg() {
        return this.selectedBg;
    }

    public void setSelectedBg(EFLiteSprite selectedBg) {
        this.selectedBg = selectedBg;
    }

    public int getSelectedBgColor() {
        return this.selectedBgColor;
    }

    public void setSelectedBgColor(int selectedBgColor) {
        this.selectedBgColor = selectedBgColor;
    }

    public void setBgColor(int color) {
        super.setBgColor(color);
        this.setSelectedBgColor(color);
    }

    public void setFgColor(int color) {
        super.setFgColor(color);
        this.setSelectedFgColor(color);
    }

    public int getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public void setSelectedBorderColor(int selectedBorderColor) {
        this.selectedBorderColor = selectedBorderColor;
    }

    public int getSelectedBorderSize() {
        return this.selectedBorderSize;
    }

    public void setSelectedBorderSize(int selectedBorderSize) {
        this.selectedBorderSize = selectedBorderSize;
    }

    public EFLiteSprite getSelectedFg() {
        return this.selectedFg;
    }

    public void setSelectedFg(EFLiteSprite selectedFg) {
        this.selectedFg = selectedFg;
    }

    public int getSelectedFgColor() {
        return this.selectedFgColor;
    }

    public void setSelectedFgColor(int selectedFgColor) {
        this.selectedFgColor = selectedFgColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, boolean localizationSupport) {
        if (localizationSupport) {
            this.textKey = text;
            text = LocalizationSupport.getMessage(this.textKey);
        }
        this.setText(text);
    }

    private void drawText(Graphics g) {
        switch (this.alignment) {
            case 0: {
                TextWriter.getInstance().drawText(g, this.text, this.horizontalOffset, (this.height - TextWriter.getInstance().getTextHeight(this.text)) / 2 + this.verticalOffset);
                break;
            }
            case 1: {
                TextWriter.getInstance().drawText(g, this.text, this.width - this.horizontalOffset - TextWriter.getInstance().getTextWidth(this.text), (this.height - TextWriter.getInstance().getTextHeight(this.text)) / 2 + this.verticalOffset);
                break;
            }
            case 2: {
                TextWriter.getInstance().drawText(g, this.text, (this.width - TextWriter.getInstance().getTextWidth(this.text)) / 2, (this.height - TextWriter.getInstance().getTextHeight(this.text)) / 2 + this.verticalOffset);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (!this.enabled) {
            this.selected = false;
            return;
        }
        if (this.actionListener != null && this.selected != selected) {
            if (selected) {
                this.actionListener.onSelected();
            } else {
                this.actionListener.onDeselected();
            }
        }
        this.selected = selected;
    }

    public void setFocused(boolean focused) {
        if (focused && this.actionListener != null) {
            this.actionListener.actionPerformed();
        }
    }

    public boolean isFocused() {
        return false;
    }

    public void keyPressed(int keyCode) {
    }

    public String getTextKey() {
        return this.textKey;
    }
}

