/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.game;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.SoundHandler;
import com.jarbull.efw.game.GameObjectHolder;
import com.jarbull.efw.game.TimerHolder;
import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.manager.EMidlet;

public class Level {
    private int status;
    private String levelName;
    private Object userData;
    private int bestScore;
    private int currentScore;
    private String[] imagePaths;
    private String[] soundPaths;
    public static final int NOT_PLAYED = 0;
    public static final int FAILED = 1;
    public static final int COMPLETED = 2;
    public static final int PLAYED = 2;

    public Level(String levelName, String[] imagePaths, String[] soundPaths) {
        this.levelName = levelName;
        this.imagePaths = imagePaths;
        this.soundPaths = soundPaths;
        this.status = 0;
    }

    public void load() {
        if (this.imagePaths != null) {
            ImageHandler.getInstance().load(this.imagePaths);
        }
        if (this.soundPaths != null) {
            SoundHandler.getInstance().load(this.soundPaths);
        }
    }

    public void unload(String[] imagePaths, String[] soundPaths, String[] timerPaths, String[] gameObjectPaths) {
        int i;
        if (imagePaths == null) {
            ImageHandler.getInstance().clear();
        } else {
            for (i = imagePaths.length - 1; i >= 0; --i) {
                ImageHandler.getInstance().clear(imagePaths[i]);
            }
        }
        if (soundPaths == null) {
            SoundHandler.getInstance().clear();
        } else {
            for (i = soundPaths.length - 1; i >= 0; --i) {
                SoundHandler.getInstance().clear(soundPaths[i]);
            }
        }
        if (timerPaths == null) {
            TimerHolder.getInstance().clearAll();
        } else {
            for (i = timerPaths.length - 1; i >= 0; --i) {
                TimerHolder.getInstance().removeTimer(i);
            }
        }
        if (gameObjectPaths == null) {
            GameObjectHolder.getInstance().clearAll();
        } else {
            for (i = gameObjectPaths.length - 1; i >= 0; --i) {
                GameObjectHolder.getInstance().removeGameObject(i);
            }
        }
    }

    public void unload() {
        ImageHandler.getInstance().clear();
        SoundHandler.getInstance().clear();
        TimerHolder.getInstance().clearAll();
        GameObjectHolder.getInstance().clearAll();
    }

    public int getBestScore() {
        String bestScoreValue = EMidlet.getInstance().getSettings().get("BestScore" + this.levelName);
        this.bestScore = bestScoreValue == null ? 0 : Integer.parseInt(bestScoreValue);
        return this.bestScore;
    }

    public void saveLevelInfo() {
        if (this.currentScore > this.bestScore) {
            this.bestScore = this.currentScore;
        }
        KeyValuePair bestScoreRecord = new KeyValuePair("BestScore" + this.levelName, String.valueOf(this.bestScore));
        KeyValuePair levelStatusRecord = new KeyValuePair("LevelStatus" + this.levelName, String.valueOf(this.status));
        EMidlet.getInstance().getSettings().add(bestScoreRecord);
        EMidlet.getInstance().getSettings().add(levelStatusRecord);
    }

    public void loadLevelInfo() {
        String bestScoreValue = EMidlet.getInstance().getSettings().get("BestScore" + this.levelName);
        this.bestScore = bestScoreValue == null ? 0 : Integer.parseInt(bestScoreValue);
        String statusValue = EMidlet.getInstance().getSettings().get("LevelStatus" + this.levelName);
        this.status = statusValue == null ? 0 : Integer.parseInt(statusValue);
    }

    public int getCurrentScore() {
        return this.currentScore;
    }

    public void setCurrentScore(int currentScore) {
        this.currentScore = currentScore;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public int getLevelStatus() {
        return this.status;
    }

    public void setLevelStatus(int status) {
        this.status = status;
    }

    public String[] getImagePaths() {
        return this.imagePaths;
    }

    public void setImagePaths(String[] imagePaths) {
        this.imagePaths = imagePaths;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    void setBestScore(int score) {
        this.bestScore = score;
    }
}

