/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.text;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.text.EFont;
import com.jarbull.efw.text.HexWriter;
import com.jarbull.efw.text.StringWriter;
import com.jarbull.efw.text.WexWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextWriter {
    public static final int WRITER_TYPE_HEX = 0;
    public static final int WRITER_TYPE_WEX = 1;
    public static final int WRITER_TYPE_STRING = 2;
    public static final int WRITER_ORIENTATION_NONE = 0;
    public static final int WRITER_ORIENTATION_ROT90 = 5;
    public static final int WRITER_ORIENTATION_ROT180 = 3;
    public static final int WRITER_ORIENTATION_ROT270 = 6;
    private static final String HASH_NAME__WRITER_TYPE = "writerType";
    private static final String HASH_NAME__ORIENTATION = "orientation";
    private static final String HASH_NAME__CURR_FONT = "currentFontName";
    private static final TextWriter INSTANCE = new TextWriter();
    int writerType = 2;
    int orientation = 0;
    Hashtable fontsHash = new Hashtable();
    String currentFontName;
    Font systemFont;
    Hashtable state = new Hashtable();

    private TextWriter() {
        this.systemFont = Font.getFont((int)32, (int)0, (int)8);
    }

    public static TextWriter getInstance() {
        return INSTANCE;
    }

    public void drawText(Graphics g, String text, int x, int y) {
        switch (this.writerType) {
            case 0: {
                HexWriter.getInstance().drawText(g, text, x, y, 0, (EFont)this.fontsHash.get(this.currentFontName));
                break;
            }
            case 1: {
                WexWriter.getInstance().drawText(g, text, x, y, 0, (EFont)this.fontsHash.get(this.currentFontName));
                break;
            }
            case 2: {
                StringWriter.getInstance().drawText(g, text, x, y, 0, this.systemFont);
            }
        }
    }

    public int getTextWidth(String text) {
        switch (this.writerType) {
            case 0: {
                return HexWriter.getInstance().getTextWidth(text, (EFont)this.fontsHash.get(this.currentFontName));
            }
            case 1: {
                return WexWriter.getInstance().getTextWidth(text, (EFont)this.fontsHash.get(this.currentFontName));
            }
            case 2: {
                return StringWriter.getInstance().getTextWidth(text, this.systemFont);
            }
        }
        return 0;
    }

    public int getTextHeight(String text) {
        switch (this.writerType) {
            case 0: {
                return HexWriter.getInstance().getTextHeight(text, (EFont)this.fontsHash.get(this.currentFontName));
            }
            case 1: {
                return WexWriter.getInstance().getTextHeight(text, (EFont)this.fontsHash.get(this.currentFontName));
            }
            case 2: {
                return StringWriter.getInstance().getTextHeight(text, this.systemFont);
            }
        }
        return 0;
    }

    public void setWriterType(int writerType) {
        this.writerType = writerType;
    }

    public int getWriterType() {
        return this.writerType;
    }

    public void setFont(EFont font) {
        this.currentFontName = font.getFontName();
    }

    public EFont getFont() {
        return (EFont)this.fontsHash.get(this.currentFontName);
    }

    public EFont getFont(String fontName) {
        return (EFont)this.fontsHash.get(fontName);
    }

    public void clearFont(EFont font) {
        ImageHandler.getInstance().clear(font.getFontImagePath());
        this.fontsHash.remove(font.getFontName());
    }

    public void clearAllFonts() {
        Enumeration enumFonts = this.fontsHash.elements();
        while (enumFonts.hasMoreElements()) {
            ImageHandler.getInstance().clear(((EFont)enumFonts.nextElement()).getFontImagePath());
        }
        this.fontsHash.clear();
    }

    public void loadFonts(EFont[] fonts) {
        for (int i = 0; i < fonts.length; ++i) {
            if (this.fontsHash.containsKey(fonts[i].getFontName())) continue;
            ImageHandler.getInstance().load(fonts[i].getFontImagePath());
            this.fontsHash.put(fonts[i].getFontName(), fonts[i]);
        }
    }

    public void loadFont(EFont font) {
        if (!this.fontsHash.containsKey(font.getFontName())) {
            ImageHandler.getInstance().load(font.getFontImagePath());
            this.fontsHash.put(font.getFontName(), font);
        }
        if (this.fontsHash.size() == 1) {
            this.setFont(font);
            this.setWriterType(font.getFontType() == 0 ? 0 : 1);
        }
    }

    public void setSystemFont(Font font) {
        this.systemFont = font;
    }

    public Font getSystemFont() {
        return this.systemFont;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void saveState() {
        this.state.put(HASH_NAME__WRITER_TYPE, new Integer(this.writerType));
        this.state.put(HASH_NAME__ORIENTATION, new Integer(this.orientation));
        if (this.currentFontName != null) {
            this.state.put(HASH_NAME__CURR_FONT, this.currentFontName);
        }
    }

    public void restoreState() {
        Object wt = this.state.get(HASH_NAME__WRITER_TYPE);
        this.writerType = wt != null ? Integer.parseInt(wt.toString()) : 2;
        this.orientation = Integer.parseInt(this.state.get(HASH_NAME__ORIENTATION).toString());
        Object cfn = this.state.get(HASH_NAME__CURR_FONT);
        this.currentFontName = cfn != null ? cfn.toString() : null;
    }
}

