/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.io;

import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.util.StringEx;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RecordHandler {
    private static final RecordHandler INSTANCE = new RecordHandler();
    private RecordStore recordStore;

    public static RecordHandler getInstance() {
        return INSTANCE;
    }

    private RecordHandler() {
    }

    public void openRecordStore(String name) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    public void closeRecordStore() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void updateRecord(KeyValuePair record) {
        try {
            RecordEnumeration recEnum = this.recordStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                int recordId = recEnum.nextRecordId();
                byte[] recData = this.recordStore.getRecord(recordId);
                String[] result = StringEx.split(new String(recData), "|");
                if (!record.getKey().equals(result[0])) continue;
                byte[] rec = record.toString().getBytes();
                this.recordStore.setRecord(recordId, rec, 0, rec.length);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void clearRecord(String id) {
        try {
            RecordEnumeration recEnum = this.recordStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                int recordId = recEnum.nextRecordId();
                byte[] recData = this.recordStore.getRecord(recordId);
                String[] result = StringEx.split(new String(recData), "|");
                if (!id.equals(result[0])) continue;
                this.recordStore.deleteRecord(recordId);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void clearRecords() {
        try {
            RecordEnumeration recEnum = this.recordStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                int recordId = recEnum.nextRecordId();
                this.recordStore.deleteRecord(recordId);
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void saveRecord(KeyValuePair record) {
        KeyValuePair[] records = null;
        boolean available = true;
        records = this.getAllRecords();
        for (int i = 0; i < records.length; ++i) {
            if (!records[i].getKey().equals(record.getKey())) continue;
            this.updateRecord(record);
            available = false;
            break;
        }
        if (available) {
            byte[] rec = record.toString().getBytes();
            try {
                this.recordStore.addRecord(rec, 0, rec.length);
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveRecords(KeyValuePair[] recordArray) {
        for (int i = recordArray.length - 1; i >= 0; --i) {
            this.saveRecord(recordArray[i]);
        }
    }

    public KeyValuePair getRecord(String id) {
        KeyValuePair[] records = this.getAllRecords();
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getKey().equals(id)) continue;
            return records[i];
        }
        return null;
    }

    public KeyValuePair[] getAllRecords() {
        int i = 0;
        KeyValuePair[] recordSet = null;
        try {
            recordSet = new KeyValuePair[this.recordStore.getNumRecords()];
            RecordEnumeration recEnum = this.recordStore.enumerateRecords(null, null, false);
            while (recEnum.hasNextElement()) {
                int recordId = recEnum.nextRecordId();
                byte[] recData = this.recordStore.getRecord(recordId);
                String[] result = StringEx.split(new String(recData), "|");
                recordSet[i] = new KeyValuePair(result[0], result[1]);
                ++i;
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return recordSet;
    }

    public int getNumOfRecords() {
        int size = 0;
        try {
            size = this.recordStore.getNumRecords();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        return size;
    }
}

